package elemental2.core;

import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Atomics {
  public static native double add(TypedArray typedArray, double index, double value);

  public static native double and(TypedArray typedArray, double index, double value);

  public static native double compareExchange(
      TypedArray typedArray, double index, double expectedValue, double replacementValue);

  public static native double exchange(TypedArray typedArray, double index, double value);

  public static native boolean isLockFree(double size);

  public static native double load(TypedArray typedArray, double index);

  public static native double or(TypedArray typedArray, double index, double value);

  public static native double store(TypedArray typedArray, double index, double value);

  public static native double sub(TypedArray typedArray, double index, double value);

  public static native JsString wait(
      Int32Array typedArray, double index, double value, double timeout);

  public static native JsString wait(Int32Array typedArray, double index, double value);

  public static native double wake(Int32Array typedArray, double index, double count);

  public static native double xor(TypedArray typedArray, double index, double value);
}
