/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp.gradle;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.dsl.AndroidSourceSet;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.Component;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.api.variant.SourceDirectories;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.SourceKind;
import com.android.builder.model.SourceProvider;
import com.google.devtools.ksp.gradle.AndroidPluginIntegration;
import com.google.devtools.ksp.gradle.KotlinFactoriesKt;
import com.google.devtools.ksp.gradle.KspAATask;
import com.google.devtools.ksp.gradle.KspTaskJvm;
import com.google.devtools.ksp.gradle.utils.AgpUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.KaptTask;
import org.jetbrains.kotlin.gradle.plugin.KotlinBaseApiPlugin;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\rH\u0002J\"\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\rJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u0012Jn\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002Jl\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ.\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\n\u0010!\u001a\u00020\u001e*\u00020\u000bJ\n\u0010\"\u001a\u00020\u001e*\u00020\u000bJ\n\u0010#\u001a\u00020\u001e*\u00020\u000bJ\n\u0010$\u001a\u00020\u001e*\u00020\u000bJ\n\u0010%\u001a\u00020\u001e*\u00020\u000bR\u001c\u0010\u0003\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006&"}, d2={"Lcom/google/devtools/ksp/gradle/AndroidPluginIntegration;", "", "()V", "kaptTaskName", "", "Lorg/gradle/api/tasks/TaskProvider;", "getKaptTaskName", "(Lorg/gradle/api/tasks/TaskProvider;)Ljava/lang/String;", "decorateAndroidExtension", "", "project", "Lorg/gradle/api/Project;", "onSourceSet", "Lkotlin/Function1;", "forEachAndroidSourceSet", "getCompilationSourceSets", "", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinJvmAndroidCompilation;", "registerGeneratedSources", "kspTaskProvider", "javaOutputDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "kotlinOutputDir", "classOutputDir", "resourcesOutputDir", "androidComponent", "Lcom/android/build/api/variant/Component;", "useKsp2", "", "syncSourceSets", "tryUpdateKspWithAndroidSourceSets", "canUseAddGeneratedSourceDirectoriesApi", "isAgpBuiltInKotlinUsed", "isKotlinAndroidPluginApplied", "isKotlinBaseApiPluginApplied", "useLegacyVariantApi", "gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAndroidPluginIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPluginIntegration.kt\ncom/google/devtools/ksp/gradle/AndroidPluginIntegration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KspSubplugin.kt\ncom/google/devtools/ksp/gradle/KspSubpluginKt\n*L\n1#1,244:1\n1557#2:245\n1628#2,3:246\n712#3,5:249\n*S KotlinDebug\n*F\n+ 1 AndroidPluginIntegration.kt\ncom/google/devtools/ksp/gradle/AndroidPluginIntegration\n*L\n66#1:245\n66#1:246,3\n80#1:249,5\n*E\n"})
public final class AndroidPluginIntegration {
    @NotNull
    public static final AndroidPluginIntegration INSTANCE = new AndroidPluginIntegration();

    private AndroidPluginIntegration() {
    }

    public final void forEachAndroidSourceSet(@NotNull Project project, @NotNull Function1<? super String, Unit> onSourceSet) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onSourceSet, (String)"onSourceSet");
        project.getPluginManager().withPlugin("com.android.base", arg_0 -> AndroidPluginIntegration.forEachAndroidSourceSet$lambda$0((Function1)new Function1<AppliedPlugin, Unit>(project, onSourceSet){
            final /* synthetic */ Project $project;
            final /* synthetic */ Function1<String, Unit> $onSourceSet;
            {
                this.$project = $project;
                this.$onSourceSet = $onSourceSet;
                super(1);
            }

            public final void invoke(AppliedPlugin it) {
                AndroidPluginIntegration.access$decorateAndroidExtension(AndroidPluginIntegration.INSTANCE, this.$project, this.$onSourceSet);
            }
        }, arg_0));
    }

    private final void decorateAndroidExtension(Project project, Function1<? super String, Unit> onSourceSet) {
        NamedDomainObjectContainer namedDomainObjectContainer;
        Object androidExt = project.getExtensions().getByName("android");
        if (androidExt instanceof BaseExtension) {
            namedDomainObjectContainer = ((BaseExtension)androidExt).getSourceSets();
        } else if (androidExt instanceof CommonExtension) {
            namedDomainObjectContainer = ((CommonExtension)androidExt).getSourceSets();
        } else {
            throw new RuntimeException("Unsupported Android Gradle plugin version.");
        }
        NamedDomainObjectContainer sourceSets = namedDomainObjectContainer;
        sourceSets.configureEach(arg_0 -> AndroidPluginIntegration.decorateAndroidExtension$lambda$1((Function1)new Function1<AndroidSourceSet, Unit>(onSourceSet){
            final /* synthetic */ Function1<String, Unit> $onSourceSet;
            {
                this.$onSourceSet = $onSourceSet;
                super(1);
            }

            public final void invoke(AndroidSourceSet it) {
                this.$onSourceSet.invoke((Object)it.getName());
            }
        }, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getCompilationSourceSets(@NotNull KotlinJvmAndroidCompilation kotlinCompilation) {
        List list;
        Intrinsics.checkNotNullParameter((Object)kotlinCompilation, (String)"kotlinCompilation");
        Object object = kotlinCompilation.getAndroidVariant();
        if (object != null && (object = object.getSourceSets()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SourceProvider sourceProvider = (SourceProvider)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void tryUpdateKspWithAndroidSourceSets(Project project, KotlinJvmAndroidCompilation kotlinCompilation, TaskProvider<?> kspTaskProvider2, Component androidComponent) {
        TaskProvider taskProvider;
        Project project2 = project;
        String name$iv = this.getKaptTaskName(kotlinCompilation.getCompileTaskProvider());
        boolean $i$f$locateTask = false;
        try {
            void $this$locateTask$iv;
            taskProvider = $this$locateTask$iv.getTasks().withType(Task.class).named(name$iv);
        }
        catch (UnknownTaskException e$iv) {
            taskProvider = null;
        }
        TaskProvider kaptProvider = taskProvider;
        BaseVariant androidVariant = kotlinCompilation.getAndroidVariant();
        if (androidVariant == null) {
            throw new RuntimeException("KSP is not compatible with Android Gradle Plugin's built-in Kotlin. Please disable by adding android.builtInKotlin=false to gradle.properties and apply kotlin(\"android\") plugin");
        }
        List sources = androidVariant.getSourceFolders(SourceKind.JAVA);
        kspTaskProvider2.configure(arg_0 -> AndroidPluginIntegration.tryUpdateKspWithAndroidSourceSets$lambda$3((Function1)new Function1<Task, Unit>((TaskProvider<Task>)kaptProvider, (List<ConfigurableFileTree>)sources){
            final /* synthetic */ TaskProvider<Task> $kaptProvider;
            final /* synthetic */ List<ConfigurableFileTree> $sources;
            {
                this.$kaptProvider = $kaptProvider;
                this.$sources = $sources;
                super(1);
            }

            public final void invoke(Task task) {
                block1: {
                    Task task2;
                    Callable<List> filteredSources;
                    block0: {
                        filteredSources = () -> tryUpdateKspWithAndroidSourceSets.1.invoke$lambda$1(this.$kaptProvider, this.$sources);
                        task2 = task;
                        if (!(task2 instanceof KspTaskJvm)) break block0;
                        Object[] objectArray = new Object[]{filteredSources};
                        ((KspTaskJvm)task).source(objectArray);
                        break block1;
                    }
                    if (!(task2 instanceof KspAATask)) break block1;
                    Object[] objectArray = new Object[]{filteredSources};
                    ((KspAATask)task).getKspConfig().getJavaSourceRoots().from(objectArray);
                }
            }

            /*
             * WARNING - void declaration
             */
            private static final List invoke$lambda$1(TaskProvider $kaptProvider, List $sources) {
                void $this$filterTo$iv$iv;
                TaskProvider taskProvider = $kaptProvider;
                Task task = taskProvider != null ? (Task)taskProvider.get() : null;
                KaptTask kaptTask = task instanceof KaptTask ? (KaptTask)task : null;
                Object destinationProperty = kaptTask != null ? kaptTask.getDestinationDir() : null;
                DirectoryProperty directoryProperty = destinationProperty;
                File dir = directoryProperty != null && (directoryProperty = (Directory)directoryProperty.get()) != null ? directoryProperty.getAsFile() : null;
                Intrinsics.checkNotNull((Object)$sources);
                Iterable $this$filter$iv = $sources;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    ConfigurableFileTree it = (ConfigurableFileTree)element$iv$iv;
                    boolean bl2 = false;
                    File file = dir;
                    if (file != null) {
                        File file2 = it.getDir();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getDir(...)");
                        bl = KotlinFactoriesKt.isParentOf(file, file2);
                    } else {
                        bl = false;
                    }
                    if (!(!bl)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }, arg_0));
    }

    private final String getKaptTaskName(TaskProvider<?> $this$kaptTaskName) {
        Object object;
        String prefix = "kapt";
        String string = $this$kaptTaskName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string, (String)"compile", (boolean)false, (int)2, null)) {
            String string2 = $this$kaptTaskName.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            object = StringsKt.replaceFirst$default((String)string2, (String)"compile", (String)prefix, (boolean)false, (int)4, null);
        } else {
            String string3 = $this$kaptTaskName.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            object = prefix + CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)string3);
        }
        return object;
    }

    private final void registerGeneratedSources(Project project, KotlinJvmAndroidCompilation kotlinCompilation, TaskProvider<?> kspTaskProvider2, Provider<Directory> javaOutputDir, Provider<Directory> kotlinOutputDir, Provider<Directory> classOutputDir, Provider<Directory> resourcesOutputDir, Component androidComponent, boolean useKsp2) {
        block8: {
            block7: {
                if (androidComponent == null || !useKsp2 || !this.canUseAddGeneratedSourceDirectoriesApi(project)) break block7;
                SourceDirectories.Flat flat = androidComponent.getSources().getJava();
                if (flat != null) {
                    flat.addGeneratedSourceDirectory(kspTaskProvider2, (Function1)registerGeneratedSources.1.INSTANCE);
                }
                SourceDirectories.Flat flat2 = androidComponent.getSources().getJava();
                if (flat2 != null) {
                    flat2.addGeneratedSourceDirectory(kspTaskProvider2, (Function1)registerGeneratedSources.2.INSTANCE);
                }
                SourceDirectories.Flat flat3 = androidComponent.getSources().getResources();
                if (flat3 != null) {
                    flat3.addGeneratedSourceDirectory(kspTaskProvider2, (Function1)registerGeneratedSources.3.INSTANCE);
                }
                androidComponent.getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).use(kspTaskProvider2).toAppend((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE, (Function1)new Function1<Task, Property<? extends FileSystemLocation>>(project, resourcesOutputDir){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Provider<Directory> $resourcesOutputDir;
                    {
                        this.$project = $project;
                        this.$resourcesOutputDir = $resourcesOutputDir;
                        super(1);
                    }

                    public final Property<? extends FileSystemLocation> invoke(Task task) {
                        DirectoryProperty directoryProperty = this.$project.getObjects().directoryProperty();
                        Provider<Directory> provider = this.$resourcesOutputDir;
                        DirectoryProperty it = directoryProperty;
                        boolean bl = false;
                        it.set(provider);
                        DirectoryProperty directoryProperty2 = directoryProperty;
                        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"also(...)");
                        return (Property)directoryProperty2;
                    }
                });
                androidComponent.getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).use(kspTaskProvider2).toAppend((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE, (Function1)new Function1<Task, Property<? extends FileSystemLocation>>(project, classOutputDir){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Provider<Directory> $classOutputDir;
                    {
                        this.$project = $project;
                        this.$classOutputDir = $classOutputDir;
                        super(1);
                    }

                    public final Property<? extends FileSystemLocation> invoke(Task task) {
                        DirectoryProperty directoryProperty = this.$project.getObjects().directoryProperty();
                        Provider<Directory> provider = this.$classOutputDir;
                        DirectoryProperty it = directoryProperty;
                        boolean bl = false;
                        it.set(provider);
                        DirectoryProperty directoryProperty2 = directoryProperty;
                        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"also(...)");
                        return (Property)directoryProperty2;
                    }
                });
                break block8;
            }
            Object[] objectArray = new Object[]{kspTaskProvider2};
            ConfigurableFileTree kspJavaOutput = project.fileTree(javaOutputDir).builtBy(objectArray);
            Object[] objectArray2 = new Object[]{kspTaskProvider2};
            ConfigurableFileTree kspKotlinOutput = project.fileTree(kotlinOutputDir).builtBy(objectArray2);
            Object[] objectArray3 = new Object[]{kspTaskProvider2};
            ConfigurableFileTree kspClassOutput = project.fileTree(classOutputDir).builtBy(objectArray3);
            Object[] objectArray4 = new Object[]{resourcesOutputDir};
            ConfigurableFileCollection configurableFileCollection = project.files(objectArray4);
            objectArray4 = new Object[]{kspTaskProvider2};
            ConfigurableFileCollection resourcesOutput = configurableFileCollection.builtBy(objectArray4);
            objectArray4 = new String[]{"**/*.java"};
            kspJavaOutput.include((String[])objectArray4);
            objectArray4 = new String[]{"**/*.kt"};
            kspKotlinOutput.include((String[])objectArray4);
            objectArray4 = new String[]{"**/*.class"};
            kspClassOutput.include((String[])objectArray4);
            BaseVariant baseVariant = kotlinCompilation.getAndroidVariant();
            if (baseVariant != null) {
                File[] fileArray = new File[]{kspKotlinOutput.getDir()};
                baseVariant.addJavaSourceFoldersToModel(fileArray);
            }
            BaseVariant baseVariant2 = kotlinCompilation.getAndroidVariant();
            if (baseVariant2 != null) {
                baseVariant2.registerExternalAptJavaOutput(kspJavaOutput);
            }
            BaseVariant baseVariant3 = kotlinCompilation.getAndroidVariant();
            if (baseVariant3 != null) {
                baseVariant3.registerPostJavacGeneratedBytecode((FileCollection)resourcesOutput);
            }
            if (this.isAgpBuiltInKotlinUsed(project)) break block8;
            BaseVariant baseVariant4 = kotlinCompilation.getAndroidVariant();
            if (baseVariant4 != null) {
                baseVariant4.registerPreJavacGeneratedBytecode((FileCollection)kspClassOutput);
            }
        }
    }

    public final void syncSourceSets(@NotNull Project project, @NotNull KotlinJvmAndroidCompilation kotlinCompilation, @NotNull TaskProvider<?> kspTaskProvider2, @NotNull Provider<Directory> javaOutputDir, @NotNull Provider<Directory> kotlinOutputDir, @NotNull Provider<Directory> classOutputDir, @NotNull Provider<Directory> resourcesOutputDir, @Nullable Component androidComponent, boolean useKsp2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kotlinCompilation, (String)"kotlinCompilation");
        Intrinsics.checkNotNullParameter(kspTaskProvider2, (String)"kspTaskProvider");
        Intrinsics.checkNotNullParameter(javaOutputDir, (String)"javaOutputDir");
        Intrinsics.checkNotNullParameter(kotlinOutputDir, (String)"kotlinOutputDir");
        Intrinsics.checkNotNullParameter(classOutputDir, (String)"classOutputDir");
        Intrinsics.checkNotNullParameter(resourcesOutputDir, (String)"resourcesOutputDir");
        this.tryUpdateKspWithAndroidSourceSets(project, kotlinCompilation, kspTaskProvider2, androidComponent);
        this.registerGeneratedSources(project, kotlinCompilation, kspTaskProvider2, javaOutputDir, kotlinOutputDir, classOutputDir, resourcesOutputDir, androidComponent, useKsp2);
    }

    public final boolean isKotlinBaseApiPluginApplied(@NotNull Project $this$isKotlinBaseApiPluginApplied) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinBaseApiPluginApplied, (String)"<this>");
        return $this$isKotlinBaseApiPluginApplied.getPlugins().findPlugin(KotlinBaseApiPlugin.class) != null;
    }

    public final boolean isKotlinAndroidPluginApplied(@NotNull Project $this$isKotlinAndroidPluginApplied) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinAndroidPluginApplied, (String)"<this>");
        return $this$isKotlinAndroidPluginApplied.getPluginManager().hasPlugin("org.jetbrains.kotlin.android");
    }

    public final boolean isAgpBuiltInKotlinUsed(@NotNull Project $this$isAgpBuiltInKotlinUsed) {
        Intrinsics.checkNotNullParameter((Object)$this$isAgpBuiltInKotlinUsed, (String)"<this>");
        return this.isKotlinBaseApiPluginApplied($this$isAgpBuiltInKotlinUsed) && !this.isKotlinAndroidPluginApplied($this$isAgpBuiltInKotlinUsed);
    }

    public final boolean useLegacyVariantApi(@NotNull Project $this$useLegacyVariantApi) {
        Intrinsics.checkNotNullParameter((Object)$this$useLegacyVariantApi, (String)"<this>");
        Project project = $this$useLegacyVariantApi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidPluginVersion androidPluginVersion = AgpUtilsKt.getAgpVersion(project);
        if (androidPluginVersion == null) {
            return true;
        }
        AndroidPluginVersion agpVersion = androidPluginVersion;
        return agpVersion.compareTo(new AndroidPluginVersion(8, 10, 0).alpha(3)) < 0;
    }

    public final boolean canUseAddGeneratedSourceDirectoriesApi(@NotNull Project $this$canUseAddGeneratedSourceDirectoriesApi) {
        Intrinsics.checkNotNullParameter((Object)$this$canUseAddGeneratedSourceDirectoriesApi, (String)"<this>");
        Project project = $this$canUseAddGeneratedSourceDirectoriesApi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidPluginVersion androidPluginVersion = AgpUtilsKt.getAgpVersion(project);
        if (androidPluginVersion == null) {
            return false;
        }
        AndroidPluginVersion agpVersion = androidPluginVersion;
        return agpVersion.compareTo(new AndroidPluginVersion(8, 12, 0).alpha(6)) >= 0;
    }

    private static final void forEachAndroidSourceSet$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void decorateAndroidExtension$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void tryUpdateKspWithAndroidSourceSets$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$decorateAndroidExtension(AndroidPluginIntegration $this, Project project, Function1 onSourceSet) {
        $this.decorateAndroidExtension(project, (Function1<? super String, Unit>)onSourceSet);
    }
}

