/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.BuiltinTypes;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.cfa.FirControlFlowChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.contracts.ContractUtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.ContractsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.LogicSystem;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.Operation;
import org.jetbrains.kotlin.fir.resolve.dfa.OperationStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.UtilKt;
import org.jetbrains.kotlin.fir.resolve.dfa.VariableStorage;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.BlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.JumpNode;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016Jq\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u0002`\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001c\u0010 \u001a\u00020\r*\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0012H\u0002J\u0016\u0010%\u001a\u00020\r*\u00020!2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J.\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0)*\u0006\u0012\u0002\b\u00030\u000f2\u0012\b\u0002\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0+H\u0002R\u001a\u0010,\u001a\u0004\u0018\u00010-*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirReturnsImpliesAnalyzer;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/cfa/FirControlFlowChecker;", "<init>", "()V", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "isWrongConditionOnNode", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "effectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "effect", "Lorg/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeReturnsEffectDeclaration;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "logicSystem", "Lorg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem;", "argumentVariables", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;Lorg/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem;[Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "canBeTrueFor", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Operation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "type", "isTrueFor", "value", "", "collectBranchExits", "", "nodes", "", "containingProperty", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getContainingProperty", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReturnsImpliesAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReturnsImpliesAnalyzer.kt\norg/jetbrains/kotlin/fir/analysis/cfa/FirReturnsImpliesAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,160:1\n1761#2,3:161\n1761#2,3:164\n1740#2,3:168\n1869#2,2:171\n1#3:167\n59#4,11:173\n23#4,2:184\n*S KotlinDebug\n*F\n+ 1 FirReturnsImpliesAnalyzer.kt\norg/jetbrains/kotlin/fir/analysis/cfa/FirReturnsImpliesAnalyzer\n*L\n75#1:161,3\n103#1:164,3\n129#1:168,3\n153#1:171,2\n158#1:173,11\n158#1:184,2\n*E\n"})
public final class FirReturnsImpliesAnalyzer
extends FirControlFlowChecker {
    @NotNull
    public static final FirReturnsImpliesAnalyzer INSTANCE = new FirReturnsImpliesAnalyzer();

    private FirReturnsImpliesAnalyzer() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Object receiverParameterSymbol;
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        for (ControlFlowGraph subGraph : graph2.getSubGraphs()) {
            this.analyze(subGraph, reporter, context2);
        }
        FirDeclaration firDeclaration = graph2.getDeclaration();
        FirFunction firFunction = firDeclaration instanceof FirFunction ? (FirFunction)firDeclaration : null;
        if (firFunction == null) {
            return;
        }
        FirFunction function2 = firFunction;
        if (!(function2 instanceof FirContractDescriptionOwner)) {
            return;
        }
        FirContractDescription firContractDescription = ((FirContractDescriptionOwner)((Object)function2)).getContractDescription();
        if (firContractDescription == null) {
            return;
        }
        FirContractDescription contractDescription = firContractDescription;
        List<FirEffectDeclaration> list = ContractUtilsKt.getEffects(contractDescription);
        if (list == null) {
            return;
        }
        List<FirEffectDeclaration> effects = list;
        ConeInferenceContext coneInferenceContext = TypeComponentsKt.getTypeContext(context2.getSession());
        LogicSystem logicSystem2 = new LogicSystem(context2, coneInferenceContext){
            private final VariableStorage variableStorage;
            {
                this.variableStorage = new VariableStorage($context.getSession());
            }

            public VariableStorage getVariableStorage() {
                return this.variableStorage;
            }
        };
        int size = ((FirContractDescriptionOwner)((Object)function2)).getValueParameters().size() + FirDeclarationUtilKt.contextParametersForFunctionOrContainingProperty(function2).size() + 1;
        RealVariable[] realVariableArray = new RealVariable[size];
        for (int i2 = 0; i2 < size; ++i2) {
            RealVariable realVariable;
            block16: {
                RealVariable realVariable2;
                block17: {
                    int realIndex;
                    block14: {
                        Object object;
                        block15: {
                            FirBasedSymbol firBasedSymbol;
                            int n2;
                            int n3 = n2 = i2;
                            RealVariable[] realVariableArray2 = realVariableArray;
                            realIndex = n2 - 1;
                            if (realIndex != -1) break block14;
                            if (function2.getSymbol() instanceof FirPropertyAccessorSymbol) {
                                firBasedSymbol = INSTANCE.getContainingProperty(context2);
                                if (firBasedSymbol == null || (firBasedSymbol = ((FirCallableSymbol)firBasedSymbol).getReceiverParameterSymbol()) == null) {
                                    FirReceiverParameter firReceiverParameter = function2.getReceiverParameter();
                                    firBasedSymbol = firReceiverParameter != null ? firReceiverParameter.getSymbol() : null;
                                }
                            } else {
                                FirReceiverParameter firReceiverParameter = function2.getReceiverParameter();
                                firBasedSymbol = firReceiverParameter != null ? firReceiverParameter.getSymbol() : null;
                            }
                            if ((object = (receiverParameterSymbol = firBasedSymbol)) != null && (object = ((FirReceiverParameterSymbol)object).getResolvedType()) != null) break block15;
                            realVariable = null;
                            break block16;
                        }
                        Object type2 = object;
                        realVariable2 = RealVariable.Companion.implicit((FirBasedSymbol)receiverParameterSymbol, (ConeKotlinType)type2);
                        break block17;
                    }
                    realVariable2 = (0 <= realIndex ? realIndex < ((Collection)((FirContractDescriptionOwner)((Object)function2)).getValueParameters()).size() : false) ? RealVariable.Companion.local(((FirContractDescriptionOwner)((Object)function2)).getValueParameters().get(realIndex).getSymbol()) : RealVariable.Companion.local(FirDeclarationUtilKt.contextParametersForFunctionOrContainingProperty(function2).get(realIndex - ((FirContractDescriptionOwner)((Object)function2)).getValueParameters().size()).getSymbol());
                }
                realVariable = realVariable2;
            }
            realVariableArray2[n3] = realVariable;
        }
        RealVariable[] argumentVariables = realVariableArray;
        for (FirEffectDeclaration firEffect : effects) {
            boolean wrongCondition;
            boolean bl2;
            block13: {
                KtReturnsEffectDeclaration returnValue;
                KtConditionalEffectDeclaration coneEffect;
                KtEffectDeclaration<ConeKotlinType, ConeDiagnostic> realIndex = firEffect.getEffect();
                KtConditionalEffectDeclaration ktConditionalEffectDeclaration = realIndex instanceof KtConditionalEffectDeclaration ? (KtConditionalEffectDeclaration)realIndex : null;
                if (ktConditionalEffectDeclaration == null || ((receiverParameterSymbol = (coneEffect = ktConditionalEffectDeclaration).getEffect()) instanceof KtReturnsEffectDeclaration ? (KtReturnsEffectDeclaration)receiverParameterSymbol : null) == null) continue;
                returnValue = returnValue;
                Iterable $this$any$iv = CfgTraverserKt.getPreviousCfgNodes(graph2.getExitNode());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CFGNode it = (CFGNode)element$iv;
                        boolean bl3 = false;
                        if (!INSTANCE.isWrongConditionOnNode(it, coneEffect, returnValue, function2, logicSystem2, argumentVariables, context2)) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (!(wrongCondition = bl2)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firEffect.getSource(), FirErrors.INSTANCE.getWRONG_IMPLIES_CONDITION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isWrongConditionOnNode(CFGNode<?> node, KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> effectDeclaration, KtReturnsEffectDeclaration<ConeKotlinType, ConeDiagnostic> effect, FirFunction function2, LogicSystem logicSystem2, RealVariable[] argumentVariables, CheckerContext context2) {
        boolean bl2;
        block20: {
            ConeKotlinType expressionType;
            Object object;
            boolean isReturn;
            BuiltinTypes builtinTypes = context2.getSession().getBuiltinTypes();
            ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(context2.getSession());
            boolean bl3 = isReturn = node instanceof JumpNode && ((JumpNode)node).getFir() instanceof FirReturnExpression;
            if (isReturn) {
                FirElement firElement = ((JumpNode)node).getFir();
                Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirReturnExpression");
                object = ((FirReturnExpression)firElement).getResult();
            } else {
                object = node.getFir();
            }
            Object resultExpression = object;
            Object object2 = resultExpression instanceof FirExpression ? (FirExpression)resultExpression : null;
            ConeKotlinType coneKotlinType = object2 != null && (object2 = FirTypeUtilsKt.getResolvedType((FirExpression)object2)) != null ? TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)object2, context2.getSession(), null, 2, null) : (expressionType = null);
            if (Intrinsics.areEqual(expressionType, (Object)builtinTypes.getNothingType().getConeType())) {
                return false;
            }
            if (isReturn && resultExpression instanceof FirWhenExpression) {
                boolean bl4;
                block19: {
                    Iterable $this$any$iv = FirReturnsImpliesAnalyzer.collectBranchExits$default(this, node, null, 1, null);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CFGNode it2 = (CFGNode)element$iv;
                            boolean bl5 = false;
                            if (!INSTANCE.isWrongConditionOnNode(it2, effectDeclaration, effect, function2, logicSystem2, argumentVariables, context2)) continue;
                            bl4 = true;
                            break block19;
                        }
                        bl4 = false;
                    }
                }
                return bl4;
            }
            Ref.ObjectRef flow = new Ref.ObjectRef();
            flow.element = node.getFlow();
            Operation operation = ContractsKt.toOperation(effect.getValue());
            if (operation != null) {
                if (resultExpression instanceof FirLiteralExpression) {
                    if (!this.isTrueFor(operation, ((FirLiteralExpression)resultExpression).getValue())) {
                        return false;
                    }
                } else if (resultExpression instanceof FirExpression) {
                    Map<RealVariable, TypeStatement> impliedByReturnValue;
                    if (expressionType != null && !this.canBeTrueFor(operation, context2.getSession(), expressionType)) {
                        return false;
                    }
                    DataFlowVariable resultVar2 = VariableStorage.get$default(logicSystem2.getVariableStorage(), (FirExpression)resultExpression, true, (Function1)new Function1<RealVariable, RealVariable>(flow.element){

                        public final RealVariable invoke(RealVariable p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return ((PersistentFlow)this.receiver).unwrapVariable(p0);
                        }
                    }, null, 8, null);
                    if (resultVar2 != null && !(impliedByReturnValue = logicSystem2.approveOperationStatement((PersistentFlow)flow.element, new OperationStatement(resultVar2, operation))).isEmpty()) {
                        void it;
                        MutableFlow it2;
                        MutableFlow bl5 = it2 = ((PersistentFlow)flow.element).fork();
                        Ref.ObjectRef objectRef = flow;
                        boolean bl6 = false;
                        logicSystem2.addTypeStatements((MutableFlow)it, impliedByReturnValue);
                        objectRef.element = it2.freeze();
                    }
                }
            }
            Map<RealVariable, TypeStatement> map = ContractsKt.approveContractStatement(logicSystem2, effectDeclaration.getCondition(), argumentVariables, null, (Function1<? super OperationStatement, ? extends Map<RealVariable, ? extends TypeStatement>>)((Function1)arg_0 -> FirReturnsImpliesAnalyzer.isWrongConditionOnNode$lambda$3(logicSystem2, flow, arg_0)));
            if (map == null) {
                return true;
            }
            Map<RealVariable, TypeStatement> conditionStatements = map;
            Iterable $this$all$iv = conditionStatements.values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Object actualType;
                    TypeStatement requirement = (TypeStatement)element$iv;
                    boolean bl7 = false;
                    ConeKotlinType requiredType = UtilKt.smartCastedType(requirement, typeContext2);
                    Object object3 = ((PersistentFlow)flow.element).getTypeStatement(requirement.getVariable());
                    if (object3 == null || (object3 = UtilKt.smartCastedType((TypeStatement)object3, typeContext2)) == null) {
                        object3 = requirement.getVariable().getOriginalType();
                    }
                    if (TypeUtilsKt.isSubtypeOf((KotlinTypeMarker)(actualType = object3), typeContext2, requiredType)) continue;
                    bl2 = false;
                    break block20;
                }
                bl2 = true;
            }
        }
        return !bl2;
    }

    private final boolean canBeTrueFor(Operation $this$canBeTrueFor, FirSession session, ConeKotlinType type2) {
        boolean bl2;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$canBeTrueFor.ordinal()]) {
            case 1: 
            case 2: {
                bl2 = AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(session), (KotlinTypeMarker)session.getBuiltinTypes().getBooleanType().getConeType(), (KotlinTypeMarker)type2, false, 8, null);
                break;
            }
            case 3: {
                bl2 = TypeUtilsKt.canBeNull(type2, session);
                break;
            }
            case 4: {
                if (!ConeBuiltinTypeUtilsKt.isNullableNothing(type2)) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl2;
    }

    private final boolean isTrueFor(Operation $this$isTrueFor, Object value2) {
        boolean bl2;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isTrueFor.ordinal()]) {
            case 1: {
                bl2 = Intrinsics.areEqual((Object)value2, (Object)true);
                break;
            }
            case 2: {
                bl2 = Intrinsics.areEqual((Object)value2, (Object)false);
                break;
            }
            case 3: {
                if (value2 == null) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            case 4: {
                if (value2 != null) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl2;
    }

    private final List<CFGNode<?>> collectBranchExits(CFGNode<?> $this$collectBranchExits, List<CFGNode<?>> nodes) {
        if ($this$collectBranchExits instanceof BlockExitNode) {
            CollectionsKt.addAll((Collection)nodes, (Iterable)CfgTraverserKt.getPreviousCfgNodes($this$collectBranchExits));
        } else {
            Iterable $this$forEach$iv = CfgTraverserKt.getPreviousCfgNodes($this$collectBranchExits);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CFGNode it = (CFGNode)element$iv;
                boolean bl2 = false;
                INSTANCE.collectBranchExits(it, nodes);
            }
        }
        return nodes;
    }

    static /* synthetic */ List collectBranchExits$default(FirReturnsImpliesAnalyzer firReturnsImpliesAnalyzer, CFGNode cFGNode, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            list = new ArrayList();
        }
        return firReturnsImpliesAnalyzer.collectBranchExits(cFGNode, list);
    }

    private final FirPropertySymbol getContainingProperty(CheckerContext $this$containingProperty) {
        Object v0;
        block5: {
            Iterable $this$lastIsInstanceOrNull$iv = $this$containingProperty.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n2 = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n2) {
                    do {
                        int i$iv;
                        Object element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n2--)) instanceof FirPropertySymbol)) continue;
                        v0 = element$iv;
                        break block5;
                    } while (0 <= n2);
                }
                v0 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
                    v0 = element$iv$iv;
                    break block5;
                }
                v0 = null;
            }
        }
        return v0;
    }

    private static final Map isWrongConditionOnNode$lambda$3(LogicSystem $logicSystem, Ref.ObjectRef $flow, OperationStatement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $logicSystem.approveOperationStatement((PersistentFlow)$flow.element, it);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Operation.values().length];
            try {
                nArray[Operation.EqTrue.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.EqFalse.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.EqNull.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.NotEqNull.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

