/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.google.common.collect.ImmutableSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedValueDescriptor;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxedValuesCollection;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0016J*\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u001bH\u0014J \u0010\u001c\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J \u0010\u001f\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u001bH\u0014J \u0010 \u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u001bH\u0014J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u001bH\u0014J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u001bH\u0014J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001bH\u0014J\u001a\u0010&\u001a\u00020\u00182\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "candidatesBoxedValues", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection;", "getCandidatesBoxedValues", "()Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxedValuesCollection;", "unaryOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "value", "binaryOperation", "value1", "value2", "ternaryOperation", "value3", "copyOperation", "processPopInstruction", "", "insnNode", "onNewBoxedValue", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "onUnboxing", "resultType", "Lorg/jetbrains/org/objectweb/asm/Type;", "onAreEqual", "onCompareTo", "onMethodCallWithBoxedValue", "onMergeFail", "onMergeSuccess", "v", "w", "processOperationWithBoxedValue", "markValueAsDirty", "Companion", "backend"})
public final class RedundantBoxingInterpreter
extends BoxingInterpreter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GenerationState generationState;
    @NotNull
    private final RedundantBoxedValuesCollection candidatesBoxedValues;
    private static final ImmutableSet<Integer> PERMITTED_OPERATIONS_OPCODES = ImmutableSet.of(Integer.valueOf(58), Integer.valueOf(25), Integer.valueOf(87), Integer.valueOf(89), Integer.valueOf(192), Integer.valueOf(193), new Integer[0]);
    private static final ImmutableSet<Integer> PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER = ImmutableSet.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), new Integer[0]);

    public RedundantBoxingInterpreter(@NotNull MethodNode methodNode, @NotNull GenerationState generationState) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
        super(insnList, generationState);
        this.generationState = generationState;
        this.candidatesBoxedValues = new RedundantBoxedValuesCollection();
    }

    @NotNull
    public final RedundantBoxedValuesCollection getCandidatesBoxedValues() {
        return this.candidatesBoxedValues;
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if ((insn.getOpcode() == 192 || insn.getOpcode() == 193) && value2 instanceof BoxedBasicValue) {
            TypeInsnNode typeInsn = (TypeInsnNode)insn;
            boolean avoidWrongOptimization = CommonConfigurationKeysKt.getLanguageVersionSettings(this.generationState.getConfiguration()).supportsFeature(LanguageFeature.AvoidWrongOptimizationOfTypeOperatorsOnValueClasses);
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)value2;
            String string = typeInsn.desc;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"desc");
            if (!RedundantBoxingInterpreter.Companion.isSafeCast(boxedBasicValue, string, avoidWrongOptimization)) {
                this.markValueAsDirty((BoxedBasicValue)value2);
            }
        }
        this.processOperationWithBoxedValue(value2, insn);
        return super.unaryOperation(insn, value2);
    }

    @Override
    @Nullable
    public BasicValue binaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value1, (String)"value1");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value2");
        this.processOperationWithBoxedValue(value1, insn);
        this.processOperationWithBoxedValue(value2, insn);
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    @Nullable
    public BasicValue ternaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2, @NotNull BasicValue value3) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value1, (String)"value1");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value2");
        Intrinsics.checkNotNullParameter((Object)value3, (String)"value3");
        this.processOperationWithBoxedValue(value3, insn);
        return super.ternaryOperation(insn, value1, value2, value3);
    }

    @Override
    @NotNull
    public BasicValue copyOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2 instanceof BoxedBasicValue && insn.getOpcode() == 58) {
            ((BoxedBasicValue)value2).getDescriptor().addVariableIndex(((VarInsnNode)insn).var);
        }
        this.processOperationWithBoxedValue(value2, insn);
        BasicValue basicValue = super.copyOperation(insn, value2);
        Intrinsics.checkNotNullExpressionValue((Object)basicValue, (String)"copyOperation(...)");
        return basicValue;
    }

    public final void processPopInstruction(@NotNull AbstractInsnNode insnNode, @NotNull BasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)insnNode, (String)"insnNode");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.processOperationWithBoxedValue(value2, insnNode);
    }

    @Override
    protected void onNewBoxedValue(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.candidatesBoxedValues.add(value2.getDescriptor());
    }

    @Override
    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value2, @NotNull Type resultType) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resultType, (String)"resultType");
        BoxedValueDescriptor $this$onUnboxing_u24lambda_u240 = value2.getDescriptor();
        boolean bl2 = false;
        Type unboxedType = $this$onUnboxing_u24lambda_u240.getUnboxTypeOrOtherwiseMethodReturnType(insn instanceof MethodInsnNode ? (MethodInsnNode)insn : null);
        if (Intrinsics.areEqual((Object)unboxedType, (Object)resultType)) {
            RedundantBoxingInterpreter.Companion.addAssociatedInsn(value2, insn);
        } else {
            $this$onUnboxing_u24lambda_u240.addUnboxingWithCastTo(insn, resultType);
        }
    }

    @Override
    protected void onAreEqual(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value1, (String)"value1");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value2");
        BoxedValueDescriptor descriptor1 = value1.getDescriptor();
        BoxedValueDescriptor descriptor2 = value2.getDescriptor();
        this.candidatesBoxedValues.merge(descriptor1, descriptor2);
        descriptor1.addInsn(insn);
    }

    @Override
    protected void onCompareTo(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value1, (String)"value1");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value2");
        BoxedValueDescriptor descriptor1 = value1.getDescriptor();
        BoxedValueDescriptor descriptor2 = value2.getDescriptor();
        this.candidatesBoxedValues.merge(descriptor1, descriptor2);
        descriptor1.addInsn(insn);
    }

    @Override
    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.markValueAsDirty(value2);
    }

    @Override
    protected void onMergeFail(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.markValueAsDirty(value2);
    }

    @Override
    protected void onMergeSuccess(@NotNull BoxedBasicValue v2, @NotNull BoxedBasicValue w2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        Intrinsics.checkNotNullParameter((Object)w2, (String)"w");
        this.candidatesBoxedValues.merge(v2.getDescriptor(), w2.getDescriptor());
    }

    private final void processOperationWithBoxedValue(BasicValue value2, AbstractInsnNode insnNode) {
        if (value2 instanceof BoxedBasicValue) {
            this.checkUsedValue(value2);
            if (!PERMITTED_OPERATIONS_OPCODES.contains(insnNode.getOpcode())) {
                this.markValueAsDirty((BoxedBasicValue)value2);
            } else {
                RedundantBoxingInterpreter.Companion.addAssociatedInsn((BoxedBasicValue)value2, insnNode);
            }
        }
    }

    private final void markValueAsDirty(BoxedBasicValue value2) {
        this.candidatesBoxedValues.remove(value2.getDescriptor());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter$Companion;", "", "<init>", "()V", "PERMITTED_OPERATIONS_OPCODES", "Lcom/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER", "isSafeCast", "", "value", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "targetInternalName", "", "avoidWrongOptimization", "addAssociatedInsn", "", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "backend"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSafeCast(BoxedBasicValue value2, String targetInternalName, boolean avoidWrongOptimization) {
            Type unboxedType;
            String string = targetInternalName;
            boolean bl2 = Intrinsics.areEqual((Object)string, (Object)Type.getInternalName(Object.class)) ? true : (Intrinsics.areEqual((Object)string, (Object)Type.getInternalName(Number.class)) ? (value2.getDescriptor().isValueClassValue() && avoidWrongOptimization ? false : (unboxedType = (Type)CollectionsKt.singleOrNull(value2.getDescriptor().getUnboxedTypes())) != null && PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER.contains(unboxedType.getSort())) : (Intrinsics.areEqual((Object)string, (Object)"java/lang/Comparable") ? !value2.getDescriptor().isValueClassValue() || !avoidWrongOptimization : Intrinsics.areEqual((Object)value2.getType().getInternalName(), (Object)targetInternalName)));
            return bl2;
        }

        private final void addAssociatedInsn(BoxedBasicValue value2, AbstractInsnNode insn) {
            BoxedValueDescriptor $this$addAssociatedInsn_u24lambda_u240 = value2.getDescriptor();
            boolean bl2 = false;
            if ($this$addAssociatedInsn_u24lambda_u240.isSafeToRemove()) {
                $this$addAssociatedInsn_u24lambda_u240.addInsn(insn);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

