/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ4\u0010\u000e\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00142\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVisibilityQualifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirResolvedQualifierChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;)V", "checkClassLikeSymbol", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isStandalone", "", "toInvisibleCompanion", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers"})
public final class FirVisibilityQualifierChecker
extends FirExpressionChecker<FirResolvedQualifier> {
    @NotNull
    public static final FirVisibilityQualifierChecker INSTANCE = new FirVisibilityQualifierChecker();

    private FirVisibilityQualifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirResolvedQualifier expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirClassLikeSymbol<?> firClassLikeSymbol = expression2.getSymbol();
        if (firClassLikeSymbol == null) {
            return;
        }
        this.checkClassLikeSymbol(firClassLikeSymbol, expression2, FirHelpersKt.isStandalone(expression2, context2), context2, reporter);
    }

    private final void checkClassLikeSymbol(FirClassLikeSymbol<?> symbol, FirResolvedQualifier expression2, boolean isStandalone, CheckerContext context2, DiagnosticReporter reporter) {
        block8: {
            Object object;
            FirFileSymbol firFileSymbol = context2.getContainingFileSymbol();
            if (firFileSymbol == null) {
                return;
            }
            FirFileSymbol containingFileSymbol = firFileSymbol;
            KtSourceElement ktSourceElement = expression2.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitReceiver.INSTANCE) && !FirVisibilityCheckerKt.isClassLikeVisible(FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession()), symbol, context2.getSession(), containingFileSymbol, context2.getContainingDeclarations())) {
                List<FirDeclaration> list;
                if (!(expression2 instanceof FirErrorResolvedQualifier && ((FirErrorResolvedQualifier)expression2).getDiagnostic() instanceof ConeVisibilityError || ((list = context2.getContainingFileSymbol()) != null && (list = (FirFile)((FirBasedSymbol)((Object)list)).getFir()) != null && (list = ((FirFile)((Object)list)).getDeclarations()) != null ? (FirDeclaration)CollectionsKt.singleOrNull(list) : null) instanceof FirCodeFragment)) {
                    reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)symbol, expression2.getSource(), context2.getSession()), context2);
                }
                return;
            }
            if (isStandalone) {
                FirRegularClassSymbol invisibleCompanion;
                FirRegularClassSymbol firRegularClassSymbol = expression2.getSymbol();
                FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol != null && (firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(firRegularClassSymbol, context2.getSession())) != null ? this.toInvisibleCompanion(firRegularClassSymbol, context2) : (invisibleCompanion = null);
                if (invisibleCompanion != null) {
                    List<FirDeclaration> list;
                    if (!(expression2 instanceof FirErrorResolvedQualifier && ((FirErrorResolvedQualifier)expression2).getDiagnostic() instanceof ConeVisibilityError || ((list = context2.getContainingFileSymbol()) != null && (list = (FirFile)((FirBasedSymbol)((Object)list)).getFir()) != null && (list = ((FirFile)((Object)list)).getDeclarations()) != null ? (FirDeclaration)CollectionsKt.singleOrNull(list) : null) instanceof FirCodeFragment)) {
                        reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(invisibleCompanion, expression2.getSource(), context2.getSession()), context2);
                    }
                    return;
                }
            }
            if (symbol instanceof FirTypeAliasSymbol) {
                FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toClassLikeSymbol(((FirTypeAliasSymbol)symbol).getResolvedExpandedTypeRef().getConeType(), context2.getSession());
                if (firClassLikeSymbol != null) {
                    FirClassLikeSymbol<?> it = firClassLikeSymbol;
                    boolean bl2 = false;
                    INSTANCE.checkClassLikeSymbol(it, expression2, isStandalone, context2, reporter);
                }
            }
            if ((object = FirVisibilityCheckerKt.getOwnerLookupTag((FirBasedSymbol)symbol)) == null || (object = ToSymbolUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context2.getSession())) == null) break block8;
            Object it = object;
            boolean bl3 = false;
            INSTANCE.checkClassLikeSymbol((FirClassLikeSymbol<?>)it, expression2, false, context2, reporter);
        }
    }

    private final FirRegularClassSymbol toInvisibleCompanion(FirRegularClassSymbol $this$toInvisibleCompanion, CheckerContext context2) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirFileSymbol firFileSymbol = context2.getContainingFileSymbol();
        if (firFileSymbol == null) {
            return null;
        }
        FirFileSymbol firFile = firFileSymbol;
        FirRegularClassSymbol firRegularClassSymbol2 = $this$toInvisibleCompanion.getResolvedCompanionObjectSymbol();
        if (firRegularClassSymbol2 != null) {
            FirRegularClassSymbol firRegularClassSymbol3;
            FirRegularClassSymbol it = firRegularClassSymbol3 = firRegularClassSymbol2;
            boolean bl2 = false;
            firRegularClassSymbol = !FirVisibilityCheckerKt.isClassLikeVisible(FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession()), it, context2.getSession(), firFile, context2.getContainingDeclarations()) ? firRegularClassSymbol3 : null;
        } else {
            firRegularClassSymbol = null;
        }
        return firRegularClassSymbol;
    }
}

