/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.web.common.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH&J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH&J-\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u00020\u0011R\u00020\u0013j\u0006\u0010\u0010\u001a\u00020\u0011j\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u001aJ\u001c\u0010\u001b\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u001c\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u001d\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u001e\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u001f\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010 \u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010!\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\"\u001a\u00020\u0005*\u00020#H\u0002J\f\u0010$\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010%\u001a\u00020\u0005*\u00020&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "allowCompanionInInterface", "", "<init>", "(Z)V", "isNativeOrEffectivelyExternal", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reportExternalEnum", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "additionalCheck", "isDefinedExternallyCallableId", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "hasExternalLikeAnnotations", "check", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkBody", "checkDelegation", "checkAnonymousInitializer", "checkConstructorPropertyParam", "isDirectlyExternal", "isPrivateMemberOfExternalClass", "isNonAbstractMemberIfInterface", "isNullableProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "hasValidExternalBody", "isDefinedExternallyExpression", "Lorg/jetbrains/kotlin/fir/FirElement;", "checkers.web.common"})
@SourceDebugExtension(value={"SMAP\nFirWebCommonExternalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWebCommonExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,270:1\n70#2:271\n67#2:275\n21#2:291\n21#2:293\n11#2:294\n37#3:272\n34#3:273\n34#3:274\n34#3:276\n1617#4,9:277\n1869#4:286\n1870#4:288\n1626#4:289\n1#5:287\n66#6:290\n18#6:292\n*S KotlinDebug\n*F\n+ 1 FirWebCommonExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker\n*L\n72#1:271\n99#1:275\n230#1:291\n231#1:293\n239#1:294\n72#1:272\n88#1:273\n89#1:274\n99#1:276\n167#1:277,9\n167#1:286\n167#1:288\n167#1:289\n167#1:287\n218#1:290\n230#1:292\n*E\n"})
public abstract class FirWebCommonExternalChecker
extends FirDeclarationChecker<FirDeclaration> {
    private final boolean allowCompanionInInterface;

    public FirWebCommonExternalChecker(boolean allowCompanionInInterface) {
        super(MppCheckerKind.Common);
        this.allowCompanionInInterface = allowCompanionInInterface;
    }

    public abstract boolean isNativeOrEffectivelyExternal(@NotNull FirBasedSymbol<?> var1, @NotNull FirSession var2);

    public abstract void reportExternalEnum(@NotNull FirDeclaration var1, @NotNull CheckerContext var2, @NotNull DiagnosticReporter var3);

    public abstract void additionalCheck(@NotNull FirDeclaration var1, @NotNull CheckerContext var2, @NotNull DiagnosticReporter var3);

    public abstract boolean isDefinedExternallyCallableId(@NotNull CallableId var1);

    public abstract boolean hasExternalLikeAnnotations(@NotNull FirDeclaration var1, @NotNull FirSession var2);

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration2) {
        boolean $i$f$isInterface;
        Object $this$isInterface$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!this.isNativeOrEffectivelyExternal(declaration2.getSymbol(), context2.getSession())) {
            return;
        }
        if (!FirHelpersKt.isTopLevel(context2) && !(declaration2 instanceof FirPropertyAccessor) && this.isDirectlyExternal(declaration2, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getNESTED_EXTERNAL_DECLARATION(), null, 8, null);
        }
        if (declaration2 instanceof FirClass) {
            String classKind2;
            String string = ((FirClass)declaration2).getStatus().isData() ? "data class" : (((FirClass)declaration2).getStatus().isInner() ? "inner class" : (((FirClass)declaration2).getStatus().isInline() || ((FirClass)declaration2).getStatus().isValue() ? "value class" : (((FirClass)declaration2).getStatus().isFun() ? "fun interface" : (classKind2 = ((FirClass)declaration2).getClassKind() == ClassKind.ANNOTATION_CLASS ? "annotation class" : null))));
            if (classKind2 != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirClass)declaration2).getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)classKind2, null, 16, null);
            }
            FirClass $this$isEnumClass$iv = (FirClass)declaration2;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            boolean bl2 = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
            if (bl2) {
                this.reportExternalEnum(declaration2, context2, reporter);
            }
        }
        if (!(declaration2 instanceof FirConstructor) && !(declaration2 instanceof FirField) && this.isPrivateMemberOfExternalClass(declaration2, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)"private member of class", null, 16, null);
        }
        FirDeclaration container = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (declaration2 instanceof FirClass) {
            $this$isInterface$iv = ((FirClass)declaration2).getClassKind();
            $i$f$isInterface = false;
            if (!($this$isInterface$iv == ClassKind.INTERFACE || this.allowCompanionInInterface && ((FirClass)declaration2).getStatus().isCompanion() || !(container instanceof FirClass))) {
                $this$isInterface$iv = ((FirClass)container).getClassKind();
                $i$f$isInterface = false;
                if ($this$isInterface$iv == ClassKind.INTERFACE) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirClass)declaration2).getSource(), FirWebCommonErrors.INSTANCE.getNESTED_CLASS_IN_EXTERNAL_INTERFACE(), null, 8, null);
                }
            }
        }
        if (this.allowCompanionInInterface && declaration2 instanceof FirClass && ((FirClass)declaration2).getStatus().isCompanion() && container instanceof FirClass) {
            $this$isInterface$iv = (FirClass)container;
            $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = ((FirClass)$this$isInterface$iv).getClassKind();
            boolean $i$f$isInterface2 = false;
            boolean bl3 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            if (bl3 && !Intrinsics.areEqual((Object)FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)declaration2), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirClass)declaration2).getSource(), FirWebCommonErrors.INSTANCE.getNAMED_COMPANION_IN_EXTERNAL_INTERFACE(), null, 8, null);
            }
        }
        if (!(declaration2 instanceof FirPropertyAccessor) && declaration2 instanceof FirCallableDeclaration && FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration2)) {
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)declaration2;
            String target = firCallableDeclaration instanceof FirFunction ? "extension function" : (firCallableDeclaration instanceof FirProperty ? "extension property" : "extension member");
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirCallableDeclaration)declaration2).getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)target, null, 16, null);
        }
        if (declaration2 instanceof FirCallableDeclaration && this.isNonAbstractMemberIfInterface(declaration2, context2.getSession()) && !this.isNullableProperty((FirCallableDeclaration)declaration2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirCallableDeclaration)declaration2).getSource(), FirWebCommonErrors.INSTANCE.getNON_ABSTRACT_MEMBER_OF_EXTERNAL_INTERFACE(), null, 8, null);
        }
        this.checkBody(declaration2, context2, reporter);
        this.checkDelegation(declaration2, context2, reporter);
        this.checkAnonymousInitializer(declaration2, context2, reporter);
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsExternalPropertyParameters)) {
            this.checkConstructorPropertyParam(declaration2, context2, reporter);
        }
        this.additionalCheck(declaration2, context2, reporter);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBody(FirDeclaration $this$checkBody, CheckerContext context2, DiagnosticReporter reporter) {
        boolean isWrong;
        FirExpression firExpression;
        if ($this$checkBody instanceof FirDefaultPropertyAccessor) {
            return;
        }
        FirDeclaration firDeclaration = $this$checkBody;
        FirBlock body = firDeclaration instanceof FirFunction ? ((FirFunction)$this$checkBody).getBody() : (firDeclaration instanceof FirAnonymousInitializer ? ((FirAnonymousInitializer)$this$checkBody).getBody() : null);
        if ($this$checkBody instanceof FirEnumEntry) {
            firExpression = null;
        } else {
            KtSourceElement ktSourceElement = $this$checkBody.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                firExpression = null;
            } else if ($this$checkBody instanceof FirVariable) {
                firExpression = ((FirVariable)$this$checkBody).getInitializer();
            } else if (body instanceof FirSingleExpressionBlock) {
                FirStatement firStatement = ((FirSingleExpressionBlock)body).getStatement();
                FirReturnExpression firReturnExpression = firStatement instanceof FirReturnExpression ? (FirReturnExpression)firStatement : null;
                firExpression = firReturnExpression != null ? firReturnExpression.getResult() : null;
            } else {
                firExpression = null;
            }
        }
        FirExpression initializer = firExpression;
        KtSourceElement ktSourceElement = $this$checkBody.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
            return;
        }
        boolean bl2 = isWrong = !(body instanceof FirSingleExpressionBlock) && !this.hasValidExternalBody($this$checkBody) || initializer != null && !this.isDefinedExternallyExpression(initializer);
        if (isWrong && body != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)body.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_BODY_OF_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        } else if (isWrong && initializer != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)initializer.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_INITIALIZER_OF_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
        if ($this$checkBody instanceof FirFunction) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = ((FirFunction)$this$checkBody).getValueParameters();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirExpression it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                FirValueParameter it = (FirValueParameter)element$iv$iv;
                boolean bl4 = false;
                if (it.getDefaultValue() == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (FirExpression defaultValue : (List)destination$iv$iv) {
                if (this.isDefinedExternallyExpression(defaultValue)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)defaultValue.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_DEFAULT_VALUE_FOR_EXTERNAL_FUN_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkDelegation(FirDeclaration $this$checkDelegation, CheckerContext context2, DiagnosticReporter reporter) {
        block6: {
            block7: {
                block5: {
                    if (!($this$checkDelegation instanceof FirMemberDeclaration) || !this.isNativeOrEffectivelyExternal(((FirMemberDeclaration)$this$checkDelegation).getSymbol(), context2.getSession())) {
                        return;
                    }
                    if (!($this$checkDelegation instanceof FirClass)) break block5;
                    FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny((FirClass)$this$checkDelegation, context2.getSession());
                    if (firConstructorSymbol != null) {
                        FirConstructorSymbol it = firConstructorSymbol;
                        boolean bl2 = false;
                        FirDelegatedConstructorCall constructorCall = it.getResolvedDelegatedConstructorCall();
                        Object object = constructorCall;
                        if ((object != null && (object = ((FirDelegatedConstructorCall)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtRealSourceElementKind) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)constructorCall.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_DELEGATED_CONSTRUCTOR_CALL(), (DiagnosticContext)context2, null, 8, null);
                        }
                    }
                    for (Map.Entry<FirTypeRef, FirFieldSymbol> entry : FirHelpersKt.collectSupertypesWithDelegates((FirClass)$this$checkDelegation).entrySet()) {
                        FirTypeRef superType = entry.getKey();
                        FirFieldSymbol delegate = entry.getValue();
                        if (delegate == null) continue;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superType.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_DELEGATION(), (DiagnosticContext)context2, null, 8, null);
                    }
                    break block6;
                }
                if (!($this$checkDelegation instanceof FirConstructor) || ((FirConstructor)$this$checkDelegation).isPrimary()) break block7;
                FirDelegatedConstructorCall delegationCall = ((FirConstructor)$this$checkDelegation).getDelegatedConstructor();
                Object object = delegationCall;
                if (!((object != null && (object = ((FirDelegatedConstructorCall)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtRealSourceElementKind)) break block6;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)delegationCall.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_DELEGATED_CONSTRUCTOR_CALL(), (DiagnosticContext)context2, null, 8, null);
                break block6;
            }
            if (!($this$checkDelegation instanceof FirProperty)) break block6;
            FirExpression firExpression = ((FirProperty)$this$checkDelegation).getDelegate();
            if (firExpression != null) {
                FirExpression it = firExpression;
                boolean bl3 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_DELEGATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkAnonymousInitializer(FirDeclaration $this$checkAnonymousInitializer, CheckerContext context2, DiagnosticReporter reporter) {
        if (!($this$checkAnonymousInitializer instanceof FirClass)) {
            return;
        }
        for (FirAnonymousInitializer anonymousInitializer : FirDeclarationUtilKt.getAnonymousInitializers((FirClass)$this$checkAnonymousInitializer)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)anonymousInitializer.getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_ANONYMOUS_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkConstructorPropertyParam(FirDeclaration $this$checkConstructorPropertyParam, CheckerContext context2, DiagnosticReporter reporter) {
        block6: {
            block5: {
                if (!($this$checkConstructorPropertyParam instanceof FirProperty)) break block5;
                KtSourceElement ktSourceElement = ((FirProperty)$this$checkConstructorPropertyParam).getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) break block6;
            }
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$checkConstructorPropertyParam);
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol containingClass = firClassSymbol;
        FirClassLikeSymbol $this$isData$iv = containingClass;
        boolean $i$f$isData = false;
        if ($this$isData$iv.getRawStatus().isData() || containingClass.getClassKind() == ClassKind.ANNOTATION_CLASS) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirProperty)$this$checkConstructorPropertyParam).getSource(), FirWebCommonErrors.INSTANCE.getEXTERNAL_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean isDirectlyExternal(FirDeclaration $this$isDirectlyExternal, FirSession session) {
        block3: {
            block2: {
                if ($this$isDirectlyExternal instanceof FirDefaultPropertyAccessor) break block2;
                KtSourceElement ktSourceElement = $this$isDirectlyExternal.getSource();
                if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind) break block3;
            }
            return false;
        }
        FirElement firElement = $this$isDirectlyExternal;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.EXTERNAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"EXTERNAL_KEYWORD");
        return FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken) || this.hasExternalLikeAnnotations($this$isDirectlyExternal, session);
    }

    private final boolean isPrivateMemberOfExternalClass(FirDeclaration $this$isPrivateMemberOfExternalClass, FirSession session) {
        block7: {
            block6: {
                boolean $i$f$getVisibility;
                Object $this$visibility$iv;
                if ($this$isPrivateMemberOfExternalClass instanceof FirPropertyAccessor) {
                    $this$visibility$iv = (FirMemberDeclaration)$this$isPrivateMemberOfExternalClass;
                    $i$f$getVisibility = false;
                    Visibility visibility = ((FirMemberDeclaration)$this$visibility$iv).getStatus().getVisibility();
                    $this$visibility$iv = ((FirPropertyAccessor)$this$isPrivateMemberOfExternalClass).getPropertySymbol();
                    $i$f$getVisibility = false;
                    if (Intrinsics.areEqual((Object)visibility, (Object)((FirCallableSymbol)$this$visibility$iv).getResolvedStatus().getVisibility())) {
                        return false;
                    }
                }
                if (!($this$isPrivateMemberOfExternalClass instanceof FirMemberDeclaration)) break block6;
                $this$visibility$iv = (FirMemberDeclaration)$this$isPrivateMemberOfExternalClass;
                $i$f$getVisibility = false;
                if (Intrinsics.areEqual((Object)((FirMemberDeclaration)$this$visibility$iv).getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) break block7;
            }
            return false;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$isPrivateMemberOfExternalClass);
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> containingDeclaration = firClassLikeSymbol;
        return this.isNativeOrEffectivelyExternal((FirBasedSymbol)containingDeclaration, session);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNonAbstractMemberIfInterface(FirDeclaration $this$isNonAbstractMemberIfInterface, FirSession session) {
        if (!($this$isNonAbstractMemberIfInterface instanceof FirCallableDeclaration)) return false;
        FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)$this$isNonAbstractMemberIfInterface;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() == Modality.ABSTRACT) return false;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$isNonAbstractMemberIfInterface);
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if ((firClassSymbol != null ? firClassSymbol.getClassKind() : null) != ClassKind.INTERFACE) return false;
        if ($this$isNonAbstractMemberIfInterface instanceof FirPropertyAccessor) return false;
        return true;
    }

    private final boolean isNullableProperty(FirCallableDeclaration $this$isNullableProperty) {
        return $this$isNullableProperty instanceof FirProperty && ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(FirTypeUtilsKt.getConeType(((FirProperty)$this$isNullableProperty).getReturnTypeRef()));
    }

    private final boolean hasValidExternalBody(FirDeclaration $this$hasValidExternalBody) {
        boolean bl2;
        FirBlock firBlock;
        FirDeclaration firDeclaration = $this$hasValidExternalBody;
        if (firDeclaration instanceof FirFunction) {
            firBlock = ((FirFunction)$this$hasValidExternalBody).getBody();
        } else if (firDeclaration instanceof FirAnonymousInitializer) {
            firBlock = ((FirAnonymousInitializer)$this$hasValidExternalBody).getBody();
        } else {
            return true;
        }
        FirBlock body = firBlock;
        if (body instanceof FirSingleExpressionBlock) {
            bl2 = this.isDefinedExternallyExpression(body);
        } else if (body != null) {
            FirStatement firStatement = (FirStatement)CollectionsKt.singleOrNull(body.getStatements());
            if (firStatement == null) {
                return false;
            }
            FirStatement statement = firStatement;
            bl2 = this.isDefinedExternallyExpression(statement);
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private final boolean isDefinedExternallyExpression(FirElement $this$isDefinedExternallyExpression) {
        FirPropertySymbol firPropertySymbol;
        FirNamedReference firNamedReference;
        FirPropertyAccessExpression firPropertyAccessExpression;
        FirPropertyAccessExpression firPropertyAccessExpression2 = firPropertyAccessExpression = $this$isDefinedExternallyExpression instanceof FirPropertyAccessExpression ? (FirPropertyAccessExpression)$this$isDefinedExternallyExpression : null;
        if (firPropertyAccessExpression == null || (firNamedReference = firPropertyAccessExpression.getCalleeReference()) == null || (firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(firNamedReference, false, 1, null)) == null) {
            return false;
        }
        FirPropertySymbol declaration2 = firPropertySymbol;
        return this.isDefinedExternallyCallableId(declaration2.getCallableId());
    }
}

