/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class PsiArrayAccessExpressionImpl
extends ExpressionPsiElement
implements PsiArrayAccessExpression,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiArrayAccessExpressionImpl.class);

    public PsiArrayAccessExpressionImpl() {
        super(ARRAY_ACCESS_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiExpression getArrayExpression() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(88);
        if (psiExpression == null) {
            PsiArrayAccessExpressionImpl.$$$reportNull$$$0(0);
        }
        return psiExpression;
    }

    @Override
    public PsiExpression getIndexExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(89);
    }

    @Override
    public PsiType getType() {
        PsiType arrayType2 = this.getArrayExpression().getType();
        if (!(arrayType2 instanceof PsiArrayType)) {
            return null;
        }
        PsiType componentType = ((PsiArrayType)arrayType2).getComponentType();
        if (PsiUtil.isAccessedForWriting(this)) {
            return componentType;
        }
        return PsiUtil.captureToplevelWildcards(componentType, this);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 88: {
                return this.getFirstChildNode();
            }
            case 89: {
                ASTNode lbracket = this.findChildByRole(74);
                if (lbracket == null) {
                    return null;
                }
                for (ASTNode child = lbracket.getTreeNext(); child != null; child = child.getTreeNext()) {
                    if (!EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                    return child;
                }
                return null;
            }
            case 74: {
                return this.findChildByType(LBRACKET);
            }
            case 75: 
        }
        return this.findChildByType(RBRACKET);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiArrayAccessExpressionImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == LBRACKET) {
            return 74;
        }
        if (i2 == RBRACKET) {
            return 75;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return child == this.getFirstChildNode() ? 88 : 89;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiArrayAccessExpressionImpl.$$$reportNull$$$0(2);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitArrayAccessExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiArrayAccessExpression:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiArrayAccessExpressionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayExpression";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiArrayAccessExpressionImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

