/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.parser.BasicExpressionParser;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.BasicJavaDocElementType;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.psi.tree.ParentProviderElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.tree.java.IJavaDocElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicJavaAstTreeUtil {
    private BasicJavaAstTreeUtil() {
    }

    @Contract(value="null ,_ -> false")
    public static boolean is(@Nullable ASTNode element2, @Nullable IElementType iElementType) {
        boolean notNull;
        boolean bl2 = notNull = element2 != null && iElementType != null;
        if (!notNull) {
            return false;
        }
        IElementType sourceElementType = element2.getElementType();
        return BasicJavaAstTreeUtil.is(sourceElementType, iElementType);
    }

    public static boolean is(@NotNull IElementType source, @NotNull IElementType target) {
        if (source == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(0);
        }
        if (target == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(1);
        }
        if (source == target) {
            return true;
        }
        if (source instanceof ParentProviderElementType) {
            Set<IElementType> parents2 = ((ParentProviderElementType)((Object)source)).getParents();
            return ContainerUtil.exists(parents2, parent2 -> parent2 != null && BasicJavaAstTreeUtil.is(parent2, target));
        }
        return false;
    }

    @Contract(value="null ,_ -> false")
    public static boolean is(@Nullable ASTNode element2, @NotNull Set<IElementType> iElementTypes) {
        boolean isNotNull;
        if (iElementTypes == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(2);
        }
        boolean bl2 = isNotNull = element2 != null;
        if (!isNotNull) {
            return false;
        }
        return BasicJavaAstTreeUtil.is(element2.getElementType(), iElementTypes);
    }

    public static boolean is(@Nullable ASTNode element2, @NotNull TokenSet tokenSet) {
        boolean isNotNull;
        if (tokenSet == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(3);
        }
        boolean bl2 = isNotNull = element2 != null;
        if (!isNotNull) {
            return false;
        }
        return ParentProviderElementType.containsWithSourceParent(element2.getElementType(), tokenSet);
    }

    public static boolean is(@Nullable ASTNode element2, @NotNull ParentAwareTokenSet tokenSet) {
        boolean isNotNull;
        if (tokenSet == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(4);
        }
        boolean bl2 = isNotNull = element2 != null;
        if (!isNotNull) {
            return false;
        }
        return BasicJavaAstTreeUtil.is(element2.getElementType(), tokenSet);
    }

    private static boolean is(@NotNull IElementType source, @NotNull ParentAwareTokenSet tokenSet) {
        if (source == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(5);
        }
        if (tokenSet == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(6);
        }
        return tokenSet.contains(source);
    }

    private static boolean is(@NotNull IElementType source, @NotNull Set<IElementType> tokenSet) {
        if (source == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(7);
        }
        if (tokenSet == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(8);
        }
        if (tokenSet.contains(source)) {
            return true;
        }
        if (source instanceof ParentProviderElementType) {
            Set<IElementType> parents2 = ((ParentProviderElementType)((Object)source)).getParents();
            return ContainerUtil.exists(parents2, parent2 -> parent2 != null && BasicJavaAstTreeUtil.is(parent2, tokenSet));
        }
        return false;
    }

    public static boolean is(@Nullable ASTNode element2, IElementType ... iElementTypes) {
        return BasicJavaAstTreeUtil.is(element2, ParentAwareTokenSet.create(iElementTypes));
    }

    public static List<ASTNode> getChildren(@Nullable ASTNode element2) {
        ArrayList<ASTNode> results = new ArrayList<ASTNode>();
        if (element2 == null) {
            return results;
        }
        for (ASTNode child = element2.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            results.add(child);
        }
        return results;
    }

    @Nullable
    public static ASTNode getReferenceNameElement(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        IElementType type2 = element2.getElementType();
        if (BasicJavaAstTreeUtil.is(type2, BasicJavaElementType.BASIC_IMPORT_STATIC_REFERENCE)) {
            return BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.IDENTIFIER);
        }
        if (BasicJavaAstTreeUtil.is(type2, BasicJavaElementType.BASIC_JAVA_CODE_REFERENCE)) {
            return TreeUtil.findChildBackward(element2, JavaTokenType.IDENTIFIER);
        }
        if (BasicJavaAstTreeUtil.is(type2, BasicJavaElementType.BASIC_METHOD_REF_EXPRESSION)) {
            ASTNode lastChild = element2.getLastChildNode();
            return BasicJavaAstTreeUtil.is(lastChild, JavaTokenType.IDENTIFIER) || BasicJavaAstTreeUtil.is(lastChild, JavaTokenType.NEW_KEYWORD) ? lastChild : null;
        }
        if (BasicJavaAstTreeUtil.is(type2, BasicJavaElementType.BASIC_REFERENCE_EXPRESSION)) {
            ASTNode lastChild = element2.getLastChildNode();
            return lastChild == null || BasicJavaAstTreeUtil.is(lastChild, ContainerUtil.newHashSet(JavaTokenType.IDENTIFIER, JavaTokenType.THIS_KEYWORD, JavaTokenType.SUPER_KEYWORD)) ? lastChild : BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.IDENTIFIER);
        }
        return null;
    }

    @Nullable
    public static ASTNode findChildByType(@Nullable ASTNode astNode, IElementType ... targets) {
        return BasicJavaAstTreeUtil.findChildByType(astNode, ParentAwareTokenSet.create(targets));
    }

    @Nullable
    public static ASTNode findChildByType(@Nullable ASTNode astNode, ParentAwareTokenSet targets) {
        if (astNode == null) {
            return null;
        }
        for (ASTNode child = astNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType elementType = child.getElementType();
            if (!BasicJavaAstTreeUtil.is(elementType, targets)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static ASTNode getElseElement(@NotNull ASTNode element2) {
        if (element2 == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(9);
        }
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_IF_STATEMENT)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.ELSE_KEYWORD);
    }

    @Nullable
    public static ASTNode getThenBranch(@NotNull ASTNode element2) {
        if (element2 == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(10);
        }
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_IF_STATEMENT)) {
            return null;
        }
        for (ASTNode child : BasicJavaAstTreeUtil.getChildren(element2)) {
            if (!BasicJavaAstTreeUtil.is(child, BasicJavaElementType.STATEMENT_SET)) continue;
            return child;
        }
        return null;
    }

    public static ASTNode getElseBranch(@Nullable ASTNode element2) {
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_IF_STATEMENT)) {
            return null;
        }
        ASTNode elseKeyword = BasicJavaAstTreeUtil.getElseElement(element2);
        if (elseKeyword == null) {
            return null;
        }
        for (ASTNode child = elseKeyword.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (!BasicJavaAstTreeUtil.is(child, BasicJavaElementType.STATEMENT_SET)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static ASTNode getLParenth(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.LPARENTH);
    }

    @Nullable
    public static ASTNode getRParenth(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.RPARENTH);
    }

    @Nullable
    public static ASTNode getFinallyBlock(@Nullable ASTNode element2) {
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_TRY_STATEMENT)) {
            return null;
        }
        ASTNode finallyKeyword = BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.FINALLY_KEYWORD);
        if (finallyKeyword == null) {
            return null;
        }
        for (ASTNode child = finallyKeyword.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (!BasicJavaAstTreeUtil.is(child, BasicJavaElementType.BASIC_CODE_BLOCK)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static ASTNode getNameIdentifier(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.IDENTIFIER);
    }

    @Nullable
    public static ASTNode getInitializer(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.EXPRESSION_SET);
    }

    @Nullable
    public static ASTNode getDocComment(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaDocElementType.BASIC_DOC_COMMENT);
    }

    @Nullable
    public static ASTNode getTypeElement(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.BASIC_TYPE);
    }

    @Nullable
    public static ASTNode getModifierList(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.BASIC_MODIFIER_LIST);
    }

    @Nullable
    public static ASTNode getLBrace(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.LBRACE);
    }

    @Nullable
    public static ASTNode getRBrace(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.RBRACE);
    }

    public static boolean isJavaToken(@Nullable ASTNode element2) {
        if (element2 == null) {
            return false;
        }
        return BasicJavaAstTreeUtil.toPsi(element2) instanceof PsiJavaToken || BasicJavaAstTreeUtil.is(element2, JavaTokenType.IDENTIFIER) || BasicJavaAstTreeUtil.isKeyword(element2) || JavaTokenType.JAVA_TOKEN_TYPE_SET.contains(element2.getElementType());
    }

    public static boolean isKeyword(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.is(element2, BasicElementTypes.BASIC_KEYWORD_BIT_SET);
    }

    public static boolean isWhiteSpace(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.is(element2, TokenType.WHITE_SPACE);
    }

    @Nullable
    public static ASTNode skipSiblingsBackward(@Nullable ASTNode element2, IElementType ... elementClasses) {
        if (element2 != null) {
            for (ASTNode e2 = element2.getTreePrev(); e2 != null; e2 = e2.getTreePrev()) {
                if (BasicJavaAstTreeUtil.is(e2, elementClasses)) continue;
                return e2;
            }
        }
        return null;
    }

    @Nullable
    public static ASTNode skipSiblingsForward(@Nullable ASTNode element2, IElementType ... elementClasses) {
        if (element2 != null) {
            for (ASTNode e2 = element2.getTreeNext(); e2 != null; e2 = e2.getTreeNext()) {
                if (BasicJavaAstTreeUtil.is(e2, elementClasses)) continue;
                return e2;
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement toPsi(@Nullable ASTNode astNode) {
        return SourceTreeToPsiMap.treeElementToPsi(astNode);
    }

    @Nullable
    public static ASTNode toNode(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        return psiElement.getNode();
    }

    @Nullable
    public static ASTNode getParentOfType(@Nullable ASTNode e2, @NotNull ParentAwareTokenSet set) {
        if (set == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(11);
        }
        if (e2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findParent(e2, set);
    }

    @Nullable
    private static ASTNode findParent(@NotNull ASTNode element2, @NotNull IElementType type2) {
        if (element2 == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(12);
        }
        if (type2 == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(13);
        }
        for (ASTNode parent2 = element2.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (!BasicJavaAstTreeUtil.is(parent2.getElementType(), type2)) continue;
            return parent2;
        }
        return null;
    }

    @Nullable
    private static ASTNode findParent(@NotNull ASTNode element2, @NotNull ParentAwareTokenSet type2) {
        if (element2 == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(14);
        }
        if (type2 == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(15);
        }
        for (ASTNode parent2 = element2.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (!BasicJavaAstTreeUtil.is(parent2.getElementType(), type2)) continue;
            return parent2;
        }
        return null;
    }

    @Nullable
    public static ASTNode getParentOfType(@Nullable ASTNode e2, @NotNull IElementType elementType) {
        if (elementType == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(16);
        }
        if (e2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findParent(e2, elementType);
    }

    @Nullable
    public static ASTNode getMethodExpression(@Nullable ASTNode element2) {
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_METHOD_CALL_EXPRESSION)) {
            return null;
        }
        return element2.getFirstChildNode();
    }

    @Nullable
    public static ASTNode getExpressionList(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.BASIC_EXPRESSION_LIST);
    }

    @Nullable
    public static ASTNode getTypeParameterList(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.BASIC_TYPE_PARAMETER_LIST);
    }

    public static boolean isComment(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.is(element2, BasicElementTypes.BASIC_JAVA_COMMENT_BIT_SET);
    }

    public static boolean isDocToken(@Nullable ASTNode element2) {
        return element2 != null && element2.getElementType().getClass().equals(IJavaDocElementType.class) && !BasicJavaAstTreeUtil.is(element2, BasicJavaDocElementType.BASIC_DOC_SNIPPET_ATTRIBUTE_VALUE);
    }

    @Nullable
    public static String getTagName(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        ASTNode docTagName = BasicJavaAstTreeUtil.findChildByType(element2, JavaDocTokenType.DOC_TAG_NAME);
        if (docTagName == null) {
            return null;
        }
        String text = docTagName.getText();
        if (text.isEmpty()) {
            return null;
        }
        return text.substring(1);
    }

    @Nullable
    public static ASTNode getROperand(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_BINARY_EXPRESSION)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.EXPRESSION_SET);
    }

    @Nullable
    public static ASTNode getBlock(@Nullable ASTNode statement) {
        if (statement == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(statement, BasicJavaElementType.STATEMENT_SET);
    }

    @Nullable
    public static ASTNode getAnonymousClass(@Nullable ASTNode expression2) {
        if (expression2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(expression2, BasicJavaElementType.BASIC_ANONYMOUS_CLASS);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static PsiElement getParentOfType(@Nullable PsiElement element2, @NotNull IElementType target, boolean strict, @Nullable ParentAwareTokenSet stopAt) {
        if (target == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(17);
        }
        if (element2 == null) {
            return null;
        }
        if (strict) {
            if (element2 instanceof PsiFile) {
                return null;
            }
            element2 = element2.getParent();
        }
        while (element2 != null && !BasicJavaAstTreeUtil.is(element2.getNode(), target)) {
            if (stopAt != null && BasicJavaAstTreeUtil.is(element2.getNode(), stopAt)) {
                return null;
            }
            if (element2 instanceof PsiFile) {
                return null;
            }
            element2 = element2.getParent();
        }
        return element2;
    }

    @Nullable
    public static ASTNode findElementInRange(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull IElementType elementType) {
        ASTNode element2;
        if (file == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(18);
        }
        if (elementType == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(19);
        }
        PsiElement element1 = file.getViewProvider().findElementAt(startOffset, JavaLanguage.INSTANCE);
        PsiElement element22 = file.getViewProvider().findElementAt(endOffset - 1, JavaLanguage.INSTANCE);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.getViewProvider().findElementAt(startOffset, JavaLanguage.INSTANCE);
        }
        if (element22 instanceof PsiWhiteSpace) {
            endOffset = element22.getTextRange().getStartOffset();
            element22 = file.getViewProvider().findElementAt(endOffset - 1, JavaLanguage.INSTANCE);
        }
        if (element22 == null || element1 == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(element1, element22);
        if (commonParent == null) {
            return null;
        }
        ASTNode node = commonParent.getNode();
        ASTNode aSTNode = element2 = BasicJavaAstTreeUtil.is(node, elementType) ? node : BasicJavaAstTreeUtil.getParentOfType(node, elementType);
        if (element2 == null || element2.getTextRange().getStartOffset() != startOffset || element2.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return element2;
    }

    @Nullable
    public static ASTNode getForInitialization(@Nullable ASTNode forStatement) {
        if (!BasicJavaAstTreeUtil.is(forStatement, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
            return null;
        }
        ASTNode initialization = BasicJavaAstTreeUtil.findChildByType(forStatement, BasicJavaElementType.STATEMENT_SET);
        if (initialization == null) {
            return null;
        }
        ASTNode paren = BasicJavaAstTreeUtil.getLParenth(forStatement);
        if (paren == null) {
            return null;
        }
        for (ASTNode child = paren; child != null; child = child.getTreeNext()) {
            if (child == initialization) {
                return initialization;
            }
            if (!BasicJavaAstTreeUtil.is(child, JavaTokenType.RPARENTH)) continue;
            return null;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static ASTNode findElementOfClassAtOffset(@NotNull PsiFile file, int offset, @NotNull IElementType elementType, boolean strictStart) {
        if (file == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(20);
        }
        if (elementType == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(21);
        }
        PsiElement result2 = null;
        for (PsiElement psiElement : file.getViewProvider().getAllFiles()) {
            PsiElement parent2;
            PsiElement elementAt = psiElement.findElementAt(offset);
            if (elementAt == null || (parent2 = BasicJavaAstTreeUtil.getParentOfType(elementAt, elementType, strictStart, null)) == null) continue;
            TextRange range = parent2.getTextRange();
            if (strictStart && range.getStartOffset() != offset || result2 != null && result2.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result2 = parent2;
        }
        return result2 == null ? null : result2.getNode();
    }

    @Nullable
    public static ASTNode getParentOfType(@Nullable ASTNode e2, @NotNull ParentAwareTokenSet types2, boolean strict) {
        if (types2 == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(22);
        }
        if (!strict && BasicJavaAstTreeUtil.is(e2, types2)) {
            return e2;
        }
        return BasicJavaAstTreeUtil.getParentOfType(e2, types2);
    }

    @Nullable
    public static PsiElement getParentOfType(@Nullable PsiElement e2, @NotNull Set<IElementType> types2, boolean strict) {
        if (types2 == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(23);
        }
        if (!strict && e2 != null && BasicJavaAstTreeUtil.is(e2.getNode(), types2)) {
            return e2;
        }
        if (e2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.toPsi(BasicJavaAstTreeUtil.getParentOfType(e2.getNode(), ParentAwareTokenSet.create(types2)));
    }

    @Nullable
    public static ASTNode getCatchBlock(@Nullable ASTNode element2) {
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_CATCH_SECTION)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.BASIC_CODE_BLOCK);
    }

    @Nullable
    public static ASTNode getParameter(@Nullable ASTNode element2) {
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.BASIC_PARAMETER);
    }

    @Nullable
    public static ASTNode getWhileKeyword(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.WHILE_KEYWORD);
    }

    @Nullable
    public static ASTNode getWhileCondition(@Nullable ASTNode element2) {
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_DO_WHILE_STATEMENT) && !BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_WHILE_STATEMENT)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.EXPRESSION_SET);
    }

    @Nullable
    public static ASTNode getDoWhileBody(@Nullable ASTNode element2) {
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_DO_WHILE_STATEMENT)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.STATEMENT_SET);
    }

    @Nullable
    public static ASTNode getForUpdate(@Nullable ASTNode statement) {
        if (!BasicJavaAstTreeUtil.is(statement, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
            return null;
        }
        ASTNode semicolon = BasicJavaAstTreeUtil.findChildByType(statement, JavaTokenType.SEMICOLON);
        if (semicolon == null) {
            return null;
        }
        for (ASTNode child = semicolon; child != null; child = child.getTreeNext()) {
            if (BasicJavaAstTreeUtil.is(child, BasicJavaElementType.STATEMENT_SET)) {
                return child;
            }
            if (BasicJavaAstTreeUtil.is(child, JavaTokenType.RPARENTH)) break;
        }
        return null;
    }

    @Nullable
    public static ASTNode getForCondition(@Nullable ASTNode element2) {
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.EXPRESSION_SET);
    }

    @Nullable
    public static ASTNode getIfCondition(@Nullable ASTNode statement) {
        if (!BasicJavaAstTreeUtil.is(statement, BasicJavaElementType.BASIC_IF_STATEMENT)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(statement, BasicJavaElementType.EXPRESSION_SET);
    }

    public static boolean hasModifierProperty(@Nullable ASTNode element2, @NotNull IElementType property2) {
        if (property2 == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(24);
        }
        if (element2 == null) {
            return false;
        }
        ASTNode modifierList2 = BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.BASIC_MODIFIER_LIST);
        if (modifierList2 == null) {
            return false;
        }
        ASTNode firstChild = modifierList2.getFirstChildNode();
        if (firstChild == null) {
            return false;
        }
        for (ASTNode child = firstChild; child != null; child = child.getTreeNext()) {
            if (!BasicJavaAstTreeUtil.is(child, property2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInterfaceEnumClassOrRecord(@Nullable ASTNode element2, @NotNull IElementType elementType) {
        if (elementType == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(25);
        }
        if (!BasicJavaAstTreeUtil.is(element2, BasicJavaElementType.CLASS_SET)) {
            return false;
        }
        if (element2 == null) {
            return false;
        }
        ASTNode firstChild = element2.getFirstChildNode();
        if (firstChild == null) {
            return false;
        }
        for (ASTNode child = firstChild; child != null; child = child.getTreeNext()) {
            if (!BasicJavaAstTreeUtil.is(child, elementType)) continue;
            return true;
        }
        return false;
    }

    public static ASTNode @Nullable [] getParameterListParameters(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        return (ASTNode[])BasicJavaAstTreeUtil.getChildren(element2).stream().filter(ch -> BasicJavaAstTreeUtil.is(ch, BasicJavaElementType.BASIC_PARAMETER)).toArray(ASTNode[]::new);
    }

    public static ASTNode @Nullable [] getAnnotationParameterListAttributes(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        return (ASTNode[])BasicJavaAstTreeUtil.getChildren(element2).stream().filter(ch -> BasicJavaAstTreeUtil.is(ch, BasicJavaElementType.BASIC_NAME_VALUE_PAIR)).toArray(ASTNode[]::new);
    }

    @Nullable
    public static ASTNode getFirstBodyElement(@Nullable ASTNode block) {
        if (block == null) {
            return null;
        }
        ASTNode lBrace = BasicJavaAstTreeUtil.getLBrace(block);
        if (lBrace == null) {
            return null;
        }
        ASTNode nextSibling = lBrace.getTreeNext();
        return nextSibling == BasicJavaAstTreeUtil.getRBrace(block) ? null : nextSibling;
    }

    @Nullable
    public static ASTNode getCodeBlock(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.BASIC_CODE_BLOCK);
    }

    @Nullable
    public static ASTNode getForBody(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        ASTNode rparenth = BasicJavaAstTreeUtil.getRParenth(element2);
        if (rparenth == null) {
            return null;
        }
        for (ASTNode child = rparenth; child != null; child = child.getTreeNext()) {
            if (!BasicJavaAstTreeUtil.is(child, BasicJavaElementType.STATEMENT_SET)) continue;
            return child;
        }
        return null;
    }

    public static ASTNode[] getCatchBlocks(@Nullable ASTNode element2) {
        ASTNode tryBlock = BasicJavaAstTreeUtil.getCodeBlock(element2);
        if (tryBlock != null) {
            List<ASTNode> catchSections = ContainerUtil.filter(BasicJavaAstTreeUtil.getChildren(element2), ch -> BasicJavaAstTreeUtil.is(ch, BasicJavaElementType.BASIC_CATCH_SECTION));
            return (ASTNode[])catchSections.stream().map(t2 -> BasicJavaAstTreeUtil.getCatchBlock(t2)).filter(t2 -> t2 != null).toArray(ASTNode[]::new);
        }
        return ASTNode.EMPTY_ARRAY;
    }

    @Nullable
    public static ASTNode getConditionalExpressionThenExpression(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        ASTNode quest = BasicJavaAstTreeUtil.findChildByType(element2, JavaTokenType.QUEST);
        if (quest == null) {
            return null;
        }
        ASTNode child = quest.getTreeNext();
        while (true) {
            if (child == null) {
                return null;
            }
            if (BasicJavaElementType.EXPRESSION_SET.contains(child.getElementType())) break;
            child = child.getTreeNext();
        }
        return child;
    }

    @Nullable
    public static IElementType getAssignmentOperationTokenType(@Nullable ASTNode expr) {
        if (expr == null) {
            return null;
        }
        ASTNode ASTNode2 = BasicJavaAstTreeUtil.findChildByType(expr, BasicExpressionParser.ASSIGNMENT_OPS.getTypes());
        if (ASTNode2 == null) {
            return null;
        }
        return ASTNode2.getElementType();
    }

    @Nullable
    public static ASTNode getPatternVariable(@Nullable ASTNode ASTNode2) {
        if (ASTNode2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(ASTNode2, BasicJavaElementType.BASIC_DECONSTRUCTION_PATTERN_VARIABLE, BasicJavaElementType.BASIC_PATTERN_VARIABLE);
    }

    @Nullable
    public static ASTNode getExpression(@Nullable ASTNode ASTNode2) {
        if (ASTNode2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(ASTNode2, BasicJavaElementType.EXPRESSION_SET);
    }

    @Nullable
    public static ASTNode getRecordComponentContainingClass(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        ASTNode parent2 = element2.getTreeParent();
        if (parent2 == null) {
            return null;
        }
        ASTNode grandParent = parent2.getTreeParent();
        if (BasicJavaAstTreeUtil.is(grandParent, BasicJavaElementType.CLASS_SET)) {
            return grandParent;
        }
        return null;
    }

    @Nullable
    public static ASTNode getRecordHeader(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.BASIC_RECORD_HEADER);
    }

    @Nullable
    public static ASTNode getRuleBody(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, ParentAwareTokenSet.orSet(ParentAwareTokenSet.create(BasicJavaElementType.BASIC_BLOCK_STATEMENT, BasicJavaElementType.BASIC_THROW_STATEMENT), BasicJavaElementType.EXPRESSION_SET));
    }

    @Nullable
    public static ASTNode getCaseLabelElementList(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.BASIC_CASE_LABEL_ELEMENT_LIST);
    }

    @Nullable
    public static ASTNode getReturnValue(@Nullable ASTNode element2) {
        if (element2 == null) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(element2, BasicJavaElementType.EXPRESSION_SET);
    }

    @Nullable
    public static ASTNode getForEachIteratedValue(@Nullable ASTNode statement) {
        if (!BasicJavaAstTreeUtil.is(statement, BasicJavaElementType.BASIC_FOREACH_STATEMENT)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(statement, BasicJavaElementType.EXPRESSION_SET);
    }

    @Nullable
    public static ASTNode getForEachIterationParameter(@Nullable ASTNode statement) {
        if (statement == null) {
            return null;
        }
        if (!BasicJavaAstTreeUtil.is(statement, BasicJavaElementType.BASIC_FOREACH_STATEMENT)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(statement, BasicJavaElementType.BASIC_PARAMETER);
    }

    @Nullable
    public static ASTNode getForeachBody(@Nullable ASTNode statement) {
        if (statement == null) {
            return null;
        }
        if (!BasicJavaAstTreeUtil.is(statement, BasicJavaElementType.BASIC_FOREACH_STATEMENT)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(statement, BasicJavaElementType.STATEMENT_SET);
    }

    @Nullable
    public static ASTNode getWhileBody(@Nullable ASTNode statement) {
        if (statement == null) {
            return null;
        }
        if (!BasicJavaAstTreeUtil.is(statement, BasicJavaElementType.BASIC_WHILE_STATEMENT)) {
            return null;
        }
        return BasicJavaAstTreeUtil.findChildByType(statement, BasicJavaElementType.STATEMENT_SET);
    }

    public static boolean hasErrorElements(@Nullable ASTNode node) {
        return !SyntaxTraverser.astTraverser(node).traverse().filter(t2 -> BasicJavaAstTreeUtil.is(t2, TokenType.ERROR_ELEMENT)).isEmpty();
    }

    public static int getTextOffset(@NotNull ASTNode node) {
        ASTNode identifier;
        if (node == null) {
            BasicJavaAstTreeUtil.$$$reportNull$$$0(26);
        }
        if (BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_LOCAL_VARIABLE, BasicJavaElementType.BASIC_PATTERN_VARIABLE, BasicJavaElementType.BASIC_RECORD_COMPONENT, BasicJavaElementType.BASIC_RECEIVER_PARAMETER, BasicJavaElementType.BASIC_MODULE, BasicJavaElementType.BASIC_IMPORT_STATIC_REFERENCE, BasicJavaElementType.BASIC_JAVA_CODE_REFERENCE) && (identifier = BasicJavaAstTreeUtil.findChildByType(node, JavaTokenType.IDENTIFIER)) != null) {
            return identifier.getStartOffset();
        }
        if (BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_REFERENCE_EXPRESSION) && (identifier = BasicJavaAstTreeUtil.findChildByType(node, JavaTokenType.IDENTIFIER, JavaTokenType.THIS_KEYWORD, JavaTokenType.SUPER_KEYWORD)) != null) {
            return identifier.getStartOffset();
        }
        ASTNode doc = BasicJavaAstTreeUtil.findChildByType(node, JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        if (doc != null) {
            return doc.getStartOffset();
        }
        return node.getStartOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iElementTypes";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/BasicJavaAstTreeUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "is";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getElseElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getThenBranch";
                break;
            }
            case 11: 
            case 16: 
            case 17: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentOfType";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "findParent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementInRange";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementOfClassAtOffset";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "hasModifierProperty";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "isInterfaceEnumClassOrRecord";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

