/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointNameKt;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.AdapterWithCustomAttributes;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\nH\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0016\u0010\u0013\u001a\u0004\u0018\u00018\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/extensions/LazyExtensionImpl;", "T", "", "Lcom/intellij/openapi/extensions/LazyExtension;", "adapter", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "point", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "(Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;)V", "id", "", "getId", "()Ljava/lang/String;", "implementationClass", "Ljava/lang/Class;", "getImplementationClass", "()Ljava/lang/Class;", "implementationClassName", "getImplementationClassName", "instance", "getInstance", "()Ljava/lang/Object;", "order", "Lcom/intellij/openapi/extensions/LoadingOrder;", "getOrder", "()Lcom/intellij/openapi/extensions/LoadingOrder;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getPluginDescriptor", "()Lcom/intellij/openapi/extensions/PluginDescriptor;", "getCustomAttribute", "name", "intellij.platform.extensions"})
@SourceDebugExtension(value={"SMAP\nExtensionPointName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionPointName.kt\ncom/intellij/openapi/extensions/LazyExtensionImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,345:1\n11#2:346\n*S KotlinDebug\n*F\n+ 1 ExtensionPointName.kt\ncom/intellij/openapi/extensions/LazyExtensionImpl\n*L\n325#1:346\n*E\n"})
final class LazyExtensionImpl<T>
implements LazyExtension<T> {
    @JvmField
    @NotNull
    public final ExtensionComponentAdapter adapter;
    @JvmField
    @NotNull
    public final ExtensionPointImpl<T> point;

    public LazyExtensionImpl(@NotNull ExtensionComponentAdapter adapter, @NotNull ExtensionPointImpl<T> point) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(point, (String)"point");
        this.adapter = adapter;
        this.point = point;
    }

    @Override
    @Nullable
    public String getId() {
        return this.adapter.getOrderId();
    }

    @Override
    @NotNull
    public LoadingOrder getOrder() {
        return this.adapter.getOrder();
    }

    @Override
    @Nullable
    public String getCustomAttribute(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.adapter instanceof AdapterWithCustomAttributes ? ((AdapterWithCustomAttributes)this.adapter).customAttributes.get(name2) : null;
    }

    @Override
    @Nullable
    public T getInstance() {
        return (T)ExtensionPointNameKt.access$createOrError(this.adapter, this.point);
    }

    @Override
    @NotNull
    public String getImplementationClassName() {
        return this.adapter.getAssignableToClassName();
    }

    @Override
    @Nullable
    public Class<T> getImplementationClass() {
        try {
            return this.adapter.getImplementationClass(this.point.componentManager);
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(ExtensionPointName.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error(this.point.componentManager.createError(e3, this.adapter.pluginDescriptor.getPluginId()));
            return null;
        }
    }

    @Override
    @NotNull
    public PluginDescriptor getPluginDescriptor() {
        return this.adapter.pluginDescriptor;
    }
}

