/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.SubstitutionUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaSamConstructorNullabilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaSamConstructorNullabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaSamConstructorNullabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaSamConstructorNullabilityChecker\n+ 2 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n248#2:77\n239#2,11:78\n60#3,4:89\n1#4:93\n*S KotlinDebug\n*F\n+ 1 FirJavaSamConstructorNullabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaSamConstructorNullabilityChecker\n*L\n39#1:77\n39#1:78,11\n41#1:89,4\n*E\n"})
public final class FirJavaSamConstructorNullabilityChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJavaSamConstructorNullabilityChecker INSTANCE = new FirJavaSamConstructorNullabilityChecker();

    private FirJavaSamConstructorNullabilityChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        if (languageVersionSettings.supportsFeature(LanguageFeature.JavaTypeParameterDefaultRepresentationWithDNN)) {
            return;
        }
        boolean reportError = languageVersionSettings.supportsFeature(LanguageFeature.ProhibitReturningIncorrectNullabilityValuesFromSamConstructorLambdaOfJdkInterfaces);
        FirNamedReference calleeReference = expression2.getCalleeReference();
        if (FirReferenceUtilsKt.isError(calleeReference)) {
            return;
        }
        FirFunctionSymbol firFunctionSymbol = FirReferenceUtilsKt.toResolvedFunctionSymbol$default(calleeReference, false, 1, null);
        if (firFunctionSymbol == null) {
            return;
        }
        FirFunctionSymbol symbol = firFunctionSymbol;
        if (!Intrinsics.areEqual((Object)symbol.getOrigin(), (Object)FirDeclarationOrigin.SamConstructor.INSTANCE)) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(symbol.getResolvedReturnType(), context2.getSession());
        if (firRegularClassSymbol == null) return;
        FirBasedSymbol $this$isJavaOrEnhancement$iv = firRegularClassSymbol;
        boolean $i$f$isJavaOrEnhancement = false;
        FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        boolean $i$f$isJavaOrEnhancement22 = false;
        if (!($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE))) {
            Object $i$f$isJavaOrEnhancement22 = $this$isJavaOrEnhancement$iv.getFir();
            if (!($i$f$isJavaOrEnhancement22 instanceof FirCallableDeclaration)) return;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)$i$f$isJavaOrEnhancement22;
            Object object = firCallableDeclaration;
            if (firCallableDeclaration == null) return;
            ImportedFromObjectOrStaticData<FirCallableDeclaration> importedFromObjectOrStaticData = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object);
            object = importedFromObjectOrStaticData;
            if (importedFromObjectOrStaticData == null) return;
            Object d2 = ((ImportedFromObjectOrStaticData)object).getOriginal();
            object = d2;
            if (d2 == null) return;
            if (!DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) return;
            boolean bl2 = true;
            if (!bl2) return;
        }
        boolean bl3 = true;
        if (!bl3) return;
        boolean bl4 = true;
        if (!bl4) {
            return;
        }
        FirCall $this$resolvedArgumentMapping$iv = expression2;
        boolean $i$f$getResolvedArgumentMapping = false;
        FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
        if (!(argumentList$iv instanceof FirResolvedArgumentList)) return;
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = ((FirResolvedArgumentList)argumentList$iv).getMapping();
        Object object = linkedHashMap;
        if (linkedHashMap == null) return;
        Set<Map.Entry<FirExpression, FirValueParameter>> set = ((LinkedHashMap)object).entrySet();
        object = set;
        if (set == null) return;
        if ((object = (Map.Entry)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) == null) {
            return;
        }
        Object object2 = object;
        Object k2 = object2.getKey();
        Intrinsics.checkNotNullExpressionValue(k2, (String)"component1(...)");
        FirExpression lambda = (FirExpression)k2;
        Object v2 = object2.getValue();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"component2(...)");
        FirValueParameter parameter2 = (FirValueParameter)v2;
        if (!(lambda instanceof FirAnonymousFunctionExpression)) {
            return;
        }
        ConeKotlinType parameterFunctionType = FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef());
        ConeSubstitutor substitutor2 = SubstitutionUtilsKt.createConeSubstitutorFromTypeArguments$default(expression2, symbol, context2.getSession(), false, true, 4, null);
        ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.lastOrNull((Object[])parameterFunctionType.getTypeArguments());
        ConeTypeProjection coneTypeProjection2 = coneTypeProjection;
        if (coneTypeProjection == null) return;
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(coneTypeProjection2);
        coneTypeProjection2 = coneKotlinType;
        if (coneKotlinType == null) return;
        ConeTypeProjection p0 = coneTypeProjection2;
        boolean bl5 = false;
        ConeKotlinType coneKotlinType2 = substitutor2.substituteOrSelf((ConeKotlinType)p0);
        coneTypeProjection2 = coneKotlinType2;
        if (coneKotlinType2 == null) {
            return;
        }
        ConeTypeProjection expectedReturnType = coneTypeProjection2;
        Iterator<FirExpression> iterator2 = FirHelpersKt.getReturnedExpressions(((FirAnonymousFunctionExpression)lambda).getAnonymousFunction()).iterator();
        while (iterator2.hasNext()) {
            FirExpression returnedExpression = iterator2.next();
            ConeKotlinType returnedExpressionType = FirTypeUtilsKt.getResolvedType(returnedExpression);
            if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)returnedExpressionType, (KotlinTypeMarker)((Object)expectedReturnType), false, 8, null)) continue;
            if (reportError) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)returnedExpression.getSource(), FirErrors.INSTANCE.getARGUMENT_TYPE_MISMATCH(), (Object)returnedExpressionType, (Object)expectedReturnType, (Object)true, (DiagnosticContext)context2, null, 64, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)returnedExpression.getSource(), FirJvmErrors.INSTANCE.getTYPE_MISMATCH_WHEN_FLEXIBILITY_CHANGES(), (Object)returnedExpressionType, (Object)expectedReturnType, (DiagnosticContext)context2, null, 32, null);
        }
    }
}

