/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.pico.AmbiguousComponentResolutionException;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.PicoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;

@ApiStatus.Internal
public class DefaultPicoContainer
implements MutablePicoContainer {
    private final DefaultPicoContainer parent;
    private final Map<Object, ComponentAdapter> componentKeyToAdapter = new ConcurrentHashMap<Object, ComponentAdapter>();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();

    public DefaultPicoContainer(@Nullable DefaultPicoContainer parent2) {
        this.parent = parent2;
    }

    public DefaultPicoContainer() {
        this(null);
    }

    @NotNull
    public final Collection<ComponentAdapter> getComponentAdapters() {
        Set<ComponentAdapter> set = this.componentAdapters.getImmutableSet();
        if (set == null) {
            DefaultPicoContainer.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @Nullable
    public final ComponentAdapter getComponentAdapter(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(1);
        }
        if ((adapter = this.getFromCache(componentKey)) == null && this.parent != null) {
            return this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    public final void release() {
        this.componentKeyToAdapter.clear();
        this.componentAdapters.clear();
    }

    @Nullable
    private ComponentAdapter getFromCache(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(2);
        }
        if ((adapter = this.componentKeyToAdapter.get(componentKey)) != null) {
            return adapter;
        }
        return componentKey instanceof Class ? this.componentKeyToAdapter.get(((Class)componentKey).getName()) : null;
    }

    @Nullable
    public final ComponentAdapter getComponentAdapterOfType(@NotNull Class<?> componentType) {
        ComponentAdapter adapterByKey;
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(3);
        }
        if ((adapterByKey = this.getComponentAdapter(componentType)) != null) {
            return adapterByKey;
        }
        List<ComponentAdapter> found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return found.get(0);
        }
        if (found.isEmpty()) {
            return this.parent == null ? null : this.parent.getComponentAdapterOfType(componentType);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i2 = 0; i2 < foundClasses.length; ++i2) {
            foundClasses[i2] = found.get(i2).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    @NotNull
    public final List<ComponentAdapter> getComponentAdaptersOfType(@NotNull Class<?> componentType) {
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(4);
        }
        if (componentType == String.class) {
            List<ComponentAdapter> list = Collections.emptyList();
            if (list == null) {
                DefaultPicoContainer.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<ComponentAdapter> result2 = new ArrayList<ComponentAdapter>();
        ComponentAdapter cacheHit = this.componentKeyToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result2.add(cacheHit);
        }
        for (ComponentAdapter adapter : this.componentKeyToAdapter.values()) {
            Class<?> descendant;
            if (adapter.getComponentKey() instanceof String || componentType != (descendant = adapter.getComponentImplementation()) && !componentType.isAssignableFrom(descendant)) continue;
            result2.add(adapter);
        }
        ArrayList<ComponentAdapter> arrayList = result2;
        if (arrayList == null) {
            DefaultPicoContainer.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public final ComponentAdapter registerComponent(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(7);
        }
        if (this.componentKeyToAdapter.putIfAbsent(componentAdapter.getComponentKey(), componentAdapter) != null) {
            @NotNull String message = "Key " + componentAdapter.getComponentKey() + " duplicated";
            throw new PicoException(message);
        }
        this.componentAdapters.add(componentAdapter);
        return componentAdapter;
    }

    @Override
    @Nullable
    public final ComponentAdapter unregisterComponent(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(8);
        }
        if ((adapter = this.componentKeyToAdapter.remove(componentKey)) == null) {
            return null;
        }
        this.componentAdapters.remove(adapter);
        return adapter;
    }

    @Override
    @Nullable
    public Object getComponentInstance(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(9);
        }
        if ((adapter = this.getFromCache(componentKey)) != null) {
            return adapter.getComponentInstance();
        }
        return this.parent == null ? null : this.parent.getComponentInstance(componentKey);
    }

    @Nullable
    public final <T> T getService(@NotNull Class<T> serviceClass) {
        ComponentAdapter adapter;
        if (serviceClass == null) {
            DefaultPicoContainer.$$$reportNull$$$0(10);
        }
        if ((adapter = this.componentKeyToAdapter.get(serviceClass.getName())) == null) {
            return null;
        }
        return (T)adapter.getComponentInstance();
    }

    @Override
    @Nullable
    public final Object getComponentInstanceOfType(@NotNull Class<?> componentType) {
        ComponentAdapter componentAdapter;
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(11);
        }
        return (componentAdapter = this.getComponentAdapterOfType(componentType)) == null ? null : this.getInstance(componentAdapter);
    }

    @Nullable
    private Object getInstance(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(12);
        }
        if (this.componentAdapters.getImmutableSet().contains(componentAdapter)) {
            return componentAdapter.getComponentInstance();
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    @Override
    public final ComponentAdapter registerComponentInstance(@NotNull Object componentKey, @NotNull Object componentInstance) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(13);
        }
        if (componentInstance == null) {
            DefaultPicoContainer.$$$reportNull$$$0(14);
        }
        return this.registerComponent(new InstanceComponentAdapter(componentKey, componentInstance));
    }

    @Override
    public final ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class<?> componentImplementation) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(15);
        }
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(16);
        }
        return this.registerComponent(new CachingConstructorInjectionComponentAdapter(this, componentKey, componentImplementation));
    }

    public final DefaultPicoContainer getParent() {
        return this.parent;
    }

    public final String toString() {
        DefaultPicoContainer parent2 = this.parent;
        return "DefaultPicoContainer" + (parent2 == null ? " (root)" : " (parent=" + parent2 + ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentAdapter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentInstance";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentAdapters";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentAdaptersOfType";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFromCache";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapterOfType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdaptersOfType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstance";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstanceOfType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentImplementation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile Set<T> immutableSet;
        private LinkedHashSet<T> synchronizedSet = new LinkedHashSet();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull T element2) {
            if (element2 == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(0);
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element2)) {
                    this.copySyncSetIfExposedAsImmutable().add(element2);
                }
            }
        }

        private LinkedHashSet<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@Nullable T element2) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                if (this.immutableSet != null) {
                    this.immutableSet = null;
                }
                this.synchronizedSet = new LinkedHashSet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<T> getImmutableSet() {
            Set<T> result2 = this.immutableSet;
            if (result2 == null) {
                Object object = this.lock;
                synchronized (object) {
                    result2 = this.immutableSet;
                    if (result2 == null) {
                        this.immutableSet = result2 = Collections.unmodifiableSet(this.synchronizedSet);
                    }
                }
            }
            Set<T> set = result2;
            if (set == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImmutableSet";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class InstanceComponentAdapter
    implements ComponentAdapter {
        private final Object componentKey;
        private final Object componentInstance;

        public InstanceComponentAdapter(@NotNull Object componentKey, @NotNull Object componentInstance) {
            if (componentKey == null) {
                InstanceComponentAdapter.$$$reportNull$$$0(0);
            }
            if (componentInstance == null) {
                InstanceComponentAdapter.$$$reportNull$$$0(1);
            }
            this.componentKey = componentKey;
            this.componentInstance = componentInstance;
        }

        @Override
        public Object getComponentInstance() {
            return this.componentInstance;
        }

        @Override
        public Object getComponentKey() {
            return this.componentKey;
        }

        @Override
        public Class<?> getComponentImplementation() {
            return this.componentInstance.getClass();
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.getComponentKey() + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentInstance";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/pico/DefaultPicoContainer$InstanceComponentAdapter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

