/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RedBlackTree<K>
extends AtomicInteger {
    public static boolean VERIFY;
    private static final int INDENT_STEP = 4;
    private int nodeSize;
    protected Node<K> root = null;

    RedBlackTree() {
        this.verifyProperties();
    }

    void incModCount() {
        this.incrementAndGet();
    }

    int getModCount() {
        return this.get();
    }

    protected void rotateLeft(@NotNull Node<K> n2) {
        if (n2 == null) {
            RedBlackTree.$$$reportNull$$$0(0);
        }
        Node<K> r2 = n2.getRight();
        this.replaceNode(n2, r2);
        n2.setRight(r2.getLeft());
        if (r2.getLeft() != null) {
            r2.getLeft().setParent(n2);
        }
        r2.setLeft(n2);
        n2.setParent(r2);
    }

    protected void rotateRight(@NotNull Node<K> n2) {
        if (n2 == null) {
            RedBlackTree.$$$reportNull$$$0(1);
        }
        Node<K> l2 = n2.getLeft();
        this.replaceNode(n2, l2);
        n2.setLeft(l2.getRight());
        if (l2.getRight() != null) {
            l2.getRight().setParent(n2);
        }
        l2.setRight(n2);
        n2.setParent(l2);
    }

    protected void replaceNode(@NotNull Node<K> oldn, Node<K> newn) {
        Node<K> parent2;
        if (oldn == null) {
            RedBlackTree.$$$reportNull$$$0(2);
        }
        if ((parent2 = oldn.getParent()) == null) {
            this.root = newn;
        } else if (oldn == parent2.getLeft()) {
            parent2.setLeft(newn);
        } else {
            parent2.setRight(newn);
        }
        if (newn != null) {
            newn.setParent(parent2);
        }
    }

    void onInsertNode() {
        ++this.nodeSize;
    }

    void insertCase1(Node<K> n2) {
        if (n2.getParent() == null) {
            ((Node)n2).setBlack();
        } else {
            this.insertCase2(n2);
        }
    }

    private void insertCase2(Node<K> n2) {
        if (!RedBlackTree.isBlack(n2.getParent())) {
            this.insertCase3(n2);
        }
    }

    private void insertCase3(Node<K> n2) {
        if (!RedBlackTree.isBlack(((Node)n2).uncle())) {
            ((Node)n2.getParent()).setBlack();
            ((Node)((Node)n2).uncle()).setBlack();
            n2.grandparent().setRed();
            this.insertCase1(n2.grandparent());
        } else {
            this.insertCase4(n2);
        }
    }

    private void insertCase4(Node<K> n2) {
        if (n2 == n2.getParent().getRight() && n2.getParent() == n2.grandparent().getLeft()) {
            this.rotateLeft(n2.getParent());
            n2 = n2.getLeft();
        } else if (n2 == n2.getParent().getLeft() && n2.getParent() == n2.grandparent().getRight()) {
            this.rotateRight(n2.getParent());
            n2 = n2.getRight();
        }
        this.insertCase5(n2);
    }

    private void insertCase5(Node<K> n2) {
        ((Node)n2.getParent()).setBlack();
        n2.grandparent().setRed();
        if (n2 == n2.getParent().getLeft() && n2.getParent() == n2.grandparent().getLeft()) {
            this.rotateRight(n2.grandparent());
        } else {
            assert (n2 == n2.getParent().getRight());
            assert (n2.getParent() == n2.grandparent().getRight());
            this.rotateLeft(n2.grandparent());
        }
    }

    private static <K> void assertParentChild(Node<K> node1) {
        assert (node1 == null || node1.getParent() == null || node1.getParent().getLeft() == node1 || node1.getParent().getRight() == node1);
    }

    protected void deleteNode(@NotNull Node<K> n2) {
        Node<K> child;
        if (n2 == null) {
            RedBlackTree.$$$reportNull$$$0(3);
        }
        this.incModCount();
        Node<K> e2 = n2;
        while (e2.getParent() != null) {
            e2 = e2.getParent();
        }
        assert (e2 == this.root) : e2;
        if (n2.getLeft() != null && n2.getRight() != null) {
            Node<K> pred = this.maximumNode(n2.getLeft());
            n2 = this.swapWithMaxPred(n2, pred);
        }
        assert (n2.getLeft() == null || n2.getRight() == null);
        Node<K> node = child = n2.getRight() == null ? n2.getLeft() : n2.getRight();
        if (RedBlackTree.isBlack(n2)) {
            n2.setColor(RedBlackTree.isBlack(child));
            this.deleteCase1(n2);
        }
        this.replaceNode(n2, child);
        if (!RedBlackTree.isBlack(this.root)) {
            ((Node)this.root).setBlack();
        }
        assert (this.nodeSize > 0) : this.nodeSize;
        --this.nodeSize;
        this.verifyProperties();
    }

    @NotNull
    protected abstract Node<K> swapWithMaxPred(@NotNull Node<K> var1, @NotNull Node<K> var2);

    @NotNull
    protected Node<K> maximumNode(@NotNull Node<K> n2) {
        if (n2 == null) {
            RedBlackTree.$$$reportNull$$$0(4);
        }
        while (n2.getRight() != null) {
            n2 = n2.getRight();
        }
        Node<K> node = n2;
        if (node == null) {
            RedBlackTree.$$$reportNull$$$0(5);
        }
        return node;
    }

    private void deleteCase1(Node<K> n2) {
        if (n2.getParent() != null) {
            this.deleteCase2(n2);
        }
    }

    private void deleteCase2(Node<K> n2) {
        if (!RedBlackTree.isBlack(n2.sibling())) {
            n2.getParent().setRed();
            ((Node)n2.sibling()).setBlack();
            if (n2 == n2.getParent().getLeft()) {
                this.rotateLeft(n2.getParent());
            } else {
                this.rotateRight(n2.getParent());
            }
        }
        this.deleteCase3(n2);
    }

    private void deleteCase3(Node<K> n2) {
        if (RedBlackTree.isBlack(n2.getParent()) && RedBlackTree.isBlack(n2.sibling()) && RedBlackTree.isBlack(n2.sibling().getLeft()) && RedBlackTree.isBlack(n2.sibling().getRight())) {
            n2.sibling().setRed();
            this.deleteCase1(n2.getParent());
        } else {
            this.deleteCase4(n2);
        }
    }

    private void deleteCase4(Node<K> n2) {
        if (!RedBlackTree.isBlack(n2.getParent()) && RedBlackTree.isBlack(n2.sibling()) && RedBlackTree.isBlack(n2.sibling().getLeft()) && RedBlackTree.isBlack(n2.sibling().getRight())) {
            n2.sibling().setRed();
            ((Node)n2.getParent()).setBlack();
        } else {
            this.deleteCase5(n2);
        }
    }

    private void deleteCase5(Node<K> n2) {
        if (n2 == n2.getParent().getLeft() && RedBlackTree.isBlack(n2.sibling()) && !RedBlackTree.isBlack(n2.sibling().getLeft()) && RedBlackTree.isBlack(n2.sibling().getRight())) {
            n2.sibling().setRed();
            ((Node)n2.sibling().getLeft()).setBlack();
            this.rotateRight(n2.sibling());
        } else if (n2 == n2.getParent().getRight() && RedBlackTree.isBlack(n2.sibling()) && !RedBlackTree.isBlack(n2.sibling().getRight()) && RedBlackTree.isBlack(n2.sibling().getLeft())) {
            n2.sibling().setRed();
            ((Node)n2.sibling().getRight()).setBlack();
            this.rotateLeft(n2.sibling());
        }
        this.deleteCase6(n2);
    }

    private void deleteCase6(Node<K> n2) {
        n2.sibling().setColor(RedBlackTree.isBlack(n2.getParent()));
        ((Node)n2.getParent()).setBlack();
        if (n2 == n2.getParent().getLeft()) {
            assert (!RedBlackTree.isBlack(n2.sibling().getRight()));
            ((Node)n2.sibling().getRight()).setBlack();
            this.rotateLeft(n2.getParent());
        } else {
            assert (!RedBlackTree.isBlack(n2.sibling().getLeft()));
            ((Node)n2.sibling().getLeft()).setBlack();
            this.rotateRight(n2.getParent());
        }
    }

    public void print() {
        RedBlackTree.printHelper(this.root, 0);
    }

    private static void printHelper(Node<?> n2, int indent) {
        if (n2 == null) {
            System.err.print("<empty tree>");
            return;
        }
        if (n2.getRight() != null) {
            RedBlackTree.printHelper(n2.getRight(), indent + 4);
        }
        for (int i2 = 0; i2 < indent; ++i2) {
            System.err.print(" ");
        }
        if (n2.isBlack()) {
            System.err.println(n2);
        } else {
            System.err.println("<" + n2 + ">");
        }
        if (n2.getLeft() != null) {
            RedBlackTree.printHelper(n2.getLeft(), indent + 4);
        }
    }

    public int size() {
        return this.nodeSize;
    }

    int nodeSize() {
        return this.nodeSize;
    }

    void verifyProperties() {
        if (VERIFY) {
            RedBlackTree.verifyProperty1(this.root);
            RedBlackTree.verifyProperty2(this.root);
            RedBlackTree.verifyProperty4(this.root);
            RedBlackTree.verifyProperty5(this.root);
        }
    }

    private static void verifyProperty1(Node<?> n2) {
        if (n2 == null) {
            return;
        }
        assert (n2.getParent() != n2);
        assert (n2.getLeft() != n2);
        assert (n2.getRight() != n2);
        RedBlackTree.assertParentChild(n2);
        RedBlackTree.verifyProperty1(n2.getLeft());
        RedBlackTree.verifyProperty1(n2.getRight());
    }

    private static void verifyProperty2(Node<?> root) {
        assert (RedBlackTree.isBlack(root));
    }

    @Contract(pure=true)
    private static boolean isBlack(@Nullable Node<?> n2) {
        return n2 == null || n2.isBlack();
    }

    private static void verifyProperty4(Node<?> n2) {
        if (!RedBlackTree.isBlack(n2)) {
            assert (RedBlackTree.isBlack(n2.getLeft()));
            assert (RedBlackTree.isBlack(n2.getRight()));
            assert (RedBlackTree.isBlack(n2.getParent()));
        }
        if (n2 == null) {
            return;
        }
        RedBlackTree.verifyProperty4(n2.getLeft());
        RedBlackTree.verifyProperty4(n2.getRight());
    }

    private static void verifyProperty5(Node<?> root) {
        RedBlackTree.verifyProperty5Helper(root, 0, -1);
    }

    private static int verifyProperty5Helper(Node<?> n2, int blackCount, int pathBlackCount) {
        if (RedBlackTree.isBlack(n2)) {
            ++blackCount;
        }
        if (n2 == null) {
            if (pathBlackCount == -1) {
                pathBlackCount = blackCount;
            } else assert (blackCount == pathBlackCount);
            return pathBlackCount;
        }
        pathBlackCount = RedBlackTree.verifyProperty5Helper(n2.getLeft(), blackCount, pathBlackCount);
        pathBlackCount = RedBlackTree.verifyProperty5Helper(n2.getRight(), blackCount, pathBlackCount);
        return pathBlackCount;
    }

    public void clear() {
        this.incModCount();
        this.root = null;
        this.nodeSize = 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RedBlackTree";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RedBlackTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "maximumNode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rotateLeft";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rotateRight";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceNode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deleteNode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "maximumNode";
                break;
            }
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Node<K> {
        protected Node<K> left;
        protected Node<K> right;
        protected Node<K> parent;
        private volatile byte myFlags;
        static final byte COLOR_MASK = 1;

        @Contract(pure=true)
        boolean isFlagSet(byte mask) {
            return BitUtil.isSet(this.myFlags, mask);
        }

        void setFlag(byte mask, boolean value2) {
            this.myFlags = BitUtil.set(this.myFlags, mask, value2);
        }

        public Node<K> grandparent() {
            assert (this.getParent() != null);
            assert (this.getParent().getParent() != null);
            return this.getParent().getParent();
        }

        public Node<K> sibling() {
            Node<K> parent2 = this.getParent();
            assert (parent2 != null);
            return this == parent2.getLeft() ? parent2.getRight() : parent2.getLeft();
        }

        private Node<K> uncle() {
            assert (this.getParent() != null);
            assert (this.getParent().getParent() != null);
            return this.getParent().sibling();
        }

        public Node<K> getLeft() {
            return this.left;
        }

        public void setLeft(Node<K> left) {
            this.left = left;
        }

        public Node<K> getRight() {
            return this.right;
        }

        public void setRight(Node<K> right) {
            this.right = right;
        }

        public Node<K> getParent() {
            return this.parent;
        }

        public void setParent(Node<K> parent2) {
            this.parent = parent2;
        }

        public abstract boolean processAliveKeys(@NotNull Processor<? super K> var1);

        public abstract boolean hasAliveKey(boolean var1);

        @Contract(pure=true)
        public boolean isBlack() {
            return this.isFlagSet((byte)1);
        }

        private void setBlack() {
            this.setFlag((byte)1, true);
        }

        void setRed() {
            this.setFlag((byte)1, false);
        }

        public void setColor(boolean isBlack) {
            this.setFlag((byte)1, isBlack);
        }
    }
}

