/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.LinkedCustomHashMap;
import com.intellij.util.containers.ShareableKey;
import com.intellij.util.containers.hash.EqualityPolicy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SLRUMap<K, V> {
    private static final int FACTOR = Integer.getInteger("idea.slru.factor", 1);
    private final LinkedCustomHashMap<K, V> protectedQueue;
    private final LinkedCustomHashMap<K, V> probationalQueue;
    private final int protectedQueueSize;
    private final int probationalQueueSize;
    private int probationalHits;
    private int protectedHits;
    private int misses;

    public SLRUMap(int protectedQueueSize, int probationalQueueSize) {
        this(protectedQueueSize, probationalQueueSize, EqualityPolicy.CANONICAL);
    }

    public SLRUMap(int protectedQueueSize, int probationalQueueSize, @NotNull EqualityPolicy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            SLRUMap.$$$reportNull$$$0(0);
        }
        this.protectedQueueSize = protectedQueueSize * FACTOR;
        this.probationalQueueSize = probationalQueueSize * FACTOR;
        this.probationalQueue = new LinkedCustomHashMap<Object, Object>(hashingStrategy, (size, eldest, key, value2) -> {
            if (size > this.probationalQueueSize) {
                this.onDropFromCache(key, value2);
                return true;
            }
            return false;
        });
        this.protectedQueue = new LinkedCustomHashMap<Object, Object>(hashingStrategy, (size, eldest, key, value2) -> {
            if (size > this.protectedQueueSize) {
                this.probationalQueue.put(key, value2);
                return true;
            }
            return false;
        });
    }

    @Nullable
    public V get(K key) {
        V value2 = this.protectedQueue.get(key);
        if (value2 != null) {
            ++this.protectedHits;
            return value2;
        }
        value2 = this.probationalQueue.remove(key);
        if (value2 != null) {
            ++this.probationalHits;
            this.putToProtectedQueue(key, value2);
            return value2;
        }
        ++this.misses;
        return null;
    }

    protected void putToProtectedQueue(K key, @NotNull V value2) {
        if (value2 == null) {
            SLRUMap.$$$reportNull$$$0(1);
        }
        this.protectedQueue.put(this.getStableKey(key), value2);
    }

    public void put(K key, @NotNull V value2) {
        V oldValue;
        if (value2 == null) {
            SLRUMap.$$$reportNull$$$0(2);
        }
        if ((oldValue = this.protectedQueue.remove(key)) != null) {
            this.onDropFromCache(key, oldValue);
        }
        if ((oldValue = this.probationalQueue.put(this.getStableKey(key), value2)) != null) {
            this.onDropFromCache(key, oldValue);
        }
    }

    protected void onDropFromCache(K key, @NotNull V value2) {
        if (value2 == null) {
            SLRUMap.$$$reportNull$$$0(3);
        }
    }

    public boolean remove(K key) {
        V value2 = this.protectedQueue.remove(key);
        if (value2 != null) {
            this.onDropFromCache(key, value2);
            return true;
        }
        value2 = this.probationalQueue.remove(key);
        if (value2 != null) {
            this.onDropFromCache(key, value2);
            return true;
        }
        return false;
    }

    public void iterateKeys(@NotNull Consumer<? super K> keyConsumer) {
        if (keyConsumer == null) {
            SLRUMap.$$$reportNull$$$0(4);
        }
        this.protectedQueue.keySet().forEach(keyConsumer);
        this.probationalQueue.keySet().forEach(keyConsumer);
    }

    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>(this.protectedQueue.entrySet());
        set.addAll(this.probationalQueue.entrySet());
        HashSet<Map.Entry<K, V>> hashSet = set;
        if (hashSet == null) {
            SLRUMap.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    public Set<V> values() {
        HashSet<V> set = new HashSet<V>(this.protectedQueue.values());
        set.addAll(this.probationalQueue.values());
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            SLRUMap.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public void clear() {
        try {
            if (!this.protectedQueue.isEmpty()) {
                for (Map.Entry<K, V> entry : this.protectedQueue.entrySet()) {
                    this.onDropFromCache(entry.getKey(), entry.getValue());
                }
            }
            if (!this.probationalQueue.isEmpty()) {
                for (Map.Entry<K, V> entry : this.probationalQueue.entrySet()) {
                    this.onDropFromCache(entry.getKey(), entry.getValue());
                }
            }
        }
        finally {
            this.protectedQueue.clear();
            this.probationalQueue.clear();
        }
    }

    private K getStableKey(K key) {
        if (key instanceof ShareableKey) {
            return (K)((ShareableKey)key).getStableCopy();
        }
        return key;
    }

    @NotNull
    public String dumpStats() {
        String string2 = "probational hits = " + this.probationalHits + ", protected hits = " + this.protectedHits + ", misses = " + this.misses;
        if (string2 == null) {
            SLRUMap.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConsumer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/SLRUMap";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/SLRUMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStats";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putToProtectedQueue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onDropFromCache";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "iterateKeys";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

