/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectNode;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ObjectTree {
    private final Map<Disposable, ObjectNode> myObject2ParentNode = new Reference2ObjectOpenHashMap<Disposable, ObjectNode>();
    private final Map<Disposable, Throwable> myDisposedObjects = CollectionFactory.createWeakIdentityMap(100, 0.5f);
    private static final Throwable UNKNOWN_TRACE = new Throwable();
    private final ObjectNode myRootNode = ObjectNode.createRootNode();
    private static final ThreadLocal<Throwable> ourTopmostDisposeTrace = new ThreadLocal();

    ObjectTree() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(@NotNull Disposable parent2, @NotNull Disposable child) throws RuntimeException {
        if (parent2 == null) {
            ObjectTree.$$$reportNull$$$0(0);
        }
        if (child == null) {
            ObjectTree.$$$reportNull$$$0(1);
        }
        if (parent2 == child) {
            throw new IllegalArgumentException("Cannot register to itself: " + parent2);
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isDisposed(parent2)) {
                throw new IncorrectOperationException("Sorry but parent: " + parent2 + " (" + parent2.getClass() + ") has already been disposed (see the cause for stacktrace) so the child: " + child + " (" + child.getClass() + ") will never be disposed", this.getDisposalTrace(parent2));
            }
            this.myDisposedObjects.remove(child);
            if (child instanceof Disposer.CheckedDisposableImpl) {
                ((Disposer.CheckedDisposableImpl)child).isDisposed = false;
            }
            ObjectNode parentNode = this.getParentNode(parent2).findOrCreateChildNode(parent2);
            ObjectNode childNode = this.getParentNode(child).moveChildNodeToOtherParent(child, parentNode);
            this.myObject2ParentNode.put(child, parentNode);
            assert (childNode.getObject() == child);
            this.checkWasNotAddedAlreadyAsChild(parentNode, childNode);
        }
    }

    @NotNull
    private ObjectNode getParentNode(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(2);
        }
        ObjectNode objectNode = ObjectUtils.chooseNotNull(this.myObject2ParentNode.get(object), this.myRootNode);
        if (objectNode == null) {
            ObjectTree.$$$reportNull$$$0(3);
        }
        return objectNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryRegister(@NotNull Disposable parent2, @NotNull Disposable child) {
        if (parent2 == null) {
            ObjectTree.$$$reportNull$$$0(4);
        }
        if (child == null) {
            ObjectTree.$$$reportNull$$$0(5);
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isDisposed(parent2)) {
                return false;
            }
            this.register(parent2, child);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Throwable getDisposalTrace(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(6);
        }
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            return ObjectUtils.nullizeIfDefaultValue(this.myDisposedObjects.get(object), UNKNOWN_TRACE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDisposed(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(7);
        }
        if (object instanceof CheckedDisposable) {
            return ((CheckedDisposable)object).isDisposed();
        }
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            return this.myDisposedObjects.get(object) != null;
        }
    }

    private void checkWasNotAddedAlreadyAsChild(@NotNull ObjectNode childNode, @NotNull ObjectNode parentNode) throws IncorrectOperationException {
        if (childNode == null) {
            ObjectTree.$$$reportNull$$$0(8);
        }
        if (parentNode == null) {
            ObjectTree.$$$reportNull$$$0(9);
        }
        ObjectNode node = childNode;
        while (node != this.myRootNode && node != null) {
            if (node == parentNode) {
                throw new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
            }
            node = this.myObject2ParentNode.get(node.getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithTrace(@NotNull @NotNull BiFunction<? super ObjectTree, ? super Throwable, ? extends @NotNull List<Disposable>> removeFromTreeAction) {
        List<Disposable> disposables;
        boolean needTrace;
        if (removeFromTreeAction == null) {
            ObjectTree.$$$reportNull$$$0(10);
        }
        Throwable trace = null;
        boolean bl2 = needTrace = Disposer.isDebugMode() && (trace = ourTopmostDisposeTrace.get()) == null;
        if (needTrace) {
            trace = ThrowableInterner.intern(new Throwable());
            ourTopmostDisposeTrace.set(trace);
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            disposables = removeFromTreeAction.apply(this, trace);
        }
        SmartList<Throwable> exceptions = null;
        for (int i2 = disposables.size() - 1; i2 >= 0; --i2) {
            Disposable disposable = disposables.get(i2);
            if (!(disposable instanceof Disposable.Parent)) continue;
            try {
                ((Disposable.Parent)disposable).beforeTreeDispose();
                continue;
            }
            catch (Throwable t2) {
                if (exceptions == null) {
                    exceptions = new SmartList<Throwable>();
                }
                exceptions.add(t2);
            }
        }
        for (Disposable disposable : disposables) {
            try {
                disposable.dispose();
            }
            catch (Throwable e2) {
                if (exceptions == null) {
                    exceptions = new SmartList();
                }
                exceptions.add(e2);
            }
        }
        if (needTrace) {
            ourTopmostDisposeTrace.remove();
        }
        if (exceptions != null) {
            ObjectTree.handleExceptions(exceptions);
        }
    }

    void executeAllChildren(@NotNull Disposable object, @NotNull Predicate<? super Disposable> predicate) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(11);
        }
        if (predicate == null) {
            ObjectTree.$$$reportNull$$$0(12);
        }
        this.runWithTrace((tree, trace) -> {
            ObjectNode parentNode = this.getParentNode(object);
            ObjectNode node = parentNode.findChildNode(object);
            if (node == null) {
                return Collections.emptyList();
            }
            ArrayList disposables = new ArrayList();
            node.removeChildNodesRecursively(disposables, (ObjectTree)tree, (Throwable)trace, predicate);
            for (Disposable disposable : disposables) {
                this.myObject2ParentNode.remove(disposable);
            }
            return disposables;
        });
    }

    void executeAll(@NotNull Disposable object, boolean processUnregistered) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(13);
        }
        this.runWithTrace((tree, trace) -> {
            ObjectNode parentNode = this.getParentNode(object);
            ObjectNode node = parentNode.findChildNode(object);
            if (node == null && !processUnregistered) {
                return Collections.emptyList();
            }
            ArrayList<Disposable> disposables = new ArrayList<Disposable>();
            if (node != null) {
                node.removeChildNodesRecursively((List<? super Disposable>)disposables, (ObjectTree)tree, (Throwable)trace, null);
                parentNode.removeChildNode(node);
            }
            if (this.rememberDisposedTrace(object, (Throwable)trace) == null) {
                disposables.add(object);
            }
            for (Disposable disposable : disposables) {
                this.myObject2ParentNode.remove(disposable);
            }
            return disposables;
        });
    }

    private Object getTreeLock() {
        return this.myRootNode;
    }

    private static void handleExceptions(@NotNull List<? extends Throwable> exceptions) {
        if (exceptions == null) {
            ObjectTree.$$$reportNull$$$0(14);
        }
        if (exceptions.isEmpty()) {
            return;
        }
        ProcessCanceledException processCanceledException = null;
        for (Throwable throwable : exceptions) {
            if (!(throwable instanceof ProcessCanceledException)) {
                ObjectTree.getLogger().error(throwable);
                continue;
            }
            if (processCanceledException != null) continue;
            processCanceledException = (ProcessCanceledException)throwable;
        }
        if (processCanceledException != null) {
            throw processCanceledException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    void assertNoReferenceKeptInTree(@NotNull Disposable disposable) {
        if (disposable == null) {
            ObjectTree.$$$reportNull$$$0(15);
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            for (ObjectNode node : this.myObject2ParentNode.values()) {
                node.assertNoReferencesKept(disposable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    void assertIsEmpty(boolean throwError) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.myRootNode.assertNoChildren(throwError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Throwable getRegistrationTrace(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(16);
        }
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            ObjectNode objectNode = this.getParentNode(object).findChildNode(object);
            return objectNode == null ? null : objectNode.getTrace();
        }
    }

    @NotNull
    static Logger getLogger() {
        Logger logger2 = Logger.getInstance(ObjectTree.class);
        if (logger2 == null) {
            ObjectTree.$$$reportNull$$$0(17);
        }
        return logger2;
    }

    Throwable rememberDisposedTrace(@NotNull Disposable object, @Nullable Throwable trace) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(18);
        }
        if (object instanceof CheckedDisposable) {
            return null;
        }
        return this.myDisposedObjects.put(object, ObjectUtils.notNull(trace, UNKNOWN_TRACE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDisposedObjectTraces() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.myDisposedObjects.clear();
            for (ObjectNode value2 : this.myObject2ParentNode.values()) {
                value2.clearTrace();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ObjectTree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeFromTreeAction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ObjectTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentNode";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentNode";
                break;
            }
            case 3: 
            case 17: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryRegister";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalTrace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkWasNotAddedAlreadyAsChild";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWithTrace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeAllChildren";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeAll";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleExceptions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferenceKeptInTree";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRegistrationTrace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "rememberDisposedTrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

