/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.DomAdapter;
import com.intellij.util.xmlb.JdomAdapter;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MapBindingKt;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.RootBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlDomAdapter;
import com.intellij.util.xmlb.annotations.Property;
import java.awt.Rectangle;
import java.util.List;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonNull;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AccessorBindingWrapper
implements MultiNodeBinding,
NestedBinding {
    private final Binding binding;
    private final MutableAccessor accessor;
    final boolean isFlat;
    private final Property.Style beanStyle;

    AccessorBindingWrapper(@NotNull MutableAccessor accessor, @NotNull Binding binding, boolean isFlat, Property.Style beanStyle) {
        if (accessor == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(0);
        }
        if (binding == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(1);
        }
        this.accessor = accessor;
        this.binding = binding;
        this.isFlat = isFlat;
        this.beanStyle = beanStyle;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.accessor;
        if (mutableAccessor == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(2);
        }
        return mutableAccessor;
    }

    @Override
    @Nullable
    public JsonElement toJson(@NotNull Object bean, @Nullable SerializationFilter filter) {
        Object value2;
        if (bean == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(3);
        }
        return (value2 = this.accessor.read(bean)) == null ? JsonNull.INSTANCE : this.binding.toJson(value2, filter);
    }

    @Override
    public void setFromJson(@NotNull Object bean, @NotNull JsonElement element2) {
        Object value2;
        Object currentValue;
        if (bean == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(5);
        }
        if ((currentValue = this.accessor.read(bean)) != (value2 = ((RootBinding)this.binding).fromJson(currentValue, element2))) {
            this.accessor.set(bean, value2);
        }
    }

    @Override
    public void serialize(@NotNull Object bean, @NotNull Element parent2, @Nullable SerializationFilter filter) {
        Object value2;
        if (bean == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(6);
        }
        if (parent2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(7);
        }
        if ((value2 = this.accessor.read(bean)) == null) {
            return;
        }
        if (this.isFlat) {
            if (this.beanStyle == Property.Style.ATTRIBUTE && value2 instanceof Rectangle) {
                Rectangle bounds2 = (Rectangle)value2;
                assert (parent2 != null);
                parent2.setAttribute("x", Integer.toString(bounds2.x));
                parent2.setAttribute("y", Integer.toString(bounds2.y));
                parent2.setAttribute("width", Integer.toString(bounds2.width));
                parent2.setAttribute("height", Integer.toString(bounds2.height));
            } else {
                ((BeanBinding)this.binding).serializeProperties(value2, parent2, filter);
            }
        } else {
            this.binding.serialize(value2, parent2, filter);
        }
    }

    @Override
    @Nullable
    public <T> Object deserialize(@Nullable Object context2, @NotNull T element2, @NotNull DomAdapter<T> adapter) {
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(8);
        }
        if (adapter == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(9);
        }
        if (adapter == JdomAdapter.INSTANCE) {
            return this.deserializeUnsafe(context2, (Element)element2);
        }
        return this.deserializeUnsafe(context2, (XmlElement)element2);
    }

    @Override
    @Nullable
    public JsonElement deserializeToJson(@NotNull Element element2) {
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(10);
        }
        return ((RootBinding)this.binding).deserializeToJson(element2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object deserializeUnsafe(Object context2, @NotNull Element element2) {
        Object deserializedValue;
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(11);
        }
        Object currentValue = this.accessor.read(context2);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, element2);
            return context2;
        }
        if (this.beanStyle == Property.Style.ATTRIBUTE && this.binding instanceof BeanBinding && ((BeanBinding)this.binding).beanClass == Rectangle.class) {
            String xA = element2.getAttributeValue("x");
            String yA = element2.getAttributeValue("y");
            String wA = element2.getAttributeValue("width");
            String hA = element2.getAttributeValue("height");
            if (xA == null || yA == null || wA == null || hA == null) return context2;
            int x = StringUtilRt.parseInt(xA, 0);
            int y = StringUtilRt.parseInt(yA, 0);
            int h2 = StringUtilRt.parseInt(hA, 0);
            int w2 = StringUtilRt.parseInt(wA, 0);
            deserializedValue = new Rectangle(x, y, w2, h2);
        } else {
            deserializedValue = this.binding.deserialize(currentValue, element2, JdomAdapter.INSTANCE);
        }
        if (currentValue == deserializedValue) return context2;
        this.accessor.set(context2, deserializedValue);
        return context2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object deserializeUnsafe(Object context2, @NotNull XmlElement element2) {
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(12);
        }
        Object currentValue = this.accessor.read(context2);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, element2);
            return context2;
        } else {
            Object deserializedValue;
            if (this.beanStyle == Property.Style.ATTRIBUTE && this.binding instanceof BeanBinding && ((BeanBinding)this.binding).beanClass == Rectangle.class) {
                String xA = element2.getAttributeValue("x");
                String yA = element2.getAttributeValue("y");
                String wA = element2.getAttributeValue("width");
                String hA = element2.getAttributeValue("height");
                if (xA == null || yA == null || wA == null || hA == null) return context2;
                int x = StringUtilRt.parseInt(xA, 0);
                int y = StringUtilRt.parseInt(yA, 0);
                int h2 = StringUtilRt.parseInt(hA, 0);
                int w2 = StringUtilRt.parseInt(wA, 0);
                deserializedValue = new Rectangle(x, y, w2, h2);
            } else {
                deserializedValue = this.binding.deserialize(currentValue, element2, XmlDomAdapter.INSTANCE);
            }
            if (currentValue == deserializedValue) return context2;
            this.accessor.set(context2, deserializedValue);
        }
        return context2;
    }

    @Override
    @Nullable
    public <T> Object deserializeList(@Nullable Object currentValue, @NotNull List<? extends T> elements, @NotNull DomAdapter<T> adapter) {
        if (elements == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(13);
        }
        if (adapter == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(14);
        }
        assert (currentValue != null);
        Object value2 = this.accessor.read(currentValue);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(value2, elements.get(0), adapter);
        } else {
            Object deserializedValue = MapBindingKt.deserializeList(this.binding, value2, elements, adapter);
            if (value2 != deserializedValue) {
                this.accessor.set(currentValue, deserializedValue);
            }
        }
        return null;
    }

    @Override
    public boolean isSurroundWithTag() {
        return false;
    }

    @Override
    @NotNull
    public JsonElement doDeserializeListToJson(@NotNull List<? extends Element> elements) {
        if (elements == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(15);
        }
        JsonElement jsonElement = ((MultiNodeBinding)this.binding).deserializeListToJson(elements);
        if (jsonElement == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(16);
        }
        return jsonElement;
    }

    @Override
    public boolean isMulti() {
        return this.binding instanceof MultiNodeBinding && ((MultiNodeBinding)this.binding).isMulti();
    }

    @Override
    public <T> boolean isBoundTo(@NotNull T element2, @NotNull DomAdapter<T> adapter) {
        if (element2 == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(17);
        }
        if (adapter == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(18);
        }
        if (this.binding instanceof MapBinding) {
            return ((MapBinding)this.binding).isBoundToWithoutProperty(adapter.getName(element2));
        }
        return this.binding.isBoundTo(element2, adapter);
    }

    public String toString() {
        return this.binding.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doDeserializeListToJson";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toJson";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFromJson";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializeToJson";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserializeUnsafe";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doDeserializeListToJson";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

