/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.DirectByteBufferAllocator;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectBufferWrapper {
    private static final int RELEASED_CODE = -1;
    private static final AtomicIntegerFieldUpdater<DirectBufferWrapper> REF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DirectBufferWrapper.class, "myReferences");
    @NotNull
    private final PagedFileStorage myFile;
    private volatile ByteBuffer myBuffer;
    private final long myPosition;
    private volatile int myBufferDataEndPos;
    private volatile boolean myDirty;
    private volatile int myReferences;

    DirectBufferWrapper(@NotNull PagedFileStorage file2, long positionInFile) throws IOException {
        if (file2 == null) {
            DirectBufferWrapper.$$$reportNull$$$0(0);
        }
        this.myReferences = 0;
        file2.getStorageLockContext().assertUnderSegmentAllocationLock();
        this.myFile = file2;
        this.myPosition = positionInFile;
        this.myBuffer = this.allocateAndLoadFileContent();
    }

    public ByteBuffer getBuffer() {
        return this.myBuffer;
    }

    public void markDirty() throws IOException {
        if (!this.myDirty) {
            if (this.myFile.isReadOnly()) {
                throw new IOException("Read-only byte buffer can't be modified. File: " + this.myFile);
            }
            this.myDirty = true;
            this.myFile.markDirty();
        }
    }

    public void fileSizeMayChanged(int bufferDataEndPos) {
        if (bufferDataEndPos > this.myBufferDataEndPos) {
            this.myBufferDataEndPos = bufferDataEndPos;
            this.myFile.ensureCachedSizeAtLeast(this.myPosition + (long)this.myBufferDataEndPos);
        }
    }

    public boolean isDirty() {
        return this.myDirty;
    }

    public ByteBuffer copy() {
        ByteBuffer duplicate = this.myBuffer.duplicate();
        duplicate.order(this.myBuffer.order());
        return duplicate;
    }

    public byte get(int index2, boolean checkAccess) {
        if (checkAccess) {
            StorageLockContext context2 = this.myFile.getStorageLockContext();
            context2.checkReadAccess();
        }
        return this.myBuffer.get(index2);
    }

    public long getLong(int index2) {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkReadAccess();
        return this.myBuffer.getLong(index2);
    }

    public void putLong(int index2, long value2) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        this.myBuffer.putLong(index2, value2);
        this.fileSizeMayChanged(index2 + 8);
    }

    public int getInt(int index2) {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkReadAccess();
        return this.myBuffer.getInt(index2);
    }

    public void putInt(int index2, int value2) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        this.myBuffer.putInt(index2, value2);
        this.fileSizeMayChanged(index2 + 4);
    }

    public void position(int newPosition) {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.myBuffer.position(newPosition);
    }

    public int position() {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkReadAccess();
        return this.myBuffer.position();
    }

    public void put(ByteBuffer src) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        this.myBuffer.put(src);
        this.fileSizeMayChanged(this.myBuffer.position());
    }

    public void put(int index2, byte b2) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        this.myBuffer.put(index2, b2);
        this.fileSizeMayChanged(index2 + 1);
    }

    public void readToArray(byte[] dst, int o2, int page_offset, int page_len, boolean checkAccess) throws IllegalArgumentException {
        if (checkAccess) {
            StorageLockContext context2 = this.myFile.getStorageLockContext();
            context2.checkReadAccess();
        }
        ByteBufferUtil.copyMemory(this.myBuffer, page_offset, dst, o2, page_len);
    }

    public void putFromArray(byte[] src, int o2, int page_offset, int page_len) throws IOException, IllegalArgumentException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        ByteBuffer buf = this.myBuffer.duplicate();
        buf.position(page_offset);
        buf.put(src, o2, page_len);
        this.fileSizeMayChanged(buf.position());
    }

    public void putFromBuffer(@NotNull ByteBuffer data, int page_offset) throws IOException, IllegalArgumentException {
        if (data == null) {
            DirectBufferWrapper.$$$reportNull$$$0(1);
        }
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        ByteBuffer buf = this.myBuffer.duplicate();
        buf.position(page_offset);
        buf.put(data);
        this.fileSizeMayChanged(buf.position());
    }

    public boolean tryLock() {
        return REF_UPDATER.updateAndGet(this, refCount -> refCount >= 0 ? refCount + 1 : refCount) >= 0;
    }

    public void unlock() {
        int currentRefs = REF_UPDATER.decrementAndGet(this);
        assert (currentRefs >= 0);
    }

    public boolean isReleased() {
        return this.myReferences == -1;
    }

    public boolean isLocked() {
        return this.myReferences > 0;
    }

    public int getLength() {
        return this.myFile.getPageSize();
    }

    private ByteBuffer allocateAndLoadFileContent() throws IOException {
        int bufferSize = this.myFile.getPageSize();
        ByteBuffer buffer = DirectByteBufferAllocator.ALLOCATOR.allocate(bufferSize);
        buffer.order(this.myFile.isNativeBytesOrder() ? ByteOrder.nativeOrder() : ByteOrder.BIG_ENDIAN);
        assert (buffer.limit() > 0);
        return this.myFile.executeIdempotentOp(ch -> {
            int readBytes = ch.read(buffer, this.myPosition);
            if (readBytes < bufferSize) {
                for (int i2 = Math.max(0, readBytes); i2 < bufferSize; ++i2) {
                    buffer.put(i2, (byte)0);
                }
            }
            return buffer;
        }, this.myFile.isReadOnly());
    }

    boolean tryRelease(boolean force) throws IOException {
        boolean releaseState;
        boolean bl2 = releaseState = REF_UPDATER.updateAndGet(this, operand -> operand == 0 ? -1 : operand) == -1;
        if (releaseState || force) {
            this.myFile.getStorageLockContext().assertUnderSegmentAllocationLock();
            if (this.isDirty()) {
                this.force();
            }
            if (this.myBuffer != null) {
                DirectByteBufferAllocator.ALLOCATOR.release(this.myBuffer);
                this.myBuffer = null;
            }
            if (force && !releaseState) {
                PagedFileStorage.LOG.error("Page buffer is referenced but was forcibly released for file " + this.myFile.getFile());
            }
            return true;
        }
        return false;
    }

    void force() throws IOException {
        this.myFile.getStorageLockContext().assertUnderSegmentAllocationLock();
        if (this.myFile.isReadOnly()) {
            throw new IllegalStateException("Can't flush .readOnly page: " + this);
        }
        if (this.isDirty()) {
            ByteBuffer buffer = this.myBuffer.duplicate();
            buffer.rewind();
            buffer.limit(this.myBufferDataEndPos);
            this.myFile.executeIdempotentOp(ch -> {
                ch.write(buffer, this.myPosition);
                return null;
            }, false);
            this.myDirty = false;
        }
    }

    @NotNull
    PagedFileStorage getFile() {
        PagedFileStorage pagedFileStorage = this.myFile;
        if (pagedFileStorage == null) {
            DirectBufferWrapper.$$$reportNull$$$0(2);
        }
        return pagedFileStorage;
    }

    public String toString() {
        return "Buffer for " + this.myFile + ", offset:" + this.myPosition + ", size: " + this.myFile.getPageSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/DirectBufferWrapper";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/DirectBufferWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putFromBuffer";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

