/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.util.ui.EDT;
import java.awt.EventQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ThreadingAssertions {
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_EXECUTE_IN_READ_ACTION = "Read access is allowed from inside read-action only (see Application.runReadAction())";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_NOT_EXECUTE_IN_READ_ACTION = "Must not execute inside read action";
    private static final String MUST_EXECUTE_IN_WRITE_INTENT_READ_ACTION = "Access is allowed from write thread only";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_EXECUTE_IN_WRITE_ACTION = "Write access is allowed inside write-action only (see Application.runWriteAction())";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_EXECUTE_IN_EDT = "Access is allowed from Event Dispatch Thread (EDT) only";
    @ApiStatus.Internal
    @VisibleForTesting
    public static final String MUST_NOT_EXECUTE_IN_EDT = "Access from Event Dispatch Thread (EDT) is not allowed";
    private static final String DOCUMENTATION_URL = "https://jb.gg/ij-platform-threading";

    private ThreadingAssertions() {
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(ThreadingAssertions.class);
        if (logger2 == null) {
            ThreadingAssertions.$$$reportNull$$$0(0);
        }
        return logger2;
    }

    public static void assertEventDispatchThread() {
        if (!EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_EDT);
        }
    }

    @ApiStatus.Obsolete
    public static void softAssertEventDispatchThread() {
        if (!EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.getLogger().error(ThreadingAssertions.createThreadAccessException(MUST_EXECUTE_IN_EDT));
        }
    }

    public static void assertBackgroundThread() {
        if (EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.throwThreadAccessException(MUST_NOT_EXECUTE_IN_EDT);
        }
    }

    @ApiStatus.Obsolete
    public static void softAssertBackgroundThread() {
        if (EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.getLogger().error(ThreadingAssertions.createThreadAccessException(MUST_NOT_EXECUTE_IN_EDT));
        }
    }

    public static void assertReadAccess() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_READ_ACTION);
        }
    }

    @ApiStatus.Obsolete
    public static void softAssertReadAccess() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ThreadingAssertions.getLogger().error(ThreadingAssertions.createThreadAccessException(MUST_EXECUTE_IN_READ_ACTION));
        }
    }

    public static void assertNoReadAccess() {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            ThreadingAssertions.throwThreadAccessException(MUST_NOT_EXECUTE_IN_READ_ACTION);
        }
    }

    public static void assertWriteIntentReadAccess() {
        if (!ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
            ThreadingAssertions.throwWriteIntentReadAccess();
        }
    }

    public static void throwWriteIntentReadAccess() {
        ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_WRITE_INTENT_READ_ACTION);
    }

    public static void assertWriteAccess() {
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            ThreadingAssertions.throwThreadAccessException(MUST_EXECUTE_IN_WRITE_ACTION);
        }
    }

    private static void throwThreadAccessException(@NotNull @NonNls String message) {
        if (message == null) {
            ThreadingAssertions.$$$reportNull$$$0(1);
        }
        throw ThreadingAssertions.createThreadAccessException(message);
    }

    @NotNull
    private static RuntimeExceptionWithAttachments createThreadAccessException(@NonNls @NotNull String message) {
        if (message == null) {
            ThreadingAssertions.$$$reportNull$$$0(2);
        }
        return new RuntimeExceptionWithAttachments(message + "; see " + DOCUMENTATION_URL + " for details\n" + ThreadingAssertions.getThreadDetails(), new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString()));
    }

    @NotNull
    private static String getThreadDetails() {
        Thread current = Thread.currentThread();
        Thread edt = EDT.getEventDispatchThreadOrNull();
        String string2 = "Current thread: " + ThreadingAssertions.describe(current) + " (EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + ")\nSystemEventQueueThread: " + (edt == current ? "(same)" : ThreadingAssertions.describe(edt));
        if (string2 == null) {
            ThreadingAssertions.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    private static String describe(@Nullable Thread o2) {
        String string2 = o2 == null ? "null" : o2 + " " + System.identityHashCode(o2);
        if (string2 == null) {
            ThreadingAssertions.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadDetails";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "throwThreadAccessException";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createThreadAccessException";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

