/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaVariableConflictResolver
implements PsiConflictResolver {
    @Override
    public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        int size;
        if (conflicts == null) {
            JavaVariableConflictResolver.$$$reportNull$$$0(0);
        }
        if ((size = conflicts.size()) == 1) {
            return conflicts.get(0);
        }
        if (size == 0) {
            return null;
        }
        CandidateInfo[] uncheckedResult = conflicts.toArray(new CandidateInfo[size]);
        CandidateInfo currentResult = uncheckedResult[0];
        PsiElement currentElement = currentResult.getElement();
        if (currentElement instanceof PsiField) {
            for (int i2 = 1; i2 < uncheckedResult.length; ++i2) {
                CandidateInfo candidate = uncheckedResult[i2];
                PsiElement otherElement = candidate.getElement();
                if (!(otherElement instanceof PsiField)) {
                    if (PsiUtil.isJvmLocalVariable(otherElement)) {
                        return candidate;
                    }
                    if (!currentResult.isAccessible()) {
                        return candidate;
                    }
                    conflicts.remove(candidate);
                    continue;
                }
                PsiClass newClass = ((PsiField)otherElement).getContainingClass();
                PsiClass oldClass = ((PsiField)currentElement).getContainingClass();
                PsiElement scope = currentResult.getCurrentFileResolveScope();
                Boolean oldClassIsInheritor = null;
                if (newClass != null && oldClass != null) {
                    if (newClass.isInheritor(oldClass, true)) {
                        if (scope instanceof PsiClass && (scope.equals(oldClass) || scope.equals(newClass) || !((PsiClass)scope).isInheritorDeep(oldClass, newClass))) {
                            conflicts.remove(currentResult);
                            currentResult = candidate;
                            currentElement = currentResult.getElement();
                            continue;
                        }
                    } else {
                        oldClassIsInheritor = oldClass.isInheritor(newClass, true);
                        if (oldClassIsInheritor.booleanValue() && (!(scope instanceof PsiClass) || scope.equals(oldClass) || scope.equals(newClass) || !((PsiClass)scope).isInheritorDeep(newClass, oldClass))) {
                            conflicts.remove(candidate);
                            continue;
                        }
                    }
                }
                if (!candidate.isAccessible()) {
                    conflicts.remove(candidate);
                    continue;
                }
                if (!currentResult.isAccessible()) {
                    conflicts.remove(currentResult);
                    currentResult = candidate;
                    currentElement = currentResult.getElement();
                    continue;
                }
                if (otherElement == currentElement) {
                    conflicts.remove(candidate);
                    continue;
                }
                if (oldClassIsInheritor == null) {
                    oldClassIsInheritor = oldClass != null && newClass != null && oldClass.isInheritor(newClass, true);
                }
                if (oldClassIsInheritor.booleanValue() && (scope instanceof PsiAnonymousClass || !(scope instanceof PsiClass) || !((PsiClass)scope).isInheritorDeep(oldClass, newClass))) {
                    conflicts.remove(candidate);
                    continue;
                }
                return null;
            }
        }
        return currentResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaVariableConflictResolver", "resolveConflict"));
    }
}

