/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransactionGuardImpl
extends TransactionGuard {
    private static final Logger LOG = Logger.getInstance(TransactionGuardImpl.class);
    private final Map<ModalityState, Boolean> myWriteSafeModalities = CollectionFactory.createConcurrentWeakMap();
    private boolean myWritingAllowed;
    private boolean myErrorReported;

    public TransactionGuardImpl() {
        this.myWriteSafeModalities.put(ModalityState.nonModal(), true);
        this.myWritingAllowed = SwingUtilities.isEventDispatchThread();
    }

    @Override
    public void submitTransaction(@NotNull Disposable parentDisposable, @Nullable TransactionId expectedContext, @NotNull Runnable transaction) {
        if (parentDisposable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(0);
        }
        if (transaction == null) {
            TransactionGuardImpl.$$$reportNull$$$0(1);
        }
        ModalityState modality = expectedContext == null ? ModalityState.nonModal() : ((TransactionIdImpl)expectedContext).myModality;
        Application app = ApplicationManager.getApplication();
        if (app.isWriteIntentLockAcquired() && this.myWritingAllowed && !ModalityState.current().dominates(modality)) {
            if (!Disposer.isDisposed(parentDisposable)) {
                transaction.run();
            }
        } else {
            ((AppUIExecutor)AppUIExecutor.onWriteThread(modality).later().expireWith(parentDisposable)).execute(transaction);
        }
    }

    @Override
    public void submitTransactionAndWait(@NotNull Runnable runnable) throws ProcessCanceledException {
        Application app;
        if (runnable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(2);
        }
        if ((app = ApplicationManager.getApplication()).isWriteIntentLockAcquired()) {
            if (!this.myWritingAllowed) {
                @NonNls String message = "Cannot run synchronous submitTransactionAndWait from invokeLater. Please use asynchronous submit*Transaction. See TransactionGuard FAQ for details.\nTransaction: " + runnable;
                if (!this.isWriteSafeModality(ModalityState.current())) {
                    message = message + "\nUnsafe modality: " + ModalityState.current();
                }
                LOG.error(message);
            }
            runnable.run();
            return;
        }
        if (app.isReadAccessAllowed()) {
            throw new IllegalStateException("submitTransactionAndWait should not be invoked from a read action");
        }
        ModalityState state = ModalityState.defaultModalityState();
        if (!this.isWriteSafeModality(state)) {
            LOG.error("Cannot run synchronous submitTransactionAndWait from a background thread created in a write-unsafe context");
        }
        app.invokeAndWait(runnable, state);
    }

    @ApiStatus.Internal
    public void performUserActivity(Runnable activity) {
        ThreadingAssertions.assertEventDispatchThread();
        this.performActivity(true, activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void performActivity(boolean userActivity, @NotNull Runnable runnable) {
        boolean allowWriting;
        if (runnable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(3);
        }
        this.myErrorReported = false;
        boolean bl = allowWriting = userActivity && this.isWriteSafeModality(ModalityState.current());
        if (this.myWritingAllowed == allowWriting) {
            runnable.run();
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        boolean prev = this.myWritingAllowed;
        this.myWritingAllowed = allowWriting;
        try {
            runnable.run();
        }
        finally {
            this.myWritingAllowed = prev;
        }
    }

    @Override
    public boolean isWritingAllowed() {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        return this.myWritingAllowed;
    }

    @Override
    public boolean isWriteSafeModality(@NotNull ModalityState state) {
        if (state == null) {
            TransactionGuardImpl.$$$reportNull$$$0(4);
        }
        return Boolean.TRUE.equals(this.myWriteSafeModalities.get(state));
    }

    public void assertWriteActionAllowed() {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        if (!this.myWritingAllowed && TransactionGuardImpl.areAssertionsEnabled() && !this.myErrorReported) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(ModalityState.current()));
            this.myErrorReported = true;
        }
    }

    @NonNls
    private static String reportWriteUnsafeContext(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(5);
        }
        return "Write-unsafe context! Model changes are allowed from write-safe contexts only. Please ensure you're using invokeLater/invokeAndWait with a correct modality state (not \"any\"). See TransactionGuard documentation for details.\n  current modality=" + modality;
    }

    @Override
    public void assertWriteSafeContext(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(6);
        }
        if (!this.isWriteSafeModality(modality) && TransactionGuardImpl.areAssertionsEnabled()) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(modality));
        }
    }

    private static boolean areAssertionsEnabled() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is("ide.require.transaction.for.model.changes", false);
    }

    @Override
    public void submitTransactionLater(@NotNull Disposable parentDisposable, @NotNull Runnable transaction) {
        if (parentDisposable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(7);
        }
        if (transaction == null) {
            TransactionGuardImpl.$$$reportNull$$$0(8);
        }
        TransactionIdImpl ctx = this.getContextTransaction();
        ApplicationManager.getApplication().invokeLaterOnWriteThread(transaction, ctx == null ? ModalityState.nonModal() : ctx.myModality);
    }

    @Override
    public TransactionIdImpl getContextTransaction() {
        if (ApplicationManager.getApplication().isWriteIntentLockAcquired() ? !this.myWritingAllowed : ProgressIndicatorProvider.getGlobalProgressIndicator() == null) {
            return null;
        }
        ModalityState state = ModalityState.defaultModalityState();
        return this.isWriteSafeModality(state) ? new TransactionIdImpl(state) : null;
    }

    public void enteredModality(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(9);
        }
        this.myWriteSafeModalities.put(modality, this.myWritingAllowed);
    }

    @NotNull
    public Runnable wrapLaterInvocation(final @NotNull Runnable runnable, final @NotNull ModalityState modalityState) {
        if (runnable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(10);
        }
        if (modalityState == null) {
            TransactionGuardImpl.$$$reportNull$$$0(11);
        }
        return new Runnable(){

            @Override
            public void run() {
                if (TransactionGuardImpl.this.isWriteSafeModality(modalityState)) {
                    ApplicationManager.getApplication().assertWriteIntentLockAcquired();
                    TransactionGuardImpl.this.runWithWritingAllowed(runnable);
                } else {
                    runnable.run();
                }
            }

            public String toString() {
                return runnable.toString();
            }
        };
    }

    private void runWithWritingAllowed(@NotNull Runnable runnable) {
        if (runnable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(12);
        }
        boolean prev = this.myWritingAllowed;
        this.myWritingAllowed = true;
        try {
            runnable.run();
        }
        finally {
            this.myWritingAllowed = prev;
        }
    }

    public String toString() {
        return "TransactionGuardImpl{myWritingAllowed=" + this.myWritingAllowed + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/TransactionGuardImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "submitTransaction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "submitTransactionAndWait";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performActivity";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriteSafeModality";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportWriteUnsafeContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "assertWriteSafeContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "submitTransactionLater";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "enteredModality";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapLaterInvocation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithWritingAllowed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class TransactionIdImpl
    implements TransactionId {
        final ModalityState myModality;

        private TransactionIdImpl(ModalityState modality) {
            this.myModality = modality;
        }

        public String toString() {
            return this.myModality.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionIdImpl)) {
                return false;
            }
            TransactionIdImpl id = (TransactionIdImpl)o;
            return Objects.equals(this.myModality, id.myModality);
        }

        public int hashCode() {
            return Objects.hash(this.myModality);
        }
    }
}

