/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class LineTokenizer {
    private int myOffset;
    private int myLength;
    private int myLineSeparatorLength;
    private boolean atEnd;
    private final CharSequence myText;

    public static String @NotNull [] tokenize(CharSequence chars, boolean includeSeparators) {
        return LineTokenizer.tokenize(chars, includeSeparators, true);
    }

    public static String @NotNull [] tokenize(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        List<String> strings2 = LineTokenizer.tokenizeIntoList(chars, includeSeparators, skipLastEmptyLine);
        String[] stringArray = strings2.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : ArrayUtilRt.toStringArray(strings2);
        if (stringArray == null) {
            LineTokenizer.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @NotNull
    public static List<String> tokenizeIntoList(CharSequence chars, boolean includeSeparators) {
        return LineTokenizer.tokenizeIntoList(chars, includeSeparators, true);
    }

    @NotNull
    public static List<String> tokenizeIntoList(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null || chars.length() == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                LineTokenizer.$$$reportNull$$$0(1);
            }
            return list;
        }
        LineTokenizer tokenizer = new LineTokenizer(chars);
        ArrayList<String> lines = new ArrayList<String>();
        while (!tokenizer.atEnd()) {
            int offset = tokenizer.getOffset();
            String line = includeSeparators ? chars.subSequence(offset, offset + tokenizer.getLength() + tokenizer.getLineSeparatorLength()).toString() : chars.subSequence(offset, offset + tokenizer.getLength()).toString();
            lines.add(line);
            tokenizer.advance();
        }
        if (!skipLastEmptyLine && LineTokenizer.stringEndsWithSeparator(tokenizer)) {
            lines.add("");
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            LineTokenizer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static int calcLineCount(@NotNull CharSequence chars, boolean skipLastEmptyLine) {
        if (chars == null) {
            LineTokenizer.$$$reportNull$$$0(3);
        }
        int lineCount = 0;
        if (chars.length() != 0) {
            LineTokenizer tokenizer = new LineTokenizer(chars);
            while (!tokenizer.atEnd()) {
                ++lineCount;
                tokenizer.advance();
            }
            if (!skipLastEmptyLine && LineTokenizer.stringEndsWithSeparator(tokenizer)) {
                ++lineCount;
            }
        }
        return lineCount;
    }

    public static String @NotNull [] tokenize(char @NotNull [] chars, boolean includeSeparators) {
        if (chars == null) {
            LineTokenizer.$$$reportNull$$$0(4);
        }
        return LineTokenizer.tokenize(chars, includeSeparators, true);
    }

    public static String @NotNull [] tokenize(char @NotNull [] chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null) {
            LineTokenizer.$$$reportNull$$$0(5);
        }
        return LineTokenizer.tokenize(chars, 0, chars.length, includeSeparators, skipLastEmptyLine);
    }

    public static String @NotNull [] tokenize(char @NotNull [] chars, int startOffset, int endOffset, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null) {
            LineTokenizer.$$$reportNull$$$0(6);
        }
        return LineTokenizer.tokenize(new CharArrayCharSequence(chars, startOffset, endOffset), includeSeparators, skipLastEmptyLine);
    }

    private static boolean stringEndsWithSeparator(@NotNull LineTokenizer tokenizer) {
        if (tokenizer == null) {
            LineTokenizer.$$$reportNull$$$0(7);
        }
        return tokenizer.getLineSeparatorLength() > 0;
    }

    public static String @NotNull [] tokenize(char @NotNull [] chars, int startOffset, int endOffset, boolean includeSeparators) {
        if (chars == null) {
            LineTokenizer.$$$reportNull$$$0(8);
        }
        return LineTokenizer.tokenize(chars, startOffset, endOffset, includeSeparators, true);
    }

    public LineTokenizer(@NotNull CharSequence text) {
        if (text == null) {
            LineTokenizer.$$$reportNull$$$0(9);
        }
        this.myText = text;
        this.myOffset = 0;
        this.advance();
    }

    public LineTokenizer(char @NotNull [] text, int startOffset, int endOffset) {
        if (text == null) {
            LineTokenizer.$$$reportNull$$$0(10);
        }
        this(new CharArrayCharSequence(text, startOffset, endOffset));
    }

    public boolean atEnd() {
        return this.atEnd;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLength() {
        return this.myLength;
    }

    public int getLineSeparatorLength() {
        return this.myLineSeparatorLength;
    }

    public void advance() {
        char c2;
        int i2 = this.myOffset + this.myLength + this.myLineSeparatorLength;
        int textLength = this.myText.length();
        if (i2 >= textLength) {
            this.atEnd = true;
            return;
        }
        while (i2 < textLength && (c2 = this.myText.charAt(i2)) != '\r' && c2 != '\n') {
            ++i2;
        }
        this.myOffset += this.myLength + this.myLineSeparatorLength;
        this.myLength = i2 - this.myOffset;
        this.myLineSeparatorLength = 0;
        if (i2 == textLength) {
            return;
        }
        char first = this.myText.charAt(i2);
        if (first == '\r' || first == '\n') {
            this.myLineSeparatorLength = 1;
        }
        if (++i2 == textLength) {
            return;
        }
        char second = this.myText.charAt(i2);
        if (first == '\r' && second == '\n') {
            this.myLineSeparatorLength = 2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/LineTokenizer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenizeIntoList";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/LineTokenizer";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcLineCount";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stringEndsWithSeparator";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

