/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.DuplicateIrNodeError;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.context.ContextUpdater;
import org.jetbrains.kotlin.backend.common.checkers.context.ParentChainUpdater;
import org.jetbrains.kotlin.backend.common.checkers.context.TypeParameterScopeUpdater;
import org.jetbrains.kotlin.backend.common.checkers.context.ValueScopeUpdater;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrConstructorReceiverChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationCheckerKt;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFieldVisibilityChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFunctionBodyChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFunctionDispatchReceiverChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFunctionParametersChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFunctionPropertiesChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrPrivateDeclarationOverrideChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrPropertyAccessorsChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrValueParameterVarargTypesChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrCallFunctionDispatchReceiverChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrCallFunctionPropertiesChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrCallTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrConstTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrCrossFileFieldUsageChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrDeclarationReferenceVisibilityChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrDynamicTypeFieldAccessChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionCheckerKt;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrFunctionReferenceFunctionDispatchReceiverChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrFunctionReferenceFunctionPropertiesChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrGetFieldTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrGetObjectValueTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrGetValueTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrNoInlineUseSitesChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrNothingTypeExpressionChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrSetValueAssignabilityChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrStringConcatenationTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrTypeOperatorTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrTypeOperatorTypeOperandChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrUnitTypeExpressionChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrValueAccessScopeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrVarargTypesChecker;
import org.jetbrains.kotlin.backend.common.checkers.type.IrSimpleTypeVisibilityChecker;
import org.jetbrains.kotlin.backend.common.checkers.type.IrTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.type.IrTypeCheckerKt;
import org.jetbrains.kotlin.backend.common.checkers.type.IrTypeParameterScopeChecker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrTypeVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020\nH\u0016J\u0010\u0010k\u001a\u00020i2\u0006\u0010l\u001a\u00020,H\u0016J\u0010\u0010m\u001a\u00020i2\u0006\u0010l\u001a\u00020/H\u0016J\u0010\u0010n\u001a\u00020i2\u0006\u0010l\u001a\u000202H\u0016J\u0010\u0010o\u001a\u00020i2\u0006\u0010l\u001a\u000205H\u0016J\u0010\u0010p\u001a\u00020i2\u0006\u0010l\u001a\u000208H\u0016J\u0010\u0010q\u001a\u00020i2\u0006\u0010l\u001a\u00020;H\u0016J\u0010\u0010r\u001a\u00020i2\u0006\u0010l\u001a\u00020>H\u0016J\u0010\u0010s\u001a\u00020i2\u0006\u0010l\u001a\u00020fH\u0016J\u0010\u0010t\u001a\u00020i2\u0006\u0010l\u001a\u00020AH\u0016J\u0010\u0010u\u001a\u00020i2\u0006\u0010l\u001a\u00020DH\u0016J\u0010\u0010v\u001a\u00020i2\u0006\u0010l\u001a\u00020`H\u0016J\u0010\u0010w\u001a\u00020i2\u0006\u0010x\u001a\u00020GH\u0016J\u0010\u0010y\u001a\u00020i2\u0006\u0010z\u001a\u00020JH\u0016J\u0010\u0010{\u001a\u00020i2\u0006\u0010l\u001a\u00020MH\u0016J\u0010\u0010|\u001a\u00020i2\u0006\u0010l\u001a\u00020PH\u0016J\u0010\u0010}\u001a\u00020i2\u0006\u0010~\u001a\u00020SH\u0016J\u0010\u0010\u007f\u001a\u00020i2\u0006\u0010l\u001a\u00020#H\u0016J\u0011\u0010\u0080\u0001\u001a\u00020i2\u0006\u0010~\u001a\u00020\u0011H\u0016J\u0011\u0010\u0081\u0001\u001a\u00020i2\u0006\u0010l\u001a\u00020\u0015H\u0016J\u001c\u0010\u0082\u0001\u001a\u00020i2\u0007\u0010\u0083\u0001\u001a\u00020\n2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0016J\u0011\u0010\u0086\u0001\u001a\u00020i2\u0006\u0010l\u001a\u00020\u001aH\u0016J\u0012\u0010\u0087\u0001\u001a\u00020i2\u0007\u0010~\u001a\u00030\u0088\u0001H\u0016J\u0011\u0010\u0089\u0001\u001a\u00020i2\u0006\u0010l\u001a\u00020XH\u0016J\u0011\u0010\u008a\u0001\u001a\u00020i2\u0006\u0010l\u001a\u00020[H\u0016J\u0011\u0010\u008b\u0001\u001a\u00020i2\u0006\u0010l\u001a\u00020^H\u0016J\u0011\u0010\u008c\u0001\u001a\u00020i2\u0006\u0010l\u001a\u00020\u001dH\u0016J\u0011\u0010\u008d\u0001\u001a\u00020i2\u0006\u0010~\u001a\u00020 H\u0016J\u0011\u0010\u008e\u0001\u001a\u00020i2\u0006\u0010l\u001a\u00020)H\u0016J\u0011\u0010\u008f\u0001\u001a\u00020i2\u0006\u0010l\u001a\u00020&H\u0016J\u0011\u0010\u0090\u0001\u001a\u00020i2\u0006\u0010~\u001a\u00020cH\u0016J\u0011\u0010\u0091\u0001\u001a\u00020i2\u0006\u0010j\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u00160\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001a0\u0014j\u0002`\u001b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001d0\u0014j\u0002`\u001e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020 0\u0010j\u0002`!0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020#0\u0014j\u0002`$0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&0\u0014j\u0002`'0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020)0\u0014j\u0002`*0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020,0\u0014j\u0002`-0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010.\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020/0\u0014j\u0002`00\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00101\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002020\u0014j\u0002`30\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002050\u0014j\u0002`60\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00107\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002080\u0014j\u0002`90\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010:\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020;0\u0014j\u0002`<0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010=\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020>0\u0014j\u0002`?0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010@\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020A0\u0014j\u0002`B0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010C\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020D0\u0014j\u0002`E0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010F\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020G0\u0014j\u0002`H0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010I\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020J0\u0014j\u0002`K0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010L\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020M0\u0014j\u0002`N0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010O\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020P0\u0014j\u0002`Q0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010R\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020S0\u0010j\u0002`T0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010U\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020V0\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010W\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020X0\u0014j\u0002`Y0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010Z\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020[0\u0014j\u0002`\\0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010]\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020^0\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010_\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020`0\u0014j\u0002`a0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020c0\u0010j\u0002`d0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020f0\u0014j\u0002`g0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0092\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrFileValidator;", "Lorg/jetbrains/kotlin/ir/visitors/IrTypeVisitorVoid;", "config", "Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;)V", "visitedElements", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lkotlin/collections/HashSet;", "contextUpdaters", "", "Lorg/jetbrains/kotlin/backend/common/checkers/context/ContextUpdater;", "fieldCheckers", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrDeclarationChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrFieldChecker;", "fieldAccessExpressionCheckers", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrExpressionChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrFieldAccessChecker;", "typeCheckers", "Lorg/jetbrains/kotlin/backend/common/checkers/type/IrTypeChecker;", "declarationReferenceCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrDeclarationReferenceChecker;", "varargCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrVarargChecker;", "valueParameterCheckers", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrValueParameterChecker;", "valueAccessCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrValueAccessChecker;", "functionAccessCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrFunctionAccessChecker;", "functionReferenceCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrFunctionReferenceChecker;", "constCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrConstChecker;", "stringConcatenationCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrStringConcatenationChecker;", "getObjectValueCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrGetObjectValueChecker;", "getValueCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrGetValueChecker;", "setValueCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrSetValueChecker;", "getFieldCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrGetFieldChecker;", "setFieldCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrSetFieldChecker;", "delegatingConstructorCallCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrDelegatingConstructorCallChecker;", "instanceInitializerCallCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrInstanceInitializerCallChecker;", "loopCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrLoopChecker;", "breakContinueCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrBreakContinue;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrBreakContinueChecker;", "returnCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrReturnChecker;", "throwCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrThrowChecker;", "functionCheckers", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrFunctionChecker;", "declarationBaseCheckers", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "propertyReferenceCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrPropertyReferenceChecker;", "localDelegatedPropertyReferenceCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrLocalDelegatedPropertyReferenceChecker;", "expressionCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "typeOperatorCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrTypeOperatorChecker;", "propertyCheckers", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrPropertyChecker;", "callCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrCallChecker;", "visitElement", "", "element", "visitConst", "expression", "visitStringConcatenation", "visitGetObjectValue", "visitGetValue", "visitSetValue", "visitGetField", "visitSetField", "visitCall", "visitDelegatingConstructorCall", "visitInstanceInitializerCall", "visitTypeOperator", "visitLoop", "loop", "visitBreakContinue", "jump", "visitReturn", "visitThrow", "visitFunction", "declaration", "visitValueAccess", "visitField", "visitFieldAccess", "visitType", "container", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "visitDeclarationReference", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitPropertyReference", "visitLocalDelegatedPropertyReference", "visitExpression", "visitVararg", "visitValueParameter", "visitFunctionReference", "visitFunctionAccess", "visitProperty", "checkTreeConsistency", "ir.backend.common"})
final class IrFileValidator
extends IrTypeVisitorVoid {
    @NotNull
    private final IrValidatorConfig config;
    @NotNull
    private final CheckerContext context;
    @NotNull
    private final HashSet<IrElement> visitedElements;
    @NotNull
    private final List<ContextUpdater> contextUpdaters;
    @NotNull
    private final List<IrDeclarationChecker<IrField>> fieldCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrFieldAccessExpression>> fieldAccessExpressionCheckers;
    @NotNull
    private final List<IrTypeChecker> typeCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrDeclarationReference>> declarationReferenceCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrVararg>> varargCheckers;
    @NotNull
    private final List<IrDeclarationChecker<IrValueParameter>> valueParameterCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrValueAccessExpression>> valueAccessCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrFunctionAccessExpression>> functionAccessCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrFunctionReference>> functionReferenceCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrConst>> constCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrStringConcatenation>> stringConcatenationCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrGetObjectValue>> getObjectValueCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrGetValue>> getValueCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrSetValue>> setValueCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrGetField>> getFieldCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrSetField>> setFieldCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrDelegatingConstructorCall>> delegatingConstructorCallCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrInstanceInitializerCall>> instanceInitializerCallCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrLoop>> loopCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrBreakContinue>> breakContinueCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrReturn>> returnCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrThrow>> throwCheckers;
    @NotNull
    private final List<IrDeclarationChecker<IrFunction>> functionCheckers;
    @NotNull
    private final List<IrDeclarationChecker<IrDeclaration>> declarationBaseCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrPropertyReference>> propertyReferenceCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrLocalDelegatedPropertyReference>> localDelegatedPropertyReferenceCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrExpression>> expressionCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrTypeOperatorCall>> typeOperatorCheckers;
    @NotNull
    private final List<IrDeclarationChecker<IrProperty>> propertyCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrCall>> callCheckers;

    public IrFileValidator(@NotNull IrValidatorConfig config, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.config = config;
        this.context = context2;
        this.visitedElements = new HashSet();
        Object[] objectArray = new ContextUpdater[]{ParentChainUpdater.INSTANCE};
        this.contextUpdaters = CollectionsKt.mutableListOf((Object[])objectArray);
        this.fieldCheckers = new ArrayList();
        this.fieldAccessExpressionCheckers = new ArrayList();
        this.typeCheckers = new ArrayList();
        this.declarationReferenceCheckers = new ArrayList();
        this.varargCheckers = new ArrayList();
        this.valueParameterCheckers = new ArrayList();
        this.valueAccessCheckers = new ArrayList();
        objectArray = new IrExpressionChecker[]{IrNoInlineUseSitesChecker.INSTANCE};
        this.functionAccessCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new IrExpressionChecker[]{IrFunctionReferenceFunctionDispatchReceiverChecker.INSTANCE, IrNoInlineUseSitesChecker.INSTANCE};
        this.functionReferenceCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        this.constCheckers = new ArrayList();
        this.stringConcatenationCheckers = new ArrayList();
        this.getObjectValueCheckers = new ArrayList();
        this.getValueCheckers = new ArrayList();
        objectArray = new IrExpressionChecker[]{IrSetValueAssignabilityChecker.INSTANCE};
        this.setValueCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        this.getFieldCheckers = new ArrayList();
        this.setFieldCheckers = new ArrayList();
        this.delegatingConstructorCallCheckers = new ArrayList();
        this.instanceInitializerCallCheckers = new ArrayList();
        this.loopCheckers = new ArrayList();
        this.breakContinueCheckers = new ArrayList();
        this.returnCheckers = new ArrayList();
        this.throwCheckers = new ArrayList();
        objectArray = new IrDeclarationChecker[]{IrFunctionDispatchReceiverChecker.INSTANCE, IrFunctionParametersChecker.INSTANCE, IrConstructorReceiverChecker.INSTANCE};
        this.functionCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new IrDeclarationChecker[]{IrPrivateDeclarationOverrideChecker.INSTANCE};
        this.declarationBaseCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        this.propertyReferenceCheckers = new ArrayList();
        this.localDelegatedPropertyReferenceCheckers = new ArrayList();
        objectArray = new IrExpressionChecker[]{IrExpressionTypeChecker.INSTANCE};
        this.expressionCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new IrExpressionChecker[]{IrTypeOperatorTypeOperandChecker.INSTANCE};
        this.typeOperatorCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        this.propertyCheckers = new ArrayList();
        objectArray = new IrExpressionChecker[]{IrCallFunctionDispatchReceiverChecker.INSTANCE};
        this.callCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.config.getCheckValueScopes()) {
            this.contextUpdaters.add(ValueScopeUpdater.INSTANCE);
            this.valueAccessCheckers.add(IrValueAccessScopeChecker.INSTANCE);
        }
        if (this.config.getCheckTypeParameterScopes()) {
            this.contextUpdaters.add(TypeParameterScopeUpdater.INSTANCE);
            this.typeCheckers.add(IrTypeParameterScopeChecker.INSTANCE);
        }
        if (this.config.getCheckAllKotlinFieldsArePrivate()) {
            this.fieldCheckers.add(IrFieldVisibilityChecker.INSTANCE);
        }
        if (this.config.getCheckCrossFileFieldUsage()) {
            this.fieldAccessExpressionCheckers.add(IrCrossFileFieldUsageChecker.INSTANCE);
        }
        if (this.config.getCheckVisibilities()) {
            this.typeCheckers.add(IrSimpleTypeVisibilityChecker.INSTANCE);
            this.declarationReferenceCheckers.add(IrDeclarationReferenceVisibilityChecker.INSTANCE);
        }
        if (this.config.getCheckVarargTypes()) {
            this.varargCheckers.add(IrVarargTypesChecker.INSTANCE);
            this.valueParameterCheckers.add(IrValueParameterVarargTypesChecker.INSTANCE);
        }
        if (this.config.getCheckTypes()) {
            this.constCheckers.add(IrConstTypeChecker.INSTANCE);
            this.stringConcatenationCheckers.add(IrStringConcatenationTypeChecker.INSTANCE);
            this.getObjectValueCheckers.add(IrGetObjectValueTypeChecker.INSTANCE);
            this.getValueCheckers.add(IrGetValueTypeChecker.INSTANCE);
            this.setValueCheckers.add(IrUnitTypeExpressionChecker.INSTANCE);
            this.getFieldCheckers.add(IrGetFieldTypeChecker.INSTANCE);
            this.setFieldCheckers.add(IrUnitTypeExpressionChecker.INSTANCE);
            this.callCheckers.add(IrCallTypeChecker.INSTANCE);
            this.delegatingConstructorCallCheckers.add(IrUnitTypeExpressionChecker.INSTANCE);
            this.instanceInitializerCallCheckers.add(IrUnitTypeExpressionChecker.INSTANCE);
            this.typeOperatorCheckers.add(IrTypeOperatorTypeChecker.INSTANCE);
            this.loopCheckers.add(IrUnitTypeExpressionChecker.INSTANCE);
            this.breakContinueCheckers.add(IrNothingTypeExpressionChecker.INSTANCE);
            this.returnCheckers.add(IrNothingTypeExpressionChecker.INSTANCE);
            this.throwCheckers.add(IrNothingTypeExpressionChecker.INSTANCE);
            this.fieldAccessExpressionCheckers.add(IrDynamicTypeFieldAccessChecker.INSTANCE);
        }
        if (this.config.getCheckProperties()) {
            this.callCheckers.add(IrCallFunctionPropertiesChecker.INSTANCE);
            this.functionCheckers.add(IrFunctionPropertiesChecker.INSTANCE);
            this.functionReferenceCheckers.add(IrFunctionReferenceFunctionPropertiesChecker.INSTANCE);
            this.propertyCheckers.add(IrPropertyAccessorsChecker.INSTANCE);
        }
        if (this.config.getCheckFunctionBody()) {
            this.functionCheckers.add(IrFunctionBodyChecker.INSTANCE);
        }
    }

    @Override
    public void visitElement(@NotNull IrElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.checkTreeConsistency(element2);
        Function0 block = () -> IrFileValidator.visitElement$lambda$0(element2, this);
        for (ContextUpdater contextUpdater : this.contextUpdaters) {
            Function0 currentBlock = block;
            block = () -> IrFileValidator.visitElement$lambda$1(contextUpdater, this, element2, currentBlock);
        }
        block.invoke();
    }

    @Override
    public void visitConst(@NotNull IrConst expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitConst(expression2);
        IrExpressionCheckerKt.check(this.constCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitStringConcatenation(expression2);
        IrExpressionCheckerKt.check(this.stringConcatenationCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitGetObjectValue(expression2);
        IrExpressionCheckerKt.check(this.getObjectValueCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitGetValue(expression2);
        IrExpressionCheckerKt.check(this.getValueCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitSetValue(expression2);
        IrExpressionCheckerKt.check(this.setValueCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitGetField(expression2);
        IrExpressionCheckerKt.check(this.getFieldCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitSetField(expression2);
        IrExpressionCheckerKt.check(this.setFieldCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitCall(expression2);
        IrExpressionCheckerKt.check(this.callCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitDelegatingConstructorCall(expression2);
        IrExpressionCheckerKt.check(this.delegatingConstructorCallCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitInstanceInitializerCall(expression2);
        IrExpressionCheckerKt.check(this.instanceInitializerCallCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitTypeOperator(expression2);
        IrExpressionCheckerKt.check(this.typeOperatorCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        super.visitLoop(loop);
        IrExpressionCheckerKt.check(this.loopCheckers, (IrExpression)loop, this.context);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        super.visitBreakContinue(jump);
        IrExpressionCheckerKt.check(this.breakContinueCheckers, (IrExpression)jump, this.context);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitReturn(expression2);
        IrExpressionCheckerKt.check(this.returnCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitThrow(expression2);
        IrExpressionCheckerKt.check(this.throwCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        super.visitFunction(declaration2);
        IrDeclarationCheckerKt.check(this.functionCheckers, (IrDeclaration)declaration2, this.context);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitValueAccess(expression2);
        IrExpressionCheckerKt.check(this.valueAccessCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitField(@NotNull IrField declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        super.visitField(declaration2);
        IrDeclarationCheckerKt.check(this.fieldCheckers, (IrDeclaration)declaration2, this.context);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitFieldAccess(expression2);
        IrExpressionCheckerKt.check(this.fieldAccessExpressionCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitType(@NotNull IrElement container, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        IrTypeCheckerKt.check(this.typeCheckers, type2, container, this.context);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitDeclarationReference(expression2);
        IrExpressionCheckerKt.check(this.declarationReferenceCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        super.visitDeclaration(declaration2);
        IrDeclarationCheckerKt.check(this.declarationBaseCheckers, (IrDeclaration)declaration2, this.context);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitPropertyReference(expression2);
        IrExpressionCheckerKt.check(this.propertyReferenceCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitLocalDelegatedPropertyReference(expression2);
        IrExpressionCheckerKt.check(this.localDelegatedPropertyReferenceCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitExpression(expression2);
        IrExpressionCheckerKt.check(this.expressionCheckers, expression2, this.context);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitVararg(expression2);
        IrExpressionCheckerKt.check(this.varargCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        super.visitValueParameter(declaration2);
        IrDeclarationCheckerKt.check(this.valueParameterCheckers, (IrDeclaration)declaration2, this.context);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitFunctionReference(expression2);
        IrExpressionCheckerKt.check(this.functionReferenceCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitFunctionAccess(expression2);
        IrExpressionCheckerKt.check(this.functionAccessCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        super.visitProperty(declaration2);
        IrDeclarationCheckerKt.check(this.propertyCheckers, (IrDeclaration)declaration2, this.context);
    }

    private final void checkTreeConsistency(IrElement element2) {
        if (this.config.getCheckTreeConsistency() && !this.visitedElements.add(element2)) {
            String renderString = element2 instanceof IrTypeParameter ? RenderIrElementKt.render$default(element2, null, 1, null) + " of " + RenderIrElementKt.render$default(((IrTypeParameter)element2).getParent(), null, 1, null) : RenderIrElementKt.render$default(element2, null, 1, null);
            this.context.error(element2, "Duplicate IR node: " + renderString);
            throw new DuplicateIrNodeError(element2);
        }
    }

    private static final Unit visitElement$lambda$0(IrElement $element, IrFileValidator this$0) {
        IrVisitorsKt.acceptChildrenVoid($element, this$0);
        return Unit.INSTANCE;
    }

    private static final Unit visitElement$lambda$1(ContextUpdater $contextUpdater, IrFileValidator this$0, IrElement $element, Function0 $currentBlock) {
        $contextUpdater.runInNewContext(this$0.context, $element, (Function0<Unit>)$currentBlock);
        return Unit.INSTANCE;
    }
}

