/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.ContextRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class BoundedTaskExecutor
extends AbstractExecutorService {
    private volatile boolean myShutdown;
    @NotNull
    private final String myName;
    private final Executor myBackendExecutor;
    private final int myMaxThreads;
    private final AtomicLong myStatus;
    private final BlockingQueue<Runnable> myTaskQueue;
    private final boolean myChangeThreadName;

    BoundedTaskExecutor(@NotNull @NonNls String name2, @NotNull Executor backendExecutor, int maxThreads, boolean changeThreadName) {
        if (name2 == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(0);
        }
        if (backendExecutor == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(1);
        }
        this(name2, backendExecutor, maxThreads, changeThreadName, new LinkedBlockingQueue<Runnable>());
    }

    BoundedTaskExecutor(@NotNull @NonNls String name2, @NotNull Executor backendExecutor, int maxThreads, boolean changeThreadName, @NotNull BlockingQueue<Runnable> queue) {
        if (name2 == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(2);
        }
        if (backendExecutor == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(3);
        }
        if (queue == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(4);
        }
        this.myStatus = new AtomicLong();
        if (name2.isEmpty() || !Character.isUpperCase(name2.charAt(0))) {
            Logger.getInstance(this.getClass()).warn("Pool name must be capitalized but got: '" + name2 + "'", new IllegalArgumentException());
        }
        this.myName = name2;
        this.myBackendExecutor = backendExecutor;
        if (maxThreads < 1) {
            throw new IllegalArgumentException("maxThreads must be >=1 but got: " + maxThreads);
        }
        if (backendExecutor instanceof BoundedTaskExecutor) {
            throw new IllegalArgumentException("backendExecutor is already BoundedTaskExecutor: " + backendExecutor);
        }
        this.myMaxThreads = maxThreads;
        this.myChangeThreadName = changeThreadName;
        this.myTaskQueue = queue;
    }

    private static int getTasksInProgress(long status2) {
        return (int)status2;
    }

    static Object info(Runnable info) {
        Object t1;
        Object task = info;
        String extra = null;
        if (task instanceof FutureTask) {
            extra = ((FutureTask)task).isCancelled() ? " (future cancelled)" : (((FutureTask)task).isDone() ? " (future done)" : null);
            t1 = ReflectionUtil.getField(task.getClass(), task, Callable.class, "callable");
            if (t1 != null) {
                task = t1;
            }
        }
        if (task instanceof Callable && task.getClass().getName().equals("java.util.concurrent.Executors$RunnableAdapter") && (t1 = ReflectionUtil.getField(task.getClass(), task, Runnable.class, "task")) != null) {
            task = t1;
        }
        return extra == null ? task : task.getClass() + extra;
    }

    @Override
    public void shutdown() {
        this.myShutdown = true;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        List<Runnable> list = this.clearAndCancelAll();
        if (list == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return this.myShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.myShutdown && this.isEmpty() && this.myTaskQueue.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (timeUnit == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(6);
        }
        if (!this.isShutdown()) {
            throw new IllegalStateException("must await termination after shutdown() or shutdownNow() only");
        }
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        while (!this.isTerminated()) {
            try {
                this.waitAllTasksExecuted(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
            }
            catch (ExecutionException e2) {
                throw new RuntimeException(e2.getCause());
            }
            catch (TimeoutException e3) {
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    protected <T> RunnableFuture<T> newTaskFor(@NotNull Runnable runnable, T value2) {
        if (runnable == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(7);
        }
        RunnableFuture<T> runnableFuture = this.newTaskFor(Executors.callable(runnable, value2));
        if (runnableFuture == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(8);
        }
        return runnableFuture;
    }

    @Override
    @NotNull
    protected <T> RunnableFuture<T> newTaskFor(@NotNull Callable<T> callable) {
        if (callable == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(9);
        }
        FutureTask<T> futureTask = AppScheduledExecutorService.capturePropagationAndCancellationContext(callable);
        if (futureTask == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(10);
        }
        return futureTask;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Runnable task;
        if (command == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(11);
        }
        Runnable runnable = task = command instanceof LastTask ? command : AppScheduledExecutorService.capturePropagationAndCancellationContext(command);
        if (this.isShutdown() && !(task instanceof LastTask)) {
            throw new RejectedExecutionException(this + " is already shutdown, trying to execute " + task + " (" + task.getClass() + ")");
        }
        long status2 = this.incrementCounterAndTimestamp();
        int inProgress = BoundedTaskExecutor.getTasksInProgress(status2);
        assert (inProgress > 0) : inProgress;
        if (inProgress <= this.myMaxThreads) {
            this.wrapAndExecute(task, status2);
            return;
        }
        if (!this.myTaskQueue.offer(task)) {
            throw new RejectedExecutionException();
        }
        Runnable next = this.pollOrGiveUp(status2);
        if (next != null) {
            this.wrapAndExecute(next, status2);
        }
    }

    private long incrementCounterAndTimestamp() {
        return this.myStatus.updateAndGet(status2 -> status2 + 1L + 0x100000000L & Long.MAX_VALUE);
    }

    private Runnable pollOrGiveUp(long status2) {
        while (true) {
            Runnable next;
            int inProgress = BoundedTaskExecutor.getTasksInProgress(status2);
            assert (inProgress > 0) : inProgress;
            if (inProgress <= this.myMaxThreads && (next = (Runnable)this.myTaskQueue.poll()) != null) {
                return next;
            }
            if (this.myStatus.compareAndSet(status2, status2 - 1L)) break;
            status2 = this.myStatus.get();
        }
        return null;
    }

    private void wrapAndExecute(final @NotNull Runnable firstTask, final long status2) {
        if (firstTask == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(12);
        }
        try {
            ContextAwareRunnable command = new ContextAwareRunnable(){
                final AtomicReference<Runnable> currentTask;
                {
                    this.currentTask = new AtomicReference<Runnable>(firstTask);
                }

                @Override
                public void run() {
                    try (AccessToken ignored = ThreadContext.resetThreadContext();){
                        if (BoundedTaskExecutor.this.myChangeThreadName) {
                            ConcurrencyUtil.runUnderThreadName(BoundedTaskExecutor.this.myName, this::executeFirstTaskAndHelpQueue);
                        } else {
                            this.executeFirstTaskAndHelpQueue();
                        }
                    }
                }

                private void executeFirstTaskAndHelpQueue() {
                    Runnable task = this.currentTask.get();
                    do {
                        this.currentTask.set(task);
                        BoundedTaskExecutor.doRun(task);
                    } while ((task = BoundedTaskExecutor.this.pollOrGiveUp(status2)) != null);
                }

                public String toString() {
                    return String.valueOf(BoundedTaskExecutor.info(this.currentTask.get()));
                }
            };
            this.myBackendExecutor.execute(command);
        }
        catch (Error | RuntimeException e2) {
            this.myStatus.decrementAndGet();
            throw e2;
        }
    }

    private static void doRun(@Async.Execute @NotNull Runnable task) {
        block5: {
            if (task == null) {
                BoundedTaskExecutor.$$$reportNull$$$0(13);
            }
            try {
                task.run();
            }
            catch (Throwable e2) {
                if (e2 instanceof ControlFlowException) break block5;
                try {
                    Logger.getInstance(BoundedTaskExecutor.class).error(e2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public synchronized void waitAllTasksExecuted(final long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void unit;
        if (timeUnit == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(14);
        }
        final CountDownLatch started = new CountDownLatch(this.myMaxThreads);
        final CountDownLatch readyToFinish = new CountDownLatch(1);
        Runnable runnable = new Runnable(){
            final /* synthetic */ TimeUnit val$unit;
            {
                this.val$unit = timeUnit;
            }

            @Override
            public void run() {
                try {
                    started.countDown();
                    readyToFinish.await();
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }

            public String toString() {
                return "LastTask to waitAllTasksExecuted for " + timeout + " " + (Object)((Object)this.val$unit) + " (" + System.identityHashCode(this) + ")";
            }
        };
        List<Future> futures = ContainerUtil.map(Collections.nCopies(this.myMaxThreads, null), __ -> {
            LastTask wait = new LastTask(runnable);
            this.execute(wait);
            return wait;
        });
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        try {
            if (!started.await(timeout, (TimeUnit)unit)) {
                throw new TimeoutException("Interrupted by timeout. " + this);
            }
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
        finally {
            readyToFinish.countDown();
        }
        ConcurrencyUtil.getAll(Math.max(0L, deadline - System.nanoTime()), TimeUnit.NANOSECONDS, futures);
    }

    public boolean isEmpty() {
        return BoundedTaskExecutor.getTasksInProgress(this.myStatus.get()) == 0;
    }

    @NotNull
    public List<Runnable> clearAndCancelAll() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>(this.myTaskQueue.size());
        this.myTaskQueue.drainTo(queued);
        for (Runnable fromQueue : queued) {
            Runnable task = fromQueue instanceof ContextRunnable ? ((ContextRunnable)fromQueue).getDelegate() : fromQueue;
            if (!(task instanceof FutureTask) || task instanceof LastTask) continue;
            ((FutureTask)task).cancel(false);
        }
        ArrayList<Runnable> arrayList = queued;
        if (arrayList == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public String toString() {
        int size = this.myTaskQueue.size();
        return "BoundedExecutor(" + this.myMaxThreads + ")" + (this.isShutdown() ? " SHUTDOWN " : "") + "; inProgress: " + BoundedTaskExecutor.getTasksInProgress(this.myStatus.get()) + (size == 0 ? "" : "; queue: " + size) + "; name: " + this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/BoundedTaskExecutor";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTask";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/BoundedTaskExecutor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newTaskFor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAndCancelAll";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newTaskFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndExecute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "waitAllTasksExecuted";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class LastTask
    extends FutureTask<Void> {
        LastTask(@NotNull Runnable runnable) {
            if (runnable == null) {
                LastTask.$$$reportNull$$$0(0);
            }
            super(runnable, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/concurrency/BoundedTaskExecutor$LastTask", "<init>"));
        }
    }
}

