/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulkVirtualFileListenerAdapter
implements BulkFileListener {
    private final VirtualFileListener myAdapted;
    private final VirtualFileSystem myFileSystem;

    public BulkVirtualFileListenerAdapter(@NotNull VirtualFileListener adapted) {
        if (adapted == null) {
            BulkVirtualFileListenerAdapter.$$$reportNull$$$0(0);
        }
        this(adapted, null);
    }

    public BulkVirtualFileListenerAdapter(@NotNull VirtualFileListener adapted, @Nullable VirtualFileSystem fileSystem) {
        if (adapted == null) {
            BulkVirtualFileListenerAdapter.$$$reportNull$$$0(1);
        }
        this.myAdapted = adapted;
        this.myFileSystem = fileSystem;
    }

    @Override
    public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            BulkVirtualFileListenerAdapter.$$$reportNull$$$0(2);
        }
        for (VFileEvent vFileEvent : events) {
            if (this.myFileSystem != null && this.myFileSystem != vFileEvent.getFileSystem()) continue;
            BulkVirtualFileListenerAdapter.fireBefore(this.myAdapted, vFileEvent);
        }
    }

    @Override
    public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            BulkVirtualFileListenerAdapter.$$$reportNull$$$0(3);
        }
        for (VFileEvent vFileEvent : events) {
            if (this.myFileSystem != null && this.myFileSystem != vFileEvent.getFileSystem()) continue;
            BulkVirtualFileListenerAdapter.fireAfter(this.myAdapted, vFileEvent);
        }
    }

    public static void fireAfter(@NotNull VirtualFileListener adapted, @NotNull VFileEvent event) {
        if (adapted == null) {
            BulkVirtualFileListenerAdapter.$$$reportNull$$$0(4);
        }
        if (event == null) {
            BulkVirtualFileListenerAdapter.$$$reportNull$$$0(5);
        }
        if (event instanceof VFileContentChangeEvent) {
            VFileContentChangeEvent ce = (VFileContentChangeEvent)event;
            VirtualFile file2 = ce.getFile();
            adapted.contentsChanged(new VirtualFileEvent(event.getRequestor(), file2, file2.getParent(), ce.getOldModificationStamp(), ce.getModificationStamp()));
        } else if (event instanceof VFileCopyEvent) {
            VFileCopyEvent ce = (VFileCopyEvent)event;
            VirtualFile original = ce.getFile();
            VirtualFile copy = ce.getNewParent().findChild(ce.getNewChildName());
            if (copy != null) {
                adapted.fileCopied(new VirtualFileCopyEvent(event.getRequestor(), original, copy));
            }
        } else if (event instanceof VFileCreateEvent) {
            VFileCreateEvent ce = (VFileCreateEvent)event;
            VirtualFile newChild = ce.getFile();
            if (newChild != null) {
                adapted.fileCreated(new VirtualFileEvent(event.getRequestor(), newChild, ce.getParent(), 0L, 0L));
            }
        } else if (event instanceof VFileDeleteEvent) {
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            adapted.fileDeleted(new VirtualFileEvent(event.getRequestor(), de.getFile(), de.getFile().getParent(), 0L, 0L));
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent me = (VFileMoveEvent)event;
            adapted.fileMoved(new VirtualFileMoveEvent(event.getRequestor(), me.getFile(), me.getOldParent(), me.getNewParent()));
        } else if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            adapted.propertyChanged(new VirtualFilePropertyEvent(event.getRequestor(), pce.getFile(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue()));
        }
    }

    public static void fireBefore(@NotNull VirtualFileListener adapted, @NotNull VFileEvent event) {
        if (adapted == null) {
            BulkVirtualFileListenerAdapter.$$$reportNull$$$0(6);
        }
        if (event == null) {
            BulkVirtualFileListenerAdapter.$$$reportNull$$$0(7);
        }
        if (event instanceof VFileContentChangeEvent) {
            VFileContentChangeEvent ce = (VFileContentChangeEvent)event;
            VirtualFile file2 = ce.getFile();
            adapted.beforeContentsChange(new VirtualFileEvent(event.getRequestor(), file2, file2.getParent(), ce.getOldModificationStamp(), ce.getModificationStamp()));
        } else if (event instanceof VFileDeleteEvent) {
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            adapted.beforeFileDeletion(new VirtualFileEvent(event.getRequestor(), de.getFile(), de.getFile().getParent(), 0L, 0L));
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent me = (VFileMoveEvent)event;
            adapted.beforeFileMovement(new VirtualFileMoveEvent(event.getRequestor(), me.getFile(), me.getOldParent(), me.getNewParent()));
        } else if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            adapted.beforePropertyChange(new VirtualFilePropertyEvent(event.getRequestor(), pce.getFile(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapted";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/impl/BulkVirtualFileListenerAdapter";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fireAfter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fireBefore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

