/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.model.Symbol;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.CachedValueBase;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class IdempotenceChecker {
    private static final Logger LOG = Logger.getInstance(IdempotenceChecker.class);
    private static final Set<Class<?>> ourReportedValueClasses = Collections.synchronizedSet(new HashSet());
    private static final ThreadLocal<Integer> ourRandomCheckNesting = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<List<String>> ourLog = new ThreadLocal();
    private static final Supplier<RegistryValue> rateCheckProperty = new SynchronizedClearableLazy<RegistryValue>(() -> Registry.get("platform.random.idempotence.check.rate"));
    private static final Map<Class, Set<Class>> allSupersWithEquals = ConcurrentFactoryMap.createMap(clazz -> JBIterable.generate(clazz, Class::getSuperclass).filter(c2 -> c2 != Object.class && ReflectionUtil.getDeclaredMethod(c2, "equals", Object.class) != null).toSet());

    public static <T> void checkEquivalence(@Nullable T existing, @Nullable T fresh, @NotNull Class<?> providerClass, @Nullable Computable<? extends T> recomputeValue) {
        String msg;
        if (providerClass == null) {
            IdempotenceChecker.$$$reportNull$$$0(0);
        }
        if ((msg = IdempotenceChecker.checkValueEquivalence(existing, fresh)) != null) {
            IdempotenceChecker.reportFailure(existing, fresh, providerClass, recomputeValue, msg);
        }
    }

    private static <T> void reportFailure(@Nullable T existing, @Nullable T fresh, @NotNull Class<?> providerClass, @Nullable Computable<? extends T> recomputeValue, String msg) {
        boolean shouldReport;
        if (providerClass == null) {
            IdempotenceChecker.$$$reportNull$$$0(1);
        }
        boolean bl2 = shouldReport = (ApplicationManager.getApplication().isUnitTestMode() || ourReportedValueClasses.add(providerClass)) && !"true".equals(System.getProperty("idea.disable.idempotence.checker", "false"));
        if (shouldReport) {
            if (recomputeValue != null) {
                msg = msg + IdempotenceChecker.recomputeWithLogging(existing, fresh, recomputeValue);
            }
            LOG.error(PluginException.createByClass(msg, null, providerClass));
        }
    }

    @NotNull
    private static <T> String recomputeWithLogging(@Nullable T existing, @Nullable T fresh, @NotNull Computable<? extends T> recomputeValue) {
        if (recomputeValue == null) {
            IdempotenceChecker.$$$reportNull$$$0(2);
        }
        ResultWithLog<T> rwl = IdempotenceChecker.computeWithLogging(recomputeValue);
        Object freshest = ((ResultWithLog)rwl).result;
        @NonNls String msg = "\n\nRecomputation gives " + IdempotenceChecker.objAndClass(freshest);
        msg = IdempotenceChecker.checkValueEquivalence(existing, freshest) == null ? msg + " which is equivalent to 'existing'" : (IdempotenceChecker.checkValueEquivalence(fresh, freshest) == null ? msg + " which is equivalent to 'fresh'" : msg + " which is different from both values");
        if (!((ResultWithLog)rwl).log.isEmpty() && !(freshest instanceof ResultWithLog)) {
            msg = msg + "\nRecomputation log:\n" + rwl.printLog();
        }
        String string2 = msg;
        if (string2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(3);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> ResultWithLog<T> computeWithLogging(@NotNull Computable<? extends T> recomputeValue) {
        List<String> threadLog;
        boolean outermost;
        if (recomputeValue == null) {
            IdempotenceChecker.$$$reportNull$$$0(4);
        }
        boolean bl2 = outermost = (threadLog = ourLog.get()) == null;
        if (outermost) {
            threadLog = new ArrayList<String>();
            ourLog.set(threadLog);
        }
        int start = threadLog.size();
        T result2 = recomputeValue.compute();
        ResultWithLog resultWithLog = new ResultWithLog(result2, new ArrayList<String>(threadLog.subList(start, threadLog.size())));
        ResultWithLog resultWithLog2 = resultWithLog;
        if (resultWithLog2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(5);
        }
        return resultWithLog2;
        finally {
            if (outermost) {
                ourLog.set(null);
            }
        }
    }

    @NonNls
    private static String objAndClass(Object o2) {
        if (o2 == null) {
            return "null";
        }
        String s2 = o2.toString();
        return s2.contains(o2.getClass().getSimpleName()) || o2 instanceof String || o2 instanceof Number || o2 instanceof Class ? s2 : s2 + " (class " + o2.getClass().getName() + ")";
    }

    private static String checkValueEquivalence(@Nullable Object existing, @Nullable Object fresh) {
        if (existing == fresh) {
            return null;
        }
        String eqMsg = IdempotenceChecker.checkClassEquivalence(existing, fresh);
        if (eqMsg != null) {
            return eqMsg;
        }
        Object[] eArray = IdempotenceChecker.asArray(existing);
        if (eArray != null) {
            return IdempotenceChecker.checkArrayEquivalence(eArray, Objects.requireNonNull(IdempotenceChecker.asArray(fresh)), existing);
        }
        if (existing instanceof ResultWithLog) {
            return IdempotenceChecker.whichIsField("result", existing, fresh, IdempotenceChecker.checkValueEquivalence(((ResultWithLog)existing).getResult(), ((ResultWithLog)fresh).getResult()));
        }
        if (existing instanceof CachedValueBase.Data) {
            return IdempotenceChecker.checkCachedValueData((CachedValueBase.Data)existing, (CachedValueBase.Data)fresh);
        }
        if (existing instanceof List || IdempotenceChecker.isOrderedSet(existing)) {
            return IdempotenceChecker.checkCollectionElements((Collection)existing, (Collection)fresh);
        }
        if (IdempotenceChecker.isOrderedMap(existing)) {
            return IdempotenceChecker.checkCollectionElements(((Map)existing).entrySet(), ((Map)fresh).entrySet());
        }
        if (existing instanceof Set) {
            return IdempotenceChecker.whichIsField("size", existing, fresh, IdempotenceChecker.checkCollectionSizes(((Set)existing).size(), ((Set)fresh).size()));
        }
        if (existing instanceof Map) {
            if (existing instanceof ConcurrentMap) {
                return null;
            }
            return IdempotenceChecker.whichIsField("size", existing, fresh, IdempotenceChecker.checkCollectionSizes(((Map)existing).size(), ((Map)fresh).size()));
        }
        if (IdempotenceChecker.isExpectedToHaveSaneEquals(existing) && !existing.equals(fresh)) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        if (existing instanceof PsiNamedElement) {
            return IdempotenceChecker.checkPsiEquivalence((PsiElement)existing, (PsiElement)fresh);
        }
        if (existing instanceof ResolveResult) {
            PsiElement freshPsi;
            PsiElement existingPsi = ((ResolveResult)existing).getElement();
            if (existingPsi != (freshPsi = ((ResolveResult)fresh).getElement())) {
                String s2 = IdempotenceChecker.checkClassEquivalence(existingPsi, freshPsi);
                if (s2 == null) {
                    s2 = IdempotenceChecker.checkPsiEquivalence(existingPsi, freshPsi);
                }
                return IdempotenceChecker.whichIsField("element", existing, fresh, s2);
            }
            return null;
        }
        return null;
    }

    private static boolean isOrderedMap(@NotNull Object o2) {
        if (o2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(6);
        }
        return o2 instanceof LinkedHashMap || o2 instanceof SortedMap;
    }

    private static boolean isOrderedSet(@NotNull Object o2) {
        if (o2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(7);
        }
        return o2 instanceof LinkedHashSet || o2 instanceof SortedSet;
    }

    private static String whichIsField(@NotNull @NonNls String field, @NotNull Object existing, @NotNull Object fresh, @Nullable String msg) {
        if (field == null) {
            IdempotenceChecker.$$$reportNull$$$0(8);
        }
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(9);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(10);
        }
        return msg == null ? null : IdempotenceChecker.appendDetail(msg, "which is " + field + " of " + existing + " and " + fresh);
    }

    private static Object @Nullable [] asArray(@NotNull Object o2) {
        if (o2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(11);
        }
        if (o2 instanceof Object[]) {
            return (Object[])o2;
        }
        if (o2 instanceof Map.Entry) {
            return new Object[]{((Map.Entry)o2).getKey(), ((Map.Entry)o2).getValue()};
        }
        if (o2 instanceof Pair) {
            return new Object[]{((Pair)o2).first, ((Pair)o2).second};
        }
        if (o2 instanceof Trinity) {
            return new Object[]{((Trinity)o2).first, ((Trinity)o2).second, ((Trinity)o2).third};
        }
        return null;
    }

    private static String checkCachedValueData(@NotNull CachedValueBase.Data<?> existing, @NotNull CachedValueBase.Data<?> fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(12);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(13);
        }
        Object[] deps1 = existing.getDependencies();
        Object[] deps2 = fresh.getDependencies();
        Object eValue = existing.get();
        Object fValue = fresh.get();
        if (deps1.length != deps2.length) {
            String msg = IdempotenceChecker.reportProblem(deps1.length, deps2.length);
            msg = IdempotenceChecker.appendDetail(msg, "which is length of CachedValue dependencies: " + Arrays.toString(deps1) + " and " + Arrays.toString(deps2));
            msg = IdempotenceChecker.appendDetail(msg, "where values are  " + IdempotenceChecker.objAndClass(eValue) + " and " + IdempotenceChecker.objAndClass(fValue));
            return msg;
        }
        return IdempotenceChecker.checkValueEquivalence(eValue, fValue);
    }

    private static boolean isExpectedToHaveSaneEquals(@NotNull Object existing) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(14);
        }
        return existing instanceof Comparable || existing instanceof Symbol;
    }

    @Contract(value="null,_->!null;_,null->!null")
    private static String checkClassEquivalence(@Nullable Object existing, @Nullable Object fresh) {
        Class<?> c2;
        if (existing == null || fresh == null) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        Class<?> c1 = existing.getClass();
        if (c1 != (c2 = fresh.getClass()) && !IdempotenceChecker.objectsOfDifferentClassesCanStillBeEquivalent(existing, fresh)) {
            return IdempotenceChecker.whichIsField("class", existing, fresh, IdempotenceChecker.reportProblem(c1, c2));
        }
        return null;
    }

    private static boolean objectsOfDifferentClassesCanStillBeEquivalent(@NotNull Object existing, @NotNull Object fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(15);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(16);
        }
        if (existing instanceof Map && fresh instanceof Map && IdempotenceChecker.isOrderedMap(existing) == IdempotenceChecker.isOrderedMap(fresh)) {
            return true;
        }
        if (existing instanceof Set && fresh instanceof Set && IdempotenceChecker.isOrderedSet(existing) == IdempotenceChecker.isOrderedSet(fresh)) {
            return true;
        }
        if (existing instanceof List && fresh instanceof List) {
            return true;
        }
        if (existing instanceof PsiNamedElement && fresh instanceof PsiNamedElement) {
            return true;
        }
        return ContainerUtil.intersects((Collection)allSupersWithEquals.get(existing.getClass()), (Collection)allSupersWithEquals.get(fresh.getClass()));
    }

    private static String checkPsiEquivalence(@NotNull PsiElement existing, @NotNull PsiElement fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(17);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(18);
        }
        if (!(existing.equals(fresh) || existing.isEquivalentTo(fresh) || fresh.isEquivalentTo(existing) || !IdempotenceChecker.seemsToBeResolveTarget(existing) && !IdempotenceChecker.seemsToBeResolveTarget(fresh))) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        return null;
    }

    private static boolean seemsToBeResolveTarget(@NotNull PsiElement psi) {
        if (psi == null) {
            IdempotenceChecker.$$$reportNull$$$0(19);
        }
        if (psi.isPhysical()) {
            return true;
        }
        PsiElement nav = psi.getNavigationElement();
        return nav != null && nav.isPhysical();
    }

    private static String checkCollectionElements(@NotNull Collection<?> existing, @NotNull Collection<?> fresh) {
        if (existing == null) {
            IdempotenceChecker.$$$reportNull$$$0(20);
        }
        if (fresh == null) {
            IdempotenceChecker.$$$reportNull$$$0(21);
        }
        if (fresh.isEmpty()) {
            return null;
        }
        return IdempotenceChecker.checkArrayEquivalence(existing.toArray(), fresh.toArray(), existing);
    }

    private static String checkCollectionSizes(int size1, int size2) {
        if (size2 == 0) {
            return null;
        }
        if (size1 != size2) {
            return IdempotenceChecker.reportProblem(size1, size2);
        }
        return null;
    }

    private static String checkArrayEquivalence(Object @NotNull [] a1, Object @NotNull [] a2, @NotNull Object original1) {
        int len2;
        int len1;
        if (original1 == null) {
            IdempotenceChecker.$$$reportNull$$$0(22);
        }
        if (a1 == null) {
            IdempotenceChecker.$$$reportNull$$$0(23);
        }
        if (a2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(24);
        }
        if ((len1 = a1.length) != (len2 = a2.length)) {
            return IdempotenceChecker.appendDetail(IdempotenceChecker.reportProblem(len1, len2), "which is length of " + Arrays.toString(a1) + " and " + Arrays.toString(a2));
        }
        for (int i2 = 0; i2 < len1; ++i2) {
            String msg = IdempotenceChecker.checkValueEquivalence(a1[i2], a2[i2]);
            if (msg == null) continue;
            return IdempotenceChecker.whichIsField(original1 instanceof Map.Entry ? (i2 == 0 ? "key" : "value") : i2 + "th element", Arrays.toString(a1), Arrays.toString(a2), msg);
        }
        return null;
    }

    @NotNull
    private static String reportProblem(@Nullable Object o1, @Nullable Object o2) {
        return IdempotenceChecker.appendDetail("Non-idempotent computation: it returns different results when invoked multiple times or on different threads:", IdempotenceChecker.objAndClass(o1) + " != " + IdempotenceChecker.objAndClass(o2));
    }

    @Contract(pure=true)
    @NotNull
    private static String appendDetail(@NotNull @NonNls String message, @NotNull @NonNls String detail) {
        if (message == null) {
            IdempotenceChecker.$$$reportNull$$$0(25);
        }
        if (detail == null) {
            IdempotenceChecker.$$$reportNull$$$0(26);
        }
        String string2 = message + "\n  " + StringUtil.trimLog(detail, 10000);
        if (string2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(27);
        }
        return string2;
    }

    public static boolean areRandomChecksEnabled() {
        return ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManagerEx.isInStressTest();
    }

    @TestOnly
    public static void disableRandomChecksUntil(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            IdempotenceChecker.$$$reportNull$$$0(28);
        }
        rateCheckProperty.get().setValue(0, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void applyForRandomCheck(@NotNull T data, @NotNull Object provider2, @NotNull Computable<? extends T> recomputeValue) {
        if (data == null) {
            IdempotenceChecker.$$$reportNull$$$0(29);
        }
        if (provider2 == null) {
            IdempotenceChecker.$$$reportNull$$$0(30);
        }
        if (recomputeValue == null) {
            IdempotenceChecker.$$$reportNull$$$0(31);
        }
        if (IdempotenceChecker.areRandomChecksEnabled() && IdempotenceChecker.shouldPerformRandomCheck()) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            Integer prevNesting = ourRandomCheckNesting.get();
            ourRandomCheckNesting.set(prevNesting + 1);
            try {
                T fresh = recomputeValue.compute();
                if (stamp.mayCacheNow()) {
                    IdempotenceChecker.checkEquivalence(data, fresh, provider2.getClass(), recomputeValue);
                }
            }
            finally {
                ourRandomCheckNesting.set(prevNesting);
            }
        }
    }

    private static boolean shouldPerformRandomCheck() {
        int rate = rateCheckProperty.get().asInteger();
        return rate > 0 && ThreadLocalRandom.current().nextInt(rate) == 0;
    }

    @TestOnly
    public static boolean isCurrentThreadInsideRandomCheck() {
        return ourRandomCheckNesting.get() > 0;
    }

    public static boolean isLoggingEnabled() {
        return ourLog.get() != null;
    }

    public static void logTrace(@NotNull @NonNls String message) {
        List<String> log;
        if (message == null) {
            IdempotenceChecker.$$$reportNull$$$0(32);
        }
        if ((log = ourLog.get()) != null) {
            log.add(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 27: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 27: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
            case 2: 
            case 4: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recomputeValue";
                break;
            }
            case 3: 
            case 5: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/IdempotenceChecker";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fresh";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original1";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/IdempotenceChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "recomputeWithLogging";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWithLogging";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "appendDetail";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkEquivalence";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reportFailure";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recomputeWithLogging";
                break;
            }
            case 3: 
            case 5: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeWithLogging";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isOrderedMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isOrderedSet";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "whichIsField";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "asArray";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkCachedValueData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isExpectedToHaveSaneEquals";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "objectsOfDifferentClassesCanStillBeEquivalent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiEquivalence";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "seemsToBeResolveTarget";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkCollectionElements";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayEquivalence";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendDetail";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "disableRandomChecksUntil";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "applyForRandomCheck";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "logTrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 27: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ResultWithLog<T> {
        private final T result;
        private final List<String> log;

        private ResultWithLog(T result2, List<String> log) {
            this.result = result2;
            this.log = log;
        }

        public T getResult() {
            return this.result;
        }

        String printLog() {
            return StringUtil.join(this.log, s2 -> "  " + s2, "\n");
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof ResultWithLog)) {
                return false;
            }
            ResultWithLog log = (ResultWithLog)o2;
            return Arrays.deepEquals(new Object[]{this.result}, new Object[]{log.result});
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }

        public String toString() {
            return "ResultWithLog{" + this.result + (this.log.isEmpty() ? "" : ", log='\n" + this.printLog() + '\'') + '}';
        }
    }
}

