/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.util.KeyedLazyInstance;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileSystem {
    public static final ExtensionPointName<KeyedLazyInstance<VirtualFileSystem>> EP_NAME = ExtensionPointName.create("com.intellij.virtualFileSystem");

    protected VirtualFileSystem() {
    }

    @NonNls
    @NotNull
    public abstract String getProtocol();

    @Nullable
    public abstract VirtualFile findFileByPath(@NotNull @NonNls String var1);

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            VirtualFileSystem.$$$reportNull$$$0(0);
        }
        String string2 = path.replace('/', File.separatorChar);
        if (string2 == null) {
            VirtualFileSystem.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public abstract void refresh(boolean var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByPath(@NotNull String var1);

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1);

    public final void addVirtualFileListener(@NotNull VirtualFileListener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            VirtualFileSystem.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            VirtualFileSystem.$$$reportNull$$$0(3);
        }
        this.addVirtualFileListener(listener2);
        Disposer.register(disposable, () -> this.removeVirtualFileListener(listener2));
    }

    public abstract void removeVirtualFileListener(@NotNull VirtualFileListener var1);

    protected abstract void deleteFile(Object var1, @NotNull VirtualFile var2) throws IOException;

    protected abstract void moveFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3) throws IOException;

    protected abstract void renameFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile createChildFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile createChildDirectory(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile copyFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3, @NotNull String var4) throws IOException;

    public abstract boolean isReadOnly();

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean isValidName(@NotNull String name2) {
        if (name2 == null) {
            VirtualFileSystem.$$$reportNull$$$0(4);
        }
        return !name2.isEmpty() && name2.indexOf(92) < 0 && name2.indexOf(47) < 0;
    }

    @Nullable
    public Path getNioPath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileSystem.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VirtualFileSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VirtualFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFileListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNioPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

