/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.Propagation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a \u0010\t\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\f\u001a:\u0010\t\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0010\u0012\u0006\b\u0001\u0012\u0002H\u00110\u000f\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0010\u0012\u0006\b\u0001\u0012\u0002H\u00110\u000f\u001a\b\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\n\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0007\u001a\u0006\u0010\u0016\u001a\u00020\u0007\u001a\n\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0007\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u0007\u001a\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007H\u0007\u001a\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\b\b\u0002\u0010 \u001a\u00020!\u001a\b\u0010\"\u001a\u00020!H\u0002\u001a\u0006\u0010#\u001a\u00020\u001d\u001a?\u0010$\u001a\u00020\u001d\"\u0004\b\u0000\u0010\u00102\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00062!\u0010&\u001a\u001d\u0012\u0013\u0012\u0011H\u0010\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u0002H\u00100'H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "VIOLATORS", "", "", "tlCoroutineContext", "Ljava/lang/ThreadLocal;", "Lkotlin/coroutines/CoroutineContext;", "tlTemporaryContext", "captureThreadContext", "Ljava/lang/Runnable;", "runnable", "Ljava/util/concurrent/Callable;", "V", "callable", "Ljava/util/function/Function;", "T", "U", "f", "checkContextInstalled", "", "currentTemporaryThreadContextOrNull", "currentThreadContext", "currentThreadContextOrNull", "getContextSkeleton", "", "Lkotlin/coroutines/CoroutineContext$Element;", "context", "installTemporaryThreadContext", "Lcom/intellij/openapi/application/AccessToken;", "coroutineContext", "installThreadContext", "replace", "", "isKnownViolator", "resetThreadContext", "withThreadLocal", "variable", "update", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "intellij.platform.util"})
@JvmName(name="ThreadContext")
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nthreadContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 threadContext.kt\ncom/intellij/concurrency/ThreadContext\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n11065#2:254\n11400#2,3:255\n1747#3,3:258\n*S KotlinDebug\n*F\n+ 1 threadContext.kt\ncom/intellij/concurrency/ThreadContext\n*L\n105#1:254\n105#1:255,3\n106#1:258,3\n*E\n"})
public final class ThreadContext {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ThreadLocal<CoroutineContext> tlCoroutineContext;
    @NotNull
    private static final List<String> VIOLATORS;
    @NotNull
    private static final ThreadLocal<CoroutineContext> tlTemporaryContext;

    @VisibleForTesting
    @Nullable
    public static final CoroutineContext currentThreadContextOrNull() {
        return tlCoroutineContext.get();
    }

    @NotNull
    public static final CoroutineContext currentThreadContext() {
        ThreadContext.checkContextInstalled();
        CoroutineContext coroutineContext = tlCoroutineContext.get();
        if (coroutineContext == null) {
            coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        return coroutineContext;
    }

    private static final void checkContextInstalled() {
        if (LoadingState.APP_STARTED.isOccurred() && Propagation.isCheckContextAssertions() && tlCoroutineContext.get() == null && !ThreadContext.isKnownViolator()) {
            LOG.warn("Missing thread context. Most likely there is no `blockingContext` on the boundary of coroutine code and blocking code.", new Throwable());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isKnownViolator() {
        boolean bl;
        block8: {
            void $this$mapTo$iv$iv;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Object[] $this$map$iv = stackTraceElementArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getClassName() + '.' + it.getMethodName());
            }
            List stackTrace = (List)destination$iv$iv;
            Iterable $this$any$iv = VIOLATORS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block7: {
                        String badTrace = (String)element$iv;
                        boolean bl4 = false;
                        Iterable $this$any$iv2 = stackTrace;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String it = (String)element$iv2;
                                boolean bl5 = false;
                                if (!StringsKt.startsWith$default((String)it, (String)badTrace, (boolean)false, (int)2, null)) continue;
                                bl3 = true;
                                break block7;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final AccessToken resetThreadContext() {
        return ThreadContext.withThreadLocal(tlCoroutineContext, resetThreadContext.1.INSTANCE);
    }

    @NotNull
    public static final AccessToken installThreadContext(@NotNull CoroutineContext coroutineContext, boolean replace2) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        return ThreadContext.withThreadLocal(tlCoroutineContext, (Function1)new Function1<CoroutineContext, CoroutineContext>(replace2, coroutineContext){
            final /* synthetic */ boolean $replace;
            final /* synthetic */ CoroutineContext $coroutineContext;
            {
                this.$replace = $replace;
                this.$coroutineContext = $coroutineContext;
                super(1);
            }

            @Nullable
            public final CoroutineContext invoke(@Nullable CoroutineContext previousContext) {
                if (!this.$replace && previousContext != null) {
                    ThreadContext.access$getLOG$p().error("Thread context was already set: " + previousContext);
                }
                return this.$coroutineContext;
            }
        });
    }

    public static /* synthetic */ AccessToken installThreadContext$default(CoroutineContext coroutineContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ThreadContext.installThreadContext(coroutineContext, bl);
    }

    @ApiStatus.Internal
    @Nullable
    public static final CoroutineContext currentTemporaryThreadContextOrNull() {
        return tlTemporaryContext.get();
    }

    @ApiStatus.Internal
    @NotNull
    public static final AccessToken installTemporaryThreadContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        return ThreadContext.withThreadLocal(tlTemporaryContext, (Function1)new Function1<CoroutineContext, CoroutineContext>(coroutineContext){
            final /* synthetic */ CoroutineContext $coroutineContext;
            {
                this.$coroutineContext = $coroutineContext;
                super(1);
            }

            @Nullable
            public final CoroutineContext invoke(@Nullable CoroutineContext coroutineContext) {
                return this.$coroutineContext;
            }
        });
    }

    @ApiStatus.Internal
    @NotNull
    public static final <T> AccessToken withThreadLocal(@NotNull ThreadLocal<T> variable, @NotNull Function1<? super T, ? extends T> update) {
        Intrinsics.checkNotNullParameter(variable, (String)"variable");
        Intrinsics.checkNotNullParameter(update, (String)"update");
        T previousValue = variable.get();
        Object newValue = update.invoke(previousValue);
        if (newValue == previousValue) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        variable.set(newValue);
        return new AccessToken(variable, previousValue, newValue){
            final /* synthetic */ ThreadLocal<T> $variable;
            final /* synthetic */ T $previousValue;
            final /* synthetic */ T $newValue;
            {
                this.$variable = $variable;
                this.$previousValue = $previousValue;
                this.$newValue = $newValue;
            }

            public void finish() {
                T currentValue = this.$variable.get();
                this.$variable.set(this.$previousValue);
                boolean bl = currentValue == this.$newValue;
                T t2 = this.$newValue;
                if (!bl) {
                    boolean bl2 = false;
                    String string2 = "Value was not reset correctly. Expected: " + t2 + ", actual: " + currentValue;
                    throw new IllegalStateException(string2.toString());
                }
            }
        };
    }

    @NotNull
    public static final Runnable captureThreadContext(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return Propagation.captureRunnableThreadContext(runnable);
    }

    @NotNull
    public static final <T, U> Function<? super T, ? extends U> captureThreadContext(@NotNull Function<? super T, ? extends U> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return Propagation.capturePropagationAndCancellationContext(f);
    }

    @NotNull
    public static final Set<CoroutineContext.Element> getContextSkeleton(@NotNull CoroutineContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ThreadContext.checkContextInstalled();
        return (Set)context2.fold(new HashSet(), (Function2)getContextSkeleton.1.INSTANCE);
    }

    @NotNull
    public static final <V> Callable<V> captureThreadContext(@NotNull Callable<V> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        return Propagation.captureCallableThreadContext(callable);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger2 = Logger.getInstance("#com.intellij.concurrency");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        tlCoroutineContext = new ThreadLocal();
        Object[] objectArray = new String[]{"com.intellij.diagnostic", "com.intellij.openapi.actionSystem", "org.jetbrains.idea.maven.server", "com.intellij.internal.statistic", "com.intellij.openapi.diagnostic.Logger", "com.intellij.openapi.extensions.impl.ExtensionPointImpl.getExtensionList", "com.intellij.openapi.extensions.impl.ExtensionPointImpl.getExtensions", "com.intellij.openapi.project.SmartModeScheduler.onStateChanged", "javax.swing.JComponent.paint", "com.intellij.openapi.application.impl.LaterInvocator.leaveModal", "com.intellij.openapi.application.impl.LaterInvocator.invokeAndWait", "com.intellij.util.animation.JBAnimator.animate", "com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl.disconnect", "com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl.scheduleUpdateRunnable", "com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl.stopProcess", "com.intellij.openapi.wm.impl.WindowCloseListener.windowClosing", "com.intellij.ide.ApplicationActivationStateManager.updateState", "com.intellij.openapi.util.io.GentleFlusherBase"};
        VIOLATORS = CollectionsKt.listOf((Object[])objectArray);
        tlTemporaryContext = new ThreadLocal();
    }
}

