/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.FirDefaultParametersResolverKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentPassedTwice;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtomWithSingleChild;
import org.jetbrains.kotlin.fir.resolve.calls.ManyLambdaExpressionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.NameForAmbiguousParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NameNotFound;
import org.jetbrains.kotlin.fir.resolve.calls.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.fir.resolve.calls.NoValueForParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NonVarargSpread;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.resolve.calls.TooManyArguments;
import org.jetbrains.kotlin.fir.resolve.calls.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ParameterNameTypeAttributeKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.ForbiddenNamedArgumentsTarget;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001LB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001402J\u0018\u00103\u001a\u0002002\u0006\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u000bH\u0002J\u0018\u00106\u001a\u0002002\u0006\u00107\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u000bH\u0002J\u0018\u00108\u001a\u0002002\u0006\u00104\u001a\u0002092\u0006\u00107\u001a\u00020:H\u0002J\u000e\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020\u0014J\u0014\u0010=\u001a\u0002002\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001402J\u0006\u0010?\u001a\u000200J\b\u0010@\u001a\u000200H\u0002J\u0010\u0010A\u001a\u0002002\u0006\u00107\u001a\u00020\u0014H\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010\u00182\u0006\u0010C\u001a\u00020\u0017H\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010\u00182\u0006\u00107\u001a\u00020:H\u0002J\u0010\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR.\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u00132\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R9\u0010#\u001a*\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140%0$j\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140%`&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001d\u0010)\u001a\u0004\u0018\u00010*8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b+\u0010,R\u0018\u0010G\u001a\u00020\u000b*\u00020H8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010IR\u001a\u0010J\u001a\b\u0012\u0004\u0012\u00020\u0018028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010\"\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor;", "", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "originScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "isIndexedSetOperator", "", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;Z)V", "state", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor$State;", "currentPositionedParameterIndex", "", "varargArguments", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "nameToParameter", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "namedDynamicArgumentsNamesImpl", "", "namedDynamicArgumentsNames", "getNamedDynamicArgumentsNames", "()Ljava/util/Set;", "value", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "diagnostics", "getDiagnostics", "()Ljava/util/List;", "result", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lkotlin/collections/LinkedHashMap;", "getResult", "()Ljava/util/LinkedHashMap;", "forbiddenNamedArgumentsTarget", "Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "getForbiddenNamedArgumentsTarget", "()Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "forbiddenNamedArgumentsTarget$delegate", "Lkotlin/Lazy;", "processNonLambdaArguments", "", "arguments", "", "processNonLambdaArgument", "atom", "isLastArgument", "processPositionArgument", "argument", "processNamedArgument", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtomWithSingleChild;", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "processExternalArgument", "externalArgument", "processExcessLambdaArguments", "excessLambdaArguments", "processDefaultsAndRunChecks", "completeVarargPositionArguments", "addVarargArgument", "getParameterByName", "name", "findParameterByName", "addDiagnostic", "diagnostic", "isSpread", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "parameters", "getParameters", "State", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirArgumentsToParametersMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,452:1\n1#2:453\n1869#3,2:454\n1236#3,4:467\n346#3,8:471\n1267#3,4:479\n360#3,7:483\n81#4,7:456\n76#4,2:463\n57#4:465\n78#4:466\n*S KotlinDebug\n*F\n+ 1 FirArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor\n*L\n279#1:454,2\n354#1:467,4\n421#1:471,8\n344#1:479,4\n394#1:483,7\n286#1:456,7\n286#1:463,2\n286#1:465\n286#1:466\n*E\n"})
final class FirCallArgumentsProcessor {
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final FirFunction function;
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @Nullable
    private final FirScope originScope;
    private final boolean isIndexedSetOperator;
    @NotNull
    private State state;
    private int currentPositionedParameterIndex;
    @Nullable
    private List<ConeResolutionAtom> varargArguments;
    @Nullable
    private Map<Name, ? extends FirValueParameter> nameToParameter;
    @Nullable
    private Set<Name> namedDynamicArgumentsNamesImpl;
    @Nullable
    private List<ResolutionDiagnostic> diagnostics;
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> result;
    @NotNull
    private final Lazy forbiddenNamedArgumentsTarget$delegate;

    public FirCallArgumentsProcessor(@NotNull FirSession useSiteSession, @NotNull FirFunction function2, @NotNull BodyResolveComponents bodyResolveComponents2, @Nullable FirScope originScope, boolean isIndexedSetOperator) {
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents2, (String)"bodyResolveComponents");
        this.useSiteSession = useSiteSession;
        this.function = function2;
        this.bodyResolveComponents = bodyResolveComponents2;
        this.originScope = originScope;
        this.isIndexedSetOperator = isIndexedSetOperator;
        this.state = State.POSITION_ARGUMENTS;
        this.result = new LinkedHashMap(this.function.getValueParameters().size());
        this.forbiddenNamedArgumentsTarget$delegate = LazyKt.lazy(() -> FirCallArgumentsProcessor.forbiddenNamedArgumentsTarget_delegate$lambda$1(this));
    }

    private final Set<Name> getNamedDynamicArgumentsNames() {
        Set set = this.namedDynamicArgumentsNamesImpl;
        if (set == null) {
            Set set2;
            Set it = set2 = (Set)new LinkedHashSet();
            boolean bl2 = false;
            this.namedDynamicArgumentsNamesImpl = it;
            set = set2;
        }
        return set;
    }

    @Nullable
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> getResult() {
        return this.result;
    }

    @Nullable
    public final ForbiddenNamedArgumentsTarget getForbiddenNamedArgumentsTarget() {
        Lazy lazy = this.forbiddenNamedArgumentsTarget$delegate;
        return (ForbiddenNamedArgumentsTarget)((Object)lazy.getValue());
    }

    public final void processNonLambdaArguments(@NotNull List<? extends ConeResolutionAtom> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Iterator iterator2 = ((Iterable)arguments2).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int argumentIndex = n2++;
            ConeResolutionAtom argument = (ConeResolutionAtom)iterator2.next();
            this.processNonLambdaArgument(argument, argumentIndex == CollectionsKt.getLastIndex(arguments2));
        }
        if (this.state == State.VARARG_POSITION) {
            this.completeVarargPositionArguments();
        }
    }

    private final void processNonLambdaArgument(ConeResolutionAtom atom, boolean isLastArgument) {
        FirExpression argument = atom.getExpression();
        if (!(argument instanceof FirNamedArgumentExpression)) {
            if (this.state == State.VARARG_POSITION && this.isIndexedSetOperator && isLastArgument) {
                this.completeVarargPositionArguments();
            }
            this.processPositionArgument(atom, isLastArgument);
            return;
        }
        if (!(atom instanceof ConeResolutionAtomWithSingleChild)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (((ConeResolutionAtomWithSingleChild)atom).getSubAtom() == null) {
            boolean bl2 = false;
            String string3 = "SubAtom of named argument is null";
            throw new IllegalArgumentException(string3.toString());
        }
        if (Intrinsics.areEqual((Object)this.function.getOrigin(), (Object)FirDeclarationOrigin.DynamicScope.INSTANCE)) {
            this.processPositionArgument(((ConeResolutionAtomWithSingleChild)atom).getSubAtom(), isLastArgument);
            if (!this.getNamedDynamicArgumentsNames().add(((FirNamedArgumentExpression)argument).getName())) {
                this.addDiagnostic(new ArgumentPassedTwice((FirNamedArgumentExpression)argument));
            }
        } else {
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
            this.processNamedArgument((ConeResolutionAtomWithSingleChild)atom, (FirNamedArgumentExpression)argument);
        }
    }

    private final void processPositionArgument(ConeResolutionAtom argument, boolean isLastArgument) {
        int n2;
        if (this.state == State.NAMED_ONLY_ARGUMENTS) {
            this.addDiagnostic(new MixingNamedAndPositionArguments(argument.getExpression()));
            return;
        }
        if (this.isIndexedSetOperator) {
            int lastParameterIndex = CollectionsKt.getLastIndex(this.getParameters());
            n2 = isLastArgument ? lastParameterIndex : (this.currentPositionedParameterIndex >= lastParameterIndex ? -1 : this.currentPositionedParameterIndex);
        } else {
            n2 = this.currentPositionedParameterIndex;
        }
        int assignedParameterIndex = n2;
        FirValueParameter parameter2 = (FirValueParameter)CollectionsKt.getOrNull(this.getParameters(), (int)assignedParameterIndex);
        if (parameter2 == null) {
            this.addDiagnostic(new TooManyArguments(argument.getExpression(), this.function));
            return;
        }
        if (!parameter2.isVararg()) {
            int n3 = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n3 + 1;
            ((Map)this.result).put(parameter2, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtom>(argument));
            this.state = State.POSITION_ARGUMENTS;
        } else {
            this.addVarargArgument(argument);
            this.state = State.VARARG_POSITION;
        }
    }

    private final void processNamedArgument(ConeResolutionAtomWithSingleChild atom, FirNamedArgumentExpression argument) {
        ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget = this.getForbiddenNamedArgumentsTarget();
        if (forbiddenNamedArgumentsTarget != null) {
            ForbiddenNamedArgumentsTarget it = forbiddenNamedArgumentsTarget;
            boolean bl2 = false;
            this.addDiagnostic(new NamedArgumentNotAllowed(atom.getExpression(), this.function, it));
        }
        boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
        this.state = State.NAMED_ONLY_ARGUMENTS;
        FirValueParameter firValueParameter = this.findParameterByName(argument);
        if (firValueParameter == null) {
            return;
        }
        FirValueParameter parameter2 = firValueParameter;
        ResolvedCallArgument<ConeResolutionAtom> resolvedCallArgument = this.result.get(parameter2);
        if (resolvedCallArgument != null) {
            ResolvedCallArgument<ConeResolutionAtom> it = resolvedCallArgument;
            boolean bl3 = false;
            this.addDiagnostic(new ArgumentPassedTwice(argument));
            return;
        }
        ((Map)this.result).put(parameter2, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtomWithSingleChild>(atom));
        if (stateAllowsMixedNamedAndPositionArguments && Intrinsics.areEqual((Object)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex), (Object)parameter2)) {
            this.state = State.POSITION_ARGUMENTS;
            int n2 = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n2 + 1;
        }
    }

    public final void processExternalArgument(@NotNull ConeResolutionAtom externalArgument) {
        Intrinsics.checkNotNullParameter((Object)externalArgument, (String)"externalArgument");
        FirExpression argumentExpression = externalArgument.getExpression();
        FirValueParameter lastParameter = (FirValueParameter)CollectionsKt.lastOrNull(this.getParameters());
        if (lastParameter == null) {
            this.addDiagnostic(new TooManyArguments(argumentExpression, this.function));
            return;
        }
        if (!Intrinsics.areEqual((Object)this.function.getOrigin(), (Object)FirDeclarationOrigin.DynamicScope.INSTANCE)) {
            if (lastParameter.isVararg()) {
                this.addDiagnostic(new VarargArgumentOutsideParentheses(argumentExpression, lastParameter));
                return;
            }
            ResolvedCallArgument<ConeResolutionAtom> previousOccurrence = this.result.get(lastParameter);
            if (previousOccurrence != null) {
                this.addDiagnostic(new TooManyArguments(argumentExpression, this.function));
                return;
            }
            ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtom>(externalArgument));
        } else {
            ResolvedCallArgument<ConeResolutionAtom> existing = this.result.get(lastParameter);
            if (existing == null) {
                ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtom>(externalArgument));
            } else {
                ((Map)this.result).put(lastParameter, new ResolvedCallArgument.VarargArgument(CollectionsKt.plus((Collection)existing.getArguments(), (Object)externalArgument)));
            }
        }
    }

    public final void processExcessLambdaArguments(@NotNull List<? extends ConeResolutionAtom> excessLambdaArguments) {
        Intrinsics.checkNotNullParameter(excessLambdaArguments, (String)"excessLambdaArguments");
        Iterable $this$forEach$iv = excessLambdaArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeResolutionAtom arg = (ConeResolutionAtom)element$iv;
            boolean bl2 = false;
            this.addDiagnostic(new ManyLambdaExpressionArguments(arg.getExpression()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processDefaultsAndRunChecks() {
        for (Map.Entry entry : ((Map)this.result).entrySet()) {
            FirValueParameter parameter2 = (FirValueParameter)entry.getKey();
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)entry.getValue();
            if (parameter2.isVararg()) continue;
            if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                String message$iv = "Incorrect resolved argument for parameter " + parameter2.getClass() + ": " + resolvedArgument.getClass();
                Throwable cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string2 = attachmentName$iv;
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
                boolean bl2 = false;
                void $this$processDefaultsAndRunChecks_u24lambda_u247 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl3 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$processDefaultsAndRunChecks_u24lambda_u247, "parameter", parameter2);
                $this$processDefaultsAndRunChecks_u24lambda_u247.withEntryGroup("arguments", (Function1<? super ExceptionAttachmentBuilder, Unit>)((Function1)arg_0 -> FirCallArgumentsProcessor.processDefaultsAndRunChecks$lambda$7$lambda$6(resolvedArgument, arg_0)));
                kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            if (!this.isSpread(((ConeResolutionAtom)((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()).getExpression())) continue;
            this.addDiagnostic(new NonVarargSpread(((ConeResolutionAtom)((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()).getExpression()));
        }
        Iterator iterator2 = ((Iterable)this.getParameters()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index2 = n2++;
            FirValueParameter parameter3 = (FirValueParameter)((Object)iterator2.next());
            if (this.result.containsKey(parameter3)) continue;
            if (FirDefaultParametersResolverKt.getDefaultParameterResolver(this.bodyResolveComponents.getSession()).declaresDefaultValue(this.useSiteSession, this.bodyResolveComponents.getScopeSession(), this.function, this.originScope, index2)) {
                ((Map)this.result).put(parameter3, ResolvedCallArgument.DefaultArgument.INSTANCE);
                continue;
            }
            if (parameter3.isVararg()) {
                ((Map)this.result).put(parameter3, new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList()));
                continue;
            }
            this.addDiagnostic(new NoValueForParameter(parameter3, this.function));
        }
    }

    private final void completeVarargPositionArguments() {
        boolean bl2;
        boolean bl3 = bl2 = this.state == State.VARARG_POSITION;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string2 = "Incorrect state: " + (Object)((Object)this.state);
            throw new AssertionError((Object)string2);
        }
        FirValueParameter parameter2 = this.getParameters().get(this.currentPositionedParameterIndex);
        Map map = this.result;
        List<ConeResolutionAtom> list = this.varargArguments;
        Intrinsics.checkNotNull(list);
        map.put(parameter2, new ResolvedCallArgument.VarargArgument<ConeResolutionAtom>(list));
    }

    private final void addVarargArgument(ConeResolutionAtom argument) {
        if (this.varargArguments == null) {
            this.varargArguments = new ArrayList();
        }
        List<ConeResolutionAtom> list = this.varargArguments;
        Intrinsics.checkNotNull(list);
        list.add(argument);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter getParameterByName(Name name2) {
        block8: {
            void $this$associateByTo$iv;
            block9: {
                FirNamedFunctionSymbol symbol;
                if (this.nameToParameter != null) break block8;
                if (!ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden(this.function) || this.getForbiddenNamedArgumentsTarget() != null) break block9;
                FirFunctionSymbol<FirFunction> firFunctionSymbol = this.function.getSymbol();
                FirNamedFunctionSymbol firNamedFunctionSymbol = symbol = firFunctionSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firFunctionSymbol : null;
                if (symbol != null) {
                    FirScope firScope = this.originScope;
                    FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                    if (firTypeScope != null) {
                        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirCallArgumentsProcessor.getParameterByName$lambda$10(this, arg_0)));
                    }
                }
                if (this.nameToParameter == null) {
                    this.nameToParameter = MapsKt.emptyMap();
                }
                break block8;
            }
            Iterable symbol = this.getParameters();
            Map map = new LinkedHashMap();
            FirCallArgumentsProcessor firCallArgumentsProcessor = this;
            boolean $i$f$associateByTo = false;
            for (Object element$iv : $this$associateByTo$iv) {
                Object object;
                void var14_17;
                block11: {
                    void parameter2;
                    block10: {
                        FirAnnotation annotation;
                        void destination$iv;
                        FirValueParameter firValueParameter = (FirValueParameter)element$iv;
                        var14_17 = destination$iv;
                        boolean bl2 = false;
                        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(parameter2.getReturnTypeRef());
                        FirAnnotation firAnnotation = annotation = coneKotlinType != null ? ParameterNameTypeAttributeKt.getParameterNameAnnotation(coneKotlinType) : null;
                        String argument = firAnnotation != null ? FirAnnotationUtilsKt.getStringArgument(firAnnotation, StandardNames.NAME, this.useSiteSession) : null;
                        object = argument;
                        if (object == null) break block10;
                        String it = object;
                        boolean bl3 = false;
                        Name name3 = Name.identifier(it);
                        object = name3;
                        if (name3 != null) break block11;
                    }
                    object = parameter2.getName();
                }
                var14_17.put(object, element$iv);
            }
            firCallArgumentsProcessor.nameToParameter = map;
        }
        Map<Name, ? extends FirValueParameter> map = this.nameToParameter;
        Intrinsics.checkNotNull(map);
        return map.get(name2);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter findParameterByName(FirNamedArgumentExpression argument) {
        Ref.ObjectRef parameter2;
        block9: {
            int n2;
            int n3;
            Ref.IntRef matchedIndex;
            FirNamedFunctionSymbol symbol;
            block7: {
                void $this$indexOfFirst$iv;
                block8: {
                    parameter2 = new Ref.ObjectRef();
                    parameter2.element = this.getParameterByName(argument.getName());
                    FirFunctionSymbol<FirFunction> firFunctionSymbol = this.function.getSymbol();
                    symbol = firFunctionSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firFunctionSymbol : null;
                    matchedIndex = new Ref.IntRef();
                    matchedIndex.element = -1;
                    if (parameter2.element != null) break block8;
                    if (symbol != null && (ClassMembersKt.isSubstitutionOrIntersectionOverride(this.function) || DeclarationUtilsKt.isJavaOrEnhancement(this.function))) {
                        Ref.ObjectRef allowedParameters = new Ref.ObjectRef();
                        FirScope firScope = this.originScope;
                        FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                        if (firTypeScope != null) {
                            FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirCallArgumentsProcessor.findParameterByName$lambda$14(matchedIndex, parameter2, this, allowedParameters, argument, arg_0)));
                        }
                    }
                    if (parameter2.element != null) break block9;
                    this.addDiagnostic(new NameNotFound(argument, this.function));
                    break block9;
                }
                if (symbol == null || !ClassMembersKt.isSubstitutionOrIntersectionOverride(this.function) && !DeclarationUtilsKt.isJavaOrEnhancement(this.function)) break block9;
                Map<Name, ? extends FirValueParameter> map = this.nameToParameter;
                Intrinsics.checkNotNull(map);
                Iterable allowedParameters = map.entrySet();
                Ref.IntRef intRef = matchedIndex;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    if (index$iv < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Map.Entry it = (Map.Entry)item$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual(it.getKey(), (Object)argument.getName())) {
                        n3 = index$iv;
                        break block7;
                    }
                    ++index$iv;
                }
                n3 = -1;
            }
            intRef.element = n2 = n3;
            if (matchedIndex.element != -1) {
                FirScope firScope = this.originScope;
                FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                if (firTypeScope != null) {
                    FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirCallArgumentsProcessor.findParameterByName$lambda$16(matchedIndex, argument, this, arg_0)));
                }
            }
        }
        return (FirValueParameter)parameter2.element;
    }

    private final void addDiagnostic(ResolutionDiagnostic diagnostic) {
        if (this.diagnostics == null) {
            this.diagnostics = new ArrayList();
        }
        List<ResolutionDiagnostic> list = this.diagnostics;
        Intrinsics.checkNotNull(list);
        list.add(diagnostic);
    }

    private final boolean isSpread(FirExpression $this$isSpread) {
        return $this$isSpread instanceof FirWrappedArgumentExpression ? ((FirWrappedArgumentExpression)$this$isSpread).isSpread() : false;
    }

    private final List<FirValueParameter> getParameters() {
        return this.function.getValueParameters();
    }

    private static final ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget_delegate$lambda$1(FirCallArgumentsProcessor this$0) {
        FirScope firScope = this$0.originScope;
        return ResolveUtilsKt.forbiddenNamedArgumentsTargetOrNull(this$0.function, firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null);
    }

    private static final Unit processDefaultsAndRunChecks$lambda$7$lambda$6(ResolvedCallArgument $resolvedArgument, ExceptionAttachmentBuilder $this$withEntryGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$withEntryGroup, (String)"$this$withEntryGroup");
        Iterator iterator2 = ((Iterable)$resolvedArgument.getArguments()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index2 = n2++;
            ConeResolutionAtom argument = (ConeResolutionAtom)iterator2.next();
            FirExceptionUtilsKt.withFirEntry($this$withEntryGroup, "argument" + index2, argument.getExpression());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final ProcessorAction getParameterByName$lambda$10(FirCallArgumentsProcessor this$0, FirNamedFunctionSymbol overrideSymbol) {
        void $this$associateTo$iv;
        Intrinsics.checkNotNullParameter((Object)overrideSymbol, (String)"overrideSymbol");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)overrideSymbol.getFir())) {
            return ProcessorAction.NEXT;
        }
        Iterable iterable = CollectionsKt.withIndex((Iterable)this$0.getParameters());
        Map map = new LinkedHashMap();
        FirCallArgumentsProcessor firCallArgumentsProcessor = this$0;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            void destination$iv;
            void var7_8 = destination$iv;
            IndexedValue indexedValue = (IndexedValue)element$iv;
            boolean bl2 = false;
            int i2 = indexedValue.component1();
            FirValueParameter p = (FirValueParameter)indexedValue.component2();
            indexedValue = TuplesKt.to((Object)((FirSimpleFunction)overrideSymbol.getFir()).getValueParameters().get(i2).getName(), (Object)p);
            var7_8.put(indexedValue.getFirst(), indexedValue.getSecond());
        }
        firCallArgumentsProcessor.nameToParameter = map;
        return ProcessorAction.STOP;
    }

    private static final ProcessorAction findParameterByName$findAndReportValueParameterWithDifferentName(List<FirValueParameterSymbol> $this$findParameterByName_u24findAndReportValueParameterWithDifferentName, Ref.IntRef matchedIndex, FirNamedArgumentExpression $argument, FirCallArgumentsProcessor this$0) {
        Name someName;
        FirValueParameter someParameter;
        FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)CollectionsKt.getOrNull($this$findParameterByName_u24findAndReportValueParameterWithDifferentName, (int)matchedIndex.element);
        FirValueParameter firValueParameter = someParameter = firValueParameterSymbol != null ? (FirValueParameter)firValueParameterSymbol.getFir() : null;
        Name name2 = someName = firValueParameter != null ? firValueParameter.getName() : null;
        if (someName != null && !Intrinsics.areEqual((Object)someName, (Object)$argument.getName())) {
            this$0.addDiagnostic(new NameForAmbiguousParameter($argument));
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    /*
     * WARNING - void declaration
     */
    private static final ProcessorAction findParameterByName$lambda$14(Ref.IntRef $matchedIndex, Ref.ObjectRef $parameter, FirCallArgumentsProcessor this$0, Ref.ObjectRef $allowedParameters, FirNamedArgumentExpression $argument, FirNamedFunctionSymbol it) {
        ProcessorAction processorAction;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)it.getFir())) {
            return ProcessorAction.NEXT;
        }
        List<FirValueParameterSymbol> someParameterSymbols = it.getValueParameterSymbols();
        if ($matchedIndex.element != -1) {
            processorAction = FirCallArgumentsProcessor.findParameterByName$findAndReportValueParameterWithDifferentName(someParameterSymbols, $matchedIndex, $argument, this$0);
        } else {
            int n2;
            int n3;
            block9: {
                void $this$indexOfFirst$iv;
                List<FirValueParameterSymbol> list = someParameterSymbols;
                Ref.IntRef intRef = $matchedIndex;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    FirValueParameterSymbol originalParameter = (FirValueParameterSymbol)item$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)originalParameter.getName(), (Object)$argument.getName())) {
                        n3 = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n3 = -1;
            }
            intRef.element = n2 = n3;
            if ($matchedIndex.element != -1) {
                FirValueParameter someParameter;
                $parameter.element = this$0.getParameters().get($matchedIndex.element);
                Object object = (List)$allowedParameters.element;
                FirValueParameter firValueParameter = object != null && (object = (FirValueParameterSymbol)CollectionsKt.getOrNull((List)object, (int)$matchedIndex.element)) != null ? (FirValueParameter)((FirBasedSymbol)object).getFir() : (someParameter = null);
                if (someParameter != null) {
                    this$0.addDiagnostic(new NameForAmbiguousParameter($argument));
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
            } else {
                $allowedParameters.element = someParameterSymbols;
                processorAction = ProcessorAction.NEXT;
            }
        }
        return processorAction;
    }

    private static final ProcessorAction findParameterByName$lambda$16(Ref.IntRef $matchedIndex, FirNamedArgumentExpression $argument, FirCallArgumentsProcessor this$0, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)it.getFir())) {
            return ProcessorAction.NEXT;
        }
        return FirCallArgumentsProcessor.findParameterByName$findAndReportValueParameterWithDifferentName(it.getValueParameterSymbols(), $matchedIndex, $argument, this$0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor$State;", "", "<init>", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS", "resolve"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State POSITION_ARGUMENTS = new State();
        public static final /* enum */ State VARARG_POSITION = new State();
        public static final /* enum */ State NAMED_ONLY_ARGUMENTS = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.POSITION_ARGUMENTS, State.VARARG_POSITION, State.NAMED_ONLY_ARGUMENTS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

