/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaClassOnCompanionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirPropertyAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaClassOnCompanionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaClassOnCompanionChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaClassOnCompanionChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,50:1\n65#2:51\n*S KotlinDebug\n*F\n+ 1 FirJavaClassOnCompanionChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaClassOnCompanionChecker\n*L\n40#1:51\n*E\n"})
public final class FirJavaClassOnCompanionChecker
extends FirExpressionChecker<FirPropertyAccessExpression> {
    @NotNull
    public static final FirJavaClassOnCompanionChecker INSTANCE = new FirJavaClassOnCompanionChecker();

    private FirJavaClassOnCompanionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirPropertyAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl2;
        FirRegularClassSymbol projectionClassSymbol;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirBasedSymbol<?> firBasedSymbol = expression2.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = firBasedSymbol instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)((Object)firBasedSymbol) : null;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference2 = firResolvedNamedReference;
        firBasedSymbol = FirReferenceUtilsKt.getSymbol(reference2);
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (!Intrinsics.areEqual((Object)(firCallableSymbol != null ? firCallableSymbol.getCallableId() : null), (Object)JvmStandardClassIds.Callables.INSTANCE.getJavaClass())) {
            return;
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType(expression2);
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType actualType = coneClassLikeType;
        Object object = ArraysKt.singleOrNull((Object[])actualType.getTypeArguments());
        ConeKotlinTypeProjection coneKotlinTypeProjection = object instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)object : null;
        if (coneKotlinTypeProjection == null || (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) == null) {
            return;
        }
        ConeKotlinTypeProjection projectionType = coneKotlinTypeProjection;
        FirRegularClassSymbol firRegularClassSymbol = projectionClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((ConeKotlinType)projectionType, context2.getSession());
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isCompanion$iv = firRegularClassSymbol;
            boolean $i$f$isCompanion = false;
            bl2 = $this$isCompanion$iv.getRawStatus().isCompanion();
        } else {
            bl2 = false;
        }
        if (!bl2) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(projectionClassSymbol);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> containingClassSymbol = firClassLikeSymbol;
        ConeClassLikeType[] coneClassLikeTypeArray = new ConeClassLikeType[]{ScopeUtilsKt.defaultType(containingClassSymbol)};
        ConeClassLikeType expectedType = TypeConstructionUtilsKt.constructClassType$default(actualType.getLookupTag(), coneClassLikeTypeArray, actualType.isMarkedNullable(), null, 4, null);
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getJAVA_CLASS_ON_COMPANION(), (Object)actualType, (Object)expectedType, (DiagnosticContext)context2, null, 32, null);
    }
}

