/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.Processor;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PersistentMapBase<Key, Value> {
    @ApiStatus.OverrideOnly
    @NotNull
    public DataExternalizer<Value> getValuesExternalizer();

    default public void appendData(Key key, @NotNull AppendablePersistentMap.ValueDataAppender appender) throws IOException {
        if (appender == null) {
            PersistentMapBase.$$$reportNull$$$0(0);
        }
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        DataExternalizer<Value> dataExternalizer = this.getValuesExternalizer();
        Value oldValue = this.get(key);
        if (oldValue != null) {
            dataExternalizer.save(dos, oldValue);
        }
        appender.append(dos);
        dos.close();
        DataInputStream dis = new DataInputStream(bos.toInputStream());
        Value newValue = dataExternalizer.read(dis);
        dis.close();
        this.put(key, newValue);
    }

    public boolean processExistingKeys(@NotNull Processor<? super Key> var1) throws IOException;

    public boolean processKeys(@NotNull Processor<? super Key> var1) throws IOException;

    public boolean containsKey(Key var1) throws IOException;

    @Nullable
    public Value get(Key var1) throws IOException;

    public void put(Key var1, Value var2) throws IOException;

    public void remove(Key var1) throws IOException;

    public boolean isDirty();

    public void markDirty() throws IOException;

    default public void markCorrupted() {
    }

    public void force() throws IOException;

    public boolean isClosed();

    public void close() throws IOException;

    public void closeAndDelete() throws IOException;

    default public int keysCount() {
        return -1;
    }

    public static <K, V, M extends PersistentMapBase<? super K, ? super V>> M canonicalize(@NotNull PersistentMapBase<K, V> originalMap, @NotNull M targetCanonicalMap, @NotNull Function<? super List<K>, ? extends List<K>> stableKeysSorter, @NotNull Function<? super V, ? extends V> valueCanonicalizer) throws IOException {
        if (originalMap == null) {
            PersistentMapBase.$$$reportNull$$$0(1);
        }
        if (targetCanonicalMap == null) {
            PersistentMapBase.$$$reportNull$$$0(2);
        }
        if (stableKeysSorter == null) {
            PersistentMapBase.$$$reportNull$$$0(3);
        }
        if (valueCanonicalizer == null) {
            PersistentMapBase.$$$reportNull$$$0(4);
        }
        ArrayList keys = new ArrayList();
        originalMap.processExistingKeys(k2 -> {
            keys.add(k2);
            return true;
        });
        List<K> sortedKeys = stableKeysSorter.apply(keys);
        for (K key : sortedKeys) {
            V value2 = originalMap.get(key);
            V canonicalizedValue = valueCanonicalizer.apply(value2);
            targetCanonicalMap.put(key, canonicalizedValue);
        }
        return targetCanonicalMap;
    }

    public static <K, V, M extends PersistentMapBase<? super K, ? super V>> M canonicalize(@NotNull PersistentMapBase<K, V> originalMap, @NotNull M targetCanonicalMap, @NotNull Function<List<K>, List<K>> stableKeysSorter) throws IOException {
        if (originalMap == null) {
            PersistentMapBase.$$$reportNull$$$0(5);
        }
        if (targetCanonicalMap == null) {
            PersistentMapBase.$$$reportNull$$$0(6);
        }
        if (stableKeysSorter == null) {
            PersistentMapBase.$$$reportNull$$$0(7);
        }
        return PersistentMapBase.canonicalize(originalMap, targetCanonicalMap, stableKeysSorter, Function.identity());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMap";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCanonicalMap";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stableKeysSorter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueCanonicalizer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/PersistentMapBase";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "appendData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canonicalize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

