/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class ImmutableList<E>
extends AbstractCollection<E>
implements List<E> {
    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public boolean addAll(int index2, @NotNull Collection<? extends E> c2) {
        if (c2 == null) {
            ImmutableList.$$$reportNull$$$0(0);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index2, E element2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index2, E element2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o2) {
        ListIterator<E> it = this.listIterator();
        if (o2 == null) {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                return it.previousIndex();
            }
        } else {
            while (it.hasNext()) {
                if (!o2.equals(it.next())) continue;
                return it.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o2) {
        ListIterator<E> it = this.listIterator(this.size());
        if (o2 == null) {
            while (it.hasPrevious()) {
                if (it.previous() != null) continue;
                return it.nextIndex();
            }
        } else {
            while (it.hasPrevious()) {
                if (!o2.equals(it.previous())) continue;
                return it.nextIndex();
            }
        }
        return -1;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        ListIterator<E> listIterator = this.listIterator(0);
        if (listIterator == null) {
            ImmutableList.$$$reportNull$$$0(1);
        }
        return listIterator;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index2) {
        return new ListItr(index2);
    }

    @Override
    @NotNull
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        if (this instanceof SubList) {
            List original = ((SubList)this).l;
            int originalOffset = ((SubList)this).offset;
            return new SubList(original, fromIndex + originalOffset, toIndex + originalOffset);
        }
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        ListIterator<E> e1 = this.listIterator();
        ListIterator e2 = ((List)o2).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o22;
            E o1 = e1.next();
            if (Objects.equals(o1, o22 = e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e2 : this) {
            hashCode = 31 * hashCode + (e2 == null ? 0 : e2.hashCode());
        }
        return hashCode;
    }

    @Contract(value="_ -> new")
    @NotNull
    static <T> ImmutableList<T> singleton(T element2) {
        return new Singleton<T>(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ImmutableList";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ImmutableList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listIterator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ImmutableList.this.size();
        }

        @Override
        public E next() {
            try {
                int i2 = this.cursor;
                Object next = ImmutableList.this.get(i2);
                this.lastRet = i2;
                this.cursor = i2 + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e2) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index2) {
            this.cursor = index2;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            try {
                int i2 = this.cursor - 1;
                Object previous = ImmutableList.this.get(i2);
                this.lastRet = this.cursor = i2;
                return previous;
            }
            catch (IndexOutOfBoundsException e2) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e2) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SubList<E>
    extends ImmutableList<E> {
        private final List<? extends E> l;
        private final int offset;
        private final int size;

        SubList(@NotNull List<? extends E> list, int fromIndex, int toIndex) {
            if (list == null) {
                SubList.$$$reportNull$$$0(0);
            }
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > list.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            this.l = list;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        @Override
        public E get(int index2) {
            if (index2 < 0 || index2 >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.size);
            }
            return this.l.get(index2 + this.offset);
        }

        @Override
        public int size() {
            return this.size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ImmutableList$SubList", "<init>"));
        }
    }

    private static final class Singleton<E>
    extends ImmutableList<E> {
        private final E element;

        Singleton(E e2) {
            this.element = e2;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public E get(int index2) {
            if (index2 != 0) {
                throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.size());
            }
            return this.element;
        }
    }
}

