/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.PsiLoopStatementImpl;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PatternResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class PsiWhileStatementImpl
extends PsiLoopStatementImpl
implements PsiWhileStatement,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiWhileStatementImpl.class);

    public PsiWhileStatementImpl() {
        super(WHILE_STATEMENT);
    }

    @Override
    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public PsiStatement getBody() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(38);
    }

    @Override
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 35: {
                return this.findChildByType(WHILE_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 38: 
        }
        return PsiImplUtil.findStatementChild(this);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == WHILE_KEYWORD) {
            return 35;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            return 38;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitWhileStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ElementClassHint elementClassHint;
        if (processor == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(2);
        }
        if (state == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(4);
        }
        if ((elementClassHint = processor.getHint(ElementClassHint.KEY)) != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        if (lastParent == null) {
            return PsiWhileStatementImpl.processDeclarationsInLoopCondition(processor, state, place, this);
        }
        PsiExpression condition = this.getCondition();
        if (condition != null && lastParent == this.getBody()) {
            return condition.processDeclarations(processor, PatternResolveState.WHEN_TRUE.putInto(state), null, place);
        }
        return true;
    }

    static boolean processDeclarationsInLoopCondition(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiConditionalLoopStatement loop) {
        if (processor == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(7);
        }
        if (loop == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(8);
        }
        if (state.get(PatternResolveState.KEY) == PatternResolveState.WHEN_NONE) {
            return true;
        }
        PsiExpression condition = loop.getCondition();
        if (condition == null) {
            return true;
        }
        PsiScopeProcessor conditionProcessor = (element2, s2) -> {
            assert (element2 instanceof PsiPatternVariable);
            NameHint hint = processor.getHint(NameHint.KEY);
            if (hint != null && !((PsiPatternVariable)element2).getName().equals(hint.getName(s2))) {
                return true;
            }
            PatternResolveState resolveState = PatternResolveState.stateAtParent((PsiPatternVariable)element2, condition);
            if (resolveState == PatternResolveState.WHEN_TRUE || !PsiTreeUtil.processElements(loop, e -> !(e instanceof PsiBreakStatement) || ((PsiBreakStatement)e).findExitedStatement() != loop)) {
                return true;
            }
            return processor.execute(element2, s2);
        };
        return condition.processDeclarations(conditionProcessor, PatternResolveState.WHEN_BOTH.putInto(state), null, place);
    }

    @Override
    public String toString() {
        return "PsiWhileStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loop";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiWhileStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarationsInLoopCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

