/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.fasterxml.aalto.UncheckedStreamException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.SafeStAXStreamBuilder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.xml.dom.StaxFactory;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Attribute;
import org.jdom.CloneBase;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDOMUtil {
    @NonNls
    private static final String X = "x";
    @NonNls
    private static final String Y = "y";
    @NonNls
    private static final String WIDTH = "width";
    @NonNls
    private static final String HEIGHT = "height";
    public static final Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace("xi", "http://www.w3.org/2001/XInclude");
    public static final Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");
    private static final Predicate<Content> CONTENT_FILTER = content -> !(content instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)content).getText());
    @NotNull
    private static final Format DEFAULT_FORMAT = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setLineSeparator("\n");

    private JDOMUtil() {
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent2) {
        List<Object> list = parent2 == null ? Collections.emptyList() : parent2.getChildren();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent2, @NotNull String name2) {
        if (name2 == null) {
            JDOMUtil.$$$reportNull$$$0(1);
        }
        if (parent2 != null) {
            List<Element> list = parent2.getChildren(name2);
            if (list == null) {
                JDOMUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<Element> list = Collections.emptyList();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static Logger getLogger() {
        return LoggerHolder.LOG;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        return JDOMUtil.areElementsEqual(e1, e2, false);
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Objects.equals(e1.getName(), e2.getName()) && JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(e1), JDOMUtil.getAttributes(e2), ignoreEmptyAttrValues) && JDOMUtil.areElementContentsEqual(e1, e2, ignoreEmptyAttrValues);
    }

    public static int hashCode(@Nullable Element e, boolean ignoreEmptyAttrValues) {
        if (e == null) {
            return 0;
        }
        int hashCode = e.getName().hashCode();
        for (Attribute attribute : JDOMUtil.getAttributes(e)) {
            String value2 = attribute.getValue();
            if (ignoreEmptyAttrValues && (value2 == null || value2.isEmpty())) continue;
            hashCode = hashCode * 31 * 31 + attribute.getName().hashCode() * 31 + value2.hashCode();
        }
        Iterator iterator2 = e.content().filter(CONTENT_FILTER).iterator();
        while (iterator2.hasNext()) {
            Content content = (Content)iterator2.next();
            int contentHash = content instanceof Element ? JDOMUtil.hashCode((Element)content, ignoreEmptyAttrValues) : e.getValue().hashCode();
            hashCode = hashCode * 31 + contentHash;
        }
        return hashCode;
    }

    private static boolean areElementContentsEqual(@NotNull Element e1, @NotNull Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null) {
            JDOMUtil.$$$reportNull$$$0(4);
        }
        if (e2 == null) {
            JDOMUtil.$$$reportNull$$$0(5);
        }
        return JDOMUtil.contentListsEqual(e1.content().filter(CONTENT_FILTER), e2.content().filter(CONTENT_FILTER), ignoreEmptyAttrValues);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Element @NotNull [] getElements(@NotNull Element m4) {
        if (m4 == null) {
            JDOMUtil.$$$reportNull$$$0(6);
        }
        List<Element> list = m4.getChildren();
        Element[] elementArray = list.toArray(new Element[0]);
        if (elementArray == null) {
            JDOMUtil.$$$reportNull$$$0(7);
        }
        return elementArray;
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        if (str == null) {
            JDOMUtil.$$$reportNull$$$0(8);
        }
        String string2 = JDOMUtil.legalizeChars(str).toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        if (str == null) {
            JDOMUtil.$$$reportNull$$$0(10);
        }
        StringBuilder result2 = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            JDOMUtil.appendLegalized(result2, str.charAt(i));
        }
        StringBuilder stringBuilder = result2;
        if (stringBuilder == null) {
            JDOMUtil.$$$reportNull$$$0(11);
        }
        return stringBuilder;
    }

    private static void appendLegalized(@NotNull @NonNls StringBuilder sb, char each) {
        if (sb == null) {
            JDOMUtil.$$$reportNull$$$0(12);
        }
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter(each)) {
            String s2 = Long.toHexString(each);
            sb.append("0x").append(s2.toUpperCase(Locale.ENGLISH));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentListsEqual(@NotNull Stream<Content> c1, @NotNull Stream<Content> c2, boolean ignoreEmptyAttrValues) {
        if (c1 == null) {
            JDOMUtil.$$$reportNull$$$0(13);
        }
        if (c2 == null) {
            JDOMUtil.$$$reportNull$$$0(14);
        }
        Iterator l1 = c1.iterator();
        Iterator l2 = c2.iterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next(), ignoreEmptyAttrValues)) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2, boolean ignoreEmptyAttrValues) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2, ignoreEmptyAttrValues);
    }

    private static boolean isAttributesEqual(@NotNull List<? extends Attribute> l1, @NotNull List<? extends Attribute> l2, boolean ignoreEmptyAttrValues) {
        if (l1 == null) {
            JDOMUtil.$$$reportNull$$$0(15);
        }
        if (l2 == null) {
            JDOMUtil.$$$reportNull$$$0(16);
        }
        if (ignoreEmptyAttrValues) {
            l1 = JDOMUtil.getNotEmptyAttributes(l1);
            l2 = JDOMUtil.getNotEmptyAttributes(l2);
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (JDOMUtil.attributesEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<? extends Attribute> getNotEmptyAttributes(@NotNull List<? extends Attribute> list) {
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(17);
        }
        if (list.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                JDOMUtil.$$$reportNull$$$0(18);
            }
            return list2;
        }
        ArrayList<Attribute> result2 = null;
        for (Attribute attribute : list) {
            String s2 = attribute.getValue();
            if (s2 == null || s2.isEmpty()) continue;
            if (result2 == null) {
                result2 = new ArrayList<Attribute>(list.size());
            }
            result2.add(attribute);
        }
        List<Object> list3 = result2 == null ? Collections.emptyList() : result2;
        if (list3 == null) {
            JDOMUtil.$$$reportNull$$$0(19);
        }
        return list3;
    }

    private static boolean attributesEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        if (a1 == null) {
            JDOMUtil.$$$reportNull$$$0(20);
        }
        if (a2 == null) {
            JDOMUtil.$$$reportNull$$$0(21);
        }
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static Document loadDocumentUsingStaX(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(22);
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(stream);
        Document document = SafeStAXStreamBuilder.buildDocument(xmlStreamReader);
        xmlStreamReader.close();
        Document document2 = document;
        if (document2 == null) {
            JDOMUtil.$$$reportNull$$$0(23);
        }
        return document2;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (UncheckedStreamException | XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static Element loadUsingStaX(@NotNull InputStream stream, @Nullable SafeJdomFactory factory2) throws JDOMException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(24);
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(stream);
        Element element2 = SafeStAXStreamBuilder.build(xmlStreamReader, true, true, factory2 == null ? SafeStAXStreamBuilder.FACTORY : factory2);
        xmlStreamReader.close();
        Element element3 = element2;
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(25);
        }
        return element3;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (UncheckedStreamException | XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
    }

    @NotNull
    public static Element load(@NotNull CharSequence seq) throws IOException, JDOMException {
        if (seq == null) {
            JDOMUtil.$$$reportNull$$$0(26);
        }
        Element element2 = JDOMUtil.load(new CharSequenceReader(seq));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(27);
        }
        return element2;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull File file2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(28);
        }
        return JDOMUtil.loadDocumentUsingStaX(new FileInputStream(file2));
    }

    @NotNull
    public static Element load(@NotNull File file2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(29);
        }
        return JDOMUtil.loadUsingStaX(new FileInputStream(file2), null);
    }

    @NotNull
    public static Element load(@NotNull Path file2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(30);
        }
        try {
            return JDOMUtil.loadUsingStaX(Files.newInputStream(file2, new OpenOption[0]), null);
        }
        catch (ClosedFileSystemException e) {
            throw new IOException("Cannot read file from closed file system: " + file2, e);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull File file2, @Nullable SafeJdomFactory factory2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(31);
        }
        return JDOMUtil.loadUsingStaX(new FileInputStream(file2), factory2);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull Path file2, @Nullable SafeJdomFactory factory2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(32);
        }
        try {
            return JDOMUtil.loadUsingStaX(Files.newInputStream(file2, new OpenOption[0]), factory2);
        }
        catch (ClosedFileSystemException e) {
            throw new IOException("Cannot read file from closed file system: " + file2, e);
        }
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(33);
        }
        return JDOMUtil.loadDocumentUsingStaX(stream);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(Reader reader) throws JDOMException, IOException {
        Element element2;
        if (reader == null) {
            return null;
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(reader);
        try {
            element2 = SafeStAXStreamBuilder.build(xmlStreamReader, true, true, SafeStAXStreamBuilder.FACTORY);
        }
        catch (Throwable throwable) {
            try {
                xmlStreamReader.close();
                throw throwable;
            }
            catch (UncheckedStreamException | XMLStreamException e) {
                throw new JDOMException(e.getMessage(), e);
            }
        }
        xmlStreamReader.close();
        return element2;
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.loadUsingStaX(stream, null);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static Element load(byte @NotNull [] data) throws JDOMException, IOException {
        if (data == null) {
            JDOMUtil.$$$reportNull$$$0(34);
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(data);
        Element element2 = SafeStAXStreamBuilder.build(xmlStreamReader, true, true, SafeStAXStreamBuilder.FACTORY);
        xmlStreamReader.close();
        Element element3 = element2;
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(35);
        }
        return element3;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (UncheckedStreamException | XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull InputStream stream, @Nullable SafeJdomFactory factory2) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(36);
        }
        return JDOMUtil.loadUsingStaX(stream, factory2);
    }

    @NotNull
    public static Element load(@NotNull Class<?> clazz, @NotNull String resource) throws JDOMException, IOException {
        InputStream stream;
        if (clazz == null) {
            JDOMUtil.$$$reportNull$$$0(37);
        }
        if (resource == null) {
            JDOMUtil.$$$reportNull$$$0(38);
        }
        if ((stream = clazz.getResourceAsStream(resource)) == null) {
            throw new FileNotFoundException(resource);
        }
        Element element2 = JDOMUtil.load(stream);
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(39);
        }
        return element2;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(40);
        }
        return JDOMUtil.loadDocumentUsingStaX(URLUtil.openStream(url));
    }

    @NotNull
    public static Element load(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(41);
        }
        Element element2 = JDOMUtil.load(URLUtil.openStream(url));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(42);
        }
        return element2;
    }

    @NotNull
    public static Element loadResource(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(43);
        }
        Element element2 = JDOMUtil.load(URLUtil.openResourceStream(url));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(44);
        }
        return element2;
    }

    public static void writeDocument(@NotNull Document document, @NotNull String filePath2, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(45);
        }
        if (filePath2 == null) {
            JDOMUtil.$$$reportNull$$$0(46);
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath2));){
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull File file2, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(47);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(48);
        }
        JDOMUtil.write((Parent)document, file2, lineSeparator);
    }

    public static void write(@NotNull Element element2, @NotNull Path file2) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(49);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(50);
        }
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file2, new OpenOption[0]);){
            JDOMUtil.createOutputter("\n").output(element2, (Writer)writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element2, "");
        }
    }

    public static void write(@NotNull Parent element2, @NotNull File file2) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(51);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(52);
        }
        JDOMUtil.write(element2, file2, "\n");
    }

    public static void write(@NotNull Parent element2, @NotNull File file2, @NotNull String lineSeparator) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(53);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(54);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(55);
        }
        FileUtilRt.createParentDirs(file2);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file2));){
            JDOMUtil.write(element2, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(56);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(57);
        }
        JDOMUtil.write((Parent)document, stream, lineSeparator);
    }

    public static void write(@NotNull Parent element2, @NotNull OutputStream stream) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(58);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(59);
        }
        JDOMUtil.write(element2, stream, "\n");
    }

    public static void write(@NotNull Parent element2, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(60);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(61);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(62);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            if (element2 instanceof Document) {
                JDOMUtil.writeDocument((Document)element2, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((Element)element2, writer, lineSeparator);
            }
        }
    }

    @NotNull
    public static String writeDocument(@NotNull Document document, String lineSeparator) {
        String string2;
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(63);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            string2 = writer.toString();
        }
        catch (IOException ignored) {
            return "";
        }
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(64);
        }
        return string2;
    }

    @NotNull
    public static String write(@NotNull Element element2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(65);
        }
        return JDOMUtil.writeElement(element2);
    }

    @NotNull
    public static String write(@NotNull Parent element2, String lineSeparator) {
        String string2;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(66);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.write(element2, writer, lineSeparator);
            string2 = writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(67);
        }
        return string2;
    }

    public static void write(Parent element2, Writer writer, String lineSeparator) throws IOException {
        if (element2 instanceof Element) {
            JDOMUtil.writeElement((Element)element2, writer, lineSeparator);
        } else if (element2 instanceof Document) {
            JDOMUtil.writeDocument((Document)element2, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull Element element2, Writer writer, String lineSeparator) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(68);
        }
        try {
            JDOMUtil.createOutputter(lineSeparator).output(element2, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element2, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(69);
        }
        return JDOMUtil.writeElement(element2, "\n");
    }

    @NotNull
    public static String writeElement(@NotNull Element element2, String lineSeparator) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(70);
        }
        StringWriter writer = new StringWriter();
        try {
            JDOMUtil.createOutputter(lineSeparator).output(element2, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element2, "");
        }
        String string2 = writer.toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(71);
        }
        return string2;
    }

    @NotNull
    public static String writeChildren(@NotNull Element element2, @NotNull String lineSeparator) throws IOException {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(72);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(73);
        }
        StringWriter writer = new StringWriter();
        for (Element child : element2.getChildren()) {
            JDOMUtil.writeElement(child, writer, lineSeparator);
            writer.append(lineSeparator);
        }
        String string2 = writer.toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(74);
        }
        return string2;
    }

    private static void writeDocument(@NotNull Document document, @NotNull Writer writer, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(75);
        }
        if (writer == null) {
            JDOMUtil.$$$reportNull$$$0(76);
        }
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException e) {
            JDOMUtil.getLogger().error(e);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static Format createFormat(@Nullable String lineSeparator) {
        if (lineSeparator == null || lineSeparator.equals("\n")) {
            Format format = DEFAULT_FORMAT;
            if (format == null) {
                JDOMUtil.$$$reportNull$$$0(77);
            }
            return format;
        }
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setLineSeparator(lineSeparator);
        if (format == null) {
            JDOMUtil.$$$reportNull$$$0(78);
        }
        return format;
    }

    @ApiStatus.Internal
    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        return new MyXMLOutputter(lineSeparator);
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(79);
        }
        return JDOMUtil.escapeText(text, false, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(80);
        }
        return JDOMUtil.escapeText(text, false, escapeSpaces, escapeLineEnds);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(81);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            buffer = XmlStringUtil.appendEscapedSymbol(text, buffer, i, quotation, ch);
        }
        String string2 = buffer == null ? text : buffer.toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(82);
        }
        return string2;
    }

    private static void printDiagnostics(@NotNull Element element2, String prefix) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(83);
        }
        ElementInfo info = JDOMUtil.getElementInfo(element2);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element2.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(84);
        }
        boolean hasNullAttributes = false;
        StringBuilder buf = new StringBuilder(element2.getName());
        List<Attribute> attributes = JDOMUtil.getAttributes(element2);
        int length = attributes.size();
        if (length > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                hasNullAttributes = true;
            }
            buf.append("]");
        }
        return new ElementInfo(buf, hasNullAttributes);
    }

    public static void updateFileSet(File @NotNull [] oldFiles, String @NotNull [] newFilePaths, Document @NotNull [] newFileDocuments, String lineSeparator) throws IOException {
        if (oldFiles == null) {
            JDOMUtil.$$$reportNull$$$0(85);
        }
        if (newFilePaths == null) {
            JDOMUtil.$$$reportNull$$$0(86);
        }
        if (newFileDocuments == null) {
            JDOMUtil.$$$reportNull$$$0(87);
        }
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        for (String newFilePath : newFilePaths) {
            File file2 = new File(newFilePath);
            if (!file2.exists() || file2.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file3 : oldFiles) {
            if (!file3.exists() || file3.canWrite()) continue;
            throw new IOException("File \"" + file3.getAbsolutePath() + "\" is not writeable");
        }
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result2 = oldFile.delete();
            if (result2) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    public static boolean isEmpty(@Nullable Element element2) {
        return element2 == null || element2.isEmpty();
    }

    public static boolean isEmpty(@Nullable Element element2, int attributeCount) {
        return element2 == null || JDOMUtil.getAttributes(element2).size() == attributeCount && element2.getContent().isEmpty();
    }

    @NotNull
    public static List<Attribute> getAttributes(@NotNull Element e) {
        if (e == null) {
            JDOMUtil.$$$reportNull$$$0(88);
        }
        List<Attribute> list = e.hasAttributes() ? e.getAttributes() : Collections.emptyList();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(89);
        }
        return list;
    }

    @Contract(value="_, !null -> !null; !null, _ -> !null")
    @Nullable
    public static Element merge(@Nullable Element to, @Nullable Element from2) {
        if (from2 == null) {
            return to;
        }
        if (to == null) {
            return from2;
        }
        Iterator<CloneBase> iterator2 = from2.getChildren().iterator();
        while (iterator2.hasNext()) {
            Element configuration2 = iterator2.next();
            iterator2.remove();
            to.addContent(configuration2);
        }
        iterator2 = JDOMUtil.getAttributes(from2).iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            iterator2.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    @NotNull
    public static Element deepMerge(@NotNull Element to, @NotNull Element from2) {
        if (to == null) {
            JDOMUtil.$$$reportNull$$$0(90);
        }
        if (from2 == null) {
            JDOMUtil.$$$reportNull$$$0(91);
        }
        return JDOMUtil.deepMergeWithAttributes(to, from2, Collections.emptyList());
    }

    @NotNull
    public static Element deepMergeWithAttributes(@NotNull Element to, @NotNull Element from2, @NotNull List<? extends MergeAttribute> mergeByAttributes) {
        if (to == null) {
            JDOMUtil.$$$reportNull$$$0(92);
        }
        if (from2 == null) {
            JDOMUtil.$$$reportNull$$$0(93);
        }
        if (mergeByAttributes == null) {
            JDOMUtil.$$$reportNull$$$0(94);
        }
        Iterator<CloneBase> iterator2 = from2.getChildren().iterator();
        while (iterator2.hasNext()) {
            Element child = iterator2.next();
            iterator2.remove();
            Element existingChild = to.getChild(child.getName());
            if (existingChild != null && JDOMUtil.isEmpty(existingChild)) {
                to.removeChild(child.getName());
                existingChild = null;
            }
            if (existingChild == null || existingChild.getChildren().isEmpty() || !JDOMUtil.areAttributesEqual(JDOMUtil.getAttributes(existingChild), JDOMUtil.getAttributes(child), existingChild, mergeByAttributes)) {
                to.addContent(child);
                continue;
            }
            JDOMUtil.deepMergeWithAttributes(existingChild, child, mergeByAttributes);
        }
        iterator2 = JDOMUtil.getAttributes(from2).iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            iterator2.remove();
            to.setAttribute(attribute);
        }
        Element element2 = to;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(95);
        }
        return element2;
    }

    private static boolean areAttributesEqual(@NotNull List<? extends Attribute> l1, @NotNull List<? extends Attribute> l2, @NotNull Element base, @NotNull List<? extends MergeAttribute> mergeByAttributes) {
        Set attributes;
        if (l1 == null) {
            JDOMUtil.$$$reportNull$$$0(96);
        }
        if (l2 == null) {
            JDOMUtil.$$$reportNull$$$0(97);
        }
        if (base == null) {
            JDOMUtil.$$$reportNull$$$0(98);
        }
        if (mergeByAttributes == null) {
            JDOMUtil.$$$reportNull$$$0(99);
        }
        if ((attributes = mergeByAttributes.stream().filter(o -> o.elementName.equals(base.getName())).map(o -> o.attributeName).collect(Collectors.toSet())).isEmpty()) {
            return JDOMUtil.isAttributesEqual(l1, l2, false);
        }
        Map<String, String> secondMap = l2.stream().collect(Collectors.toMap(Attribute::getName, Attribute::getValue));
        return l1.stream().filter(o -> attributes.contains(o.getName())).allMatch(o -> o.getValue().equals(secondMap.get(o.getName())));
    }

    @Nullable
    public static Element reduceChildren(@NotNull String name2, @NotNull Element parent2) {
        List<Element> children2;
        Iterator<Element> it;
        if (name2 == null) {
            JDOMUtil.$$$reportNull$$$0(100);
        }
        if (parent2 == null) {
            JDOMUtil.$$$reportNull$$$0(101);
        }
        if (!(it = (children2 = parent2.getChildren(name2)).iterator()).hasNext()) {
            return null;
        }
        Element accumulator = it.next();
        while (it.hasNext()) {
            JDOMUtil.merge(accumulator, it.next());
            it.remove();
        }
        return accumulator;
    }

    @NotNull
    public static Element internElement(@NotNull Element element2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(102);
        }
        Element element3 = JDOMInterner.INSTANCE.internElement(element2);
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(103);
        }
        return element3;
    }

    @NotNull
    public static String removeControlChars(@NotNull String text) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(104);
        }
        StringBuilder result2 = null;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Verifier.isXMLCharacter(c)) {
                if (result2 != null) continue;
                result2 = new StringBuilder(text.length());
                result2.append(text, 0, i);
                continue;
            }
            if (result2 == null) continue;
            result2.append(c);
        }
        String string2 = result2 == null ? text : result2.toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(105);
        }
        return string2;
    }

    @Nullable
    public static Point getLocation(@Nullable Element element2) {
        return element2 == null ? null : JDOMUtil.getLocation(element2, X, Y);
    }

    @Nullable
    public static Point getLocation(@NotNull Element element2, @NotNull String x, @NotNull String y) {
        String sX;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(106);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(107);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(108);
        }
        if ((sX = element2.getAttributeValue(x)) == null) {
            return null;
        }
        String sY = element2.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        try {
            return new Point(Integer.parseInt(sX), Integer.parseInt(sY));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setLocation(@NotNull Element element2, @NotNull Point location2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(109);
        }
        if (location2 == null) {
            JDOMUtil.$$$reportNull$$$0(110);
        }
        return JDOMUtil.setLocation(element2, X, Y, location2);
    }

    @NotNull
    public static Element setLocation(@NotNull Element element2, @NotNull String x, @NotNull String y, @NotNull Point location2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(111);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(112);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(113);
        }
        if (location2 == null) {
            JDOMUtil.$$$reportNull$$$0(114);
        }
        Element element3 = element2.setAttribute(x, Integer.toString(location2.x)).setAttribute(y, Integer.toString(location2.y));
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(115);
        }
        return element3;
    }

    @Nullable
    public static Dimension getSize(@Nullable Element element2) {
        return element2 == null ? null : JDOMUtil.getSize(element2, WIDTH, HEIGHT);
    }

    @Nullable
    public static Dimension getSize(@NotNull Element element2, @NotNull String width, @NotNull String height) {
        String sWidth;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(116);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(117);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(118);
        }
        if ((sWidth = element2.getAttributeValue(width)) == null) {
            return null;
        }
        String sHeight = element2.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Dimension(iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setSize(@NotNull Element element2, @NotNull Dimension size) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(119);
        }
        if (size == null) {
            JDOMUtil.$$$reportNull$$$0(120);
        }
        return JDOMUtil.setSize(element2, WIDTH, HEIGHT, size);
    }

    @NotNull
    public static Element setSize(@NotNull Element element2, @NotNull String width, @NotNull String height, @NotNull Dimension size) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(121);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(122);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(123);
        }
        if (size == null) {
            JDOMUtil.$$$reportNull$$$0(124);
        }
        Element element3 = element2.setAttribute(width, Integer.toString(size.width)).setAttribute(height, Integer.toString(size.height));
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(125);
        }
        return element3;
    }

    @Nullable
    public static Rectangle getBounds(@Nullable Element element2) {
        return element2 == null ? null : JDOMUtil.getBounds(element2, X, Y, WIDTH, HEIGHT);
    }

    @Nullable
    public static Rectangle getBounds(@NotNull Element element2, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height) {
        String sX;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(126);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(127);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(128);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(129);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(130);
        }
        if ((sX = element2.getAttributeValue(x)) == null) {
            return null;
        }
        String sY = element2.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        String sWidth = element2.getAttributeValue(width);
        if (sWidth == null) {
            return null;
        }
        String sHeight = element2.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Rectangle(Integer.parseInt(sX), Integer.parseInt(sY), iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setBounds(@NotNull Element element2, @NotNull Rectangle bounds2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(131);
        }
        if (bounds2 == null) {
            JDOMUtil.$$$reportNull$$$0(132);
        }
        return JDOMUtil.setBounds(element2, X, Y, WIDTH, HEIGHT, bounds2);
    }

    @NotNull
    public static Element setBounds(@NotNull Element element2, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height, @NotNull Rectangle bounds2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(133);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(134);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(135);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(136);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(137);
        }
        if (bounds2 == null) {
            JDOMUtil.$$$reportNull$$$0(138);
        }
        Element element3 = element2.setAttribute(x, Integer.toString(bounds2.x)).setAttribute(y, Integer.toString(bounds2.y)).setAttribute(width, Integer.toString(bounds2.width)).setAttribute(height, Integer.toString(bounds2.height));
        if (element3 == null) {
            JDOMUtil.$$$reportNull$$$0(139);
        }
        return element3;
    }

    public static void copyMissingContent(@NotNull Element source, @NotNull Element target) {
        if (source == null) {
            JDOMUtil.$$$reportNull$$$0(140);
        }
        if (target == null) {
            JDOMUtil.$$$reportNull$$$0(141);
        }
        Element targetClone = target.clone();
        for (Attribute attribute : source.getAttributes()) {
            if (JDOMUtil.hasAttribute(targetClone, attribute.getName())) continue;
            target.setAttribute(attribute.clone());
        }
        for (Content content : source.getContent()) {
            if (JDOMUtil.hasContent(targetClone, content)) continue;
            target.addContent(content.clone());
        }
    }

    private static boolean hasAttribute(@NotNull Element element2, @NotNull String name2) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(142);
        }
        if (name2 == null) {
            JDOMUtil.$$$reportNull$$$0(143);
        }
        return element2.getAttribute(name2) != null;
    }

    private static boolean hasContent(@NotNull Element element2, @NotNull Content content) {
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(144);
        }
        if (content == null) {
            JDOMUtil.$$$reportNull$$$0(145);
        }
        return content instanceof Element && !element2.getChildren(((Element)content).getName()).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 1: 
            case 100: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 15: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 16: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 22: 
            case 24: 
            case 33: 
            case 36: 
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 48: 
            case 50: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 40: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 45: 
            case 47: 
            case 56: 
            case 63: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 49: 
            case 51: 
            case 53: 
            case 58: 
            case 60: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 83: 
            case 84: 
            case 102: 
            case 106: 
            case 109: 
            case 111: 
            case 116: 
            case 119: 
            case 121: 
            case 126: 
            case 131: 
            case 133: 
            case 142: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 55: 
            case 62: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFiles";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilePaths";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileDocuments";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 94: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeByAttributes";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 107: 
            case 112: 
            case 127: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = X;
                break;
            }
            case 108: 
            case 113: 
            case 128: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = Y;
                break;
            }
            case 110: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 117: 
            case 122: 
            case 129: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = WIDTH;
                break;
            }
            case 118: 
            case 123: 
            case 130: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = HEIGHT;
                break;
            }
            case 120: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 132: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeChars";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotEmptyAttributes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocumentUsingStaX";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUsingStaX";
                break;
            }
            case 27: 
            case 35: 
            case 39: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResource";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "writeDocument";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "writeElement";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChildren";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormat";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeText";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "deepMergeWithAttributes";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "internElement";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "removeControlChars";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocation";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "setSize";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "setBounds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areElementContentsEqual";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "legalizeText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "legalizeChars";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendLegalized";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "contentListsEqual";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAttributesEqual";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNotEmptyAttributes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "attributesEqual";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadDocumentUsingStaX";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadUsingStaX";
                break;
            }
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 28: 
            case 33: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "loadDocument";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "loadResource";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 56: 
            case 57: 
            case 63: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "writeDocument";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "writeElement";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "writeChildren";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "printDiagnostics";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "updateFileSet";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "deepMerge";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "deepMergeWithAttributes";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "areAttributesEqual";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "reduceChildren";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "removeControlChars";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "setSize";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getBounds";
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "setBounds";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "copyMissingContent";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "hasContent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LoggerHolder {
        private static final Logger LOG = Logger.getInstance(JDOMUtil.class);

        private LoggerHolder() {
        }
    }

    private static final class MyXMLOutputter
    extends XMLOutputter {
        private MyXMLOutputter(@NotNull String lineSeparator) {
            if (lineSeparator == null) {
                MyXMLOutputter.$$$reportNull$$$0(0);
            }
            super(JDOMUtil.createFormat(lineSeparator));
        }

        @Override
        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(1);
            }
            String string2 = JDOMUtil.escapeText(str, false, true);
            if (string2 == null) {
                MyXMLOutputter.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(3);
            }
            String string2 = JDOMUtil.escapeText(str, false, false);
            if (string2 == null) {
                MyXMLOutputter.$$$reportNull$$$0(4);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineSeparator";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeAttributeEntities";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeElementEntities";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeAttributeEntities";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeElementEntities";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ElementInfo {
        @NotNull
        private final CharSequence name;
        private final boolean hasNullAttributes;

        private ElementInfo(@NotNull CharSequence name2, boolean attributes) {
            if (name2 == null) {
                ElementInfo.$$$reportNull$$$0(0);
            }
            this.name = name2;
            this.hasNullAttributes = attributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/JDOMUtil$ElementInfo", "<init>"));
        }
    }

    public static final class MergeAttribute {
        public String elementName;
        public String attributeName;

        public MergeAttribute(String elementName, String attributeName) {
            this.elementName = elementName;
            this.attributeName = attributeName;
        }
    }

    public static interface ElementOutputFilter {
        public boolean accept(@NotNull Element var1, int var2);
    }
}

