/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.CachedFieldsForObjectInstances;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmIrDeserializer;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.overrides.IrJavaIncompatibilityRulesOverridabilityCondition;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.utils.InjectedValue;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrExternalPackageFragmentImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import org.jetbrains.kotlin.ir.symbols.IrExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0018\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020A2\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010B\u001a\u00020C2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0010\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "irDeserializer", "Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "parametersAreAssignable", "", "getParametersAreAssignable", "()Z", "externalOverridabilityConditions", "", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "getExternalOverridabilityConditions", "()Ljava/util/List;", "classNameOverride", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassNameOverride", "()Ljava/util/Map;", "cachedFields", "Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "getCachedFields", "()Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "kotlinIrInternalPackage", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrExternalPackageFragmentImpl;", "kotlinJvmInternalPackage", "specialAnnotationConstructors", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "rawTypeAnnotationClassConstructor", "generateRawTypeAnnotationCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "createSpecialAnnotationClass", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "findInjectedValue", "Lorg/jetbrains/kotlin/fir/backend/utils/InjectedValue;", "calleeReference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "irNeedsDeserialization", "getIrNeedsDeserialization", "deserializeToplevelClass", "irClass", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "hasBackingField", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isTrueStatic", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "initializeIrBuiltInsAndSymbolTable", "", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nJvmFir2IrExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmFir2IrExtensions.kt\norg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class JvmFir2IrExtensions
implements Fir2IrExtensions,
JvmGeneratorExtensions {
    @NotNull
    private final JvmIrDeserializer irDeserializer;
    @Nullable
    private IrBuiltIns irBuiltIns;
    @Nullable
    private SymbolTable symbolTable;
    @NotNull
    private final Map<IrClass, JvmClassName> classNameOverride;
    @NotNull
    private final CachedFieldsForObjectInstances cachedFields;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinIrInternalPackage;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinJvmInternalPackage;
    @NotNull
    private final List<IrConstructor> specialAnnotationConstructors;
    @NotNull
    private final IrConstructor rawTypeAnnotationClassConstructor;
    private final boolean irNeedsDeserialization;

    public JvmFir2IrExtensions(@NotNull CompilerConfiguration configuration2, @NotNull JvmIrDeserializer irDeserializer) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)irDeserializer, (String)"irDeserializer");
        this.irDeserializer = irDeserializer;
        this.classNameOverride = new LinkedHashMap();
        this.cachedFields = new CachedFieldsForObjectInstances(IrFactoryImpl.INSTANCE, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2));
        this.kotlinIrInternalPackage = new IrExternalPackageFragmentImpl(new DescriptorlessExternalPackageFragmentSymbol(), IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN());
        IrExternalPackageFragmentSymbol irExternalPackageFragmentSymbol = new DescriptorlessExternalPackageFragmentSymbol();
        FqName fqName = JvmAnnotationNames.KOTLIN_JVM_INTERNAL;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"KOTLIN_JVM_INTERNAL");
        this.kotlinJvmInternalPackage = new IrExternalPackageFragmentImpl(irExternalPackageFragmentSymbol, fqName);
        this.specialAnnotationConstructors = new ArrayList();
        this.rawTypeAnnotationClassConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(this.createSpecialAnnotationClass(JvmSymbols.Companion.getRAW_TYPE_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage)));
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ENHANCED_NULLABILITY_ANNOTATION");
        this.createSpecialAnnotationClass(fqName2, this.kotlinJvmInternalPackage);
        this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_MUTABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.irNeedsDeserialization = configuration2.get(JVMConfigurationKeys.SERIALIZE_IR, JvmSerializeIrMode.NONE) != JvmSerializeIrMode.NONE;
    }

    @Override
    public boolean getParametersAreAssignable() {
        return true;
    }

    @Override
    @NotNull
    public List<IrExternalOverridabilityCondition> getExternalOverridabilityConditions() {
        return CollectionsKt.listOf((Object)new IrJavaIncompatibilityRulesOverridabilityCondition());
    }

    @Override
    @NotNull
    public Map<IrClass, JvmClassName> getClassNameOverride() {
        return this.classNameOverride;
    }

    @Override
    @NotNull
    public CachedFieldsForObjectInstances getCachedFields() {
        return this.cachedFields;
    }

    @Override
    @NotNull
    public IrConstructorCall generateRawTypeAnnotationCall() {
        IrConstructor it = this.rawTypeAnnotationClassConstructor;
        boolean bl = false;
        return IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, IrUtilsKt.getConstructedClassType(it), it.getSymbol(), null, 16, null);
    }

    private final IrClass createSpecialAnnotationClass(FqName fqn, IrPackageFragment parent2) {
        IrClass irClass;
        IrClass $this$createSpecialAnnotationClass_u24lambda_u241 = irClass = IrUtilsKt.createSpecialAnnotationClass(IrFactoryImpl.INSTANCE, fqn, parent2);
        boolean bl = false;
        this.specialAnnotationConstructors.add((IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors($this$createSpecialAnnotationClass_u24lambda_u241)));
        return irClass;
    }

    @Override
    @Nullable
    public InjectedValue findInjectedValue(@NotNull FirReference calleeReference, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)calleeReference, (String)"calleeReference");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        return null;
    }

    @Override
    public boolean getIrNeedsDeserialization() {
        return this.irNeedsDeserialization;
    }

    @Override
    public boolean deserializeToplevelClass(@NotNull IrClass irClass, @NotNull Fir2IrComponents components) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        IrBuiltIns irBuiltIns = this.irBuiltIns;
        if (irBuiltIns == null) {
            throw new IllegalStateException("BuiltIns are not initialized".toString());
        }
        IrBuiltIns builtIns2 = irBuiltIns;
        SymbolTable symbolTable = this.symbolTable;
        if (symbolTable == null) {
            throw new IllegalStateException("SymbolTable is not initialized".toString());
        }
        SymbolTable symbolTable2 = symbolTable;
        return this.irDeserializer.deserializeTopLevelClass(irClass, builtIns2, symbolTable2, components.getIrProviders(), this);
    }

    @Override
    public boolean hasBackingField(@NotNull FirProperty property, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return property.getOrigin() instanceof FirDeclarationOrigin.Java || Fir2IrExtensions.Default.INSTANCE.hasBackingField(property, session);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTrueStatic(@NotNull FirCallableDeclaration declaration2, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (FirAnnotationUtilsKt.hasAnnotation(declaration2, StandardClassIds.Annotations.INSTANCE.getJvmStatic(), session)) return true;
        if (!(declaration2 instanceof FirPropertyAccessor)) return false;
        FirPropertyAccessor firPropertyAccessor = (FirPropertyAccessor)declaration2;
        Object object = firPropertyAccessor;
        if (firPropertyAccessor == null) return false;
        FirPropertySymbol firPropertySymbol = ((FirPropertyAccessor)object).getPropertySymbol();
        object = firPropertySymbol;
        if (firPropertySymbol == null) return false;
        FirProperty firProperty = (FirProperty)((FirBasedSymbol)object).getFir();
        object = firProperty;
        if (firProperty == null) return false;
        if (!FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)object, StandardClassIds.Annotations.INSTANCE.getJvmStatic(), session)) return false;
        return true;
    }

    @Override
    public void initializeIrBuiltInsAndSymbolTable(@NotNull IrBuiltIns irBuiltIns, @NotNull SymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        if (!(this.irBuiltIns == null)) {
            boolean $i$a$-require-JvmFir2IrExtensions$initializeIrBuiltInsAndSymbolTable$32 = false;
            String $i$a$-require-JvmFir2IrExtensions$initializeIrBuiltInsAndSymbolTable$32 = "BuiltIns are already initialized";
            throw new IllegalArgumentException($i$a$-require-JvmFir2IrExtensions$initializeIrBuiltInsAndSymbolTable$32.toString());
        }
        this.irBuiltIns = irBuiltIns;
        if (!(this.symbolTable == null)) {
            boolean bl = false;
            String string2 = "SymboTable is already initialized";
            throw new IllegalArgumentException(string2.toString());
        }
        this.symbolTable = symbolTable;
    }
}

