/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u0005\u001a\u0017\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0086\u0002\u001a\u0018\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u00020\f2\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\r\u001a\u00020\u0007*\u00020\f2\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\r\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\t\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0004\u0018\u00010\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"MODIFIER_KEYWORD_SET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getModifierList", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "Lorg/jetbrains/kotlin/KtSourceElement;", "contains", "", "token", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getModifier", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "Lorg/jetbrains/kotlin/fir/FirElement;", "hasModifier", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "valOrVarKeyword", "Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "getValOrVarKeyword", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirKeywordUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirKeywordUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirKeywordUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class FirKeywordUtilsKt {
    @NotNull
    private static final TokenSet MODIFIER_KEYWORD_SET;

    @Nullable
    public static final FirModifierList getModifierList(@Nullable KtSourceElement $this$getModifierList) {
        FirModifierList firModifierList;
        KtSourceElement ktSourceElement = $this$getModifierList;
        if (ktSourceElement == null) {
            firModifierList = null;
        } else if (ktSourceElement instanceof KtPsiSourceElement) {
            FirModifierList.FirPsiModifierList firPsiModifierList;
            PsiElement psiElement = ((KtPsiSourceElement)$this$getModifierList).getPsi();
            KtElement ktElement = psiElement instanceof KtModifierListOwner ? (KtModifierListOwner)psiElement : null;
            if (ktElement != null && (ktElement = ktElement.getModifierList()) != null) {
                KtElement it = ktElement;
                boolean bl = false;
                firPsiModifierList = new FirModifierList.FirPsiModifierList((KtModifierList)it);
            } else {
                firPsiModifierList = null;
            }
            firModifierList = firPsiModifierList;
        } else if (ktSourceElement instanceof KtLightSourceElement) {
            Object v3;
            block10: {
                Iterable iterable = LightTreeUtilsKt.getChildren(((KtLightSourceElement)$this$getModifierList).getLighterASTNode(), ((KtLightSourceElement)$this$getModifierList).getTreeStructure());
                for (Object t : iterable) {
                    LighterASTNode it = (LighterASTNode)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.MODIFIER_LIST)) continue;
                    v3 = t;
                    break block10;
                }
                v3 = null;
            }
            LighterASTNode lighterASTNode = v3;
            if (lighterASTNode == null) {
                return null;
            }
            LighterASTNode modifierListNode = lighterASTNode;
            int offsetDelta = ((KtLightSourceElement)$this$getModifierList).getStartOffset() - ((KtLightSourceElement)$this$getModifierList).getLighterASTNode().getStartOffset();
            firModifierList = new FirModifierList.FirLightModifierList(modifierListNode, ((KtLightSourceElement)$this$getModifierList).getTreeStructure(), offsetDelta);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firModifierList;
    }

    public static final boolean contains(@Nullable FirModifierList $this$contains, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        FirModifierList firModifierList = $this$contains;
        return firModifierList != null ? firModifierList.contains(token) : false;
    }

    @Nullable
    public static final FirModifier<?> getModifier(@NotNull FirElement $this$getModifier, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter((Object)$this$getModifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList($this$getModifier.getSource());
        return firModifierList != null ? firModifierList.get(token) : null;
    }

    public static final boolean hasModifier(@NotNull FirElement $this$hasModifier, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter((Object)$this$hasModifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return FirKeywordUtilsKt.contains(FirKeywordUtilsKt.getModifierList($this$hasModifier.getSource()), token);
    }

    public static final boolean hasModifier(@NotNull FirBasedSymbol<?> $this$hasModifier, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter($this$hasModifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return FirKeywordUtilsKt.hasModifier((FirElement)$this$hasModifier.getFir(), token);
    }

    @Nullable
    public static final KtKeywordToken getValOrVarKeyword(@Nullable KtSourceElement $this$valOrVarKeyword) {
        KtKeywordToken ktKeywordToken;
        KtSourceElement ktSourceElement = $this$valOrVarKeyword;
        if (ktSourceElement == null) {
            ktKeywordToken = null;
        } else if (ktSourceElement instanceof KtPsiSourceElement) {
            PsiElement psiElement = ((KtPsiSourceElement)$this$valOrVarKeyword).getPsi();
            PsiElement psiElement2 = psiElement instanceof KtValVarKeywordOwner ? (KtValVarKeywordOwner)psiElement : null;
            if (psiElement2 != null && (psiElement2 = psiElement2.getValOrVarKeyword()) != null) {
                IElementType iElementType;
                PsiElement it = psiElement2;
                boolean bl = false;
                ASTNode aSTNode = it.getNode();
                IElementType iElementType2 = iElementType = aSTNode != null ? aSTNode.getElementType() : null;
                ktKeywordToken = iElementType instanceof KtKeywordToken ? (KtKeywordToken)iElementType : null;
            } else {
                ktKeywordToken = null;
            }
        } else if (ktSourceElement instanceof KtLightSourceElement) {
            IElementType iElementType;
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.valOrVarKeyword(((KtLightSourceElement)$this$valOrVarKeyword).getTreeStructure(), ((KtLightSourceElement)$this$valOrVarKeyword).getLighterASTNode());
            IElementType iElementType3 = iElementType = lighterASTNode != null ? lighterASTNode.getTokenType() : null;
            ktKeywordToken = iElementType instanceof KtKeywordToken ? (KtKeywordToken)iElementType : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ktKeywordToken;
    }

    public static final /* synthetic */ TokenSet access$getMODIFIER_KEYWORD_SET$p() {
        return MODIFIER_KEYWORD_SET;
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = KtTokens.SOFT_KEYWORDS;
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.FUN_KEYWORD};
        tokenSetArray[1] = TokenSet.create(iElementTypeArray);
        TokenSet tokenSet = TokenSet.orSet(tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        MODIFIER_KEYWORD_SET = tokenSet;
    }
}

