/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KaImplicitReceiverSmartCast;
import org.jetbrains.kotlin.analysis.api.components.KaImplicitReceiverSmartCastKind;
import org.jetbrains.kotlin.analysis.api.components.KaSmartCastInfo;
import org.jetbrains.kotlin.analysis.api.components.KaSmartCastProvider;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirSmartcastProviderKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010R\u0018\u0010\u0016\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirSmartcastProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KaSmartCastProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "isExplicitSmartCastInfoTarget", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "getMatchingFirExpressionWithSmartCast", "Lorg/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;", "expression", "getSmartCastedInfo", "Lorg/jetbrains/kotlin/analysis/api/components/KaSmartCastInfo;", "isImplicitSmartCastInfoTarget", "getMatchingFirQualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "getImplicitReceiverSmartCast", "", "Lorg/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCast;", "smartCastedImplicitReceiver", "firExpression", "kind", "Lorg/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCastKind;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirSmartcastProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirSmartcastProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirSmartcastProvider\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,126:1\n26#2:127\n*S KotlinDebug\n*F\n+ 1 KtFirSmartcastProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirSmartcastProvider\n*L\n65#1:127\n*E\n"})
public final class KaFirSmartcastProvider
extends KaSmartCastProvider
implements KaFirSessionComponent {
    @NotNull
    private final KaFirSession analysisSession;
    @NotNull
    private final KaLifetimeToken token;

    public KaFirSmartcastProvider(@NotNull KaFirSession analysisSession, @NotNull KaLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KaFirSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KaLifetimeToken getToken() {
        return this.token;
    }

    private final boolean isExplicitSmartCastInfoTarget(KtExpression $this$isExplicitSmartCastInfoTarget) {
        if ($this$isExplicitSmartCastInfoTarget.getParent() instanceof KtParenthesizedExpression) {
            return false;
        }
        if ($this$isExplicitSmartCastInfoTarget instanceof KtQualifiedExpression && ((KtQualifiedExpression)$this$isExplicitSmartCastInfoTarget).getSelectorExpression() instanceof KtCallExpression) {
            return false;
        }
        if ($this$isExplicitSmartCastInfoTarget instanceof KtNameReferenceExpression && KtPsiUtilKt.getQualifiedExpressionForSelector($this$isExplicitSmartCastInfoTarget) != null) {
            return false;
        }
        return $this$isExplicitSmartCastInfoTarget instanceof KtQualifiedExpression || $this$isExplicitSmartCastInfoTarget instanceof KtNameReferenceExpression || $this$isExplicitSmartCastInfoTarget instanceof KtParenthesizedExpression;
    }

    private final FirSmartCastExpression getMatchingFirExpressionWithSmartCast(KtExpression expression2) {
        FirExpression firExpression;
        FirStatement firStatement;
        KtExpression possibleFunctionCall;
        FirElement firExpression2;
        if (!this.isExplicitSmartCastInfoTarget(expression2)) {
            return null;
        }
        KtExpression ktExpression = KtFirSmartcastProviderKt.access$getPossiblyQualifiedCallExpressionForCallee(expression2);
        if (ktExpression == null) {
            ktExpression = expression2;
        }
        FirSmartCastExpression firSmartCastExpression = (firExpression2 = LowLevelFirApiFacadeKt.getOrBuildFir(possibleFunctionCall = ktExpression, this.getAnalysisSession().getFirResolveSession())) instanceof FirSmartCastExpression ? (FirSmartCastExpression)firExpression2 : (firExpression2 instanceof FirSafeCallExpression ? ((firStatement = ((FirSafeCallExpression)firExpression2).getSelector()) instanceof FirSmartCastExpression ? (FirSmartCastExpression)firStatement : null) : (firExpression2 instanceof FirImplicitInvokeCall ? ((firExpression = ((FirImplicitInvokeCall)firExpression2).getExplicitReceiver()) instanceof FirSmartCastExpression ? (FirSmartCastExpression)firExpression : null) : null));
        return firSmartCastExpression;
    }

    @Override
    @Nullable
    public KaSmartCastInfo getSmartCastedInfo(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirSmartCastExpression firSmartCastExpression = this.getMatchingFirExpressionWithSmartCast(expression2);
        if (firSmartCastExpression == null) {
            return null;
        }
        FirSmartCastExpression firSmartCastExpression2 = firSmartCastExpression;
        return this.getSmartCastedInfo(firSmartCastExpression2);
    }

    private final KaSmartCastInfo getSmartCastedInfo(FirSmartCastExpression expression2) {
        Object object;
        FirTypeRef $this$coneTypeSafe$iv = expression2.getSmartcastType();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        Object object2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(object2 instanceof ConeKotlinType)) {
            object2 = object = null;
        }
        if (object2 == null || (object = this.asKtType((ConeKotlinType)object)) == null) {
            return null;
        }
        Object type2 = object;
        return new KaSmartCastInfo((KaType)type2, expression2.isStable(), this.getToken());
    }

    private final boolean isImplicitSmartCastInfoTarget(KtExpression $this$isImplicitSmartCastInfoTarget) {
        return $this$isImplicitSmartCastInfoTarget instanceof KtNameReferenceExpression || $this$isImplicitSmartCastInfoTarget instanceof KtOperationReferenceExpression;
    }

    private final FirQualifiedAccessExpression getMatchingFirQualifiedAccessExpression(KtExpression expression2) {
        FirExpression firExpression;
        FirStatement firStatement;
        KtExpression ktExpression;
        if (!this.isImplicitSmartCastInfoTarget(expression2)) {
            return null;
        }
        KtOperationExpression ktOperationExpression = KtFirSmartcastProviderKt.access$getOperationExpressionForOperationReference(expression2);
        if (ktOperationExpression != null) {
            ktExpression = ktOperationExpression;
        } else {
            ktExpression = KtFirSmartcastProviderKt.access$getPossiblyQualifiedCallExpressionForCallee(expression2);
            if (ktExpression == null) {
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(expression2);
                ktExpression = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : expression2;
            }
        }
        KtExpression wholeExpression = ktExpression;
        FirElement firExpression2 = LowLevelFirApiFacadeKt.getOrBuildFir(wholeExpression, this.getAnalysisSession().getFirResolveSession());
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : (firExpression2 instanceof FirSafeCallExpression ? ((firStatement = ((FirSafeCallExpression)firExpression2).getSelector()) instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firStatement : null) : (firExpression2 instanceof FirSmartCastExpression ? ((firExpression = ((FirSmartCastExpression)firExpression2).getOriginalExpression()) instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null) : null));
        return firQualifiedAccessExpression;
    }

    @Override
    @NotNull
    public Collection<KaImplicitReceiverSmartCast> getImplicitReceiverSmartCast(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirQualifiedAccessExpression firQualifiedAccessExpression = this.getMatchingFirQualifiedAccessExpression(expression2);
        if (firQualifiedAccessExpression == null) {
            return CollectionsKt.emptyList();
        }
        FirQualifiedAccessExpression firQualifiedExpression = firQualifiedAccessExpression;
        Object[] objectArray = new KaImplicitReceiverSmartCast[]{this.smartCastedImplicitReceiver(firQualifiedExpression, KaImplicitReceiverSmartCastKind.DISPATCH), this.smartCastedImplicitReceiver(firQualifiedExpression, KaImplicitReceiverSmartCastKind.EXTENSION)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final KaImplicitReceiverSmartCast smartCastedImplicitReceiver(FirQualifiedAccessExpression firExpression, KaImplicitReceiverSmartCastKind kind) {
        FirExpression firExpression2;
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                firExpression2 = firExpression.getDispatchReceiver();
                break;
            }
            case 2: {
                firExpression2 = firExpression.getExtensionReceiver();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        FirExpression receiver = firExpression2;
        if (receiver == null || Intrinsics.areEqual((Object)receiver, (Object)firExpression.getExplicitReceiver())) {
            return null;
        }
        if (!FirTypeUtilsKt.isStableSmartcast(receiver)) {
            return null;
        }
        KaType type2 = this.asKtType(FirTypeUtilsKt.getResolvedType(receiver));
        return new KaImplicitReceiverSmartCast(type2, kind, this.getToken());
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KaImplicitReceiverSmartCastKind.values().length];
            try {
                nArray[KaImplicitReceiverSmartCastKind.DISPATCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaImplicitReceiverSmartCastKind.EXTENSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

