/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.components;

import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.KaReferenceShortener;
import org.jetbrains.kotlin.analysis.api.components.KaSessionMixIn;
import org.jetbrains.kotlin.analysis.api.components.ShortenCommand;
import org.jetbrains.kotlin.analysis.api.components.ShortenOptions;
import org.jetbrains.kotlin.analysis.api.components.ShortenStrategy;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001JP\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u000bH\u0016JF\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u000bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/analysis/api/components/KaReferenceShortenerMixIn;", "Lorg/jetbrains/kotlin/analysis/api/components/KaSessionMixIn;", "collectPossibleReferenceShortenings", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "selection", "Lcom/intellij/openapi/util/TextRange;", "shortenOptions", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenOptions;", "classShortenStrategy", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenStrategy;", "callableShortenStrategy", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "collectPossibleReferenceShorteningsInElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "analysis-api"})
@SourceDebugExtension(value={"SMAP\nKtReferenceShortener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/components/KaReferenceShortenerMixIn\n+ 2 KtLifetimeOwner.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeOwnerKt\n+ 3 KtLifetimeToken.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenKt\n*L\n1#1,234:1\n22#2:235\n18#2:236\n19#2,5:244\n22#2:249\n18#2:250\n19#2,5:258\n34#3,7:237\n34#3,7:251\n*S KotlinDebug\n*F\n+ 1 KtReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/components/KaReferenceShortenerMixIn\n*L\n147#1:235\n147#1:236\n147#1:244,5\n172#1:249\n172#1:250\n172#1:258,5\n147#1:237,7\n172#1:251,7\n*E\n"})
public interface KaReferenceShortenerMixIn
extends KaSessionMixIn {
    @NotNull
    default public ShortenCommand collectPossibleReferenceShortenings(@NotNull KtFile file2, @NotNull TextRange selection, @NotNull ShortenOptions shortenOptions, @NotNull Function1<? super KaClassLikeSymbol, ? extends ShortenStrategy> classShortenStrategy, @NotNull Function1<? super KaCallableSymbol, ? extends ShortenStrategy> callableShortenStrategy) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)shortenOptions, (String)"shortenOptions");
        Intrinsics.checkNotNullParameter(classShortenStrategy, (String)"classShortenStrategy");
        Intrinsics.checkNotNullParameter(callableShortenStrategy, (String)"callableShortenStrategy");
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        return this.getAnalysisSession().getReferenceShortener$analysis_api().collectShortenings(file2, selection, shortenOptions, classShortenStrategy, callableShortenStrategy);
    }

    public static /* synthetic */ ShortenCommand collectPossibleReferenceShortenings$default(KaReferenceShortenerMixIn kaReferenceShortenerMixIn, KtFile ktFile, TextRange textRange, ShortenOptions shortenOptions, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectPossibleReferenceShortenings");
        }
        if ((n & 2) != 0) {
            textRange = ktFile.getTextRange();
        }
        if ((n & 4) != 0) {
            shortenOptions = ShortenOptions.Companion.getDEFAULT();
        }
        if ((n & 8) != 0) {
            function1 = ShortenStrategy.Companion.getDefaultClassShortenStrategy();
        }
        if ((n & 0x10) != 0) {
            function12 = ShortenStrategy.Companion.getDefaultCallableShortenStrategy();
        }
        return kaReferenceShortenerMixIn.collectPossibleReferenceShortenings(ktFile, textRange, shortenOptions, function1, function12);
    }

    @NotNull
    default public ShortenCommand collectPossibleReferenceShorteningsInElement(@NotNull KtElement element2, @NotNull ShortenOptions shortenOptions, @NotNull Function1<? super KaClassLikeSymbol, ? extends ShortenStrategy> classShortenStrategy, @NotNull Function1<? super KaCallableSymbol, ? extends ShortenStrategy> callableShortenStrategy) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)shortenOptions, (String)"shortenOptions");
        Intrinsics.checkNotNullParameter(classShortenStrategy, (String)"classShortenStrategy");
        Intrinsics.checkNotNullParameter(callableShortenStrategy, (String)"callableShortenStrategy");
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        KaReferenceShortener kaReferenceShortener = this.getAnalysisSession().getReferenceShortener$analysis_api();
        KtFile ktFile = element2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        TextRange textRange = element2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return kaReferenceShortener.collectShortenings(ktFile, textRange, shortenOptions, classShortenStrategy, callableShortenStrategy);
    }

    public static /* synthetic */ ShortenCommand collectPossibleReferenceShorteningsInElement$default(KaReferenceShortenerMixIn kaReferenceShortenerMixIn, KtElement ktElement, ShortenOptions shortenOptions, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectPossibleReferenceShorteningsInElement");
        }
        if ((n & 2) != 0) {
            shortenOptions = ShortenOptions.Companion.getDEFAULT();
        }
        if ((n & 4) != 0) {
            function1 = ShortenStrategy.Companion.getDefaultClassShortenStrategy();
        }
        if ((n & 8) != 0) {
            function12 = ShortenStrategy.Companion.getDefaultCallableShortenStrategy();
        }
        return kaReferenceShortenerMixIn.collectPossibleReferenceShorteningsInElement(ktElement, shortenOptions, function1, function12);
    }
}

