/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrCoroutineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.AddContinuationLowering;
import org.jetbrains.kotlin.backend.jvm.lower.AddContinuationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmLocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLambdaLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLoweringUtils;
import org.jetbrains.kotlin.backend.jvm.lower.TailCallOptimizationLowering;
import org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Type;

@PhaseDescription(name="AddContinuation", description="Add continuation classes and parameters to suspend functions", prerequisite={SuspendLambdaLowering.class, JvmLocalDeclarationsLowering.class, TailCallOptimizationLowering.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u0017*\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J6\u0010\u001a\u001a\u00020\b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/SuspendLoweringUtils;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addContinuationParameterToSuspendCalls", "generateContinuationClassForNamedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "dispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "attributeContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "capturesCrossinline", "", "addConstructorForNamedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "capturedThisField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "addInvokeSuspendForNamedFunction", "resultField", "labelField", "isStaticSuspendImpl", "toSuspendImplementationName", "Lorg/jetbrains/kotlin/name/Name;", "createStaticSuspendImpl", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "addContinuationObjectAndContinuationParameterToSuspendFunctions", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nAddContinuationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddContinuationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,501:1\n50#2,4:502\n80#2:506\n74#2,10:507\n80#2:517\n74#2,10:518\n289#2:528\n283#2,13:529\n1#3:542\n350#4,12:543\n350#4,12:567\n350#4,12:591\n416#5,10:555\n416#5,10:579\n72#6,2:565\n72#6,2:589\n*S KotlinDebug\n*F\n+ 1 AddContinuationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering\n*L\n91#1:502,4\n101#1:506\n101#1:507,10\n108#1:517\n108#1:518,10\n129#1:528\n129#1:529,13\n137#1:543,12\n157#1:567,12\n172#1:591,12\n138#1:555,10\n270#1:579,10\n138#1:565,2\n270#1:589,2\n*E\n"})
public final class AddContinuationLowering
extends SuspendLoweringUtils
implements FileLoweringPass {
    public AddContinuationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.addContinuationObjectAndContinuationParameterToSuspendFunctions(irFile);
        this.addContinuationParameterToSuspendCalls(irFile);
    }

    private final void addContinuationParameterToSuspendCalls(IrFile irFile) {
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            private final List<IrFunction> functionStack;
            final /* synthetic */ AddContinuationLowering this$0;
            {
                this.this$0 = $receiver;
                this.functionStack = new ArrayList<E>();
            }

            public final List<IrFunction> getFunctionStack() {
                return this.functionStack;
            }

            public IrStatement visitFunction(IrFunction declaration2) {
                IrStatement irStatement;
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                UtilsKt.push(this.functionStack, declaration2);
                IrStatement it = irStatement = super.visitFunction(declaration2);
                boolean bl = false;
                UtilsKt.pop(this.functionStack);
                return irStatement;
            }

            public IrExpression visitFunctionReference(IrFunctionReference expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitFunctionReference(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                IrFunctionReference transformed = (IrFunctionReference)irExpression;
                return AddContinuationLoweringKt.access$retargetToSuspendView(transformed, this.this$0.getContext(), null, addContinuationParameterToSuspendCalls.1::visitFunctionReference$lambda$1);
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitCall(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                IrCall transformed = (IrCall)irExpression;
                IrFunction irFunction = UtilsKt.peek(this.functionStack);
                if (irFunction == null) {
                    return transformed;
                }
                return AddContinuationLoweringKt.access$retargetToSuspendView(transformed, this.this$0.getContext(), irFunction, addContinuationParameterToSuspendCalls.1::visitCall$lambda$2);
            }

            private static final IrFunctionReference visitFunctionReference$lambda$1(IrFunctionReference $this$retargetToSuspendView, IrSimpleFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)$this$retargetToSuspendView, (String)"$this$retargetToSuspendView");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return BuildersKt.fromSymbolOwner(IrFunctionReferenceImpl.Companion, $this$retargetToSuspendView.getStartOffset(), $this$retargetToSuspendView.getEndOffset(), $this$retargetToSuspendView.getType(), it, $this$retargetToSuspendView.getTypeArgumentsCount(), $this$retargetToSuspendView.getReflectionTarget(), $this$retargetToSuspendView.getOrigin());
            }

            private static final IrCall visitCall$lambda$2(IrCall $this$retargetToSuspendView, IrSimpleFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)$this$retargetToSuspendView, (String)"$this$retargetToSuspendView");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, $this$retargetToSuspendView.getStartOffset(), $this$retargetToSuspendView.getEndOffset(), $this$retargetToSuspendView.getType(), it, 0, 0, $this$retargetToSuspendView.getOrigin(), $this$retargetToSuspendView.getSuperQualifierSymbol(), 48, null);
            }
        });
    }

    private final IrClass generateContinuationClassForNamedFunction(IrFunction irFunction, IrValueParameter dispatchReceiverParameter, IrAttributeContainer attributeContainer, boolean capturesCrossinline) {
        IrField irField;
        IrClass irClass;
        DescriptorVisibility descriptorVisibility;
        IrFactory $this$buildClass$iv = this.getContext().getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u240 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setName(Name.special("<Continuation>"));
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getCONTINUATION_CLASS());
        if (capturesCrossinline) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PACKAGE_VISIBILITY");
        }
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setVisibility(descriptorVisibility);
        IrClass $this$generateContinuationClassForNamedFunction_u24lambda_u244 = irClass = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$generateContinuationClassForNamedFunction_u24lambda_u244);
        $this$generateContinuationClassForNamedFunction_u24lambda_u244.setSuperTypes(CollectionsKt.plus((Collection)$this$generateContinuationClassForNamedFunction_u24lambda_u244.getSuperTypes(), (Object)IrUtilsKt.getDefaultType((IrClass)this.getContext().getIr().getSymbols().getContinuationImplClass().getOwner())));
        $this$generateContinuationClassForNamedFunction_u24lambda_u244.setParent(irFunction);
        IrUtilsKt.copyTypeParametersFrom$default($this$generateContinuationClassForNamedFunction_u24lambda_u244, irFunction, null, null, 6, null);
        IrClass $this$addField$iv = $this$generateContinuationClassForNamedFunction_u24lambda_u244;
        boolean $i$f$addField = false;
        Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
        boolean bl4 = false;
        IrFieldBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241 = $this$buildField_u24lambda_u244$iv$iv;
        boolean bl5 = false;
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getCONTINUATION_CLASS_RESULT_FIELD());
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setName(Name.identifier("result"));
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setType(this.getContext().getIr().getSymbols().getResultOfAnyType());
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setVisibility(JavaDescriptorVisibilities.PACKAGE_VISIBILITY);
        Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u244$iv$iv);
        boolean bl6 = false;
        ((IrDeclarationBase)field$iv).setParent($this$addField$iv);
        $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
        Object resultField = $this$buildField$iv$iv;
        IrValueParameter irValueParameter = dispatchReceiverParameter;
        if (irValueParameter != null) {
            IrField irField2;
            IrValueParameter it = irValueParameter;
            boolean bl7 = false;
            IrClass $this$addField$iv2 = $this$generateContinuationClassForNamedFunction_u24lambda_u244;
            boolean $i$f$addField2 = false;
            IrFactory $this$buildField$iv$iv2 = $this$addField$iv2.getFactory();
            boolean $i$f$buildField2 = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv2 = new IrFieldBuilder();
            $i$a$-run-DeclarationBuildersKt$buildField$2$iv$iv = false;
            IrFieldBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242 = $this$buildField_u24lambda_u244$iv$iv2;
            boolean bl8 = false;
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setName(Name.identifier("this$0"));
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setType(it.getType());
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_OUTER_THIS());
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setVisibility(JavaDescriptorVisibilities.PACKAGE_VISIBILITY);
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setFinal(true);
            IrField field$iv2 = irField2 = DeclarationBuildersKt.buildField($this$buildField$iv$iv2, $this$buildField_u24lambda_u244$iv$iv2);
            $i$a$-also-DeclarationBuildersKt$addField$1$iv = false;
            field$iv2.setParent($this$addField$iv2);
            $this$addField$iv2.getDeclarations().add(field$iv2);
            irField = irField2;
        } else {
            irField = null;
        }
        IrField capturedThisField = irField;
        IrType irType = this.getContext().getIrBuiltIns().getIntType();
        DescriptorVisibility descriptorVisibility4 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility4, (String)"PACKAGE_VISIBILITY");
        IrField labelField = DeclarationBuildersKt.addField($this$generateContinuationClassForNamedFunction_u24lambda_u244, "label", irType, descriptorVisibility4);
        this.addConstructorForNamedFunction($this$generateContinuationClassForNamedFunction_u24lambda_u244, capturedThisField, capturesCrossinline);
        this.addInvokeSuspendForNamedFunction($this$generateContinuationClassForNamedFunction_u24lambda_u244, irFunction, (IrField)resultField, labelField, capturedThisField, Intrinsics.areEqual((Object)irFunction.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSUSPEND_IMPL_STATIC_FUNCTION()));
        IrDeclarationsKt.copyAttributes((IrAttributeContainer)$this$generateContinuationClassForNamedFunction_u24lambda_u244, attributeContainer);
        return irClass;
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor addConstructorForNamedFunction(IrClass $this$addConstructorForNamedFunction, IrField capturedThisField, boolean capturesCrossinline) {
        void it;
        IrDelegatingConstructorCall irDelegatingConstructorCall;
        void $this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
        void this_$iv$iv;
        IrConstructor it2;
        IrValueParameter irValueParameter;
        Object object;
        DescriptorVisibility descriptorVisibility;
        IrClass $this$addConstructor$iv = $this$addConstructorForNamedFunction;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2425$iv = $this$buildConstructor_u24lambda_u2424$iv$iv;
        boolean bl2 = false;
        IrFunctionBuilder $this$addConstructorForNamedFunction_u24lambda_u245 = $this$addConstructor_u24lambda_u2425$iv;
        boolean bl3 = false;
        $this$addConstructorForNamedFunction_u24lambda_u245.setPrimary(true);
        $this$addConstructorForNamedFunction_u24lambda_u245.setReturnType(IrUtilsKt.getDefaultType($this$addConstructorForNamedFunction));
        if (capturesCrossinline) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PACKAGE_VISIBILITY");
        }
        $this$addConstructorForNamedFunction_u24lambda_u245.setVisibility(descriptorVisibility);
        $this$addConstructor_u24lambda_u2425$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
        Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2424$iv$iv);
        boolean bl4 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        ((IrDeclarationBase)constructor$iv).setParent($this$addConstructor$iv);
        Object constructor = object = $this$buildConstructor$iv$iv;
        boolean bl5 = false;
        IrField irField = capturedThisField;
        if (irField != null) {
            IrField it3 = irField;
            boolean bl6 = false;
            IrFunction irFunction = (IrFunction)constructor;
            String string2 = it3.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            irValueParameter = DeclarationBuildersKt.addValueParameter$default(irFunction, string2, it3.getType(), null, 4, null);
        } else {
            irValueParameter = null;
        }
        IrValueParameter capturedThisParameter = irValueParameter;
        IrValueParameter completionParameterSymbol = this.addCompletionValueParameter((IrFunction)constructor);
        Sequence<IrConstructor> $this$single$iv = IrUtilsKt.getConstructors((IrClass)this.getContext().getIr().getSymbols().getContinuationImplClass().getOwner());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it2 = (IrConstructor)element$iv;
            boolean bl7 = false;
            if (!(it2.getValueParameters().size() == 1)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructor superClassConstructor = single$iv;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)((IrConstructor)constructor).getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        it2 = this_$iv$iv;
        Object object2 = constructor;
        boolean bl8 = false;
        if (capturedThisField != null) {
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
            IrValueParameter irValueParameter2 = $this$addConstructorForNamedFunction.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter2);
            IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter2);
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
            IrValueParameter irValueParameter3 = capturedThisParameter;
            Intrinsics.checkNotNull((Object)irValueParameter3);
            $this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, irExpression, capturedThisField, ExpressionHelpersKt.irGet(irBuilderWithScope3, irValueParameter3), null, 8, null));
        }
        IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249, superClassConstructor);
        void var21_29 = $this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
        boolean bl9 = false;
        it.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249, completionParameterSymbol));
        var21_29.unaryPlus(irDelegatingConstructorCall);
        ((IrFunction)object2).setBody(this_$iv$iv.doBuild());
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void addInvokeSuspendForNamedFunction(IrClass $this$addInvokeSuspendForNamedFunction, IrFunction irFunction, IrField resultField, IrField labelField, IrField capturedThisField, boolean isStaticSuspendImpl) {
        void $this$single$iv;
        JvmBackendContext backendContext = this.getContext();
        Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions((IrClass)this.getContext().getIr().getSymbols().getContinuationImplClass().getOwner());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)Name.identifier("invokeSuspend"))) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction invokeSuspend = single$iv;
        this.addFunctionOverride($this$addInvokeSuspendForNamedFunction, invokeSuspend, irFunction.getStartOffset(), irFunction.getEndOffset(), (Function2<? super IrBlockBodyBuilder, ? super IrFunction, Unit>)((Function2)(arg_0, arg_1) -> AddContinuationLowering.addInvokeSuspendForNamedFunction$lambda$16(resultField, labelField, irFunction, $this$addInvokeSuspendForNamedFunction, capturedThisField, backendContext, isStaticSuspendImpl, arg_0, arg_1)));
    }

    private final Name toSuspendImplementationName(Name $this$toSuspendImplementationName) {
        Name name2 = Name.guessByFirstCharacter($this$toSuspendImplementationName.asString() + "$suspendImpl");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"guessByFirstCharacter(...)");
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createStaticSuspendImpl(IrSimpleFunction irFunction) {
        void it;
        int i;
        void $this$createStaticSuspendImpl_u24lambda_u2419;
        IrFunctionAccessExpression irFunctionAccessExpression;
        void this_$iv$iv;
        IrFactory irFactory = this.getContext().getIrFactory();
        IrDeclarationParent irDeclarationParent = irFunction.getParent();
        Name name2 = this.toSuspendImplementationName(irFunction.getName());
        IrFunction irFunction2 = irFunction;
        IrDeclarationOrigin irDeclarationOrigin = JvmLoweredDeclarationOrigin.INSTANCE.getSUSPEND_IMPL_STATIC_FUNCTION();
        DescriptorVisibility descriptorVisibility = JvmIrUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass(irFunction)) ? DescriptorVisibilities.PUBLIC : JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNull((Object)descriptorVisibility);
        IrSimpleFunction irSimpleFunction = IrUtilsKt.createStaticFunctionWithReceivers$default(irFactory, irDeclarationParent, name2, irFunction2, null, irDeclarationOrigin, Modality.OPEN, descriptorVisibility, false, false, IrTypeSystemContextKt.extractTypeParameters(IrUtilsKt.getParentAsClass(irFunction)), (Function3)new Function3<IrFunction, IrFunction, Map<IrValueParameter, ? extends IrValueParameter>, Unit>((Object)this.getContext()){

            public final void invoke(IrFunction p0, IrFunction p1, Map<IrValueParameter, ? extends IrValueParameter> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((JvmBackendContext)this.receiver).remapMultiFieldValueClassStructure(p0, p1, p2);
            }
        }, 8, null);
        irSimpleFunction.setBody(IrInlineUtilsKt.moveBodyTo(irFunction, irSimpleFunction));
        if (IrUtilsKt.getParentAsClass(irFunction).isInner()) {
            IrValueParameter movedDispatchParameter = irSimpleFunction.getValueParameters().get(0);
            boolean bl = Intrinsics.areEqual((Object)movedDispatchParameter.getOrigin(), (Object)IrDeclarationOrigin.Companion.getMOVED_DISPATCH_RECEIVER());
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22 = false;
                String $i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22 = "MOVED_DISPATCH_RECEIVER should be the first parameter in " + RenderIrElementKt.render$default(irSimpleFunction, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22);
            }
            IrBody irBody = irSimpleFunction.getBody();
            Intrinsics.checkNotNull((Object)irBody);
            IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(irFunction, movedDispatchParameter, this){
                final /* synthetic */ IrSimpleFunction $irFunction;
                final /* synthetic */ IrValueParameter $movedDispatchParameter;
                final /* synthetic */ AddContinuationLowering this$0;
                {
                    this.$irFunction = $irFunction;
                    this.$movedDispatchParameter = $movedDispatchParameter;
                    this.this$0 = $receiver;
                }

                public IrExpression visitGetValue(IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrValueDeclaration owner = expression2.getSymbol().getOwner();
                    if (owner instanceof IrValueParameter && this.isInstanceReceiverOfOuterClass((IrValueParameter)owner)) {
                        IrClass cursor = IrUtilsKt.getParentAsClass(this.$irFunction);
                        IrExpression value2 = BuildersKt.IrGetValueImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), this.$movedDispatchParameter.getSymbol(), null, 8, null);
                        while (!Intrinsics.areEqual((Object)cursor, (Object)((IrValueParameter)owner).getParent())) {
                            IrField outerThisField = this.this$0.getContext().getInnerClassesSupport().getOuterThisField(cursor);
                            value2 = BuildersKt.IrGetFieldImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), outerThisField.getSymbol(), outerThisField.getType(), value2, null, null, 96, null);
                            cursor = IrUtilsKt.getParentAsClass(cursor);
                        }
                        return value2;
                    }
                    return super.visitGetValue(expression2);
                }

                private final boolean isInstanceReceiverOfOuterClass(IrValueParameter param) {
                    if (!Intrinsics.areEqual((Object)param.getOrigin(), (Object)IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER())) {
                        return false;
                    }
                    if (!(param.getParent() instanceof IrClass)) {
                        return false;
                    }
                    IrDeclarationParent cursor = IrUtilsKt.getParentAsClass(this.$irFunction).getParent();
                    while (cursor instanceof IrClass) {
                        if (Intrinsics.areEqual((Object)cursor, (Object)param.getParent())) {
                            return true;
                        }
                        cursor = ((IrClass)cursor).getParent();
                    }
                    return false;
                }
            });
        }
        IrDeclarationsKt.copyAttributes((IrAttributeContainer)irSimpleFunction, irFunction);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)irFunction.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var9_11 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction2 = irFunction;
        boolean bl = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2419, irSimpleFunction);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2419;
        void var14_17 = $this$createStaticSuspendImpl_u24lambda_u2419;
        boolean bl2 = false;
        int n = ((Collection)irFunction.getTypeParameters()).size();
        for (i = 0; i < n; ++i) {
            it.putTypeArgument(i, $this$createStaticSuspendImpl_u24lambda_u2419.getContext().getIrBuiltIns().getAnyNType());
        }
        i = 0;
        if (irFunction.getDispatchReceiverParameter() != null) {
            int n2 = i++;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2419;
            IrValueParameter irValueParameter = irFunction.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            it.putValueArgument(n2, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter));
        }
        if (irFunction.getExtensionReceiverParameter() != null) {
            int n3 = i++;
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2419;
            IrValueParameter irValueParameter = irFunction.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            it.putValueArgument(n3, ExpressionHelpersKt.irGet(irBuilderWithScope3, irValueParameter));
        }
        for (IrValueParameter parameter2 : irFunction.getValueParameters()) {
            it.putValueArgument(i++, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2419, parameter2));
        }
        Unit unit = Unit.INSTANCE;
        var14_17.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irFunctionAccessExpression));
        irSimpleFunction2.setBody(this_$iv$iv.doBuild());
        return irSimpleFunction;
    }

    private final void addContinuationObjectAndContinuationParameterToSuspendFunctions(IrFile irFile) {
        irFile.accept(new IrElementTransformerVoid(this){
            final /* synthetic */ AddContinuationLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrStatement visitClass(IrClass declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                TransformKt.transformDeclarationsFlat(declaration2, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)arg_0 -> addContinuationObjectAndContinuationParameterToSuspendFunctions.1.visitClass$lambda$0(this, arg_0)));
                return declaration2;
            }

            /*
             * WARNING - void declaration
             */
            private final List<IrFunction> transformToView(IrSimpleFunction function2) {
                void $this$transformToView_u24lambda_u245;
                void this_$iv$iv;
                void $this$irBlockBody_u24default$iv;
                IrSimpleFunction irSimpleFunction;
                Object $this$buildFun$iv;
                Object $this$transformToView_u24lambda_u242;
                Object newType;
                IrFactory $this$filterTo$iv$iv;
                void $this$filter$iv;
                function2.accept(this, null);
                boolean capturesCrossinline = this.isCapturingCrossinline(function2);
                IrSimpleFunction view = AddContinuationLoweringKt.access$suspendFunctionViewOrStub(function2, this.this$0.getContext());
                IrValueParameter continuationParameter = JvmIrCoroutineUtilsKt.continuationParameter(view);
                Iterable iterable = IrUtilsKt.getExplicitParameters(view);
                Object object = IrUtilsKt.getExplicitParameters(function2);
                boolean $i$f$filter22 = false;
                void var8_9 = $this$filter$iv;
                Object destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                Object object2 = $this$filterTo$iv$iv.iterator();
                while (object2.hasNext()) {
                    T element$iv$iv = object2.next();
                    IrValueParameter it = (IrValueParameter)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)continuationParameter))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Map parameterMap = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)object, (Iterable)((List)destination$iv$iv)));
                view.setBody(IrInlineUtilsKt.moveBodyTo(function2, view, parameterMap));
                Object[] $i$f$filter22 = new IrSimpleFunction[]{view};
                List result2 = CollectionsKt.mutableListOf((Object[])$i$f$filter22);
                if (function2.getBody() == null || !JvmIrCoroutineUtilsKt.hasContinuation(function2)) {
                    return result2;
                }
                if (Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass(function2).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getLAMBDA_IMPL()) || Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass(function2).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL())) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Type type2 = JvmIrAttributesKt.getLocalClassType(IrUtilsKt.getParentAsClass(function2));
                    Intrinsics.checkNotNull((Object)type2);
                    newType = Type.getObjectType(stringBuilder.append(type2.getInternalName()).append('$').append(function2.getName()).append("$1").toString());
                    JvmIrAttributesKt.setLocalClassType(function2, (Type)newType);
                }
                if (capturesCrossinline || function2.isInline()) {
                    DescriptorVisibility descriptorVisibility;
                    newType = result2;
                    $this$filterTo$iv$iv = this.this$0.getContext().getIrFactory();
                    destination$iv$iv = this.this$0;
                    boolean $i$f$buildFun = false;
                    IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
                    boolean bl = false;
                    $this$transformToView_u24lambda_u242 = $this$buildFun_u24lambda_u2420$iv;
                    boolean bl2 = false;
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u242).setContainerSource(view.getContainerSource());
                    ((IrDeclarationBuilder)$this$transformToView_u24lambda_u242).setName(Name.identifier(MethodSignatureMapper.mapFunctionName$default(((SuspendLoweringUtils)destination$iv$iv).getContext().getDefaultMethodSignatureMapper(), view, false, 2, null) + "$$forInline"));
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u242).setReturnType(view.getReturnType());
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u242).setModality(view.getModality());
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u242).setSuspend(view.isSuspend());
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u242).setInline(view.isInline());
                    if (view.isInline()) {
                        DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PRIVATE;
                        descriptorVisibility = descriptorVisibility2;
                        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PRIVATE");
                    } else {
                        descriptorVisibility = view.getVisibility();
                    }
                    ((IrDeclarationBuilder)$this$transformToView_u24lambda_u242).setVisibility(descriptorVisibility);
                    ((IrDeclarationBuilder)$this$transformToView_u24lambda_u242).setOrigin(view.isInline() ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE() : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE_CAPTURES_CROSSINLINE());
                    $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
                    destination$iv$iv = this.this$0;
                    Object $this$transformToView_u24lambda_u243 = $this$buildFun$iv;
                    boolean bl3 = false;
                    IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)$this$transformToView_u24lambda_u243, view);
                    IrUtilsKt.copyParameterDeclarationsFrom((IrFunction)$this$transformToView_u24lambda_u243, view);
                    ((SuspendLoweringUtils)destination$iv$iv).getContext().remapMultiFieldValueClassStructure(view, (IrFunction)$this$transformToView_u24lambda_u243, null);
                    IrDeclarationsKt.copyAttributes((IrAttributeContainer)$this$transformToView_u24lambda_u243, view);
                    ((SuspendLoweringUtils)destination$iv$iv).generateErrorForInlineBody((IrSimpleFunction)$this$transformToView_u24lambda_u243);
                    newType.add($this$buildFun$iv);
                }
                if (IrUtilsKt.isOverridable(function2)) {
                    $this$buildFun$iv = AddContinuationLowering.access$createStaticSuspendImpl(this.this$0, view);
                    IrSimpleFunction it = $this$buildFun$iv;
                    boolean bl = false;
                    ((Collection)result2).add(it);
                    irSimpleFunction = $this$buildFun$iv;
                } else {
                    irSimpleFunction = view;
                }
                IrSimpleFunction newFunction = irSimpleFunction;
                $this$buildFun$iv = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)newFunction.getSymbol(), 0, 0, 6, null);
                object2 = this.this$0;
                int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                boolean $i$f$irBlockBody = false;
                $this$transformToView_u24lambda_u242 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                boolean $i$f$blockBody = false;
                void var15_22 = this_$iv$iv;
                object = newFunction;
                boolean bl = false;
                IrFunction irFunction = newFunction;
                IrValueParameter irValueParameter = view.getDispatchReceiverParameter();
                Intrinsics.checkNotNull((Object)function2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrAttributeContainer");
                $this$transformToView_u24lambda_u245.unaryPlus(AddContinuationLowering.access$generateContinuationClassForNamedFunction((AddContinuationLowering)object2, irFunction, irValueParameter, function2, capturesCrossinline));
                if (newFunction.getBody() instanceof IrExpressionBody) {
                    IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$transformToView_u24lambda_u245;
                    IrBody irBody = newFunction.getBody();
                    Intrinsics.checkNotNull((Object)irBody);
                    IrStatement irStatement = IrUtilsKt.getStatements(irBody).get(0);
                    Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    $this$transformToView_u24lambda_u245.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, (IrExpression)irStatement));
                } else {
                    IrBody irBody = newFunction.getBody();
                    Intrinsics.checkNotNull((Object)irBody);
                    for (IrStatement statement : IrUtilsKt.getStatements(irBody)) {
                        $this$transformToView_u24lambda_u245.unaryPlus(statement);
                    }
                }
                ((IrFunction)object).setBody(this_$iv$iv.doBuild());
                return result2;
            }

            private final boolean isCapturingCrossinline(IrSimpleFunction $this$isCapturingCrossinline) {
                Ref.BooleanRef capturesCrossinline = new Ref.BooleanRef();
                IrAttributeContainer irAttributeContainer = $this$isCapturingCrossinline.getOriginalBeforeInline();
                if (irAttributeContainer == null) {
                    irAttributeContainer = $this$isCapturingCrossinline;
                }
                IrVisitorsKt.acceptVoid(irAttributeContainer, new IrElementVisitorVoid(capturesCrossinline){
                    final /* synthetic */ Ref.BooleanRef $capturesCrossinline;
                    {
                        this.$capturesCrossinline = $capturesCrossinline;
                    }

                    public void visitElement(IrElement element2) {
                        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                        IrVisitorsKt.acceptChildrenVoid(element2, this);
                    }

                    public void visitFieldAccess(IrFieldAccessExpression expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        if (Intrinsics.areEqual((Object)((IrField)expression2.getSymbol().getOwner()).getOrigin(), (Object)LocalDeclarationsLowering.Companion.getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE())) {
                            this.$capturesCrossinline.element = true;
                            return;
                        }
                        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                    }

                    public void visitClass(IrClass declaration2) {
                        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                    }

                    public void visitElement(IrElement element2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitElement(this, element2, data);
                    }

                    public void visitDeclaration(IrDeclarationBase declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
                    }

                    public void visitDeclaration(IrDeclarationBase declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
                    }

                    public void visitValueParameter(IrValueParameter declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
                    }

                    public void visitValueParameter(IrValueParameter declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
                    }

                    public void visitClass(IrClass declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
                    }

                    public void visitAnonymousInitializer(IrAnonymousInitializer declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
                    }

                    public void visitAnonymousInitializer(IrAnonymousInitializer declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
                    }

                    public void visitTypeParameter(IrTypeParameter declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
                    }

                    public void visitTypeParameter(IrTypeParameter declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
                    }

                    public void visitFunction(IrFunction declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
                    }

                    public void visitFunction(IrFunction declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
                    }

                    public void visitConstructor(IrConstructor declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
                    }

                    public void visitConstructor(IrConstructor declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
                    }

                    public void visitEnumEntry(IrEnumEntry declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
                    }

                    public void visitEnumEntry(IrEnumEntry declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
                    }

                    public void visitErrorDeclaration(IrErrorDeclaration declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
                    }

                    public void visitErrorDeclaration(IrErrorDeclaration declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
                    }

                    public void visitField(IrField declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
                    }

                    public void visitField(IrField declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
                    }

                    public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
                    }

                    public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
                    }

                    public void visitModuleFragment(IrModuleFragment declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
                    }

                    public void visitModuleFragment(IrModuleFragment declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
                    }

                    public void visitProperty(IrProperty declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
                    }

                    public void visitProperty(IrProperty declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
                    }

                    public void visitScript(IrScript declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
                    }

                    public void visitScript(IrScript declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
                    }

                    public void visitSimpleFunction(IrSimpleFunction declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
                    }

                    public void visitSimpleFunction(IrSimpleFunction declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
                    }

                    public void visitTypeAlias(IrTypeAlias declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
                    }

                    public void visitTypeAlias(IrTypeAlias declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
                    }

                    public void visitVariable(IrVariable declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
                    }

                    public void visitVariable(IrVariable declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
                    }

                    public void visitPackageFragment(IrPackageFragment declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
                    }

                    public void visitPackageFragment(IrPackageFragment declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
                    }

                    public void visitExternalPackageFragment(IrExternalPackageFragment declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
                    }

                    public void visitExternalPackageFragment(IrExternalPackageFragment declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
                    }

                    public void visitFile(IrFile declaration2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
                    }

                    public void visitFile(IrFile declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
                    }

                    public void visitExpression(IrExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
                    }

                    public void visitExpression(IrExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
                    }

                    public void visitBody(IrBody body2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                    }

                    public void visitBody(IrBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                    }

                    public void visitExpressionBody(IrExpressionBody body2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                    }

                    public void visitExpressionBody(IrExpressionBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                    }

                    public void visitBlockBody(IrBlockBody body2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                    }

                    public void visitBlockBody(IrBlockBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                    }

                    public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
                    }

                    public void visitDeclarationReference(IrDeclarationReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                    }

                    public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
                    }

                    public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                    }

                    public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
                    }

                    public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                    }

                    public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
                    }

                    public void visitConstructorCall(IrConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                    }

                    public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
                    }

                    public void visitSingletonReference(IrGetSingletonValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                    }

                    public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
                    }

                    public void visitGetObjectValue(IrGetObjectValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                    }

                    public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
                    }

                    public void visitGetEnumValue(IrGetEnumValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                    }

                    public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
                    }

                    public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
                    }

                    public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
                    }

                    public void visitContainerExpression(IrContainerExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                    }

                    public void visitBlock(IrBlock expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
                    }

                    public void visitBlock(IrBlock expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                    }

                    public void visitComposite(IrComposite expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
                    }

                    public void visitComposite(IrComposite expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                    }

                    public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
                    }

                    public void visitReturnableBlock(IrReturnableBlock expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
                    }

                    public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
                    }

                    public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
                    }

                    public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                    }

                    public void visitSyntheticBody(IrSyntheticBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                    }

                    public void visitBreakContinue(IrBreakContinue jump, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                    }

                    public void visitBreakContinue(IrBreakContinue jump) {
                        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                    }

                    public void visitBreak(IrBreak jump, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                    }

                    public void visitBreak(IrBreak jump) {
                        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                    }

                    public void visitContinue(IrContinue jump, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                    }

                    public void visitContinue(IrContinue jump) {
                        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                    }

                    public void visitCall(IrCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
                    }

                    public void visitCall(IrCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
                    }

                    public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
                    }

                    public void visitCallableReference(IrCallableReference<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                    }

                    public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
                    }

                    public void visitFunctionReference(IrFunctionReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                    }

                    public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
                    }

                    public void visitPropertyReference(IrPropertyReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                    }

                    public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                    }

                    public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                    }

                    public void visitClassReference(IrClassReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
                    }

                    public void visitClassReference(IrClassReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                    }

                    public void visitConst(IrConst<?> expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
                    }

                    public void visitConst(IrConst<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                    }

                    public void visitConstantValue(IrConstantValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
                    }

                    public void visitConstantValue(IrConstantValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
                    }

                    public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
                    }

                    public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
                    }

                    public void visitConstantObject(IrConstantObject expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
                    }

                    public void visitConstantObject(IrConstantObject expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
                    }

                    public void visitConstantArray(IrConstantArray expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
                    }

                    public void visitConstantArray(IrConstantArray expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
                    }

                    public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                    }

                    public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                    }

                    public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
                    }

                    public void visitDynamicExpression(IrDynamicExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                    }

                    public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                    }

                    public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                    }

                    public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                    }

                    public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                    }

                    public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                    }

                    public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                    }

                    public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
                    }

                    public void visitErrorExpression(IrErrorExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                    }

                    public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                    }

                    public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                    }

                    public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
                    }

                    public void visitGetField(IrGetField expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
                    }

                    public void visitGetField(IrGetField expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                    }

                    public void visitSetField(IrSetField expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
                    }

                    public void visitSetField(IrSetField expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                    }

                    public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
                    }

                    public void visitFunctionExpression(IrFunctionExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                    }

                    public void visitGetClass(IrGetClass expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
                    }

                    public void visitGetClass(IrGetClass expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                    }

                    public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                    }

                    public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                    }

                    public void visitLoop(IrLoop loop, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
                    }

                    public void visitLoop(IrLoop loop) {
                        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
                    }

                    public void visitWhileLoop(IrWhileLoop loop, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
                    }

                    public void visitWhileLoop(IrWhileLoop loop) {
                        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
                    }

                    public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
                    }

                    public void visitDoWhileLoop(IrDoWhileLoop loop) {
                        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
                    }

                    public void visitReturn(IrReturn expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
                    }

                    public void visitReturn(IrReturn expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                    }

                    public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
                    }

                    public void visitStringConcatenation(IrStringConcatenation expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
                    }

                    public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                    }

                    public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                    }

                    public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                    }

                    public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                    }

                    public void visitThrow(IrThrow expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
                    }

                    public void visitThrow(IrThrow expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                    }

                    public void visitTry(IrTry aTry, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                    }

                    public void visitTry(IrTry aTry) {
                        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                    }

                    public void visitCatch(IrCatch aCatch, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                    }

                    public void visitCatch(IrCatch aCatch) {
                        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                    }

                    public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
                    }

                    public void visitTypeOperator(IrTypeOperatorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                    }

                    public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
                    }

                    public void visitValueAccess(IrValueAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
                    }

                    public void visitGetValue(IrGetValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
                    }

                    public void visitGetValue(IrGetValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                    }

                    public void visitSetValue(IrSetValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
                    }

                    public void visitSetValue(IrSetValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
                    }

                    public void visitVararg(IrVararg expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
                    }

                    public void visitVararg(IrVararg expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                    }

                    public void visitSpreadElement(IrSpreadElement spread, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                    }

                    public void visitSpreadElement(IrSpreadElement spread) {
                        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                    }

                    public void visitWhen(IrWhen expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
                    }

                    public void visitWhen(IrWhen expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                    }

                    public void visitBranch(IrBranch branch, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                    }

                    public void visitBranch(IrBranch branch) {
                        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                    }

                    public void visitElseBranch(IrElseBranch branch, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                    }

                    public void visitElseBranch(IrElseBranch branch) {
                        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                    }
                });
                return capturesCrossinline.element;
            }

            private static final List visitClass$lambda$0(addContinuationObjectAndContinuationParameterToSuspendFunctions.1 this$0, IrDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof IrSimpleFunction && ((IrSimpleFunction)it).isSuspend()) {
                    return this$0.transformToView((IrSimpleFunction)it);
                }
                it.accept(this$0, null);
                return null;
            }
        }, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addInvokeSuspendForNamedFunction$lambda$16(IrField $resultField, IrField $labelField, IrFunction $irFunction, IrClass $this_addInvokeSuspendForNamedFunction, IrField $capturedThisField, JvmBackendContext $backendContext, boolean $isStaticSuspendImpl, IrBlockBodyBuilder $this$addFunctionOverride, IrFunction function2) {
        IrGetFieldImpl capturedThisValue;
        IrGetFieldImpl irGetFieldImpl;
        void it;
        void $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addFunctionOverride, (String)"$this$addFunctionOverride");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        IrBuilderWithScope irBuilderWithScope = $this$addFunctionOverride;
        IrBuilderWithScope irBuilderWithScope2 = $this$addFunctionOverride;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        $this$addFunctionOverride.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), $resultField, ExpressionHelpersKt.irGet($this$addFunctionOverride, function2.getValueParameters().get(0)), null, 8, null));
        int signBit = Integer.MIN_VALUE;
        IrBuilderWithScope irBuilderWithScope3 = $this$addFunctionOverride;
        IrBuilderWithScope irBuilderWithScope4 = $this$addFunctionOverride;
        IrValueParameter irValueParameter2 = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter2);
        Object object = IrUtilsKt.getFunctions($this$addFunctionOverride.getContext().getIrBuiltIns().getIntClass());
        IrBuilderWithScope irBuilderWithScope5 = $this$addFunctionOverride;
        IrField irField = $labelField;
        IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope4, irValueParameter2);
        IrBuilderWithScope irBuilderWithScope6 = irBuilderWithScope3;
        IrBlockBodyBuilder irBlockBodyBuilder = $this$addFunctionOverride;
        boolean $i$f$single22 = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunctionSymbol it2 = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it2.getOwner()).getName(), (Object)OperatorNameConventions.OR)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object var23_33 = single$iv;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = var23_33;
        IrType irType = $this$addFunctionOverride.getContext().getIrBuiltIns().getIntType();
        IrBuilderWithScope irBuilderWithScope7 = $this$addFunctionOverride;
        IrBuilderWithScope irBuilderWithScope8 = $this$addFunctionOverride;
        IrValueParameter irValueParameter3 = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter3);
        irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope6, irExpression, irField, ExpressionHelpersKt.irCallOp$default(irBuilderWithScope5, irSimpleFunctionSymbol, irType, ExpressionHelpersKt.irGetField$default(irBuilderWithScope7, ExpressionHelpersKt.irGet(irBuilderWithScope8, irValueParameter3), $labelField, null, 4, null), ExpressionHelpersKt.irInt$default($this$addFunctionOverride, signBit, null, 2, null), null, 16, null), null, 8, null));
        Object $i$f$single22 = object = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$addFunctionOverride, $irFunction);
        irBuilderWithScope6 = $this$addFunctionOverride;
        irBlockBodyBuilder = $this$addFunctionOverride;
        boolean bl = false;
        int n = ((Collection)$irFunction.getTypeParameters()).size();
        for (int i = 0; i < n; ++i) {
            it.putTypeArgument(i, IrTypesKt.getDefaultType($this_addInvokeSuspendForNamedFunction.getTypeParameters().get(i)));
        }
        IrField irField2 = $capturedThisField;
        if (irField2 != null) {
            IrField irField3 = irField2;
            boolean bl2 = false;
            IrBuilderWithScope irBuilderWithScope9 = $this$addFunctionOverride;
            IrBuilderWithScope irBuilderWithScope10 = $this$addFunctionOverride;
            IrValueParameter irValueParameter4 = function2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter4);
            irGetFieldImpl = ExpressionHelpersKt.irGetField$default(irBuilderWithScope9, ExpressionHelpersKt.irGet(irBuilderWithScope10, irValueParameter4), irField3, null, 4, null);
        } else {
            irGetFieldImpl = capturedThisValue = null;
        }
        if ($irFunction.getDispatchReceiverParameter() != null) {
            it.setDispatchReceiver(capturedThisValue);
        }
        IrValueParameter irValueParameter5 = $irFunction.getExtensionReceiverParameter();
        if (irValueParameter5 != null) {
            IrValueParameter extensionReceiverParameter = irValueParameter5;
            boolean bl3 = false;
            it.setExtensionReceiver(JvmIrTypeUtilsKt.defaultValue(extensionReceiverParameter.getType(), -1, -1, $backendContext));
        }
        Iterator iterator2 = ((Iterable)CollectionsKt.dropLast($irFunction.getValueParameters(), (int)1)).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int i = n2++;
            IrValueParameter parameter2 = (IrValueParameter)iterator2.next();
            it.putValueArgument(i, JvmIrTypeUtilsKt.defaultValue(parameter2.getType(), -1, -1, $backendContext));
        }
        int n3 = $irFunction.getValueParameters().size() - 1;
        IrValueParameter irValueParameter6 = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter6);
        it.putValueArgument(n3, BuildersKt.IrGetValueImpl$default(-1, -1, irValueParameter6.getSymbol(), null, 8, null));
        if ($isStaticSuspendImpl) {
            it.putValueArgument(0, capturedThisValue);
        }
        irExpression = Unit.INSTANCE;
        irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope6, (IrExpression)object));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ IrSimpleFunction access$createStaticSuspendImpl(AddContinuationLowering $this, IrSimpleFunction irFunction) {
        return $this.createStaticSuspendImpl(irFunction);
    }

    public static final /* synthetic */ IrClass access$generateContinuationClassForNamedFunction(AddContinuationLowering $this, IrFunction irFunction, IrValueParameter dispatchReceiverParameter, IrAttributeContainer attributeContainer, boolean capturesCrossinline) {
        return $this.generateContinuationClassForNamedFunction(irFunction, dispatchReceiverParameter, attributeContainer, capturesCrossinline);
    }
}

