/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiParameterListImpl
extends JavaStubPsiElement<PsiParameterListStub>
implements PsiParameterList {
    private static final Logger LOG = Logger.getInstance(PsiParameterListImpl.class);

    public PsiParameterListImpl(@NotNull PsiParameterListStub stub) {
        if (stub == null) {
            PsiParameterListImpl.$$$reportNull$$$0(0);
        }
        super(stub, (IStubElementType)JavaStubElementTypes.PARAMETER_LIST);
    }

    public PsiParameterListImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiParameterListImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    public PsiParameter @NotNull [] getParameters() {
        PsiParameter[] psiParameterArray = (PsiParameter[])this.getStubOrPsiChildren(JavaStubElementTypes.PARAMETER, PsiParameter.ARRAY_FACTORY);
        if (psiParameterArray == null) {
            PsiParameterListImpl.$$$reportNull$$$0(2);
        }
        return psiParameterArray;
    }

    @Override
    public int getParameterIndex(@NotNull PsiParameter parameter2) {
        PsiElement parent2;
        if (parameter2 == null) {
            PsiParameterListImpl.$$$reportNull$$$0(3);
        }
        if ((parent2 = parameter2.getParent()) != this) {
            LOG.error("Not my parameter; parameter class = " + parameter2.getClass() + "; this class = " + this.getClass() + "; parameter parent class = " + (parent2 == null ? null : parent2.getClass()));
        }
        return PsiImplUtil.getParameterIndex(parameter2, this);
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiParameterListImpl.$$$reportNull$$$0(4);
        }
        return compositeElement;
    }

    @Override
    public int getParametersCount() {
        PsiParameterListStub stub = (PsiParameterListStub)this.getGreenStub();
        if (stub != null) {
            int count = 0;
            for (StubElement child : stub.getChildrenStubs()) {
                if (child.getStubType() != JavaStubElementTypes.PARAMETER) continue;
                ++count;
            }
            return count;
        }
        return this.getNode().countChildren(Constants.PARAMETER_BIT_SET);
    }

    @Override
    @Nullable
    public PsiParameter getParameter(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index is negative: " + index);
        }
        PsiParameterListStub stub = (PsiParameterListStub)this.getGreenStub();
        if (stub != null) {
            int count = 0;
            for (StubElement child : stub.getChildrenStubs()) {
                if (child.getStubType() != JavaStubElementTypes.PARAMETER) continue;
                if (count == index) {
                    return (PsiParameter)child.getPsi();
                }
                ++count;
            }
        } else {
            CompositeElement node = this.getNode();
            int count = 0;
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child.getElementType() != JavaStubElementTypes.PARAMETER) continue;
                if (count == index) {
                    return (PsiParameter)child.getPsi();
                }
                ++count;
            }
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        PsiParameterListStub stub = (PsiParameterListStub)this.getGreenStub();
        if (stub != null) {
            for (StubElement child : stub.getChildrenStubs()) {
                if (child.getStubType() != JavaStubElementTypes.PARAMETER) continue;
                return false;
            }
            return true;
        }
        return this.getNode().findChildByType(Constants.PARAMETER_BIT_SET) == null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiParameterListImpl.$$$reportNull$$$0(5);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameterList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiParameterList:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiParameterListImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiParameterListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

