/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.calls.mpp.ActualTypealiasToSpecialAnnotationUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ActualTypealiasToSpecialAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class ActualTypealiasToSpecialAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final ActualTypealiasToSpecialAnnotationChecker INSTANCE = new ActualTypealiasToSpecialAnnotationChecker();

    private ActualTypealiasToSpecialAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            return;
        }
        if (!(declaration2 instanceof KtTypeAlias && descriptor2 instanceof TypeAliasDescriptor && ((TypeAliasDescriptor)descriptor2).isActual())) {
            return;
        }
        ClassDescriptor classDescriptor2 = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        if (classDescriptor3.getKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor3);
        if (classId == null) {
            return;
        }
        ClassId classId2 = classId;
        if (ActualTypealiasToSpecialAnnotationUtils.INSTANCE.isAnnotationProhibitedInActualTypeAlias(classId2)) {
            context2.getTrace().report(Errors.ACTUAL_TYPEALIAS_TO_SPECIAL_ANNOTATION.on((KtTypeAlias)declaration2, classId2));
        }
    }
}

