/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\ncoroutineCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,205:1\n125#2:206\n1251#3,2:207\n*S KotlinDebug\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker\n*L\n76#1:206\n85#1:207,2\n*E\n"})
public final class CoroutineSuspendCallChecker
implements CallChecker {
    @NotNull
    public static final CoroutineSuspendCallChecker INSTANCE = new CoroutineSuspendCallChecker();

    private CoroutineSuspendCallChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Object descriptor2;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (obj instanceof FunctionDescriptor) {
            if (!((FunctionDescriptor)descriptor2).isSuspend()) {
                return;
            }
        } else if (obj instanceof PropertyDescriptor) {
            Intrinsics.checkNotNull(descriptor2);
            if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor2), (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_FQ_NAME())) {
                return;
            }
        } else {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNull((Object)ktElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        KtExpression callElement = (KtExpression)ktElement;
        FunctionDescriptor enclosingSuspendFunction = CoroutineCallCheckerKt.findEnclosingSuspendFunction(context2);
        if (enclosingSuspendFunction != null) {
            if (!InlineUtil.checkNonLocalReturnUsage(enclosingSuspendFunction, callElement, context2.getResolutionContext())) {
                boolean shouldReport = true;
                PsiFile containingFile2 = callElement.getContainingFile();
                if (containingFile2 instanceof KtCodeFragment) {
                    KtExpression c;
                    KtExpression ktExpression;
                    PsiElement psiElement = ((KtCodeFragment)containingFile2).getContext();
                    if (psiElement != null) {
                        void $this$getParentOfType$iv;
                        PsiElement psiElement2 = psiElement;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        ktExpression = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtExpression.class, strict$iv);
                    } else {
                        ktExpression = c = null;
                    }
                    if (c != null && InlineUtil.checkNonLocalReturnUsage(enclosingSuspendFunction, c, context2.getResolutionContext())) {
                        shouldReport = false;
                    }
                }
                if (shouldReport) {
                    context2.getTrace().report(Errors.NON_LOCAL_SUSPENSION_POINT.on(reportOn));
                }
            } else {
                boolean bl;
                block21: {
                    Sequence<HierarchicalScope> $this$any$iv = ScopeUtilsKt.getParentsWithSelf(context2.getScope());
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        HierarchicalScope it = (HierarchicalScope)element$iv;
                        boolean bl2 = false;
                        if (!CoroutineCallCheckerKt.access$isScopeForDefaultParameterValuesOf(it, enclosingSuspendFunction)) continue;
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
                if (bl) {
                    context2.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "suspend function calls in a context of default parameter value"));
                }
            }
            context2.getTrace().record(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall(), enclosingSuspendFunction);
            CoroutineCallCheckerKt.access$checkRestrictsSuspension(enclosingSuspendFunction, resolvedCall2, reportOn, context2);
        } else {
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
            if (!CallUtilKt.isCallableReference(call2)) {
                Intrinsics.checkNotNull(descriptor2);
                Object obj2 = descriptor2;
                if (obj2 instanceof FunctionDescriptor) {
                    context2.getTrace().report(Errors.ILLEGAL_SUSPEND_FUNCTION_CALL.on(reportOn, (CallableDescriptor)resolvedCall2.getCandidateDescriptor()));
                } else if (obj2 instanceof PropertyDescriptor) {
                    context2.getTrace().report(Errors.ILLEGAL_SUSPEND_PROPERTY_ACCESS.on(reportOn, (CallableDescriptor)resolvedCall2.getCandidateDescriptor()));
                }
            }
        }
    }
}

