/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u001bJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J'\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0005J\u0013\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u000e\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u0005J\b\u0010*\u001a\u00020\u001bH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/name/ClassId;", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "topLevelName", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)V", "relativeClassName", "isLocal", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Z)V", "()Z", "isNestedClass", "outerClassId", "getOuterClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "outermostClassId", "getOutermostClassId", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "parentClassId", "getParentClassId", "getRelativeClassName", "shortClassName", "getShortClassName", "()Lorg/jetbrains/kotlin/name/Name;", "asFqNameString", "", "asSingleFqName", "asString", "component1", "component2", "component3", "copy", "createNestedClassId", "name", "equals", "other", "hashCode", "", "startsWith", "segment", "toString", "Companion", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nClassId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassId.kt\norg/jetbrains/kotlin/name/ClassId\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,141:1\n1#2:142\n226#3:143\n226#3:144\n*S KotlinDebug\n*F\n+ 1 ClassId.kt\norg/jetbrains/kotlin/name/ClassId\n*L\n37#1:143\n47#1:144\n*E\n"})
public final class ClassId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName packageFqName;
    @NotNull
    private final FqName relativeClassName;
    private final boolean isLocal;

    public ClassId(@NotNull FqName packageFqName, @NotNull FqName relativeClassName, boolean isLocal2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)relativeClassName, (String)"relativeClassName");
        this.packageFqName = packageFqName;
        this.relativeClassName = relativeClassName;
        this.isLocal = isLocal2;
        boolean bl2 = bl = !this.relativeClassName.isRoot();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Class name must not be root: " + this.packageFqName + (this.isLocal ? " (local)" : "");
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final FqName getRelativeClassName() {
        return this.relativeClassName;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull Name topLevelName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)topLevelName, (String)"topLevelName");
        FqName fqName2 = FqName.topLevel(topLevelName);
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"topLevel(...)");
        this(packageFqName, fqName2, false);
    }

    @Nullable
    public final ClassId getParentClassId() {
        ClassId classId;
        boolean condition$iv = this.isNestedClass();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            FqName fqName2 = this.relativeClassName.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"parent(...)");
            classId = new ClassId(this.packageFqName, fqName2, this.isLocal);
        } else {
            classId = null;
        }
        return classId;
    }

    @NotNull
    public final Name getShortClassName() {
        Name name2 = this.relativeClassName.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
        return name2;
    }

    @Nullable
    public final ClassId getOuterClassId() {
        ClassId classId;
        FqName fqName2 = this.relativeClassName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"parent(...)");
        FqName parent2 = fqName2;
        boolean condition$iv = !parent2.isRoot();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            classId = new ClassId(this.packageFqName, parent2, this.isLocal);
        } else {
            classId = null;
        }
        return classId;
    }

    @NotNull
    public final ClassId getOutermostClassId() {
        FqName name2 = this.relativeClassName;
        while (!name2.parent().isRoot()) {
            Intrinsics.checkNotNullExpressionValue((Object)name2.parent(), (String)"parent(...)");
        }
        return new ClassId(this.packageFqName, name2, false);
    }

    public final boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    @NotNull
    public final ClassId createNestedClassId(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        FqName fqName2 = this.relativeClassName.child(name2);
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
        return new ClassId(this.packageFqName, fqName2, this.isLocal);
    }

    @NotNull
    public final FqName asSingleFqName() {
        return this.packageFqName.isRoot() ? this.relativeClassName : new FqName(this.packageFqName.asString() + '.' + this.relativeClassName.asString());
    }

    public final boolean startsWith(@NotNull Name segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        return this.packageFqName.startsWith(segment);
    }

    @NotNull
    public final String asString() {
        String string2;
        if (this.packageFqName.isRoot()) {
            string2 = ClassId.asString$escapeSlashes(this.relativeClassName);
        } else {
            StringBuilder stringBuilder2;
            StringBuilder $this$asString_u24lambda_u243 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            String string3 = this.packageFqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            $this$asString_u24lambda_u243.append(StringsKt.replace$default((String)string3, (char)'.', (char)'/', (boolean)false, (int)4, null));
            $this$asString_u24lambda_u243.append("/");
            $this$asString_u24lambda_u243.append(ClassId.asString$escapeSlashes(this.relativeClassName));
            String string4 = stringBuilder2.toString();
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        }
        return string2;
    }

    @NotNull
    public final String asFqNameString() {
        String string2;
        if (this.packageFqName.isRoot()) {
            String string3 = this.relativeClassName.asString();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        } else {
            StringBuilder stringBuilder2;
            StringBuilder $this$asFqNameString_u24lambda_u244 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$asFqNameString_u24lambda_u244.append(this.packageFqName.asString());
            $this$asFqNameString_u24lambda_u244.append(".");
            $this$asFqNameString_u24lambda_u244.append(this.relativeClassName.asString());
            String string4 = stringBuilder2.toString();
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        }
        return string2;
    }

    @NotNull
    public String toString() {
        return this.packageFqName.isRoot() ? '/' + this.asString() : this.asString();
    }

    @NotNull
    public final FqName component1() {
        return this.packageFqName;
    }

    @NotNull
    public final FqName component2() {
        return this.relativeClassName;
    }

    public final boolean component3() {
        return this.isLocal;
    }

    @NotNull
    public final ClassId copy(@NotNull FqName packageFqName, @NotNull FqName relativeClassName, boolean isLocal2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)relativeClassName, (String)"relativeClassName");
        return new ClassId(packageFqName, relativeClassName, isLocal2);
    }

    public static /* synthetic */ ClassId copy$default(ClassId classId, FqName fqName2, FqName fqName3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            fqName2 = classId.packageFqName;
        }
        if ((n & 2) != 0) {
            fqName3 = classId.relativeClassName;
        }
        if ((n & 4) != 0) {
            bl = classId.isLocal;
        }
        return classId.copy(fqName2, fqName3, bl);
    }

    public int hashCode() {
        int result2 = this.packageFqName.hashCode();
        result2 = result2 * 31 + this.relativeClassName.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isLocal);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassId)) {
            return false;
        }
        ClassId classId = (ClassId)other;
        if (!Intrinsics.areEqual((Object)this.packageFqName, (Object)classId.packageFqName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.relativeClassName, (Object)classId.relativeClassName)) {
            return false;
        }
        return this.isLocal == classId.isLocal;
    }

    private static final String asString$escapeSlashes(FqName $this$asString_u24escapeSlashes) {
        String string2 = $this$asString_u24escapeSlashes.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String res2 = string2;
        if (StringsKt.contains$default((CharSequence)res2, (char)'/', (boolean)false, (int)2, null)) {
            return '`' + res2 + '`';
        }
        return res2;
    }

    @JvmStatic
    @NotNull
    public static final ClassId topLevel(@NotNull FqName topLevelFqName) {
        return Companion.topLevel(topLevelFqName);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ClassId fromString(@NotNull String string2, boolean isLocal2) {
        return Companion.fromString(string2, isLocal2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ClassId fromString(@NotNull String string2) {
        return Companion.fromString(string2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/name/ClassId$Companion;", "", "()V", "fromString", "Lorg/jetbrains/kotlin/name/ClassId;", "string", "", "isLocal", "", "topLevel", "topLevelFqName", "Lorg/jetbrains/kotlin/name/FqName;", "compiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ClassId topLevel(@NotNull FqName topLevelFqName) {
            Intrinsics.checkNotNullParameter((Object)topLevelFqName, (String)"topLevelFqName");
            FqName fqName2 = topLevelFqName.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"parent(...)");
            Name name2 = topLevelFqName.shortName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
            return new ClassId(fqName2, name2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ClassId fromString(@NotNull String string2, boolean isLocal2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
            int tickIndex = StringsKt.indexOf$default((CharSequence)string2, (char)'`', (int)0, (boolean)false, (int)6, null);
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)string2, (String)"/", (int)(tickIndex == -1 ? string2.length() : tickIndex), (boolean)false, (int)4, null);
            String packageName2 = null;
            String className2 = null;
            if (lastSlashIndex == -1) {
                packageName2 = "";
                className2 = StringsKt.replace$default((String)string2, (String)"`", (String)"", (boolean)false, (int)4, null);
            } else {
                String string3 = string2.substring(0, lastSlashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                packageName2 = StringsKt.replace$default((String)string3, (char)'/', (char)'.', (boolean)false, (int)4, null);
                String string4 = string2.substring(lastSlashIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                className2 = StringsKt.replace$default((String)string4, (String)"`", (String)"", (boolean)false, (int)4, null);
            }
            return new ClassId(new FqName(packageName2), new FqName(className2), isLocal2);
        }

        public static /* synthetic */ ClassId fromString$default(Companion companion, String string2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.fromString(string2, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ClassId fromString(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
            return org.jetbrains.kotlin.name.ClassId$Companion.fromString$default(this, string2, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

