/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEvaluatorResult;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\nH\u0002\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u0010*\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\nH\u0002\u001a\u001c\u0010\u0012\u001a\u0004\u0018\u00010\b*\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0002\u001a&\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\u00162\u0006\u0010\u0018\u001a\u00020\nH\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\u0013H\u0002\u001a0\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u0017*\u0004\u0018\u00010\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00132\u0006\u0010\u0018\u001a\u00020\nH\u0002\u001a\u0012\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013*\u00020\u001eH\u0002\u001a\u0012\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013*\u00020\u001fH\u0002\u001a\u000e\u0010 \u001a\u00020\u0010*\u0004\u0018\u00010!H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\u00a8\u0006\""}, d2={"isCharCode", "", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "isStringEquals", "isStringLength", "isStringPlus", "evaluateBinary", "", "arg1", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "callableId", "arg2", "evaluateUnary", "arg", "adjustTypeAndConvertToLiteral", "Lorg/jetbrains/kotlin/fir/FirEvaluatorResult;", "original", "convertToGivenKind", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "value", "copy", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "T", "originalExpression", "toCompileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "toConstExpression", "kind", "toConstantValueKind", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/name/ClassId;", "wrap", "Lorg/jetbrains/kotlin/fir/FirElement;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirCompileTimeConstantEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirCompileTimeConstantEvaluatorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,520:1\n1#2:521\n*E\n"})
public final class FirCompileTimeConstantEvaluatorKt {
    private static final <T> CompileTimeType toCompileTimeType(ConstantValueKind<T> $this$toCompileTimeType) {
        ConstantValueKind<T> constantValueKind = $this$toCompileTimeType;
        return Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? CompileTimeType.BYTE : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? CompileTimeType.SHORT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? CompileTimeType.INT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? CompileTimeType.LONG : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? CompileTimeType.DOUBLE : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? CompileTimeType.FLOAT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE) ? CompileTimeType.CHAR : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE) ? CompileTimeType.BOOLEAN : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE) ? CompileTimeType.STRING : CompileTimeType.ANY))))))));
    }

    private static final Object evaluateUnary(FirExpression arg, CallableId callableId) {
        if (!(arg instanceof FirLiteralExpression) || ((FirLiteralExpression)arg).getValue() == null) {
            return null;
        }
        Object object = FirCompileTimeConstantEvaluatorKt.convertToGivenKind(((FirLiteralExpression)arg).getKind(), ((FirLiteralExpression)arg).getValue());
        if (object == null) {
            return null;
        }
        Object opr = object;
        String string2 = callableId.getCallableName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return OperationsMapGeneratedKt.evalUnaryOp(string2, FirCompileTimeConstantEvaluatorKt.toCompileTimeType(((FirLiteralExpression)arg).getKind()), opr);
    }

    private static final Object evaluateBinary(FirExpression arg1, CallableId callableId, FirExpression arg2) {
        if (!(arg1 instanceof FirLiteralExpression) || ((FirLiteralExpression)arg1).getValue() == null) {
            return null;
        }
        if (!(arg2 instanceof FirLiteralExpression) || ((FirLiteralExpression)arg2).getValue() == null) {
            return null;
        }
        CompileTimeType rightType = FirCompileTimeConstantEvaluatorKt.isStringEquals(callableId) ? CompileTimeType.ANY : (FirCompileTimeConstantEvaluatorKt.isStringPlus(callableId) ? CompileTimeType.ANY : FirCompileTimeConstantEvaluatorKt.toCompileTimeType(((FirLiteralExpression)arg2).getKind()));
        Object object = FirCompileTimeConstantEvaluatorKt.convertToGivenKind(((FirLiteralExpression)arg1).getKind(), ((FirLiteralExpression)arg1).getValue());
        if (object == null) {
            return null;
        }
        Object opr1 = object;
        Object object2 = FirCompileTimeConstantEvaluatorKt.convertToGivenKind(((FirLiteralExpression)arg2).getKind(), ((FirLiteralExpression)arg2).getValue());
        if (object2 == null) {
            return null;
        }
        Object opr2 = object2;
        String string2 = callableId.getCallableName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String functionName = string2;
        if ((Intrinsics.areEqual((Object)functionName, (Object)"div") || Intrinsics.areEqual((Object)functionName, (Object)"rem")) && rightType != CompileTimeType.FLOAT && rightType != CompileTimeType.DOUBLE) {
            Number number = opr2 instanceof Number ? (Number)((Number)opr2) : (Number)null;
            boolean bl = number != null ? number.intValue() == 0 : false;
            if (bl) {
                return FirEvaluatorResult.DivisionByZero.INSTANCE;
            }
        }
        return OperationsMapGeneratedKt.evalBinaryOp(functionName, FirCompileTimeConstantEvaluatorKt.toCompileTimeType(((FirLiteralExpression)arg1).getKind()), opr1, rightType, opr2);
    }

    private static final FirEvaluatorResult adjustTypeAndConvertToLiteral(Object $this$adjustTypeAndConvertToLiteral, FirExpression original) {
        if ($this$adjustTypeAndConvertToLiteral == null) {
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }
        if ($this$adjustTypeAndConvertToLiteral instanceof FirEvaluatorResult) {
            return (FirEvaluatorResult)$this$adjustTypeAndConvertToLiteral;
        }
        ConeKotlinType expectedType = FirTypeUtilsKt.getResolvedType(original);
        ConstantValueKind<?> constantValueKind = FirCompileTimeConstantEvaluatorKt.toConstantValueKind(expectedType);
        if (constantValueKind == null) {
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }
        ConstantValueKind<?> expectedKind = constantValueKind;
        Object object = FirCompileTimeConstantEvaluatorKt.convertToGivenKind(expectedKind, $this$adjustTypeAndConvertToLiteral);
        if (object == null) {
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }
        Object typeAdjustedValue = object;
        return FirCompileTimeConstantEvaluatorKt.wrap(FirCompileTimeConstantEvaluatorKt.toConstExpression(typeAdjustedValue, expectedKind, original));
    }

    private static final boolean isStringLength(CallableId $this$isStringLength) {
        return Intrinsics.areEqual((Object)$this$isStringLength.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringLength.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"length");
    }

    private static final boolean isStringEquals(CallableId $this$isStringEquals) {
        return Intrinsics.areEqual((Object)$this$isStringEquals.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringEquals.getCallableName(), (Object)OperatorNameConventions.EQUALS);
    }

    private static final boolean isStringPlus(CallableId $this$isStringPlus) {
        return Intrinsics.areEqual((Object)$this$isStringPlus.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringPlus.getCallableName(), (Object)OperatorNameConventions.PLUS);
    }

    private static final boolean isCharCode(CallableId $this$isCharCode) {
        return Intrinsics.areEqual((Object)$this$isCharCode.getPackageName(), (Object)StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) && $this$isCharCode.getClassId() == null && Intrinsics.areEqual((Object)$this$isCharCode.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"code");
    }

    private static final ConstantValueKind<?> toConstantValueKind(ConeKotlinType $this$toConstantValueKind) {
        Object object;
        ConeKotlinType coneKotlinType = $this$toConstantValueKind;
        if (coneKotlinType instanceof ConeErrorType) {
            object = null;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            ConeClassifierLookupTag coneClassifierLookupTag = ((ConeLookupTagBasedType)$this$toConstantValueKind).getLookupTag();
            Object object2 = coneClassifierLookupTag instanceof ConeClassLikeLookupTag ? (ConeClassLikeLookupTag)coneClassifierLookupTag : null;
            object = object2 != null && (object2 = ((ConeClassLikeLookupTag)object2).getClassId()) != null ? FirCompileTimeConstantEvaluatorKt.toConstantValueKind((ClassId)object2) : null;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = FirCompileTimeConstantEvaluatorKt.toConstantValueKind(((ConeFlexibleType)$this$toConstantValueKind).getUpperBound());
        } else if (coneKotlinType instanceof ConeCapturedType) {
            object = ((ConeCapturedType)$this$toConstantValueKind).getLowerType();
            if (object == null || (object = FirCompileTimeConstantEvaluatorKt.toConstantValueKind((ConeKotlinType)object)) == null) {
                List<ConeKotlinType> list2 = ((ConeCapturedType)$this$toConstantValueKind).getConstructor().getSupertypes();
                Intrinsics.checkNotNull(list2);
                object = FirCompileTimeConstantEvaluatorKt.toConstantValueKind((ConeKotlinType)CollectionsKt.first(list2));
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            object = FirCompileTimeConstantEvaluatorKt.toConstantValueKind(((ConeDefinitelyNotNullType)$this$toConstantValueKind).getOriginal());
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            object = FirCompileTimeConstantEvaluatorKt.toConstantValueKind((ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toConstantValueKind).getIntersectedTypes()));
        } else if ((coneKotlinType instanceof ConeStubType ? true : coneKotlinType instanceof ConeIntegerLiteralType) ? true : coneKotlinType instanceof ConeTypeVariableType) {
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private static final ConstantValueKind<?> toConstantValueKind(ClassId $this$toConstantValueKind) {
        ClassId classId = $this$toConstantValueKind;
        return Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getByte()) ? (ConstantValueKind)ConstantValueKind.Byte.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getDouble()) ? (ConstantValueKind)ConstantValueKind.Double.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getFloat()) ? (ConstantValueKind)ConstantValueKind.Float.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getInt()) ? (ConstantValueKind)ConstantValueKind.Int.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getLong()) ? (ConstantValueKind)ConstantValueKind.Long.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getShort()) ? (ConstantValueKind)ConstantValueKind.Short.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getChar()) ? (ConstantValueKind)ConstantValueKind.Char.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getString()) ? (ConstantValueKind)ConstantValueKind.String.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getBoolean()) ? (ConstantValueKind)ConstantValueKind.Boolean.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getUByte()) ? (ConstantValueKind)ConstantValueKind.UnsignedByte.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getUShort()) ? (ConstantValueKind)ConstantValueKind.UnsignedShort.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getUInt()) ? (ConstantValueKind)ConstantValueKind.UnsignedInt.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getULong()) ? (ConstantValueKind)ConstantValueKind.UnsignedLong.INSTANCE : null))))))))))));
    }

    private static final Object convertToGivenKind(ConstantValueKind<?> $this$convertToGivenKind, Object value2) {
        if (value2 == null) {
            return null;
        }
        ConstantValueKind<?> constantValueKind = $this$convertToGivenKind;
        return Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE) ? (Comparable)((Boolean)value2) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE) ? (Comparable)((Character)value2) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE) ? (Comparable)((Object)((String)value2)) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? (Comparable)Byte.valueOf(((Number)value2).byteValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? (Comparable)Double.valueOf(((Number)value2).doubleValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? (Comparable)Float.valueOf(((Number)value2).floatValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? (Comparable)Integer.valueOf(((Number)value2).intValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? (Comparable)Long.valueOf(((Number)value2).longValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? (Comparable)Short.valueOf(((Number)value2).shortValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE) ? UByte.box-impl((byte)UByte.constructor-impl((byte)((byte)((Number)value2).longValue()))) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE) ? UShort.box-impl((short)UShort.constructor-impl((short)((short)((Number)value2).longValue()))) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE) ? UInt.box-impl((int)UInt.constructor-impl((int)((int)((Number)value2).longValue()))) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)((Number)value2).longValue())) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)((Number)value2).longValue())) : null)))))))))))));
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> FirLiteralExpression<T> toConstExpression(Object $this$toConstExpression, ConstantValueKind<T> kind, FirExpression originalExpression) {
        FirLiteralExpression<Object> firLiteralExpression;
        void it;
        List<FirAnnotation> list2;
        List<FirAnnotation> list3 = list2 = originalExpression.getAnnotations();
        Object object = $this$toConstExpression;
        ConstantValueKind<T> constantValueKind = kind;
        KtSourceElement ktSourceElement = originalExpression.getSource();
        boolean bl = false;
        boolean bl2 = !((Collection)it).isEmpty();
        List<FirAnnotation> list4 = bl2 ? list2 : null;
        FirLiteralExpression<Object> $this$toConstExpression_u24lambda_u241 = firLiteralExpression = FirConstExpressionBuilderKt.buildLiteralExpression(ktSourceElement, constantValueKind, object, list4 != null ? CollectionsKt.toMutableList((Collection)list4) : null, false);
        boolean bl3 = false;
        $this$toConstExpression_u24lambda_u241.replaceConeTypeOrNull(FirTypeUtilsKt.getResolvedType(originalExpression));
        return firLiteralExpression;
    }

    private static final <T> FirLiteralExpression<T> copy(FirLiteralExpression<T> $this$copy, FirExpression originalExpression) {
        return FirCompileTimeConstantEvaluatorKt.toConstExpression($this$copy.getValue(), $this$copy.getKind(), originalExpression);
    }

    private static final FirEvaluatorResult wrap(FirElement $this$wrap) {
        return $this$wrap != null ? (FirEvaluatorResult)new FirEvaluatorResult.Evaluated($this$wrap) : (FirEvaluatorResult)FirEvaluatorResult.NotEvaluated.INSTANCE;
    }

    public static final /* synthetic */ FirEvaluatorResult access$wrap(FirElement $receiver) {
        return FirCompileTimeConstantEvaluatorKt.wrap($receiver);
    }

    public static final /* synthetic */ boolean access$isStringLength(CallableId $receiver) {
        return FirCompileTimeConstantEvaluatorKt.isStringLength($receiver);
    }

    public static final /* synthetic */ boolean access$isCharCode(CallableId $receiver) {
        return FirCompileTimeConstantEvaluatorKt.isCharCode($receiver);
    }

    public static final /* synthetic */ Object access$evaluateUnary(FirExpression arg, CallableId callableId) {
        return FirCompileTimeConstantEvaluatorKt.evaluateUnary(arg, callableId);
    }

    public static final /* synthetic */ FirEvaluatorResult access$adjustTypeAndConvertToLiteral(Object $receiver, FirExpression original) {
        return FirCompileTimeConstantEvaluatorKt.adjustTypeAndConvertToLiteral($receiver, original);
    }

    public static final /* synthetic */ Object access$evaluateBinary(FirExpression arg1, CallableId callableId, FirExpression arg2) {
        return FirCompileTimeConstantEvaluatorKt.evaluateBinary(arg1, callableId, arg2);
    }

    public static final /* synthetic */ FirLiteralExpression access$toConstExpression(Object $receiver, ConstantValueKind kind, FirExpression originalExpression) {
        return FirCompileTimeConstantEvaluatorKt.toConstExpression($receiver, kind, originalExpression);
    }

    public static final /* synthetic */ FirLiteralExpression access$copy(FirLiteralExpression $receiver, FirExpression originalExpression) {
        return FirCompileTimeConstantEvaluatorKt.copy($receiver, originalExpression);
    }
}

