/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.java.FirJvmTargetProvider;
import org.jetbrains.kotlin.fir.java.FirJvmTargetProviderKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmInlineTargetQualifiedAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInlineTargetVersion", "callableSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmInlineTargetQualifiedAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmInlineTargetQualifiedAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmInlineTargetQualifiedAccessChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,86:1\n28#2:87\n28#2:88\n*S KotlinDebug\n*F\n+ 1 FirJvmInlineTargetQualifiedAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmInlineTargetQualifiedAccessChecker\n*L\n39#1:87\n42#1:88\n*E\n"})
public final class FirJvmInlineTargetQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJvmInlineTargetQualifiedAccessChecker INSTANCE = new FirJvmInlineTargetQualifiedAccessChecker();

    private FirJvmInlineTargetQualifiedAccessChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        if (callableSymbol.getOrigin().getFromSource()) {
            return;
        }
        FirCallableSymbol firCallableSymbol2 = callableSymbol;
        if (firCallableSymbol2 instanceof FirFunctionSymbol) {
            FirCallableSymbol $this$isInline$iv = callableSymbol;
            boolean $i$f$isInline = false;
            bl = $this$isInline$iv.getRawStatus().isInline();
        } else {
            if (!(firCallableSymbol2 instanceof FirPropertySymbol)) return;
            FirPropertyAccessorSymbol accessor = FirHelpersKt.isLhsOfAssignment(expression2, context2) ? ((FirPropertySymbol)callableSymbol).getSetterSymbol() : ((FirPropertySymbol)callableSymbol).getGetterSymbol();
            if (accessor == null) return;
            FirCallableSymbol $this$isInline$iv = accessor;
            boolean $i$f$isInline = false;
            if (!$this$isInline$iv.getRawStatus().isInline()) return;
            bl = true;
        }
        boolean isInline = bl;
        if (!isInline) return;
        this.checkInlineTargetVersion(callableSymbol, context2, reporter, expression2);
    }

    private final void checkInlineTargetVersion(FirCallableSymbol<?> callableSymbol, CheckerContext context2, DiagnosticReporter reporter, FirElement element2) {
        KotlinJvmBinaryClass kotlinJvmBinaryClass2;
        Object object = FirJvmTargetProviderKt.getJvmTargetProvider(context2.getSession());
        if (object == null || (object = ((FirJvmTargetProvider)object).getJvmTarget()) == null) {
            return;
        }
        Object currentJvmTarget = object;
        ConeClassLikeLookupTag containingClass = ClassMembersKt.containingClassLookupTag(callableSymbol);
        if (containingClass != null) {
            FirRegularClassSymbol firRegularClassSymbol = LookupTagUtilsKt.toFirRegularClassSymbol(containingClass, context2.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
            SourceElement sourceElement = DeclarationAttributesKt.getSourceElement((FirClassLikeDeclaration)containingClassSymbol.getFir());
            KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement = sourceElement instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)sourceElement : null;
            if (kotlinJvmBinarySourceElement == null) {
                return;
            }
            KotlinJvmBinarySourceElement sourceElement2 = kotlinJvmBinarySourceElement;
            kotlinJvmBinaryClass2 = sourceElement2.getBinaryClass();
        } else {
            DeserializedContainerSource deserializedContainerSource = callableSymbol.getContainerSource();
            JvmPackagePartSource jvmPackagePartSource = deserializedContainerSource instanceof JvmPackagePartSource ? (JvmPackagePartSource)deserializedContainerSource : null;
            if (jvmPackagePartSource == null) {
                return;
            }
            JvmPackagePartSource containerSource = jvmPackagePartSource;
            kotlinJvmBinaryClass2 = containerSource.getKnownJvmBinaryClass();
        }
        KotlinJvmBinaryClass binaryClass = kotlinJvmBinaryClass2;
        FileBasedKotlinClass fileBasedKotlinClass = binaryClass instanceof FileBasedKotlinClass ? (FileBasedKotlinClass)binaryClass : null;
        if (fileBasedKotlinClass == null) {
            return;
        }
        int inlinedVersion = fileBasedKotlinClass.getClassVersion();
        int currentVersion = ((JvmTarget)currentJvmTarget).getMajorVersion();
        if (currentVersion < inlinedVersion) {
            Object object2 = ReferenceUtilsKt.toReference(element2, context2.getSession());
            if (object2 == null || (object2 = ((FirReference)object2).getSource()) == null) {
                object2 = element2.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)object2, FirJvmErrors.INSTANCE.getINLINE_FROM_HIGHER_PLATFORM(), (Object)JvmTarget.Companion.getDescription(inlinedVersion), (Object)JvmTarget.Companion.getDescription(currentVersion), (DiagnosticContext)context2, null, 32, null);
        }
    }
}

