/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J8\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u0003*\u00020\u00052\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00030\u0013H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy;", "", "considerType", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "missingTypes", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reportMissingTypes", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isTypeOfLambdaParameter", "", "forEachClassLikeType", "action", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1863#2,2:117\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy\n*L\n65#1:117,2\n*E\n"})
public interface FirMissingDependencyClassProxy {
    default public void forEachClassLikeType(@NotNull ConeKotlinType $this$forEachClassLikeType, @NotNull Function1<? super ConeClassLikeType, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachClassLikeType, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ConeKotlinType coneKotlinType = $this$forEachClassLikeType;
        if (coneKotlinType instanceof ConeFlexibleType) {
            this.forEachClassLikeType(((ConeFlexibleType)$this$forEachClassLikeType).getLowerBound(), action);
            this.forEachClassLikeType(((ConeFlexibleType)$this$forEachClassLikeType).getUpperBound(), action);
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.forEachClassLikeType(((ConeDefinitelyNotNullType)$this$forEachClassLikeType).getOriginal(), action);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            Iterable $this$forEach$iv = ((ConeIntersectionType)$this$forEachClassLikeType).getIntersectedTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                this.forEachClassLikeType(it, action);
            }
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            action.invoke((Object)$this$forEachClassLikeType);
        }
    }

    default public void considerType(@NotNull ConeKotlinType type2, @NotNull Set<ConeKotlinType> missingTypes, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(missingTypes, (String)"missingTypes");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Ref.BooleanRef hasError2 = new Ref.BooleanRef();
        Ref.BooleanRef hasMissingClass = new Ref.BooleanRef();
        this.forEachClassLikeType(type2, (Function1<? super ConeClassLikeType, Unit>)((Function1)new Function1<ConeClassLikeType, Unit>(hasError2, this, missingTypes, context2, hasMissingClass){
            final /* synthetic */ Ref.BooleanRef $hasError;
            final /* synthetic */ FirMissingDependencyClassProxy this$0;
            final /* synthetic */ Set<ConeKotlinType> $missingTypes;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ Ref.BooleanRef $hasMissingClass;
            {
                this.$hasError = $hasError;
                this.this$0 = $receiver;
                this.$missingTypes = $missingTypes;
                this.$context = $context;
                this.$hasMissingClass = $hasMissingClass;
                super(1);
            }

            public final void invoke(ConeClassLikeType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof ConeErrorType) {
                    ConeKotlinType delegatedType = ((ConeErrorType)it).getDelegatedType();
                    if (delegatedType == null) {
                        this.$hasError.element = true;
                    } else {
                        this.this$0.considerType(delegatedType, this.$missingTypes, this.$context);
                    }
                } else {
                    this.$hasMissingClass.element = this.$hasMissingClass.element || LookupTagUtilsKt.toSymbol(it.getLookupTag(), this.$context.getSession()) == null;
                }
            }
        }));
        if (hasMissingClass.element && !hasError2.element) {
            ConeKotlinType reportedType = TypeUtilsKt.withNullability$default(type2, ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(context2.getSession()), null, false, 12, null);
            missingTypes.add(reportedType);
        }
    }

    default public void reportMissingTypes(@Nullable KtSourceElement source, @NotNull Set<ConeKotlinType> missingTypes, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, boolean isTypeOfLambdaParameter) {
        Intrinsics.checkNotNullParameter(missingTypes, (String)"missingTypes");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Set reported = new LinkedHashSet();
        for (ConeKotlinType missingType : missingTypes) {
            ConeKotlinType withoutArguments = TypeUtilsKt.withArguments(missingType, new ConeTypeProjection[0]);
            if (reported.contains(withoutArguments)) continue;
            if (isTypeOfLambdaParameter && missingType.getTypeArguments().length == 0 && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ForbidLambdaParameterWithMissingDependencyType)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS_IN_LAMBDA_PARAMETER(), (Object)withoutArguments, (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS(), (Object)withoutArguments, (DiagnosticContext)context2, null, 16, null);
            ((Collection)reported).add(withoutArguments);
        }
    }
}

