/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.IndexedGetIterationHandler;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0006*\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\r*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\b*\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/ArrayIterationHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/IndexedGetIterationHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "supportsUnsignedArrays", "", "getFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getGetFunction", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getFunctionName", "Lorg/jetbrains/kotlin/name/Name;", "getGetFunctionName", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/name/Name;", "sizePropertyGetter", "getSizePropertyGetter", "matchIterable", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isArrayType", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIndexedGetIterationHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedGetIterationHandlers.kt\norg/jetbrains/kotlin/backend/common/lower/loops/handlers/ArrayIterationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,154:1\n1#2:155\n350#3,12:156\n*S KotlinDebug\n*F\n+ 1 IndexedGetIterationHandlers.kt\norg/jetbrains/kotlin/backend/common/lower/loops/handlers/ArrayIterationHandler\n*L\n102#1:156,12\n*E\n"})
public final class ArrayIterationHandler
extends IndexedGetIterationHandler {
    private final boolean supportsUnsignedArrays;

    public ArrayIterationHandler(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, true);
        this.supportsUnsignedArrays = context2.getOptimizeLoopsOverUnsignedArrays();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchIterable(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.isArrayType(expression2.getType())) {
            return true;
        }
        if (!(expression2 instanceof IrCall)) return false;
        IrCall irCall = (IrCall)expression2;
        Object object = irCall;
        if (irCall == null) return false;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = ((IrCall)object).getSymbol();
        object = irSimpleFunctionSymbol;
        if (irSimpleFunctionSymbol == null) return false;
        if ((object = (IrSimpleFunction)object.getOwner()) == null) {
            return false;
        }
        Object callee = object;
        if (!((IrFunction)callee).getValueParameters().isEmpty()) return false;
        IrValueParameter irValueParameter = ((IrFunction)callee).getExtensionReceiverParameter();
        IrAnnotationContainer irAnnotationContainer = irValueParameter;
        if (irValueParameter == null) return false;
        IrType irType = irAnnotationContainer.getType();
        irAnnotationContainer = irType;
        if (irType == null) return false;
        IrAnnotationContainer irAnnotationContainer2 = irAnnotationContainer;
        boolean bl = false;
        if (!IrTypePredicatesKt.isArray((IrType)irAnnotationContainer2)) {
            if (!IrTypeUtilsKt.isPrimitiveArray((IrType)irAnnotationContainer2)) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)callee), (Object)new FqName("kotlin.collections.reversed"))) return false;
        return true;
    }

    @Override
    @NotNull
    public IrSimpleFunction getSizePropertyGetter(@NotNull IrType $this$sizePropertyGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$sizePropertyGetter, (String)"<this>");
        IrClass irClass = IrTypesKt.getClass($this$sizePropertyGetter);
        Intrinsics.checkNotNull((Object)irClass);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertyGetter(irClass, "size");
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
    }

    private final boolean isArrayType(IrType $this$isArrayType) {
        return IrTypePredicatesKt.isArray($this$isArrayType) || IrTypeUtilsKt.isPrimitiveArray($this$isArrayType) || this.supportsUnsignedArrays && IrTypeUtilsKt.isUnsignedArray($this$isArrayType);
    }

    private final Name getGetFunctionName(IrType $this$getFunctionName) {
        Name it = this.getContext().getIr().getSymbols().getGetWithoutBoundCheckName();
        boolean bl = false;
        return this.isArrayType($this$getFunctionName) && it != null ? it : OperatorNameConventions.GET;
    }

    @Override
    @NotNull
    public IrSimpleFunction getGetFunction(@NotNull IrType $this$getFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunction, (String)"<this>");
        IrClass irClass = IrTypesKt.getClass($this$getFunction);
        Intrinsics.checkNotNull((Object)irClass);
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)this.getGetFunctionName($this$getFunction)) && it.getValueParameters().size() == 1 && IrTypePredicatesKt.isInt(it.getValueParameters().get(0).getType()))) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return single$iv;
    }
}

