/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalFileChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExternalFileChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExternalFileChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalFileChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n288#2,2:45\n*S KotlinDebug\n*F\n+ 1 FirJsExternalFileChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalFileChecker\n*L\n32#1:45,2\n*E\n"})
public final class FirJsExternalFileChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsExternalFileChecker INSTANCE = new FirJsExternalFileChecker();

    private FirJsExternalFileChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirAnnotation targetAnnotations;
        FirAnnotation firAnnotation;
        List<FirAnnotation> list2;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Object object = FirHelpersKt.closestNonLocalWith(context2, declaration2);
        if (object == null || (object = ((FirDeclaration)object).getSymbol()) == null) {
            return;
        }
        Object closestNonLocal = object;
        if (FirJsHelpersKt.isNativeObject(closestNonLocal, context2) || !FirHelpersKt.isTopLevel(context2)) {
            return;
        }
        FirFile firFile = context2.getContainingFile();
        if (firFile != null && (list2 = firFile.getAnnotations()) != null) {
            Object v1;
            block6: {
                void $this$firstOrNull$iv;
                Iterable iterable = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirAnnotation it = (FirAnnotation)element$iv;
                    boolean bl = false;
                    if (!CollectionsKt.contains((Iterable)JsStandardClassIds.Annotations.annotationsRequiringExternal, (Object)FirAnnotationUtilsKt.toAnnotationClassId(it, context2.getSession()))) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            firAnnotation = v1;
        } else {
            firAnnotation = targetAnnotations = null;
        }
        if (targetAnnotations != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getNON_EXTERNAL_DECLARATION_IN_INAPPROPRIATE_FILE(), (Object)FirTypeUtilsKt.getResolvedType(targetAnnotations), (DiagnosticContext)context2, null, 16, null);
        }
    }
}

