/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.utils.caches;

import com.intellij.openapi.project.Project;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CachedValueBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.utils.caches.SoftCachedMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J#\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0015\u001a\u00028\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R6\u0010\f\u001a*\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u0000\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0001 \u000e*\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000f0\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/utils/caches/SoftCachedMapWithTrackers;", "K", "", "V", "Lorg/jetbrains/kotlin/analysis/utils/caches/SoftCachedMap;", "project", "Lcom/intellij/openapi/project/Project;", "kind", "Lorg/jetbrains/kotlin/analysis/utils/caches/SoftCachedMap$Kind;", "trackers", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/analysis/utils/caches/SoftCachedMap$Kind;[Ljava/lang/Object;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "Lcom/intellij/psi/util/CachedValue;", "[Ljava/lang/Object;", "clear", "", "clearCachedValues", "getOrPut", "key", "create", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "analysis-internal-utils"})
@SourceDebugExtension(value={"SMAP\nSoftCachedMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoftCachedMap.kt\norg/jetbrains/kotlin/analysis/utils/caches/SoftCachedMapWithTrackers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1853#2,2:85\n72#3,2:87\n1#4:89\n*S KotlinDebug\n*F\n+ 1 SoftCachedMap.kt\norg/jetbrains/kotlin/analysis/utils/caches/SoftCachedMapWithTrackers\n*L\n55#1:85,2\n61#1:87,2\n61#1:89\n*E\n"})
final class SoftCachedMapWithTrackers<K, V>
extends SoftCachedMap<K, V> {
    @NotNull
    private final Project project;
    @NotNull
    private final Object[] trackers;
    @NotNull
    private final ConcurrentMap<K, CachedValue<V>> cache;

    public SoftCachedMapWithTrackers(@NotNull Project project, @NotNull SoftCachedMap.Kind kind, @NotNull Object[] trackers) {
        ConcurrentMap concurrentMap;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)trackers, (String)"trackers");
        this.project = project;
        this.trackers = trackers;
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentSoftMap();
                concurrentMap = concurrentMap2;
                Intrinsics.checkNotNullExpressionValue(concurrentMap2, (String)"createConcurrentSoftMap(...)");
                break;
            }
            case 2: {
                concurrentMap = new ConcurrentHashMap();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.cache = concurrentMap;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void clearCachedValues() {
        Iterable $this$forEach$iv = this.cache.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CachedValue it = (CachedValue)element$iv;
            boolean bl = false;
            CachedValueBase cachedValueBase = it instanceof CachedValueBase ? (CachedValueBase)((Object)it) : null;
            if (cachedValueBase == null) continue;
            cachedValueBase.clear();
        }
    }

    @Override
    @NotNull
    public V getOrPut(@NotNull K key, @NotNull Function0<? extends V> create2) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(create2, (String)"create");
        ConcurrentMap $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key);
        if (object == null) {
            boolean bl = false;
            CachedValue default$iv = CachedValuesManager.getManager(this.project).createCachedValue(() -> SoftCachedMapWithTrackers.getOrPut$lambda$2$lambda$1(create2, this));
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object t = ((CachedValue)object).getValue();
        Intrinsics.checkNotNullExpressionValue(t, (String)"getValue(...)");
        return (V)t;
    }

    private static final CachedValueProvider.Result getOrPut$lambda$2$lambda$1(Function0 $create, SoftCachedMapWithTrackers this$0) {
        Intrinsics.checkNotNullParameter((Object)$create, (String)"$create");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = this$0.trackers;
        return new CachedValueProvider.Result<Object>($create.invoke(), Arrays.copyOf(objectArray, objectArray.length));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SoftCachedMap.Kind.values().length];
            try {
                nArray[SoftCachedMap.Kind.SOFT_KEYS_SOFT_VALUES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoftCachedMap.Kind.STRONG_KEYS_SOFT_VALUES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

