/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentIntKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.IntKeyWeakValueHashMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.SoftValueHashMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakHashSet;
import com.intellij.util.containers.WeakKeyIntValueHashMap;
import com.intellij.util.containers.WeakValueHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public final class ContainerUtil {
    private static final int INSERTION_SORT_THRESHOLD = 10;

    @SafeVarargs
    @Contract(pure=true)
    public static <T> T @NotNull [] ar(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(1);
        }
        return elements;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(2);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(3);
        }
        HashMap<K, V> map = new HashMap<K, V>(entries.length + 1);
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull List<? extends K> keys2, @NotNull List<? extends V> values2) {
        if (keys2 == null) {
            ContainerUtil.$$$reportNull$$$0(5);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(6);
        }
        if (keys2.size() != values2.size()) {
            throw new IllegalArgumentException(keys2 + " must have same length as " + values2);
        }
        HashMap<K, V> map = new HashMap<K, V>(keys2.size());
        for (int i = 0; i < keys2.size(); ++i) {
            map.put(keys2.get(i), values2.get(i));
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(8);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(9);
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        LinkedHashMap<K, V> linkedHashMap = map;
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(10);
        }
        return linkedHashMap;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(11);
        }
        return tObjectHashingStrategy;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(12);
        }
        return tObjectHashingStrategy;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(13);
        }
        LinkedList list2 = new LinkedList();
        Collections.addAll(list2, elements);
        LinkedList linkedList = list2;
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(14);
        }
        return linkedList;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(15);
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    @Contract(pure=true)
    @NotNull
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(16);
        }
        ArrayList<E> collection = new ArrayList<E>();
        for (E element2 : iterable) {
            collection.add(element2);
        }
        ArrayList<E> arrayList = collection;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        return new ArrayList(size);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> newArrayList(final T @NotNull [] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(18);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index2) {
                if (index2 < 0 || index2 >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index2 + " size:" + this.size);
                }
                return elements[start + index2];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> newUnmodifiableList(@NotNull List<? extends T> originalList) {
        int size;
        if (originalList == null) {
            ContainerUtil.$$$reportNull$$$0(19);
        }
        if ((size = originalList.size()) == 0) {
            return ContainerUtil.emptyList();
        }
        if (size == 1) {
            List<T> list2 = Collections.singletonList(originalList.get(0));
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(20);
            }
            return list2;
        }
        List<? extends T> list3 = Collections.unmodifiableList(new ArrayList<T>(originalList));
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(21);
        }
        return list3;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> unmodifiableOrEmptyCollection(@NotNull Collection<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(22);
        }
        if ((size = original.size()) == 0) {
            return ContainerUtil.emptyList();
        }
        Collection<? extends T> collection = Collections.unmodifiableCollection(original);
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> unmodifiableOrEmptyList(@NotNull List<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(24);
        }
        if ((size = original.size()) == 0) {
            return ContainerUtil.emptyList();
        }
        List<? extends T> list2 = Collections.unmodifiableList(original);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(25);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> unmodifiableOrEmptySet(@NotNull Set<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(26);
        }
        if ((size = original.size()) == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(27);
            }
            return set;
        }
        Set<? extends T> set = Collections.unmodifiableSet(original);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(28);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> unmodifiableOrEmptyMap(@NotNull Map<? extends K, ? extends V> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(29);
        }
        if ((size = original.size()) == 0) {
            Map map = Collections.emptyMap();
            if (map == null) {
                ContainerUtil.$$$reportNull$$$0(30);
            }
            return map;
        }
        Map<? extends K, ? extends V> map = Collections.unmodifiableMap(original);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(31);
        }
        return map;
    }

    @Deprecated
    @NotNull
    public static <T> List<T> newSmartList() {
        return new SmartList();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static <T> List<T> newSmartList(T element2) {
        return new SmartList<T>(element2);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(32);
        }
        return new HashSet<T>(Arrays.asList(elements));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(33);
        }
        Iterator<T> iterator2 = iterable.iterator();
        HashSet<T> set = new HashSet<T>();
        while (iterator2.hasNext()) {
            set.add(iterator2.next());
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(34);
        }
        return hashSet;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(35);
        }
        return new HashSet<T>(collection);
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(36);
        }
        HashSet<T> set = new HashSet<T>();
        while (iterator2.hasNext()) {
            set.add(iterator2.next());
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(37);
        }
        return hashSet;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean isEmpty2;
        boolean bl = isEmpty2 = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        if (isEmpty2) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(38);
            }
            return set;
        }
        return ContainerUtil.newHashSet(iterable);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(39);
        }
        LinkedHashSet<T> collection = new LinkedHashSet<T>();
        for (T element2 : elements) {
            collection.add(element2);
        }
        LinkedHashSet<T> linkedHashSet = collection;
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(40);
        }
        return linkedHashSet;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(41);
        }
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> THashSet<T> newTroveSet() {
        return new THashSet();
    }

    @SafeVarargs
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(pure=true)
    @NotNull
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(42);
        }
        return new THashSet<T>(Arrays.asList(elements));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(pure=true)
    @NotNull
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        return new THashMap(ContainerUtil.identityStrategy());
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> newConcurrentSet() {
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(43);
        }
        return set;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    @Contract(pure=true)
    @NotNull
    public static <E> List<E> reverse(final @NotNull List<? extends E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(44);
        }
        if (elements.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index2) {
                return elements.get(elements.size() - 1 - index2);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> union(@NotNull Map<? extends K, ? extends V> map, @NotNull Map<? extends K, ? extends V> map2) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(45);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(46);
        }
        HashMap<K, V> result2 = new HashMap<K, V>(map.size() + map2.size());
        result2.putAll(map);
        result2.putAll(map2);
        HashMap<K, V> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(47);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> union(@NotNull Set<? extends T> set, @NotNull Set<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(48);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(49);
        }
        return ContainerUtil.union(set, set2);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> union(@NotNull Collection<? extends T> set, @NotNull Collection<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(50);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(51);
        }
        HashSet<T> result2 = new HashSet<T>(set.size() + set2.size());
        result2.addAll(set);
        result2.addAll(set2);
        HashSet<T> hashSet = result2;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(52);
        }
        return hashSet;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(53);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(54);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(55);
                }
                return set;
            }
        }
        Set<E> set = Collections.unmodifiableSet(new HashSet<E>(Arrays.asList(elements)));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(56);
        }
        return set;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <E> ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(57);
        }
        return new ImmutableListBackedByArray(array);
    }

    @Contract(pure=true)
    @NotNull
    public static <E> ImmutableList<E> immutableSingletonList(E element2) {
        ImmutableList<E> immutableList = ImmutableList.singleton(element2);
        if (immutableList == null) {
            ContainerUtil.$$$reportNull$$$0(58);
        }
        return immutableList;
    }

    @Contract(pure=true)
    @NotNull
    public static <E> ImmutableList<E> immutableList(@NotNull List<? extends E> list2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(59);
        }
        return new ImmutableListBackedByList(list2);
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        return new ImmutableMapBuilder();
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> MultiMap<K, V> groupBy(@NotNull Iterable<? extends V> collection, @NotNull NullableFunction<? super V, ? extends K> grouper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(60);
        }
        if (grouper == null) {
            ContainerUtil.$$$reportNull$$$0(61);
        }
        MultiMap<K, V> result2 = MultiMap.createLinked();
        for (V data2 : collection) {
            K key = grouper.fun(data2);
            if (key == null) continue;
            result2.putValue(key, data2);
        }
        if (!result2.isEmpty() && result2.keySet().iterator().next() instanceof Comparable) {
            return new KeyOrderedMultiMap(result2);
        }
        MultiMap<K, V> multiMap = result2;
        if (multiMap == null) {
            ContainerUtil.$$$reportNull$$$0(62);
        }
        return multiMap;
    }

    @Contract(pure=true)
    public static <T> T getOrElse(@NotNull List<? extends T> elements, int i, T defaultValue) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(63);
        }
        return elements.size() > i ? elements.get(i) : defaultValue;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> intersection(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(64);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(65);
        }
        if (map1.isEmpty() || map2.isEmpty()) {
            Map map = Collections.emptyMap();
            if (map == null) {
                ContainerUtil.$$$reportNull$$$0(66);
            }
            return map;
        }
        if (map2.size() < map1.size()) {
            Map<K, V> t = map1;
            map1 = map2;
            map2 = t;
        }
        HashMap<K, V> res2 = new HashMap<K, V>(map1);
        for (Map.Entry<K, V> entry : map1.entrySet()) {
            V v2;
            K key = entry.getKey();
            V v1 = entry.getValue();
            if (Objects.equals(v1, v2 = map2.get(key))) continue;
            res2.remove(key);
        }
        HashMap<K, V> hashMap = res2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(67);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, Couple<V>> diff(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(68);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(69);
        }
        Set<K> keys2 = ContainerUtil.union(map1.keySet(), map2.keySet());
        HashMap<K, Couple<V>> res2 = new HashMap<K, Couple<V>>();
        for (K k : keys2) {
            V v2;
            V v1 = map1.get(k);
            if (Objects.equals(v1, v2 = map2.get(k))) continue;
            res2.put(k, Couple.of(v1, v2));
        }
        HashMap<K, Couple<V>> hashMap = res2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(70);
        }
        return hashMap;
    }

    public static <T> void processSortedListsInOrder(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems, @NotNull PairConsumer<? super T, ? super Boolean> processor2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(71);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(72);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(73);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(74);
        }
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            T element2;
            T e;
            if (index1 >= list1.size()) {
                e = list2.get(index2++);
                processor2.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(false)));
                continue;
            }
            if (index2 >= list2.size()) {
                e = list1.get(index1++);
                processor2.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(true)));
                continue;
            }
            T element1 = list1.get(index1);
            int c = comparator.compare(element1, element2 = list2.get(index2));
            if (c == 0) {
                ++index1;
                ++index2;
                if (mergeEqualItems) {
                    e = element1;
                    processor2.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(true)));
                    continue;
                }
                processor2.consume((Boolean)element1, (Boolean)((Boolean)Boolean.valueOf(true)));
                e = element2;
                processor2.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(false)));
                continue;
            }
            if (c < 0) {
                e = element1;
                ++index1;
                processor2.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(true)));
                continue;
            }
            e = element2;
            ++index2;
            processor2.consume((Boolean)e, (Boolean)((Boolean)Boolean.valueOf(false)));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> mergeSortedLists(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(75);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(76);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(77);
        }
        ArrayList result2 = new ArrayList(list1.size() + list2.size());
        ContainerUtil.processSortedListsInOrder(list1, list2, comparator, mergeEqualItems, (t, __) -> result2.add(t));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(78);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> subList(@NotNull List<T> list2, int from2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(79);
        }
        List<T> list3 = list2.subList(from2, list2.size());
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(80);
        }
        return list3;
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(81);
        }
        if (appendix == null) {
            ContainerUtil.$$$reportNull$$$0(82);
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> iterator2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(83);
        }
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(84);
        }
        while (iterator2.hasNext()) {
            T o = iterator2.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(85);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(86);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(87);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(88);
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<? extends T> iterator2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(89);
        }
        if (!iterator2.hasNext()) {
            return ContainerUtil.emptyList();
        }
        ArrayList list2 = new ArrayList();
        ContainerUtil.addAll(list2, iterator2);
        ArrayList arrayList = list2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(90);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newMapFromKeys(@NotNull Iterator<? extends K> keys2, @NotNull Convertor<? super K, ? extends V> valueConvertor) {
        if (keys2 == null) {
            ContainerUtil.$$$reportNull$$$0(91);
        }
        if (valueConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(92);
        }
        HashMap<K, V> map = new HashMap<K, V>();
        while (keys2.hasNext()) {
            K key = keys2.next();
            map.put(key, valueConvertor.convert(key));
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(93);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newMapFromValues(@NotNull Iterator<? extends V> values2, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(94);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(95);
        }
        HashMap map = new HashMap();
        ContainerUtil.fillMapWithValues(map, values2, keyConvertor);
        HashMap hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(96);
        }
        return hashMap;
    }

    public static <K, V> void fillMapWithValues(@NotNull Map<? super K, ? super V> map, @NotNull Iterator<? extends V> values2, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(97);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(98);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(99);
        }
        while (values2.hasNext()) {
            V value2 = values2.next();
            map.put(keyConvertor.convert(value2), value2);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, Set<V>> classify(@NotNull Iterator<? extends V> iterator2, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(100);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(101);
        }
        LinkedHashMap<Object, Set> hashMap = new LinkedHashMap<Object, Set>();
        while (iterator2.hasNext()) {
            V value2 = iterator2.next();
            K key = keyConvertor.convert(value2);
            Set set = hashMap.computeIfAbsent(key, __ -> new LinkedHashSet());
            set.add(value2);
        }
        LinkedHashMap<Object, Set> linkedHashMap = hashMap;
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(102);
        }
        return linkedHashMap;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> emptyIterable() {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(103);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> T find(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(105);
        }
        for (T element2 : array) {
            if (!condition.value(element2)) continue;
            return element2;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<? super T> processor2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(106);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(107);
        }
        for (T t : iterable) {
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list2, @NotNull Processor<? super T> processor2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(108);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(109);
        }
        int size = list2.size();
        for (int i = 0; i < size; ++i) {
            T t = list2.get(i);
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(T @NotNull [] iterable, @NotNull Processor<? super T> processor2) {
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(110);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(111);
        }
        for (T t : iterable) {
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull Iterator<? extends T> iterator2, @NotNull Processor<? super T> processor2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(112);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(113);
        }
        while (iterator2.hasNext()) {
            if (processor2.process(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(114);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(115);
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull T equalTo) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(116);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(117);
        }
        return (T)ContainerUtil.find(iterable, object -> equalTo == object || equalTo.equals(object));
    }

    @Contract(pure=true)
    public static <T> T find(@NotNull Iterator<? extends T> iterator2, @NotNull T equalTo) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(118);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(119);
        }
        return (T)ContainerUtil.find(iterator2, (? super T object) -> equalTo == object || equalTo.equals(object));
    }

    public static <T> T find(@NotNull Iterator<? extends T> iterator2, @NotNull Condition<? super T> condition) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(120);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(121);
        }
        while (iterator2.hasNext()) {
            T value2 = iterator2.next();
            if (!condition.value(value2)) continue;
            return value2;
        }
        return null;
    }

    @Contract(pure=true)
    public static <T> T findLast(@NotNull List<? extends T> list2, @NotNull Condition<? super T> condition) {
        int index2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(122);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(123);
        }
        if ((index2 = ContainerUtil.lastIndexOf(list2, condition)) < 0) {
            return null;
        }
        return list2.get(index2);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2Map(T @NotNull [] collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(124);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(125);
        }
        return ContainerUtil.map2Map(Arrays.asList(collection), mapper);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2Map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(126);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(127);
        }
        HashMap set = new HashMap(collection.size());
        for (T t : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t);
            set.put(pair.first, pair.second);
        }
        HashMap hashMap = set;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(128);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2MapNotNull(T @NotNull [] collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(129);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(130);
        }
        return ContainerUtil.map2MapNotNull(Arrays.asList(collection), mapper);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2MapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(131);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(132);
        }
        HashMap set = new HashMap(collection.size());
        for (T t : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t);
            if (pair == null) continue;
            set.put(pair.first, pair.second);
        }
        HashMap hashMap = set;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(133);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> map2Map(@NotNull Collection<? extends Pair<? extends K, ? extends V>> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(134);
        }
        HashMap result2 = new HashMap(collection.size());
        for (Pair<K, V> pair : collection) {
            result2.put(pair.first, pair.second);
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(135);
        }
        return hashMap;
    }

    @Contract(pure=true)
    public static <T> Object @NotNull [] map2Array(T @NotNull [] array, @NotNull Function<? super T, Object> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(136);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(137);
        }
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    @Contract(pure=true)
    public static <T> Object @NotNull [] map2Array(@NotNull Collection<? extends T> array, @NotNull Function<? super T, Object> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(138);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(139);
        }
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map2Array(T @NotNull [] array, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(140);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(141);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(142);
        }
        V[] result2 = ArrayUtil.newArray(aClass, array.length);
        for (int i = 0; i < array.length; ++i) {
            result2[i] = mapper.fun(array[i]);
        }
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(143);
        }
        return result2;
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(144);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(145);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(146);
        }
        V[] result2 = ArrayUtil.newArray(aClass, collection.size());
        int i = 0;
        for (T t : collection) {
            result2[i++] = mapper.fun(t);
        }
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(147);
        }
        return result2;
    }

    @Contract(mutates="param2")
    public static <T, V> V @NotNull [] map2Array(@NotNull Collection<? extends T> collection, V @NotNull [] to, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(148);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(149);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(150);
        }
        V[] VArray = ContainerUtil.map2List(collection, mapper).toArray(to);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(151);
        }
        return VArray;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> filter(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(152);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(153);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> findAll(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(154);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(155);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(156);
        }
        return smartList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> filterIsInstance(@NotNull Collection<?> collection, @NotNull Class<? extends T> aClass) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(157);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(158);
        }
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> filterIsInstance(Object @NotNull [] collection, @NotNull Class<? extends T> aClass) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(159);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(160);
        }
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(161);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(162);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> filter(@NotNull Map<? extends K, ? extends V> map, @NotNull Condition<? super K> keyFilter) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(163);
        }
        if (keyFilter == null) {
            ContainerUtil.$$$reportNull$$$0(164);
        }
        HashMap<K, V> result2 = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!keyFilter.value(entry.getKey())) continue;
            result2.put(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(165);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(166);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(167);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(168);
        }
        return smartList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(169);
        }
        return ContainerUtil.findAll(collection, Conditions.notNull());
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V extends T> List<V> findAll(T @NotNull [] array, @NotNull Class<V> instanceOf) {
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(170);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(171);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : array) {
            if (!instanceOf.isInstance(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(172);
        }
        return smartList;
    }

    @Contract(pure=true)
    public static <T, V extends T> V @NotNull [] findAllAsArray(T @NotNull [] collection, @NotNull Class<V> instanceOf) {
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(173);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(174);
        }
        List<V> list2 = ContainerUtil.findAll(collection, instanceOf);
        V[] array = ArrayUtil.newArray(instanceOf, list2.size());
        V[] VArray = list2.toArray(array);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(175);
        }
        return VArray;
    }

    @Contract(pure=true)
    public static <T, V extends T> V @NotNull [] findAllAsArray(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(176);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(177);
        }
        List<V> list2 = ContainerUtil.findAll(collection, instanceOf);
        V[] array = ArrayUtil.newArray(instanceOf, list2.size());
        V[] VArray = list2.toArray(array);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(178);
        }
        return VArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] findAllAsArray(T @NotNull [] collection, @NotNull Condition<? super T> instanceOf) {
        List<T> list2;
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(179);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(180);
        }
        if ((list2 = ContainerUtil.findAll(collection, instanceOf)).size() == collection.length) {
            if (collection == null) {
                ContainerUtil.$$$reportNull$$$0(181);
            }
            return collection;
        }
        T[] array = ArrayUtil.newArray(ArrayUtil.getComponentType(collection), list2.size());
        T[] TArray = list2.toArray(array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(182);
        }
        return TArray;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V extends T> List<V> findAll(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(183);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(184);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(185);
        }
        return smartList;
    }

    public static <T> boolean all(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(186);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(187);
        }
        for (T t : collection) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static void removeDuplicates(@NotNull Collection<?> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(188);
        }
        HashSet collected = new HashSet();
        collection.removeIf(t -> !collected.add(t));
    }

    @Contract(pure=true)
    @NotNull
    public static Map<String, String> stringMap(String ... keyValues) {
        if (keyValues == null) {
            ContainerUtil.$$$reportNull$$$0(189);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            result2.put(keyValues[i], keyValues[i + 1]);
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(190);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> iterate(T @NotNull [] array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(191);
        }
        Iterator iterator2 = array.length == 0 ? Collections.emptyIterator() : Arrays.asList(array).iterator();
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(192);
        }
        return iterator2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> iterate(final @NotNull Enumeration<? extends T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(193);
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> iterate(T @NotNull [] arrays, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(194);
        }
        if (arrays == null) {
            ContainerUtil.$$$reportNull$$$0(195);
        }
        return ContainerUtil.iterate(Arrays.asList(arrays), condition);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(196);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(197);
        }
        if (collection.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(198);
            }
            return list2;
        }
        Iterable iterable = () -> new Iterator<T>(){
            private final Iterator impl;
            private Object next;
            {
                this.impl = collection.iterator();
                this.next = this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                Object result2 = this.next;
                this.next = this.findNext();
                return result2;
            }

            @Nullable
            private T findNext() {
                while (this.impl.hasNext()) {
                    Object each = this.impl.next();
                    if (!condition.value(each)) continue;
                    return each;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(199);
        }
        return iterable;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> iterateBackward(final @NotNull List<? extends T> list2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(200);
        }
        Iterable iterable = () -> new Iterator<T>(){
            private final ListIterator it;
            {
                this.it = list2.listIterator(list2.size());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasPrevious();
            }

            @Override
            public T next() {
                return this.it.previous();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(201);
        }
        return iterable;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, E> Iterable<Pair<T, E>> zip(final @NotNull Iterable<? extends T> iterable1, final @NotNull Iterable<? extends E> iterable2) {
        if (iterable1 == null) {
            ContainerUtil.$$$reportNull$$$0(202);
        }
        if (iterable2 == null) {
            ContainerUtil.$$$reportNull$$$0(203);
        }
        Iterable<Pair<T, E>> iterable = () -> new Iterator<Pair<T, E>>(){
            private final Iterator i1;
            private final Iterator i2;
            {
                this.i1 = iterable1.iterator();
                this.i2 = iterable2.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i1.hasNext() && this.i2.hasNext();
            }

            @Override
            public Pair<T, E> next() {
                return Pair.create(this.i1.next(), this.i2.next());
            }

            @Override
            public void remove() {
                this.i1.remove();
                this.i2.remove();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(204);
        }
        return iterable;
    }

    public static void swapElements(@NotNull List<?> list2, int index1, int index2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(205);
        }
        Object e1 = list2.get(index1);
        Object e2 = list2.get(index2);
        list2.set(index1, e2);
        list2.set(index2, e1);
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<?> iterator2, @NotNull FilteringIterator.InstanceOf<T> instanceOf) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(206);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(207);
        }
        return ContainerUtil.collect(FilteringIterator.create(iterator2, instanceOf));
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(208);
        }
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(209);
        }
        while (enumeration.hasMoreElements()) {
            T element2 = enumeration.nextElement();
            collection.add(element2);
        }
    }

    @SafeVarargs
    @NotNull
    public static <T, C extends Collection<? super T>> C addAll(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(210);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(211);
        }
        for (T element2 : elements) {
            collection.add(element2);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(212);
        }
        return c;
    }

    @SafeVarargs
    @NotNull
    public static <T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(213);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(214);
        }
        for (T element2 : elements) {
            if (element2 == null) continue;
            collection.add(element2);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(215);
        }
        return c;
    }

    @SafeVarargs
    public static <T> boolean removeAll(@NotNull Collection<T> collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(216);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        boolean modified = false;
        for (T element2 : elements) {
            modified |= collection.remove(element2);
        }
        return modified;
    }

    public static <T> boolean retainAll(@NotNull Collection<T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(218);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(219);
        }
        boolean modified = false;
        Iterator<T> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            T next = iterator2.next();
            if (condition.value(next)) continue;
            iterator2.remove();
            modified = true;
        }
        return modified;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<? extends T> iterable, @NotNull Class<? extends U> aClass) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(220);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(221);
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<? extends T> iterator2, @NotNull Class<? extends U> aClass) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(222);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(223);
        }
        return (U)ContainerUtil.find(iterator2, FilteringIterator.instanceOf(aClass));
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(T @NotNull [] array, @NotNull Class<? extends U> aClass) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(224);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(225);
        }
        return (U)ContainerUtil.find(array, FilteringIterator.instanceOf(aClass));
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<T> concat(V @NotNull [] array, @NotNull Function<? super V, ? extends Collection<? extends T>> fun) {
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(226);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(227);
        }
        return ContainerUtil.concat(Arrays.asList(array), fun);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> concat(@NotNull Iterable<? extends Collection<? extends T>> list2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(228);
        }
        int totalSize = 0;
        for (Collection<T> ts : list2) {
            totalSize += ts.size();
        }
        ArrayList result2 = new ArrayList(totalSize);
        for (Collection<T> collection : list2) {
            result2.addAll(collection);
        }
        List list3 = result2.isEmpty() ? Collections.emptyList() : result2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(229);
        }
        return list3;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> List<T> append(@NotNull List<? extends T> list2, T ... values2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(231);
        }
        return values2.length == 0 ? list2 : ContainerUtil.concat(list2, Arrays.asList(values2));
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> List<T> prepend(@NotNull List<? extends T> list2, T ... values2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(232);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(233);
        }
        return values2.length == 0 ? list2 : ContainerUtil.concat(Arrays.asList(values2), list2);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(234);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(235);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(236);
            }
            return list3;
        }
        if (list1.isEmpty()) {
            List<T> list4 = list2;
            if (list4 == null) {
                ContainerUtil.$$$reportNull$$$0(237);
            }
            return list4;
        }
        if (list2.isEmpty()) {
            List<T> list5 = list1;
            if (list5 == null) {
                ContainerUtil.$$$reportNull$$$0(238);
            }
            return list5;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                if (index2 < size1) {
                    return list1.get(index2);
                }
                return list2.get(index2 - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(final @NotNull Iterable<? extends T> it1, final @NotNull Iterable<? extends T> it2) {
        if (it1 == null) {
            ContainerUtil.$$$reportNull$$$0(239);
        }
        if (it2 == null) {
            ContainerUtil.$$$reportNull$$$0(240);
        }
        return new Iterable<T>(){

            @Override
            public void forEach(Consumer<? super T> action) {
                it1.forEach(action);
                it2.forEach(action);
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> it;
                    boolean firstFinished;
                    {
                        this.it = it1.iterator();
                        this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.firstFinished || this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        Object value2 = this.it.next();
                        this.advance();
                        return value2;
                    }

                    private void advance() {
                        if (!this.firstFinished && !this.it.hasNext()) {
                            this.it = it2.iterator();
                            this.firstFinished = true;
                        }
                    }
                };
            }
        };
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            ContainerUtil.$$$reportNull$$$0(241);
        }
        if (iterables.length == 0) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(242);
            }
            return list2;
        }
        if (iterables.length == 1) {
            Iterable<? extends T> iterable = iterables[0];
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(243);
            }
            return iterable;
        }
        Iterable iterable = () -> {
            Iterator[] iterators = new Iterator[iterables.length];
            for (int i = 0; i < iterables.length; ++i) {
                Iterable iterable = iterables[i];
                iterators[i] = iterable.iterator();
            }
            return ContainerUtil.concatIterators(iterators);
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        return iterable;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> concatIterators(Iterator<? extends T> ... iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(245);
        }
        return new SequenceIterator<T>(iterators);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> concatIterators(@NotNull Collection<? extends Iterator<? extends T>> iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(246);
        }
        return new SequenceIterator(iterators);
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(T[] ... arrays) {
        Iterable iterable = () -> {
            Iterator[] iterators = new Iterator[arrays.length];
            for (int i = 0; i < arrays.length; ++i) {
                iterators[i] = ContainerUtil.iterate(arrays[i]);
            }
            return ContainerUtil.concatIterators(iterators);
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(247);
        }
        return iterable;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> List<T> concat(final List<? extends T> ... lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(248);
        }
        int size = 0;
        for (List<T> list2 : lists) {
            size += list2.size();
        }
        if (size == 0) {
            return ContainerUtil.emptyList();
        }
        final int finalSize = size;
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                if (index2 >= 0 && index2 < finalSize) {
                    int from2 = 0;
                    for (List each : lists) {
                        if (from2 <= index2 && index2 < from2 + each.size()) {
                            return each.get(index2 - from2);
                        }
                        from2 += each.size();
                    }
                    if (from2 != finalSize) {
                        throw new ConcurrentModificationException("The list has changed. Its size was " + finalSize + "; now it's " + from2);
                    }
                }
                throw new IndexOutOfBoundsException("index: " + index2 + "; size: " + this.size());
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> concat(@NotNull List<List<? extends T>> lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(249);
        }
        return ContainerUtil.concat(lists.toArray(new List[0]));
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> concat(@NotNull Iterable<? extends T> list2, @NotNull Function<? super T, ? extends Collection<? extends V>> listGenerator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(250);
        }
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(251);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T v : list2) {
            result2.addAll(listGenerator.fun(v));
        }
        List<T> list3 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(252);
        }
        return list3;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(253);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(254);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(255);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(256);
        }
        if (collection1.isEmpty() || collection2.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result2.add(t);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(257);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <E extends Enum<E>> EnumSet<E> intersection(@NotNull EnumSet<E> collection1, @NotNull EnumSet<E> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(258);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(259);
        }
        if (collection1.isEmpty()) {
            EnumSet<E> enumSet = collection1;
            if (enumSet == null) {
                ContainerUtil.$$$reportNull$$$0(260);
            }
            return enumSet;
        }
        if (collection2.isEmpty()) {
            EnumSet<E> enumSet = collection2;
            if (enumSet == null) {
                ContainerUtil.$$$reportNull$$$0(261);
            }
            return enumSet;
        }
        EnumSet<E> result2 = EnumSet.copyOf(collection1);
        result2.retainAll(collection2);
        EnumSet<E> enumSet = result2;
        if (enumSet == null) {
            ContainerUtil.$$$reportNull$$$0(262);
        }
        return enumSet;
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable List<? extends T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getOnlyItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.size() != 1 ? defaultResult : items.iterator().next();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> getFirstItems(@NotNull List<T> items, int maxItems) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(263);
        }
        if (maxItems < 0) {
            throw new IllegalArgumentException("Expected non-negative maxItems; got: " + maxItems);
        }
        List<T> list2 = maxItems >= items.size() ? items : items.subList(0, maxItems);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(264);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> T iterateAndGetLastItem(@NotNull Iterable<? extends T> items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(265);
        }
        Iterator<T> itr = items.iterator();
        T res2 = null;
        while (itr.hasNext()) {
            res2 = itr.next();
        }
        return res2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Function<? super T, ? extends U> mapper) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(266);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(267);
        }
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> filterIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Condition<? super T> filter2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(268);
        }
        if (filter2 == null) {
            ContainerUtil.$$$reportNull$$$0(269);
        }
        return new Iterator<T>(){
            T next;
            boolean hasNext;
            {
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private void findNext() {
                this.hasNext = false;
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    if (!filter2.value(t)) continue;
                    this.next = t;
                    this.hasNext = true;
                    break;
                }
            }

            @Override
            public T next() {
                if (this.hasNext) {
                    Object result2 = this.next;
                    this.findNext();
                    return result2;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @Contract(pure=true)
    public static <T> T getLastItem(@Nullable List<? extends T> list2, @Nullable T def) {
        return ContainerUtil.isEmpty(list2) ? def : list2.get(list2.size() - 1);
    }

    @Contract(pure=true)
    public static <T> T getLastItem(@Nullable List<? extends T> list2) {
        return ContainerUtil.getLastItem(list2, null);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> subtract(@NotNull Collection<? extends T> from2, @NotNull Collection<? extends T> what) {
        if (from2 == null) {
            ContainerUtil.$$$reportNull$$$0(270);
        }
        if (what == null) {
            ContainerUtil.$$$reportNull$$$0(271);
        }
        HashSet<T> set = new HashSet<T>(from2);
        set.removeAll(what);
        Collection<T> collection = set.isEmpty() ? ContainerUtil.emptyList() : set;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(272);
        }
        return collection;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toArray(@NotNull Collection<T> c, @NotNull ArrayFactory<? extends T> factory2) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(273);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(274);
        }
        T[] a = factory2.create(c.size());
        T[] TArray = c.toArray(a);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(275);
        }
        return TArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory2) {
        if (c1 == null) {
            ContainerUtil.$$$reportNull$$$0(276);
        }
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(277);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(278);
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory2);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(279);
        }
        return TArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] mergeCollectionsToArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory2) {
        if (c1 == null) {
            ContainerUtil.$$$reportNull$$$0(280);
        }
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(281);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(282);
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory2);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(283);
        }
        return TArray;
    }

    public static <T extends Comparable<? super T>> void sort(@NotNull List<T> list2) {
        int size;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(284);
        }
        if ((size = list2.size()) < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list2.get(0);
            if (t0.compareTo(t1 = (Comparable)list2.get(1)) > 0) {
                list2.set(0, t1);
                list2.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    Comparable tj;
                    Comparable ti = (Comparable)list2.get(i);
                    if (ti.compareTo(tj = (Comparable)list2.get(j)) >= 0) continue;
                    list2.set(i, tj);
                    list2.set(j, ti);
                }
            }
        } else {
            Collections.sort(list2);
        }
    }

    public static <T> void sort(@NotNull List<T> list2, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(285);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(286);
        }
        if ((size = list2.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list2.get(0);
            if (comparator.compare(t0, t1 = list2.get(1)) > 0) {
                list2.set(0, t1);
                list2.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list2.get(i);
                    if (comparator.compare(ti, tj = list2.get(j)) >= 0) continue;
                    list2.set(i, tj);
                    list2.set(j, ti);
                }
            }
        } else {
            list2.sort(comparator);
        }
    }

    public static <T extends Comparable<? super T>> void sort(T @NotNull [] a) {
        int size;
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(287);
        }
        if ((size = a.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (t0.compareTo(t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (ti.compareTo(tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> sorted(@NotNull Collection<? extends T> list2, @NotNull Comparator<? super T> comparator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(288);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(289);
        }
        return ContainerUtil.sorted(list2, comparator);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> sorted(@NotNull Iterable<? extends T> list2, @NotNull Comparator<? super T> comparator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(290);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(291);
        }
        ArrayList<? extends T> sorted = ContainerUtil.newArrayList(list2);
        ContainerUtil.sort(sorted, comparator);
        ArrayList<? extends T> arrayList = sorted;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(292);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends Comparable<? super T>> List<T> sorted(@NotNull Collection<? extends T> list2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(293);
        }
        ArrayList<T> result2 = new ArrayList<T>(list2);
        result2.sort(null);
        ArrayList<T> arrayList = result2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(294);
        }
        return arrayList;
    }

    public static <T> void sort(T @NotNull [] a, @NotNull Comparator<? super T> comparator) {
        int size;
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(295);
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(296);
        }
        if ((size = a.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (comparator.compare(t0, t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a, comparator);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(297);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(298);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : iterable) {
            result2.add(mapping2.fun(t));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(299);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map(@NotNull Iterator<? extends T> iterator2, @NotNull Function<? super T, ? extends V> mapping2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(300);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(301);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        while (iterator2.hasNext()) {
            result2.add(mapping2.fun(iterator2.next()));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(302);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(303);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(304);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> list2 = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list2.add(mapping2.fun(t));
        }
        ArrayList<V> arrayList = list2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(305);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull List<@NotNull V> mapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends @Nullable V> mapping2) {
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(306);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(307);
        }
        if (array.length == 0) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            V o = mapping2.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(308);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull V @NotNull [] mapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends @Nullable V> mapping2, V @NotNull [] emptyArray) {
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(309);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(310);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(311);
        }
        assert (emptyArray.length == 0) : "You must pass an empty array";
        ArrayList<V> result2 = new ArrayList<V>(array.length);
        for (T t : array) {
            V v = mapping2.fun(t);
            if (v == null) continue;
            result2.add(v);
        }
        if (result2.isEmpty()) {
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(312);
            }
            return emptyArray;
        }
        V[] VArray = result2.toArray(emptyArray);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(313);
        }
        return VArray;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull List<@NotNull V> mapNotNull(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends @Nullable V> mapping2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(314);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(315);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : iterable) {
            V o = mapping2.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(316);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull List<@NotNull V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends @Nullable V> mapping2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(317);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(318);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>(collection.size());
        for (T t : collection) {
            V o = mapping2.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(319);
        }
        return list2;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> List<T> packNullables(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(320);
        }
        ArrayList<T> list2 = new ArrayList<T>();
        for (T element2 : elements) {
            ContainerUtil.addIfNotNull(list2, element2);
        }
        List<T> list3 = list2.isEmpty() ? ContainerUtil.emptyList() : list2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(321);
        }
        return list3;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapping2) {
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(322);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(323);
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            result2.add(mapping2.fun(t));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(324);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map(T @NotNull [] arr, @NotNull Function<? super T, ? extends V> mapping2, V @NotNull [] emptyArray) {
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(325);
        }
        if (arr == null) {
            ContainerUtil.$$$reportNull$$$0(326);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(327);
        }
        if (arr.length == 0) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(328);
            }
            return emptyArray;
        }
        V[] result2 = emptyArray.length < arr.length ? Arrays.copyOf(emptyArray, arr.length) : emptyArray;
        for (int i = 0; i < arr.length; ++i) {
            result2[i] = mapping2.fun(arr[i]);
        }
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(329);
        }
        return result2;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> set(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(330);
        }
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value2, @NotNull Map<? super K, ? super V> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(331);
        }
        if (value2 != null) {
            result2.put(key, value2);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable Collection<? extends V> value2, @NotNull MultiMap<? super K, ? super V> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(332);
        }
        if (value2 != null) {
            result2.putValues(key, value2);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value2, @NotNull MultiMap<? super K, ? super V> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(333);
        }
        if (value2 != null) {
            result2.putValue(key, value2);
        }
    }

    public static <T> void add(T element2, @NotNull Collection<? super T> result2, @NotNull Disposable parentDisposable) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(334);
        }
        if (parentDisposable == null) {
            ContainerUtil.$$$reportNull$$$0(335);
        }
        if (result2.add(element2)) {
            Disposer.register(parentDisposable, () -> result2.remove(element2));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> createMaybeSingletonList(@Nullable T element2) {
        List<T> list2 = element2 == null ? ContainerUtil.emptyList() : Collections.singletonList(element2);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(336);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> createMaybeSingletonSet(@Nullable T element2) {
        Set set = element2 == null ? Collections.emptySet() : Collections.singleton(element2);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(337);
        }
        return set;
    }

    @NotNull
    public static <T, V> V getOrCreate(@NotNull Map<T, V> result2, T key, @NotNull V defaultValue) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(338);
        }
        if (defaultValue == null) {
            ContainerUtil.$$$reportNull$$$0(339);
        }
        Object object = result2.computeIfAbsent(key, __ -> defaultValue);
        if (object == null) {
            ContainerUtil.$$$reportNull$$$0(340);
        }
        return (V)object;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result2, T key, @NotNull Factory<? extends V> factory2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(341);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(342);
        }
        return (V)result2.computeIfAbsent(key, __ -> factory2.create());
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> V getOrElse(@NotNull Map<? extends T, ? extends V> map, T key, @NotNull V defValue) {
        V value2;
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(343);
        }
        if (defValue == null) {
            ContainerUtil.$$$reportNull$$$0(344);
        }
        V v = (value2 = map.get(key)) == null ? defValue : value2;
        if (v == null) {
            ContainerUtil.$$$reportNull$$$0(345);
        }
        return v;
    }

    @Contract(pure=true)
    public static <T> boolean and(T @NotNull [] iterable, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(346);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(347);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(348);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(349);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(350);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(351);
        }
        for (T t : array) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(352);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(353);
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean or(T @NotNull [] iterable, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(354);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(355);
        }
        return ContainerUtil.exists(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(356);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(357);
        }
        return ContainerUtil.exists(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> int count(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(358);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(359);
        }
        int count = 0;
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            ++count;
        }
        return count;
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> List<T> list(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(360);
        }
        List<T> list2 = Arrays.asList(items);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(361);
        }
        return list2;
    }

    public static <T> void quickSort(@NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(362);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(363);
        }
        ContainerUtil.quickSort(list2, comparator, 0, list2.size());
    }

    private static <T> void quickSort(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(364);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(365);
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        int n = off + len;
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(366);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(367);
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <E> List<E> flatten(Collection<E> @NotNull [] collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(368);
        }
        return ContainerUtil.flatten(Arrays.asList(collections));
    }

    @NotNull
    public static <T> List<T> removeDuplicatesFromSorted(@NotNull List<T> list2, @NotNull Comparator<? super T> comparator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(369);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(370);
        }
        Object prev = null;
        ArrayList<T> result2 = null;
        for (int i = 0; i < list2.size(); ++i) {
            int cmp;
            T t = list2.get(i);
            if (t == null) {
                throw new IllegalArgumentException("get(" + i + ") = null");
            }
            int n = cmp = prev == null ? -1 : comparator.compare(prev, t);
            if (cmp < 0) {
                if (result2 != null) {
                    result2.add(t);
                }
            } else if (cmp == 0) {
                if (result2 == null) {
                    result2 = new ArrayList<T>(list2.size());
                    result2.addAll(list2.subList(0, i));
                }
            } else {
                throw new IllegalArgumentException("List must be sorted but get(" + (i - 1) + ")=" + list2.get(i - 1) + " > get(" + i + ")=" + t);
            }
            prev = t;
        }
        List<T> list3 = result2 == null ? list2 : result2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(371);
        }
        return list3;
    }

    @Contract(pure=true)
    @NotNull
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<? extends E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(372);
        }
        int totalSize = 0;
        for (Collection<E> list2 : collections) {
            totalSize += list2.size();
        }
        ArrayList result2 = new ArrayList(totalSize);
        for (Collection<E> collection : collections) {
            result2.addAll(collection);
        }
        List list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(373);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static <E> List<E> flattenIterables(@NotNull Iterable<? extends Iterable<? extends E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(374);
        }
        int totalSize = 0;
        for (Iterable<E> iterable : collections) {
            totalSize += iterable instanceof Collection ? ((Collection)iterable).size() : 10;
        }
        ArrayList result2 = new ArrayList(totalSize);
        for (Iterable<E> list3 : collections) {
            for (E e : list3) {
                result2.add(e);
            }
        }
        List list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(375);
        }
        return list2;
    }

    @NotNull
    public static <T, V> List<V> flatMap(@NotNull Iterable<? extends T> iterable, @NotNull @NotNull Function<? super T, ? extends @NotNull List<V>> mapping2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(376);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(377);
        }
        List<V> result2 = null;
        boolean isOriginal = true;
        for (T each : iterable) {
            List<V> toAdd = mapping2.fun(each);
            if (toAdd.isEmpty()) continue;
            if (result2 == null) {
                result2 = toAdd;
                continue;
            }
            if (isOriginal) {
                List<V> original = result2;
                result2 = new ArrayList<V>(Math.max(10, result2.size() + toAdd.size()));
                result2.addAll(original);
                isOriginal = false;
            }
            result2.addAll(toAdd);
        }
        List<T> list2 = result2 == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(result2);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(378);
        }
        return list2;
    }

    public static <K, V> V @NotNull [] convert(K @NotNull [] from2, V @NotNull [] to, @NotNull Function<? super K, ? extends V> fun) {
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(379);
        }
        if (from2 == null) {
            ContainerUtil.$$$reportNull$$$0(380);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(381);
        }
        if (to.length < from2.length) {
            to = ArrayUtil.newArray(ArrayUtil.getComponentType(to), from2.length);
        }
        for (int i = 0; i < from2.length; ++i) {
            to[i] = fun.fun(from2[i]);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(382);
        }
        return to;
    }

    @Contract(pure=true)
    public static <T> boolean containsIdentity(@NotNull Iterable<? extends T> list2, T element2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(383);
        }
        for (T t : list2) {
            if (t != element2) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int indexOfIdentity(@NotNull List<? extends T> list2, T element2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(384);
        }
        int listSize = list2.size();
        for (int i = 0; i < listSize; ++i) {
            if (list2.get(i) != element2) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> boolean equalsIdentity(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(385);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(386);
        }
        int listSize = list1.size();
        if (list2.size() != listSize) {
            return false;
        }
        for (int i = 0; i < listSize; ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> list2, @NotNull Condition<? super T> condition) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(387);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(388);
        }
        int listSize = list2.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list2.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<? extends T> list2, @NotNull Condition<? super T> condition) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(389);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(390);
        }
        for (int i = list2.size() - 1; i >= 0; --i) {
            T t = list2.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOfIdentity(@NotNull List<? extends T> list2, T object) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(391);
        }
        for (int i = list2.size() - 1; i >= 0; --i) {
            T t = list2.get(i);
            if (t != object) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findLastInstance(@NotNull List<? extends T> list2, @NotNull Class<? extends U> clazz) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(392);
        }
        if (clazz == null) {
            ContainerUtil.$$$reportNull$$$0(393);
        }
        int i = ContainerUtil.lastIndexOf(list2, clazz::isInstance);
        return i < 0 ? null : (U)list2.get(i);
    }

    @Contract(pure=true)
    public static <T, U extends T> int lastIndexOfInstance(@NotNull List<? extends T> list2, @NotNull Class<U> clazz) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(394);
        }
        if (clazz == null) {
            ContainerUtil.$$$reportNull$$$0(395);
        }
        return ContainerUtil.lastIndexOf(list2, clazz::isInstance);
    }

    @Contract(pure=true)
    @NotNull
    public static <A, B> Map<B, A> reverseMap(@NotNull Map<? extends A, ? extends B> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(396);
        }
        HashMap<B, A> result2 = new HashMap<B, A>();
        for (Map.Entry<A, B> entry : map.entrySet()) {
            result2.put(entry.getValue(), entry.getKey());
        }
        HashMap<B, A> hashMap = result2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(397);
        }
        return hashMap;
    }

    @Contract(value="null -> null; !null -> !null")
    public static <T> List<T> trimToSize(@Nullable List<T> list2) {
        if (list2 == null) {
            return null;
        }
        if (list2.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        if (list2 instanceof ArrayList) {
            ((ArrayList)list2).trimToSize();
        }
        return list2;
    }

    @Deprecated
    @Contract(value=" -> new", pure=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static <T> Stack<T> newStack() {
        return new Stack();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> emptyList() {
        List list2 = ContainerUtilRt.emptyList();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(398);
        }
        return list2;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        return new CopyOnWriteArrayList<T>(ContainerUtil.emptyList());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        return ContainerUtil.createConcurrentList();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList(@NotNull Collection<? extends T> c) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(399);
        }
        return new LockFreeCopyOnWriteArrayList<T>(c);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        return new ConcurrentLongObjectHashMap();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        return new ConcurrentIntObjectHashMap();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        return new ConcurrentIntKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(400);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors());
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(401);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(402);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(403);
        }
        return concurrentMap;
    }

    @ApiStatus.Internal
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(404);
        }
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeyWeakValueMap(strategy);
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(405);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(406);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(407);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(408);
        }
        return concurrentMap;
    }

    @NotNull
    public static <K> HashingStrategy<K> createHashingStrategy(final @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(409);
        }
        return new HashingStrategy<K>(){

            @Override
            public int hashCode(@Nullable K object) {
                return hashingStrategy.computeHashCode(object);
            }

            @Override
            public boolean equals(@Nullable K o1, @Nullable K o2) {
                return hashingStrategy.equals(o1, o2);
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(410);
        }
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap(initialCapacity, loadFactor, concurrencyLevel, ContainerUtil.createHashingStrategy(hashingStrategy));
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(411);
        }
        return concurrentMap;
    }

    @Deprecated
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(@NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(412);
        }
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap(ContainerUtil.createHashingStrategy(hashingStrategy));
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(413);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> ConcurrentList<T> createConcurrentList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> ConcurrentList<T> createConcurrentList(@NotNull Collection<? extends T> c) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(414);
        }
        return new LockFreeCopyOnWriteArrayList<T>(c);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static <T> void addIfNotNull(@Nullable T element2, @NotNull Collection<? super T> result2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(415);
        }
        ContainerUtil.addIfNotNull(result2, element2);
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result2, @Nullable T element2) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(416);
        }
        if (element2 != null) {
            result2.add(element2);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map2List(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(417);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(418);
        }
        if (array.length == 0) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> list2 = new ArrayList<V>(array.length);
        for (T t : array) {
            list2.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(419);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(420);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(421);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> list2 = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list2.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(422);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> List<Pair<K, V>> map2List(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(423);
        }
        if (map.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<Pair<K, V>> result2 = new ArrayList<Pair<K, V>>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result2.add(Pair.create(entry.getKey(), entry.getValue()));
        }
        ArrayList<Pair<K, V>> arrayList = result2;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(424);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> Set<V> map2Set(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(425);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(426);
        }
        if (array.length == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(427);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(array.length);
        for (T t : array) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(428);
        }
        return hashSet;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(429);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(430);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(431);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(432);
        }
        return hashSet;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> Set<V> map2LinkedSet(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(433);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(434);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(435);
            }
            return set;
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        LinkedHashSet<V> linkedHashSet = set;
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(436);
        }
        return linkedHashSet;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> Set<V> map2SetNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(437);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(438);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(439);
            }
            return set;
        }
        HashSet set = new HashSet(collection.size());
        for (T t : collection) {
            V value2 = mapper.fun(t);
            if (value2 == null) continue;
            set.add(value2);
        }
        Set set2 = set.isEmpty() ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(440);
        }
        return set2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(mutates="param2")
    public static <T> T @NotNull [] toArray(@NotNull List<T> collection, T @NotNull [] array) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(441);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(442);
        }
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(443);
        }
        return TArray;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(mutates="param2")
    public static <T> T @NotNull [] toArray(@NotNull Collection<? extends T> c, T @NotNull [] sample) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(444);
        }
        if (sample == null) {
            ContainerUtil.$$$reportNull$$$0(445);
        }
        T[] TArray = c.toArray(sample);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(446);
        }
        return TArray;
    }

    public static <T> T @NotNull [] copyAndClear(@NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory2, boolean clear2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(447);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(448);
        }
        int size = collection.size();
        T[] a = factory2.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear2) {
                collection.clear();
            }
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(449);
        }
        return a;
    }

    @NotNull
    public static <T> List<T> copyList(@NotNull List<? extends T> list2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(450);
        }
        if (list2 == Collections.emptyList()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(451);
            }
            return list3;
        }
        if (list2.size() == 1) {
            return new SmartList<T>(list2.get(0));
        }
        if (list2.isEmpty()) {
            return new SmartList();
        }
        return new ArrayList<T>(list2);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> toCollection(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(452);
        }
        return iterable instanceof Collection ? (ArrayList<? extends T>)iterable : ContainerUtil.newArrayList(iterable);
    }

    @NotNull
    public static <T> List<T> toList(@NotNull Enumeration<? extends T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(453);
        }
        if (!enumeration.hasMoreElements()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(454);
            }
            return list2;
        }
        SmartList<T> result2 = new SmartList<T>();
        while (enumeration.hasMoreElements()) {
            result2.add(enumeration.nextElement());
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(455);
        }
        return smartList;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> notNullize(@Nullable List<T> list2) {
        List<T> list3 = list2 == null ? ContainerUtil.emptyList() : list2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(456);
        }
        return list3;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(457);
        }
        return set2;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> notNullize(@Nullable Map<K, V> map) {
        Map map2 = map == null ? Collections.emptyMap() : map;
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(458);
        }
        return map2;
    }

    @Contract(pure=true)
    public static <T> boolean startsWith(@NotNull List<? extends T> list2, @NotNull List<? extends T> prefix) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(459);
        }
        if (prefix == null) {
            ContainerUtil.$$$reportNull$$$0(460);
        }
        return list2.size() >= prefix.size() && list2.subList(0, prefix.size()).equals(prefix);
    }

    @Contract(pure=true)
    @Nullable
    public static <C extends Collection<?>> C nullize(@Nullable C collection) {
        return ContainerUtil.isEmpty(collection) ? null : (C)collection;
    }

    @Contract(pure=true)
    public static <T extends Comparable<? super T>> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(461);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(462);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result2 = Comparing.compare((Comparable)o1.get(i), (Comparable)o2.get(i));
            if (result2 == 0) continue;
            return result2;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    @Contract(pure=true)
    public static <T> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2, @NotNull Comparator<? super T> comparator) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(463);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(464);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(465);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result2 = comparator.compare(o1.get(i), o2.get(i));
            if (result2 == 0) continue;
            return result2;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    @Contract(pure=true)
    @NotNull
    public static String toString(@NotNull Map<?, ?> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(466);
        }
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<?, ?>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<?, ?> entry = iterator2.next();
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator2.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        String string2 = sb.toString();
        if (string2 == null) {
            ContainerUtil.$$$reportNull$$$0(467);
        }
        return string2;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakKeySoftValueMap() {
        Map map = CollectionFactory.createWeakKeySoftValueMap();
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(468);
        }
        return map;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakKeyWeakValueMap() {
        Map map = CollectionFactory.createWeakKeyWeakValueMap();
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(469);
        }
        return map;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftKeySoftValueMap() {
        Map map = CollectionFactory.createSoftKeySoftValueMap();
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(470);
        }
        return map;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftValueMap() {
        return new SoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakValueMap() {
        return new WeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftMap() {
        Map map = CollectionFactory.createSoftMap();
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(471);
        }
        return map;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        return ContainerUtil.createWeakMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity) {
        Map map = CollectionFactory.createWeakMap(initialCapacity, 0.8f, HashingStrategy.canonical());
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(472);
        }
        return map;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(473);
        }
        Map map = CollectionFactory.createWeakMap(initialCapacity, loadFactor, strategy);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(474);
        }
        return map;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> Set<T> createWeakSet() {
        return new WeakHashSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> IntObjectMap<T> createIntKeyWeakValueMap() {
        return new IntKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> ObjectIntMap<T> createWeakKeyIntValueMap() {
        return new WeakKeyIntValueHashMap();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> List<T> immutableCopy(@NotNull List<? extends T> list2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(475);
        }
        if (list2.isEmpty()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(476);
            }
            return list3;
        }
        if (list2.size() == 1) {
            List<T> list4 = Collections.singletonList(list2.get(0));
            if (list4 == null) {
                ContainerUtil.$$$reportNull$$$0(477);
            }
            return list4;
        }
        return ContainerUtil.immutableList(list2.toArray());
    }

    public static <T> T reduce(@NotNull List<? extends T> list2, T identity, @NotNull BinaryOperator<T> accumulator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(478);
        }
        if (accumulator == null) {
            ContainerUtil.$$$reportNull$$$0(479);
        }
        Object result2 = identity;
        for (T t : list2) {
            result2 = accumulator.apply(result2, t);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 62: 
            case 66: 
            case 67: 
            case 70: 
            case 78: 
            case 80: 
            case 90: 
            case 93: 
            case 96: 
            case 102: 
            case 103: 
            case 128: 
            case 133: 
            case 135: 
            case 143: 
            case 147: 
            case 151: 
            case 156: 
            case 165: 
            case 168: 
            case 172: 
            case 175: 
            case 178: 
            case 181: 
            case 182: 
            case 185: 
            case 190: 
            case 192: 
            case 198: 
            case 199: 
            case 201: 
            case 204: 
            case 212: 
            case 215: 
            case 229: 
            case 236: 
            case 237: 
            case 238: 
            case 242: 
            case 243: 
            case 244: 
            case 247: 
            case 252: 
            case 257: 
            case 260: 
            case 261: 
            case 262: 
            case 264: 
            case 272: 
            case 275: 
            case 279: 
            case 283: 
            case 292: 
            case 294: 
            case 299: 
            case 302: 
            case 305: 
            case 308: 
            case 312: 
            case 313: 
            case 316: 
            case 319: 
            case 321: 
            case 324: 
            case 328: 
            case 329: 
            case 336: 
            case 337: 
            case 340: 
            case 345: 
            case 361: 
            case 371: 
            case 373: 
            case 375: 
            case 378: 
            case 382: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 411: 
            case 413: 
            case 419: 
            case 422: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 432: 
            case 435: 
            case 436: 
            case 439: 
            case 440: 
            case 443: 
            case 446: 
            case 449: 
            case 451: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 458: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: 
            case 472: 
            case 474: 
            case 476: 
            case 477: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 62: 
            case 66: 
            case 67: 
            case 70: 
            case 78: 
            case 80: 
            case 90: 
            case 93: 
            case 96: 
            case 102: 
            case 103: 
            case 128: 
            case 133: 
            case 135: 
            case 143: 
            case 147: 
            case 151: 
            case 156: 
            case 165: 
            case 168: 
            case 172: 
            case 175: 
            case 178: 
            case 181: 
            case 182: 
            case 185: 
            case 190: 
            case 192: 
            case 198: 
            case 199: 
            case 201: 
            case 204: 
            case 212: 
            case 215: 
            case 229: 
            case 236: 
            case 237: 
            case 238: 
            case 242: 
            case 243: 
            case 244: 
            case 247: 
            case 252: 
            case 257: 
            case 260: 
            case 261: 
            case 262: 
            case 264: 
            case 272: 
            case 275: 
            case 279: 
            case 283: 
            case 292: 
            case 294: 
            case 299: 
            case 302: 
            case 305: 
            case 308: 
            case 312: 
            case 313: 
            case 316: 
            case 319: 
            case 321: 
            case 324: 
            case 328: 
            case 329: 
            case 336: 
            case 337: 
            case 340: 
            case 345: 
            case 361: 
            case 371: 
            case 373: 
            case 375: 
            case 378: 
            case 382: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 411: 
            case 413: 
            case 419: 
            case 422: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 432: 
            case 435: 
            case 436: 
            case 439: 
            case 440: 
            case 443: 
            case 446: 
            case 449: 
            case 451: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 458: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: 
            case 472: 
            case 474: 
            case 476: 
            case 477: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 62: 
            case 66: 
            case 67: 
            case 70: 
            case 78: 
            case 80: 
            case 90: 
            case 93: 
            case 96: 
            case 102: 
            case 103: 
            case 128: 
            case 133: 
            case 135: 
            case 143: 
            case 147: 
            case 151: 
            case 156: 
            case 165: 
            case 168: 
            case 172: 
            case 175: 
            case 178: 
            case 181: 
            case 182: 
            case 185: 
            case 190: 
            case 192: 
            case 198: 
            case 199: 
            case 201: 
            case 204: 
            case 212: 
            case 215: 
            case 229: 
            case 236: 
            case 237: 
            case 238: 
            case 242: 
            case 243: 
            case 244: 
            case 247: 
            case 252: 
            case 257: 
            case 260: 
            case 261: 
            case 262: 
            case 264: 
            case 272: 
            case 275: 
            case 279: 
            case 283: 
            case 292: 
            case 294: 
            case 299: 
            case 302: 
            case 305: 
            case 308: 
            case 312: 
            case 313: 
            case 316: 
            case 319: 
            case 321: 
            case 324: 
            case 328: 
            case 329: 
            case 336: 
            case 337: 
            case 340: 
            case 345: 
            case 361: 
            case 371: 
            case 373: 
            case 375: 
            case 378: 
            case 382: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 411: 
            case 413: 
            case 419: 
            case 422: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 432: 
            case 435: 
            case 436: 
            case 439: 
            case 440: 
            case 443: 
            case 446: 
            case 449: 
            case 451: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 458: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: 
            case 472: 
            case 474: 
            case 476: 
            case 477: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 5: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 6: 
            case 94: 
            case 98: 
            case 231: 
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 15: 
            case 57: 
            case 105: 
            case 137: 
            case 138: 
            case 142: 
            case 171: 
            case 191: 
            case 225: 
            case 227: 
            case 307: 
            case 310: 
            case 323: 
            case 351: 
            case 418: 
            case 426: 
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 16: 
            case 33: 
            case 106: 
            case 111: 
            case 114: 
            case 116: 
            case 220: 
            case 297: 
            case 314: 
            case 347: 
            case 348: 
            case 352: 
            case 355: 
            case 356: 
            case 358: 
            case 376: 
            case 452: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalList";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 35: 
            case 60: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 125: 
            case 126: 
            case 130: 
            case 131: 
            case 134: 
            case 144: 
            case 148: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 161: 
            case 166: 
            case 169: 
            case 174: 
            case 176: 
            case 180: 
            case 183: 
            case 186: 
            case 188: 
            case 196: 
            case 208: 
            case 210: 
            case 213: 
            case 216: 
            case 218: 
            case 303: 
            case 317: 
            case 420: 
            case 429: 
            case 433: 
            case 437: 
            case 441: 
            case 447: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 36: 
            case 84: 
            case 89: 
            case 100: 
            case 112: 
            case 118: 
            case 120: 
            case 206: 
            case 222: 
            case 266: 
            case 268: 
            case 300: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 45: 
            case 97: 
            case 163: 
            case 343: 
            case 396: 
            case 423: 
            case 466: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 46: 
            case 65: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 59: 
            case 79: 
            case 108: 
            case 122: 
            case 200: 
            case 205: 
            case 228: 
            case 230: 
            case 232: 
            case 250: 
            case 284: 
            case 285: 
            case 288: 
            case 290: 
            case 293: 
            case 362: 
            case 369: 
            case 383: 
            case 384: 
            case 387: 
            case 389: 
            case 391: 
            case 392: 
            case 394: 
            case 450: 
            case 459: 
            case 475: 
            case 478: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 71: 
            case 75: 
            case 234: 
            case 385: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 72: 
            case 76: 
            case 235: 
            case 386: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 73: 
            case 77: 
            case 286: 
            case 289: 
            case 291: 
            case 295: 
            case 363: 
            case 365: 
            case 367: 
            case 370: 
            case 465: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 74: 
            case 107: 
            case 109: 
            case 110: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 95: 
            case 99: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 104: 
            case 115: 
            case 121: 
            case 123: 
            case 152: 
            case 154: 
            case 162: 
            case 167: 
            case 187: 
            case 194: 
            case 197: 
            case 219: 
            case 346: 
            case 349: 
            case 350: 
            case 353: 
            case 354: 
            case 357: 
            case 359: 
            case 388: 
            case 390: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 117: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 136: 
            case 139: 
            case 141: 
            case 146: 
            case 149: 
            case 267: 
            case 417: 
            case 421: 
            case 425: 
            case 430: 
            case 434: 
            case 438: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 140: 
            case 145: 
            case 158: 
            case 159: 
            case 221: 
            case 223: 
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 150: 
            case 381: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 170: 
            case 173: 
            case 177: 
            case 179: 
            case 184: 
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValues";
                break;
            }
            case 193: 
            case 209: 
            case 453: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrays";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 226: 
            case 379: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 240: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 245: 
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 248: 
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 253: 
            case 255: 
            case 258: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 254: 
            case 256: 
            case 259: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 263: 
            case 265: 
            case 330: 
            case 360: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 269: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 270: 
            case 380: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 271: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 273: 
            case 399: 
            case 414: 
            case 444: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 274: 
            case 278: 
            case 282: 
            case 342: 
            case 448: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 276: 
            case 280: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 277: 
            case 281: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 287: 
            case 296: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 298: 
            case 301: 
            case 304: 
            case 306: 
            case 309: 
            case 315: 
            case 318: 
            case 322: 
            case 325: 
            case 377: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 311: 
            case 327: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 326: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 338: 
            case 341: 
            case 415: 
            case 416: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 335: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 339: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 344: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 364: 
            case 366: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 368: 
            case 372: 
            case 374: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 393: 
            case 395: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 404: 
            case 473: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 409: 
            case 410: 
            case 412: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 445: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 460: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 461: 
            case 463: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 462: 
            case 464: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 479: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalStrategy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "identityStrategy";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyList";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptySet";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyMap";
                break;
            }
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 47: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSingletonList";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 66: 
            case 67: 
            case 257: 
            case 260: 
            case 261: 
            case 262: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromKeys";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromValues";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterable";
                break;
            }
            case 128: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Map";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 143: 
            case 147: 
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 156: 
            case 168: 
            case 172: 
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 175: 
            case 178: 
            case 181: 
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 190: {
                objectArray = objectArray2;
                objectArray2[1] = "stringMap";
                break;
            }
            case 192: 
            case 198: 
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 204: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 212: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 215: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 229: 
            case 236: 
            case 237: 
            case 238: 
            case 242: 
            case 243: 
            case 244: 
            case 247: 
            case 252: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 264: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 272: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 275: 
            case 279: 
            case 443: 
            case 446: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 283: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollectionsToArray";
                break;
            }
            case 292: 
            case 294: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 299: 
            case 302: 
            case 305: 
            case 324: 
            case 328: 
            case 329: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 308: 
            case 312: 
            case 313: 
            case 316: 
            case 319: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 321: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 336: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 337: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 340: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 345: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrElse";
                break;
            }
            case 361: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 371: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 373: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 375: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenIterables";
                break;
            }
            case 378: {
                objectArray = objectArray2;
                objectArray2[1] = "flatMap";
                break;
            }
            case 382: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 397: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 398: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 400: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakValueMap";
                break;
            }
            case 401: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 402: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 403: 
            case 405: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 406: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftValueMap";
                break;
            }
            case 407: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftMap";
                break;
            }
            case 408: 
            case 411: 
            case 413: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakMap";
                break;
            }
            case 419: 
            case 422: 
            case 424: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 427: 
            case 428: 
            case 431: 
            case 432: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 435: 
            case 436: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 439: 
            case 440: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 449: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 451: {
                objectArray = objectArray2;
                objectArray2[1] = "copyList";
                break;
            }
            case 454: 
            case 455: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 456: 
            case 457: 
            case 458: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 467: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 468: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeySoftValueMap";
                break;
            }
            case 469: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyWeakValueMap";
                break;
            }
            case 470: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftKeySoftValueMap";
                break;
            }
            case 471: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftMap";
                break;
            }
            case 472: 
            case 474: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakMap";
                break;
            }
            case 476: 
            case 477: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 62: 
            case 66: 
            case 67: 
            case 70: 
            case 78: 
            case 80: 
            case 90: 
            case 93: 
            case 96: 
            case 102: 
            case 103: 
            case 128: 
            case 133: 
            case 135: 
            case 143: 
            case 147: 
            case 151: 
            case 156: 
            case 165: 
            case 168: 
            case 172: 
            case 175: 
            case 178: 
            case 181: 
            case 182: 
            case 185: 
            case 190: 
            case 192: 
            case 198: 
            case 199: 
            case 201: 
            case 204: 
            case 212: 
            case 215: 
            case 229: 
            case 236: 
            case 237: 
            case 238: 
            case 242: 
            case 243: 
            case 244: 
            case 247: 
            case 252: 
            case 257: 
            case 260: 
            case 261: 
            case 262: 
            case 264: 
            case 272: 
            case 275: 
            case 279: 
            case 283: 
            case 292: 
            case 294: 
            case 299: 
            case 302: 
            case 305: 
            case 308: 
            case 312: 
            case 313: 
            case 316: 
            case 319: 
            case 321: 
            case 324: 
            case 328: 
            case 329: 
            case 336: 
            case 337: 
            case 340: 
            case 345: 
            case 361: 
            case 371: 
            case 373: 
            case 375: 
            case 378: 
            case 382: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 411: 
            case 413: 
            case 419: 
            case 422: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 432: 
            case 435: 
            case 436: 
            case 439: 
            case 440: 
            case 443: 
            case 446: 
            case 449: 
            case 451: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 458: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: 
            case 472: 
            case 474: 
            case 476: 
            case 477: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newUnmodifiableList";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyList";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptySet";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyMap";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "newTroveSet";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 57: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 63: 
            case 343: 
            case 344: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 64: 
            case 65: 
            case 255: 
            case 256: 
            case 258: 
            case 259: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 208: 
            case 209: 
            case 210: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 213: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 89: 
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 104: 
            case 105: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 145: 
            case 146: 
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 152: 
            case 153: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 154: 
            case 155: 
            case 166: 
            case 167: 
            case 170: 
            case 171: 
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 157: 
            case 158: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "filterIsInstance";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 173: 
            case 174: 
            case 176: 
            case 177: 
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "stringMap";
                break;
            }
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 226: 
            case 227: 
            case 228: 
            case 234: 
            case 235: 
            case 239: 
            case 240: 
            case 241: 
            case 248: 
            case 249: 
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 230: 
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 245: 
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 253: 
            case 254: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 266: 
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 268: 
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "filterIterator";
                break;
            }
            case 270: 
            case 271: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 273: 
            case 274: 
            case 276: 
            case 277: 
            case 278: 
            case 441: 
            case 442: 
            case 444: 
            case 445: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 280: 
            case 281: 
            case 282: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollectionsToArray";
                break;
            }
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 295: 
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 297: 
            case 298: 
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 322: 
            case 323: 
            case 325: 
            case 326: 
            case 327: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 306: 
            case 307: 
            case 309: 
            case 310: 
            case 311: 
            case 314: 
            case 315: 
            case 317: 
            case 318: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 320: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 330: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 331: 
            case 332: 
            case 333: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 334: 
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 338: 
            case 339: 
            case 341: 
            case 342: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 346: 
            case 347: 
            case 348: 
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 350: 
            case 351: 
            case 352: 
            case 353: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 354: 
            case 355: 
            case 356: 
            case 357: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 358: 
            case 359: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 360: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 362: 
            case 363: 
            case 364: 
            case 365: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 366: 
            case 367: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 368: 
            case 372: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 369: 
            case 370: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "flattenIterables";
                break;
            }
            case 376: 
            case 377: {
                objectArray = objectArray;
                objectArray[2] = "flatMap";
                break;
            }
            case 379: 
            case 380: 
            case 381: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 383: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 385: 
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 387: 
            case 388: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 389: 
            case 390: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIdentity";
                break;
            }
            case 392: 
            case 393: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 394: 
            case 395: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfInstance";
                break;
            }
            case 396: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 399: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "createHashingStrategy";
                break;
            }
            case 410: 
            case 412: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakMap";
                break;
            }
            case 414: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 415: 
            case 416: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 417: 
            case 418: 
            case 420: 
            case 421: 
            case 423: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 425: 
            case 426: 
            case 429: 
            case 430: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 433: 
            case 434: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 437: 
            case 438: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 447: 
            case 448: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 450: {
                objectArray = objectArray;
                objectArray[2] = "copyList";
                break;
            }
            case 452: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 453: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 459: 
            case 460: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 461: 
            case 462: 
            case 463: 
            case 464: 
            case 465: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 466: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 473: {
                objectArray = objectArray;
                objectArray[2] = "createWeakMap";
                break;
            }
            case 475: {
                objectArray = objectArray;
                objectArray[2] = "immutableCopy";
                break;
            }
            case 478: 
            case 479: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 47: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 62: 
            case 66: 
            case 67: 
            case 70: 
            case 78: 
            case 80: 
            case 90: 
            case 93: 
            case 96: 
            case 102: 
            case 103: 
            case 128: 
            case 133: 
            case 135: 
            case 143: 
            case 147: 
            case 151: 
            case 156: 
            case 165: 
            case 168: 
            case 172: 
            case 175: 
            case 178: 
            case 181: 
            case 182: 
            case 185: 
            case 190: 
            case 192: 
            case 198: 
            case 199: 
            case 201: 
            case 204: 
            case 212: 
            case 215: 
            case 229: 
            case 236: 
            case 237: 
            case 238: 
            case 242: 
            case 243: 
            case 244: 
            case 247: 
            case 252: 
            case 257: 
            case 260: 
            case 261: 
            case 262: 
            case 264: 
            case 272: 
            case 275: 
            case 279: 
            case 283: 
            case 292: 
            case 294: 
            case 299: 
            case 302: 
            case 305: 
            case 308: 
            case 312: 
            case 313: 
            case 316: 
            case 319: 
            case 321: 
            case 324: 
            case 328: 
            case 329: 
            case 336: 
            case 337: 
            case 340: 
            case 345: 
            case 361: 
            case 371: 
            case 373: 
            case 375: 
            case 378: 
            case 382: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 411: 
            case 413: 
            case 419: 
            case 422: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 432: 
            case 435: 
            case 436: 
            case 439: 
            case 440: 
            case 443: 
            case 446: 
            case 449: 
            case 451: 
            case 454: 
            case 455: 
            case 456: 
            case 457: 
            case 458: 
            case 467: 
            case 468: 
            case 469: 
            case 470: 
            case 471: 
            case 472: 
            case 474: 
            case 476: 
            case 477: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class KeyOrderedMultiMap<K extends Comparable<? super K>, V>
    extends MultiMap<K, V> {
        public KeyOrderedMultiMap() {
            super(new TreeMap());
        }

        public KeyOrderedMultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
            if (toCopy == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(0);
            }
            super(new TreeMap());
            this.putAllValues(toCopy);
        }

        @NotNull
        public NavigableSet<K> navigableKeySet() {
            NavigableSet navigableSet = ((TreeMap)this.myMap).navigableKeySet();
            if (navigableSet == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(1);
            }
            return navigableSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toCopy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "navigableKeySet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(E @NotNull [] array) {
            if (array == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(0);
            }
            this.myStore = array;
        }

        @Override
        public E get(int index2) {
            return this.myStore[index2];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        @Override
        public <T> T @NotNull [] toArray(T @NotNull [] a) {
            int size;
            if (a == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(1);
            }
            T[] result2 = a.length >= (size = this.size()) ? a : ArrayUtil.newArray(ArrayUtil.getComponentType(a), size);
            System.arraycopy(this.myStore, 0, result2, 0, size);
            if (result2.length > size) {
                result2[size] = null;
            }
            if (result2 == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(2);
            }
            return result2;
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            int length = this.myStore.length;
            for (int i = 0; i < length; ++i) {
                action.accept(this.myStore[i]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ImmutableListBackedByList<E>
    extends ImmutableList<E> {
        private final List<? extends E> myStore;

        private ImmutableListBackedByList(@NotNull List<? extends E> list2) {
            if (list2 == null) {
                ImmutableListBackedByList.$$$reportNull$$$0(0);
            }
            this.myStore = list2;
        }

        @Override
        public E get(int index2) {
            return this.myStore.get(index2);
        }

        @Override
        public int size() {
            return this.myStore.size();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.myStore.forEach(action);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByList", "<init>"));
        }
    }

    public static final class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new HashMap();

        @NotNull
        public ImmutableMapBuilder<K, V> put(K key, V value2) {
            this.myMap.put(key, value2);
            ImmutableMapBuilder immutableMapBuilder = this;
            if (immutableMapBuilder == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(0);
            }
            return immutableMapBuilder;
        }

        @Contract(pure=true)
        @NotNull
        public Map<K, V> build() {
            Map<K, V> map = Collections.unmodifiableMap(this.myMap);
            if (map == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/containers/ContainerUtil$ImmutableMapBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "put";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

