/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u001bH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u001bH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020 H\u0016J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "generatedFilesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;", "providers", "", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getClassNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFirCallableContainerFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFirClassifierContainerFile", "getFirClassifierContainerFileIfAny", "getFirFilesByPackage", "getFirScriptByFilePath", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirScriptSymbol;", "path", "", "getFirScriptContainerFile", "recordFile", "", "file", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFirProviderWithGeneratedFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProviderWithGeneratedFiles.kt\norg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1#2:68\n1358#3:69\n1444#3,5:70\n1444#3,5:75\n*S KotlinDebug\n*F\n+ 1 FirProviderWithGeneratedFiles.kt\norg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles\n*L\n56#1:69\n56#1:70,5\n60#1:75,5\n*E\n"})
public final class FirProviderWithGeneratedFiles
extends FirProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirProviderImpl generatedFilesProvider;
    @NotNull
    private final List<FirProvider> providers;

    public FirProviderWithGeneratedFiles(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
        this.generatedFilesProvider = new FirProviderImpl(this.session, FirKotlinScopeProviderKt.getKotlinScopeProvider(this.session));
        FirProvider[] firProviderArray = new FirProvider[]{FirProviderKt.getFirProvider(this.session), this.generatedFilesProvider};
        this.providers = CollectionsKt.listOf(firProviderArray);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public FirSymbolProvider getSymbolProvider() {
        return CollectionsKt.first(this.providers).getSymbolProvider();
    }

    @Override
    @Nullable
    public FirClassLikeDeclaration getFirClassifierByFqName(@NotNull ClassId classId) {
        FirClassLikeDeclaration firClassLikeDeclaration;
        block1: {
            Intrinsics.checkNotNullParameter(classId, "classId");
            for (FirProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirClassLikeDeclaration firClassLikeDeclaration2 = it.getFirClassifierByFqName(classId);
                if (firClassLikeDeclaration2 == null) continue;
                firClassLikeDeclaration = firClassLikeDeclaration2;
                break block1;
            }
            firClassLikeDeclaration = null;
        }
        return firClassLikeDeclaration;
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        FirFile firFile = this.getFirClassifierContainerFileIfAny(fqName2);
        if (firFile == null) {
            throw new IllegalStateException(("Couldn't find container for " + fqName2).toString());
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId fqName2) {
        FirFile firFile;
        block1: {
            Intrinsics.checkNotNullParameter(fqName2, "fqName");
            for (FirProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirFile firFile2 = it.getFirClassifierContainerFileIfAny(fqName2);
                if (firFile2 == null) continue;
                firFile = firFile2;
                break block1;
            }
            firFile = null;
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> symbol2) {
        FirFile firFile;
        block1: {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            for (FirProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirFile firFile2 = it.getFirCallableContainerFile(symbol2);
                if (firFile2 == null) continue;
                firFile = firFile2;
                break block1;
            }
            firFile = null;
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirScriptContainerFile(@NotNull FirScriptSymbol symbol2) {
        FirFile firFile;
        block1: {
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            for (FirProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirFile firFile2 = it.getFirScriptContainerFile(symbol2);
                if (firFile2 == null) continue;
                firFile = firFile2;
                break block1;
            }
            firFile = null;
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirScriptSymbol getFirScriptByFilePath(@NotNull String path) {
        FirScriptSymbol firScriptSymbol;
        block1: {
            Intrinsics.checkNotNullParameter(path, "path");
            for (FirProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirScriptSymbol firScriptSymbol2 = it.getFirScriptByFilePath(path);
                if (firScriptSymbol2 == null) continue;
                firScriptSymbol = firScriptSymbol2;
                break block1;
            }
            firScriptSymbol = null;
        }
        return firScriptSymbol;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Iterable $this$flatMap$iv = this.providers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirProvider it = (FirProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFirFilesByPackage(fqName2);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName fqName2) {
        void var3_3;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Iterable iterable = this.providers;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            FirProvider it = (FirProvider)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getClassNamesInPackage(fqName2);
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (Set)var3_3;
    }

    public final void recordFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.generatedFilesProvider.recordFile(file2);
    }
}

