/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.FirMangler;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020'2\u0006\u0010$\u001a\u00020%H\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020)2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirIrProvider;", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getComponents", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "staticScopeForCallables", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getStaticScopeForCallables", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "findDeclarationByHash", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "candidates", "", "hash", "", "(Ljava/util/Collection;Ljava/lang/Long;)Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getDeclarationForAccessorSignature", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "getDeclarationForCommonSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "kind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "getDeclarationForCompositeSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CompositeSignature;", "getDeclarationForSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFirIrProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirIrProvider.kt\norg/jetbrains/kotlin/fir/backend/FirIrProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1547#2:214\n1618#2,3:215\n659#2,11:218\n659#2,11:230\n764#2:241\n855#2,2:242\n288#2,2:244\n1#3:229\n*S KotlinDebug\n*F\n+ 1 FirIrProvider.kt\norg/jetbrains/kotlin/fir/backend/FirIrProvider\n*L\n76#1:214\n76#1:215,3\n86#1:218,11\n104#1:230,11\n166#1:241\n166#1:242,2\n200#1:244,2\n*E\n"})
public final class FirIrProvider
implements IrProvider {
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @NotNull
    private final Fir2IrDeclarationStorage declarationStorage;
    @NotNull
    private final Fir2IrClassifierStorage classifierStorage;
    @NotNull
    private final FakeOverrideGenerator fakeOverrideGenerator;

    public FirIrProvider(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter(components2, "components");
        this.components = components2;
        this.symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.components.getSession());
        this.declarationStorage = this.components.getDeclarationStorage();
        this.classifierStorage = this.components.getClassifierStorage();
        this.fakeOverrideGenerator = new FakeOverrideGenerator(this.components, new Fir2IrConversionScope(this.components.getConfiguration()));
    }

    @NotNull
    public final Fir2IrComponents getComponents() {
        return this.components;
    }

    @Override
    @Nullable
    public IrDeclaration getDeclaration(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        IdSignature idSignature = symbol2.getSignature();
        if (idSignature == null) {
            return null;
        }
        IdSignature signature = idSignature;
        return this.getDeclarationForSignature(signature, IrModuleDeserializerKt.kind(symbol2));
    }

    private final IrDeclaration getDeclarationForSignature(IdSignature signature, BinarySymbolData.SymbolKind kind) {
        IrDeclaration irDeclaration2;
        IdSignature idSignature = signature;
        if (idSignature instanceof IdSignature.AccessorSignature) {
            irDeclaration2 = this.getDeclarationForAccessorSignature((IdSignature.AccessorSignature)signature);
        } else if (idSignature instanceof IdSignature.CompositeSignature) {
            irDeclaration2 = this.getDeclarationForCompositeSignature((IdSignature.CompositeSignature)signature, kind);
        } else if (idSignature instanceof IdSignature.CommonSignature) {
            irDeclaration2 = this.getDeclarationForCommonSignature((IdSignature.CommonSignature)signature, kind);
        } else {
            throw new IllegalStateException(("Unexpected signature kind: " + signature).toString());
        }
        return irDeclaration2;
    }

    private final IrDeclaration getDeclarationForAccessorSignature(IdSignature.AccessorSignature signature) {
        Object object;
        Object object2;
        IrDeclaration irDeclaration2 = this.getDeclarationForSignature(signature.getPropertySignature(), BinarySymbolData.SymbolKind.PROPERTY_SYMBOL);
        IrProperty irProperty = irDeclaration2 instanceof IrProperty ? (IrProperty)irDeclaration2 : null;
        if (irProperty == null) {
            return null;
        }
        IrProperty property = irProperty;
        String string2 = signature.getAccessorSignature().getShortName();
        return Intrinsics.areEqual(string2, (object2 = property.getGetter()) != null && (object2 = object2.getName()) != null ? ((Name)object2).asString() : null) ? (IrDeclaration)property.getGetter() : (Intrinsics.areEqual(string2, (object = property.getSetter()) != null && (object = object.getName()) != null ? ((Name)object).asString() : null) ? (IrDeclaration)property.getSetter() : null);
    }

    private final IrDeclaration getDeclarationForCompositeSignature(IdSignature.CompositeSignature signature, BinarySymbolData.SymbolKind kind) {
        if (kind == BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL) {
            IrDeclaration irDeclaration2 = this.getDeclarationForSignature(signature.getContainer(), BinarySymbolData.SymbolKind.CLASS_SYMBOL);
            if (irDeclaration2 == null && (irDeclaration2 = this.getDeclarationForSignature(signature.getContainer(), BinarySymbolData.SymbolKind.FUNCTION_SYMBOL)) == null) {
                irDeclaration2 = this.getDeclarationForSignature(signature.getContainer(), BinarySymbolData.SymbolKind.PROPERTY_SYMBOL);
            }
            Intrinsics.checkNotNull(irDeclaration2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer");
            IrTypeParametersContainer container2 = (IrTypeParametersContainer)irDeclaration2;
            IdSignature idSignature = signature.getInner();
            Intrinsics.checkNotNull(idSignature, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.LocalSignature");
            IdSignature.LocalSignature localSignature = (IdSignature.LocalSignature)idSignature;
            return container2.getTypeParameters().get(localSignature.index());
        }
        return this.getDeclarationForSignature(signature.nearestPublicSig(), kind);
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    private final IrDeclaration getDeclarationForCommonSignature(IdSignature.CommonSignature signature, BinarySymbolData.SymbolKind kind) {
        block35: {
            block34: {
                packageFqName = new FqName(signature.getPackageFqName());
                nameSegments = signature.getNameSegments();
                v0 = Name.identifier(nameSegments.get(0));
                Intrinsics.checkNotNullExpressionValue(v0, "identifier(...)");
                topName = v0;
                firCandidates = null;
                parentClass = null;
                if (nameSegments.size() != 1 || kind == BinarySymbolData.SymbolKind.CLASS_SYMBOL) break block34;
                $this$map$iv = this.symbolProvider.getTopLevelCallableSymbols(packageFqName, topName);
                $i$f$map = false;
                var10_12 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var15_22 = (FirCallableSymbol)item$iv$iv;
                    var26_33 = destination$iv$iv;
                    $i$a$-map-FirIrProvider$getDeclarationForCommonSignature$1 = false;
                    var26_33.add((FirCallableDeclaration)it.getFir());
                }
                firCandidates = (List)destination$iv$iv;
                parentClass = null;
                break block35;
            }
            v1 = this.symbolProvider.getClassLikeSymbolByClassId(new ClassId(packageFqName, topName));
            $this$mapTo$iv$iv = v1 != null ? (FirClassLikeDeclaration)v1.getFir() : null;
            v2 = $this$mapTo$iv$iv instanceof FirRegularClass != false ? (FirRegularClass)$this$mapTo$iv$iv : null;
            if (v2 == null) {
                return null;
            }
            topLevelClass = v2;
            firParentClass = null;
            firClass = new Ref.ObjectRef<FirRegularClass>();
            firClass.element = topLevelClass;
            midSegments = kind == BinarySymbolData.SymbolKind.CLASS_SYMBOL ? CollectionsKt.drop((Iterable)nameSegments, 1) : CollectionsKt.dropLast(CollectionsKt.drop((Iterable)nameSegments, 1), 1);
            for (String midName : midSegments) {
                block33: {
                    firParentClass = (FirRegularClass)firClass.element;
                    $i$a$-map-FirIrProvider$getDeclarationForCommonSignature$1 = ((FirRegularClass)firClass.element).getDeclarations();
                    var26_34 = firClass;
                    $i$f$singleOrNull = false;
                    single$iv = null;
                    found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        it = (FirDeclaration)element$iv;
                        $i$a$-singleOrNull-FirIrProvider$getDeclarationForCommonSignature$2 = false;
                        v3 = it instanceof FirRegularClass != false ? (FirRegularClass)it : null;
                        if (!Intrinsics.areEqual(v3 != null && (v3 = v3.getName()) != null ? v3.asString() : null, midName)) continue;
                        if (found$iv) {
                            v4 = null;
                            break block33;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v4 = it = found$iv == false ? null : single$iv;
                }
                if ((it instanceof FirRegularClass != false ? (FirRegularClass)it : null) == null) {
                    return null;
                }
                var26_34.element = var26_34.element;
            }
            classId = FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)firClass.element);
            $this$getDeclarationForCommonSignature_u24lambda_u242 = this.components;
            $i$a$-with-FirIrProvider$getDeclarationForCommonSignature$scope$1 = false;
            scope = ConversionUtilsKt.unsubstitutedScope($this$getDeclarationForCommonSignature_u24lambda_u242, (FirClass)firClass.element);
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    firCandidates = CollectionsKt.listOf(firClass.element);
                    v5 = firParentClass;
                    if (v5 != null) {
                        it = v5;
                        $i$a$-let-FirIrProvider$getDeclarationForCommonSignature$3 = false;
                        v6 = FirIrProvider.getDeclarationForCommonSignature$findIrClass(this, it);
                    } else {
                        v6 = null;
                    }
                    parentClass = v6;
                    break;
                }
                case 2: {
                    v7 = Name.guessByFirstCharacter(CollectionsKt.last(nameSegments));
                    Intrinsics.checkNotNullExpressionValue(v7, "guessByFirstCharacter(...)");
                    lastName = v7;
                    $this$singleOrNull$iv = ((FirRegularClass)firClass.element).getDeclarations();
                    $i$f$singleOrNull = false;
                    single$iv = null;
                    found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        it = (FirDeclaration)element$iv;
                        $i$a$-singleOrNull-FirIrProvider$getDeclarationForCommonSignature$firCandidate$1 = false;
                        v8 = it instanceof FirEnumEntry != false ? (FirEnumEntry)it : null;
                        if (!Intrinsics.areEqual(v8 != null ? v8.getName() : null, lastName)) continue;
                        if (!found$iv) ** GOTO lbl92
                        v9 = null;
                        ** GOTO lbl96
lbl92:
                        // 1 sources

                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v9 = found$iv == false ? null : single$iv;
lbl96:
                    // 2 sources

                    if ((v10 = (firCandidate = (FirDeclaration)v9)) == null) ** GOTO lbl103
                    it = v10;
                    $i$a$-let-FirIrProvider$getDeclarationForCommonSignature$4 = false;
                    v11 = CollectionsKt.listOf(it);
                    v10 = v11;
                    if (v11 != null) ** GOTO lbl104
lbl103:
                    // 2 sources

                    return null;
lbl104:
                    // 1 sources

                    firCandidates = v10;
                    parentClass = FirIrProvider.getDeclarationForCommonSignature$findIrClass(this, (FirRegularClass)firClass.element);
                    break;
                }
                case 3: {
                    constructors = new ArrayList<E>();
                    scope.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)new Function1<FirConstructorSymbol, Unit>((List<FirConstructor>)constructors){
                        final /* synthetic */ List<FirConstructor> $constructors;
                        {
                            this.$constructors = $constructors;
                            super(1);
                        }

                        public final void invoke(FirConstructorSymbol it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            this.$constructors.add((FirConstructor)it.getFir());
                        }
                    });
                    firCandidates = constructors;
                    parentClass = FirIrProvider.getDeclarationForCommonSignature$findIrClass(this, (FirRegularClass)firClass.element);
                    break;
                }
                case 4: {
                    parentClass = FirIrProvider.getDeclarationForCommonSignature$findIrClass(this, (FirRegularClass)firClass.element);
                    v12 = Name.guessByFirstCharacter(CollectionsKt.last(nameSegments));
                    Intrinsics.checkNotNullExpressionValue(v12, "guessByFirstCharacter(...)");
                    lastName = v12;
                    functions = new ArrayList<E>();
                    scope.processFunctionsByName(lastName, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(classId, this, firClass, parentClass, (List<FirSimpleFunction>)functions){
                        final /* synthetic */ ClassId $classId;
                        final /* synthetic */ FirIrProvider this$0;
                        final /* synthetic */ Ref.ObjectRef<FirRegularClass> $firClass;
                        final /* synthetic */ IrClass $parentClass;
                        final /* synthetic */ List<FirSimpleFunction> $functions;
                        {
                            this.$classId = $classId;
                            this.this$0 = $receiver;
                            this.$firClass = $firClass;
                            this.$parentClass = $parentClass;
                            this.$functions = $functions;
                            super(1);
                        }

                        public final void invoke(FirNamedFunctionSymbol functionSymbol) {
                            FirSimpleFunction firSimpleFunction;
                            ClassId dispatchReceiverClassId;
                            Intrinsics.checkNotNullParameter(functionSymbol, "functionSymbol");
                            ConeSimpleKotlinType coneSimpleKotlinType = ((FirSimpleFunction)functionSymbol.getFir()).getDispatchReceiverType();
                            Object object = coneSimpleKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneSimpleKotlinType : null;
                            ClassId classId = object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : (dispatchReceiverClassId = null);
                            if (dispatchReceiverClassId != null && !Intrinsics.areEqual(dispatchReceiverClassId, this.$classId)) {
                                FirSimpleFunction firSimpleFunction2 = FirIrProvider.access$getFakeOverrideGenerator$p(this.this$0).createFirFunctionFakeOverrideIfNeeded$fir2ir((FirSimpleFunction)functionSymbol.getFir(), ((FirRegularClass)this.$firClass.element).getSymbol().toLookupTag(), this.$parentClass);
                                firSimpleFunction = firSimpleFunction2;
                                Intrinsics.checkNotNull(firSimpleFunction2);
                            } else {
                                firSimpleFunction = (FirSimpleFunction)functionSymbol.getFir();
                            }
                            FirSimpleFunction function2 = firSimpleFunction;
                            this.$functions.add(function2);
                        }
                    });
                    v13 = this.getStaticScopeForCallables((FirClass)firClass.element);
                    if (v13 != null) {
                        v13.processFunctionsByName(lastName, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>((List<FirSimpleFunction>)functions){
                            final /* synthetic */ List<FirSimpleFunction> $functions;
                            {
                                this.$functions = $functions;
                                super(1);
                            }

                            public final void invoke(FirNamedFunctionSymbol functionSymbol) {
                                Intrinsics.checkNotNullParameter(functionSymbol, "functionSymbol");
                                this.$functions.add((FirSimpleFunction)functionSymbol.getFir());
                            }
                        });
                    }
                    firCandidates = functions;
                    break;
                }
                case 5: {
                    parentClass = FirIrProvider.getDeclarationForCommonSignature$findIrClass(this, (FirRegularClass)firClass.element);
                    v14 = Name.guessByFirstCharacter(CollectionsKt.last(nameSegments));
                    Intrinsics.checkNotNullExpressionValue(v14, "guessByFirstCharacter(...)");
                    lastName = v14;
                    properties = new ArrayList<E>();
                    scope.processPropertiesByName(lastName, (Function1)new Function1<FirVariableSymbol<?>, Unit>(classId, this, firClass, parentClass, (List<FirVariable>)properties){
                        final /* synthetic */ ClassId $classId;
                        final /* synthetic */ FirIrProvider this$0;
                        final /* synthetic */ Ref.ObjectRef<FirRegularClass> $firClass;
                        final /* synthetic */ IrClass $parentClass;
                        final /* synthetic */ List<FirVariable> $properties;
                        {
                            this.$classId = $classId;
                            this.this$0 = $receiver;
                            this.$firClass = $firClass;
                            this.$parentClass = $parentClass;
                            this.$properties = $properties;
                            super(1);
                        }

                        public final void invoke(FirVariableSymbol<?> propertySymbol) {
                            FirProperty firProperty;
                            ClassId dispatchReceiverClassId;
                            Intrinsics.checkNotNullParameter(propertySymbol, "propertySymbol");
                            FirPropertySymbol cfr_ignored_0 = (FirPropertySymbol)propertySymbol;
                            ConeSimpleKotlinType coneSimpleKotlinType = ((FirProperty)((FirPropertySymbol)propertySymbol).getFir()).getDispatchReceiverType();
                            Object object = coneSimpleKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneSimpleKotlinType : null;
                            ClassId classId = object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : (dispatchReceiverClassId = null);
                            if (dispatchReceiverClassId != null && !Intrinsics.areEqual(dispatchReceiverClassId, this.$classId)) {
                                FirProperty firProperty2 = FirIrProvider.access$getFakeOverrideGenerator$p(this.this$0).createFirPropertyFakeOverrideIfNeeded$fir2ir((FirProperty)((FirPropertySymbol)propertySymbol).getFir(), ((FirRegularClass)this.$firClass.element).getSymbol().toLookupTag(), this.$parentClass);
                                firProperty = firProperty2;
                                Intrinsics.checkNotNull(firProperty2);
                            } else {
                                firProperty = (FirProperty)((FirPropertySymbol)propertySymbol).getFir();
                            }
                            FirProperty property = firProperty;
                            this.$properties.add(property);
                        }
                    });
                    firCandidates = properties;
                    break;
                }
                case 6: {
                    parentClass = FirIrProvider.getDeclarationForCommonSignature$findIrClass(this, (FirRegularClass)firClass.element);
                    v15 = Name.guessByFirstCharacter(CollectionsKt.last(nameSegments));
                    Intrinsics.checkNotNullExpressionValue(v15, "guessByFirstCharacter(...)");
                    lastName = v15;
                    fields = new ArrayList<E>();
                    scope.processPropertiesByName(lastName, (Function1)new Function1<FirVariableSymbol<?>, Unit>((List<FirVariable>)fields){
                        final /* synthetic */ List<FirVariable> $fields;
                        {
                            this.$fields = $fields;
                            super(1);
                        }

                        public final void invoke(FirVariableSymbol<?> propertySymbol) {
                            Intrinsics.checkNotNullParameter(propertySymbol, "propertySymbol");
                            this.$fields.add((FirVariable)propertySymbol.getFir());
                        }
                    });
                    v16 = this.getStaticScopeForCallables((FirClass)firClass.element);
                    if (v16 != null) {
                        v16.processPropertiesByName(lastName, (Function1)new Function1<FirVariableSymbol<?>, Unit>((List<FirVariable>)fields){
                            final /* synthetic */ List<FirVariable> $fields;
                            {
                                this.$fields = $fields;
                                super(1);
                            }

                            public final void invoke(FirVariableSymbol<?> propertySymbol) {
                                Intrinsics.checkNotNullParameter(propertySymbol, "propertySymbol");
                                this.$fields.add((FirVariable)propertySymbol.getFir());
                            }
                        });
                    }
                    firCandidates = fields;
                    break;
                }
                default: {
                    lastName = CollectionsKt.last(nameSegments);
                    $this$filter$iv = ((FirRegularClass)firClass.element).getDeclarations();
                    $i$f$filter = false;
                    $i$f$singleOrNull = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (FirDeclaration)element$iv$iv;
                        $i$a$-filter-FirIrProvider$getDeclarationForCommonSignature$11 = false;
                        if (!(it instanceof FirCallableDeclaration != false && Intrinsics.areEqual(((FirCallableDeclaration)it).getSymbol().getName().asString(), lastName) != false)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    firCandidates = (List)destination$iv$iv;
                    parentClass = FirIrProvider.getDeclarationForCommonSignature$findIrClass(this, (FirRegularClass)firClass.element);
                }
            }
        }
        v17 = this.findDeclarationByHash((Collection)firCandidates, signature.getId());
        if (v17 == null) {
            return null;
        }
        firDeclaration = v17;
        v18 = parentClass;
        parent = v18 != null ? (IrElement)v18 : (IrElement)Fir2IrDeclarationStorage.getIrExternalPackageFragment$default(this.declarationStorage, packageFqName, firDeclaration.getModuleData(), null, 4, null);
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                v19 = this.classifierStorage.getOrCreateIrClass(((FirRegularClass)firDeclaration).getSymbol());
                break;
            }
            case 2: {
                v20 = (FirEnumEntry)firDeclaration;
                Intrinsics.checkNotNull(parent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                v19 = Fir2IrClassifierStorage.getOrCreateIrEnumEntry$default(this.classifierStorage, v20, (IrClass)parent, null, 4, null);
                break;
            }
            case 3: {
                AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                throw null;
            }
            case 4: {
                AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                throw null;
            }
            case 5: {
                AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                throw null;
            }
            case 6: {
                firField = (FirField)firDeclaration;
                v19 = Fir2IrDeclarationStorage.getOrCreateIrField$default(this.declarationStorage, firField.getSymbol(), null, 2, null);
                break;
            }
            default: {
                throw new IllegalStateException(("Don't know how to deal with this symbol kind: " + (Object)kind).toString());
            }
        }
        return v19;
    }

    private final FirDeclaration findDeclarationByHash(Collection<? extends FirDeclaration> candidates2, Long hash) {
        Object v1;
        block3: {
            Iterable $this$firstOrNull$iv = candidates2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                FirDeclaration candidate2 = (FirDeclaration)element$iv;
                boolean bl2 = false;
                if (hash == null) {
                    bl = candidate2 instanceof FirClass || candidate2 instanceof FirEnumEntry || candidate2 instanceof FirTypeAlias;
                } else {
                    FirMangler $this$findDeclarationByHash_u24lambda_u248_u24lambda_u247 = this.components.getSignatureComposer().getMangler();
                    boolean bl3 = false;
                    bl = $this$findDeclarationByHash_u24lambda_u248_u24lambda_u247.signatureMangle(candidate2, false) == hash.longValue();
                }
                if (!bl) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    private final FirScope getStaticScopeForCallables(FirClass $this$staticScopeForCallables) {
        return $this$staticScopeForCallables.getScopeProvider().getStaticMemberScopeForCallables($this$staticScopeForCallables, this.components.getSession(), this.components.getScopeSession());
    }

    private static final IrClass getDeclarationForCommonSignature$findIrClass(FirIrProvider this$0, FirRegularClass firClass) {
        IrClassSymbol irClassSymbol = this$0.classifierStorage.getOrCreateIrClass(firClass.getSymbol()).getSymbol();
        IrDeclaration irDeclaration2 = this$0.getDeclaration(irClassSymbol);
        Intrinsics.checkNotNull(irDeclaration2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        return (IrClass)irDeclaration2;
    }

    public static final /* synthetic */ FakeOverrideGenerator access$getFakeOverrideGenerator$p(FirIrProvider $this) {
        return $this.fakeOverrideGenerator;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BinarySymbolData.SymbolKind.values().length];
            try {
                nArray[BinarySymbolData.SymbolKind.CLASS_SYMBOL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.ENUM_ENTRY_SYMBOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.CONSTRUCTOR_SYMBOL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.FUNCTION_SYMBOL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.PROPERTY_SYMBOL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.FIELD_SYMBOL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

